/* SliderAssembly.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SliderAssembly.vala, do not modify */

/* Copyright 2017 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: David Hewitt <davidmhewitt@gmail.com>
*/

#include "io.elementary.photos.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLIDER_ASSEMBLY_0_PROPERTY,
	SLIDER_ASSEMBLY_INVERTED_PROPERTY,
	SLIDER_ASSEMBLY_SLIDER_VALUE_PROPERTY,
	SLIDER_ASSEMBLY_NUM_PROPERTIES
};
static GParamSpec* slider_assembly_properties[SLIDER_ASSEMBLY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SLIDER_ASSEMBLY_VALUE_CHANGED_SIGNAL,
	SLIDER_ASSEMBLY_NUM_SIGNALS
};
static guint slider_assembly_signals[SLIDER_ASSEMBLY_NUM_SIGNALS] = {0};

struct _SliderAssemblyPrivate {
	GtkScale* slider;
	GtkEventBox* decrease_box;
	GtkEventBox* increase_box;
	GtkEventBox* active_box;
	guint click_id;
	guint initial_wait_id;
};

static gint SliderAssembly_private_offset;
static gpointer slider_assembly_parent_class = NULL;

static void slider_assembly_on_slider_value_changed (SliderAssembly* self);
static gboolean slider_assembly_step_callback (SliderAssembly* self);
static gboolean slider_assembly_get_inverted (SliderAssembly* self);
static gboolean slider_assembly_on_button_pressed (SliderAssembly* self,
                                            GtkWidget* sender,
                                            GdkEventButton* event);
static void slider_assembly_clear_timeouts (SliderAssembly* self);
static gboolean __lambda20_ (SliderAssembly* self);
static gboolean _slider_assembly_step_callback_gsource_func (gpointer self);
static gboolean ___lambda20__gsource_func (gpointer self);
static gboolean slider_assembly_on_button_released (SliderAssembly* self,
                                             GtkWidget* sender,
                                             GdkEventButton* event);
static void slider_assembly_clear_timeout (guint* id);
static GObject * slider_assembly_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static gboolean _slider_assembly_on_button_pressed_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                           GdkEventButton* event,
                                                                           gpointer self);
static gboolean _slider_assembly_on_button_released_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self);
static gboolean _slider_assembly___lambda21_ (SliderAssembly* self);
static gboolean __slider_assembly___lambda21__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                      GdkEventCrossing* event,
                                                                      gpointer self);
static void _slider_assembly_on_slider_value_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                       gpointer self);
static gboolean _slider_assembly___lambda22_ (SliderAssembly* self);
static gboolean __slider_assembly___lambda22__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                      GdkEventCrossing* event,
                                                                      gpointer self);
static void slider_assembly_finalize (GObject * obj);
static GType slider_assembly_get_type_once (void);
static void _vala_slider_assembly_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_slider_assembly_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
slider_assembly_get_instance_private (SliderAssembly* self)
{
	return G_STRUCT_MEMBER_P (self, SliderAssembly_private_offset);
}

SliderAssembly*
slider_assembly_construct (GType object_type,
                           gdouble min,
                           gdouble max,
                           gdouble step,
                           gdouble initial_val)
{
	SliderAssembly * self = NULL;
	GtkScale* _tmp0_;
	GtkScale* _tmp1_;
	self = (SliderAssembly*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->slider;
	gtk_range_set_range ((GtkRange*) _tmp0_, min, max);
	_tmp1_ = self->priv->slider;
	gtk_range_set_increments ((GtkRange*) _tmp1_, step, step);
	slider_assembly_set_slider_value (self, initial_val);
	return self;
}

SliderAssembly*
slider_assembly_new (gdouble min,
                     gdouble max,
                     gdouble step,
                     gdouble initial_val)
{
	return slider_assembly_construct (TYPE_SLIDER_ASSEMBLY, min, max, step, initial_val);
}

static void
slider_assembly_on_slider_value_changed (SliderAssembly* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, slider_assembly_signals[SLIDER_ASSEMBLY_VALUE_CHANGED_SIGNAL], 0);
}

static gboolean
slider_assembly_step_callback (SliderAssembly* self)
{
	GtkEventBox* _tmp0_;
	GtkEventBox* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->active_box;
	_tmp1_ = self->priv->increase_box;
	if (_tmp0_ == _tmp1_) {
		slider_assembly_increase_step (self);
	} else {
		slider_assembly_decrease_step (self);
	}
	result = TRUE;
	return result;
}

void
slider_assembly_increase_step (SliderAssembly* self)
{
	gdouble new_value = 0.0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkScale* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = slider_assembly_get_inverted (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GtkScale* _tmp2_;
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		GtkScale* _tmp7_;
		GtkAdjustment* _tmp8_;
		GtkAdjustment* _tmp9_;
		gdouble _tmp10_;
		gdouble _tmp11_;
		_tmp2_ = self->priv->slider;
		_tmp3_ = gtk_range_get_adjustment ((GtkRange*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gtk_adjustment_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->slider;
		_tmp8_ = gtk_range_get_adjustment ((GtkRange*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gtk_adjustment_get_step_increment (_tmp9_);
		_tmp11_ = _tmp10_;
		new_value = _tmp6_ + _tmp11_;
	} else {
		GtkScale* _tmp12_;
		GtkAdjustment* _tmp13_;
		GtkAdjustment* _tmp14_;
		gdouble _tmp15_;
		gdouble _tmp16_;
		GtkScale* _tmp17_;
		GtkAdjustment* _tmp18_;
		GtkAdjustment* _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		_tmp12_ = self->priv->slider;
		_tmp13_ = gtk_range_get_adjustment ((GtkRange*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = gtk_adjustment_get_value (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->slider;
		_tmp18_ = gtk_range_get_adjustment ((GtkRange*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = gtk_adjustment_get_step_increment (_tmp19_);
		_tmp21_ = _tmp20_;
		new_value = _tmp16_ - _tmp21_;
	}
	_tmp22_ = self->priv->slider;
	gtk_range_set_value ((GtkRange*) _tmp22_, new_value);
}

void
slider_assembly_decrease_step (SliderAssembly* self)
{
	gdouble new_value = 0.0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkScale* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = slider_assembly_get_inverted (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GtkScale* _tmp2_;
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		GtkScale* _tmp7_;
		GtkAdjustment* _tmp8_;
		GtkAdjustment* _tmp9_;
		gdouble _tmp10_;
		gdouble _tmp11_;
		_tmp2_ = self->priv->slider;
		_tmp3_ = gtk_range_get_adjustment ((GtkRange*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gtk_adjustment_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->slider;
		_tmp8_ = gtk_range_get_adjustment ((GtkRange*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gtk_adjustment_get_step_increment (_tmp9_);
		_tmp11_ = _tmp10_;
		new_value = _tmp6_ - _tmp11_;
	} else {
		GtkScale* _tmp12_;
		GtkAdjustment* _tmp13_;
		GtkAdjustment* _tmp14_;
		gdouble _tmp15_;
		gdouble _tmp16_;
		GtkScale* _tmp17_;
		GtkAdjustment* _tmp18_;
		GtkAdjustment* _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		_tmp12_ = self->priv->slider;
		_tmp13_ = gtk_range_get_adjustment ((GtkRange*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = gtk_adjustment_get_value (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->slider;
		_tmp18_ = gtk_range_get_adjustment ((GtkRange*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = gtk_adjustment_get_step_increment (_tmp19_);
		_tmp21_ = _tmp20_;
		new_value = _tmp16_ + _tmp21_;
	}
	_tmp22_ = self->priv->slider;
	gtk_range_set_value ((GtkRange*) _tmp22_, new_value);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_slider_assembly_step_callback_gsource_func (gpointer self)
{
	gboolean result;
	result = slider_assembly_step_callback ((SliderAssembly*) self);
	return result;
}

static gboolean
__lambda20_ (SliderAssembly* self)
{
	gboolean result;
	self->priv->click_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 20, _slider_assembly_step_callback_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->initial_wait_id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
___lambda20__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda20_ ((SliderAssembly*) self);
	return result;
}

static gboolean
slider_assembly_on_button_pressed (SliderAssembly* self,
                                   GtkWidget* sender,
                                   GdkEventButton* event)
{
	GtkEventBox* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	slider_assembly_clear_timeouts (self);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sender, gtk_event_box_get_type (), GtkEventBox));
	_g_object_unref0 (self->priv->active_box);
	self->priv->active_box = _tmp0_;
	self->priv->initial_wait_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda20__gsource_func, g_object_ref (self), g_object_unref);
	slider_assembly_step_callback (self);
	result = TRUE;
	return result;
}

static gboolean
slider_assembly_on_button_released (SliderAssembly* self,
                                    GtkWidget* sender,
                                    GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	slider_assembly_clear_timeouts (self);
	result = TRUE;
	return result;
}

static void
slider_assembly_clear_timeouts (SliderAssembly* self)
{
	g_return_if_fail (self != NULL);
	slider_assembly_clear_timeout (&self->priv->initial_wait_id);
	slider_assembly_clear_timeout (&self->priv->click_id);
}

static void
slider_assembly_clear_timeout (guint* id)
{
	if ((*id) != ((guint) 0)) {
		g_source_remove (*id);
		*id = (guint) 0;
	}
}

static gboolean
slider_assembly_get_inverted (SliderAssembly* self)
{
	gboolean result;
	GtkScale* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->slider;
	_tmp1_ = gtk_range_get_inverted ((GtkRange*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
slider_assembly_set_inverted (SliderAssembly* self,
                              gboolean value)
{
	GtkScale* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->slider;
	gtk_range_set_inverted ((GtkRange*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, slider_assembly_properties[SLIDER_ASSEMBLY_INVERTED_PROPERTY]);
}

gdouble
slider_assembly_get_slider_value (SliderAssembly* self)
{
	gdouble result;
	GtkScale* _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->slider;
	result = gtk_range_get_value ((GtkRange*) _tmp0_);
	return result;
}

void
slider_assembly_set_slider_value (SliderAssembly* self,
                                  gdouble value)
{
	GtkScale* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->slider;
	gtk_range_set_value ((GtkRange*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, slider_assembly_properties[SLIDER_ASSEMBLY_SLIDER_VALUE_PROPERTY]);
}

static gboolean
_slider_assembly_on_button_pressed_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                  GdkEventButton* event,
                                                                  gpointer self)
{
	gboolean result;
	result = slider_assembly_on_button_pressed ((SliderAssembly*) self, _sender, event);
	return result;
}

static gboolean
_slider_assembly_on_button_released_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                     GdkEventButton* event,
                                                                     gpointer self)
{
	gboolean result;
	result = slider_assembly_on_button_released ((SliderAssembly*) self, _sender, event);
	return result;
}

static gboolean
_slider_assembly___lambda21_ (SliderAssembly* self)
{
	gboolean result;
	slider_assembly_clear_timeouts (self);
	result = FALSE;
	return result;
}

static gboolean
__slider_assembly___lambda21__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                             GdkEventCrossing* event,
                                                             gpointer self)
{
	gboolean result;
	result = _slider_assembly___lambda21_ ((SliderAssembly*) self);
	return result;
}

static void
_slider_assembly_on_slider_value_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                  gpointer self)
{
	slider_assembly_on_slider_value_changed ((SliderAssembly*) self);
}

static gboolean
_slider_assembly___lambda22_ (SliderAssembly* self)
{
	gboolean result;
	slider_assembly_clear_timeouts (self);
	result = FALSE;
	return result;
}

static gboolean
__slider_assembly___lambda22__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                             GdkEventCrossing* event,
                                                             gpointer self)
{
	gboolean result;
	result = _slider_assembly___lambda22_ ((SliderAssembly*) self);
	return result;
}

static GObject *
slider_assembly_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SliderAssembly * self;
	GtkImage* decrease = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	GtkImage* _tmp4_ = NULL;
	GtkImage* _tmp5_;
	GtkEventBox* _tmp6_;
	GtkEventBox* _tmp7_;
	GtkEventBox* _tmp8_;
	GtkEventBox* _tmp9_;
	GtkImage* _tmp10_;
	GtkEventBox* _tmp11_;
	GtkEventBox* _tmp12_;
	GtkEventBox* _tmp13_;
	GtkEventBox* _tmp14_;
	gchar* primary_tooltip_text = NULL;
	gchar* _tmp15_;
	gchar* secondary_tooltip_text = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkScale* _tmp25_ = NULL;
	GtkScale* _tmp26_;
	GtkScale* _tmp27_;
	GtkScale* _tmp28_;
	GtkImage* increase = NULL;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	GtkImage* _tmp33_ = NULL;
	GtkImage* _tmp34_;
	GtkEventBox* _tmp35_;
	GtkEventBox* _tmp36_;
	GtkEventBox* _tmp37_;
	GtkEventBox* _tmp38_;
	GtkImage* _tmp39_;
	GtkEventBox* _tmp40_;
	GtkEventBox* _tmp41_;
	GtkEventBox* _tmp42_;
	GtkEventBox* _tmp43_;
	parent_class = G_OBJECT_CLASS (slider_assembly_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SLIDER_ASSEMBLY, SliderAssembly);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) self, 5);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 5);
	_tmp0_ = g_strdup ("<Control>minus");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = granite_markup_accel_tooltip (_tmp2_, (gint) 1, _ ("Zoom Out"));
	_tmp4_ = (GtkImage*) gtk_image_new_from_icon_name (RESOURCES_ICON_ZOOM_OUT, (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp4_, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	decrease = _tmp5_;
	_tmp6_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->decrease_box);
	self->priv->decrease_box = _tmp6_;
	_tmp7_ = self->priv->decrease_box;
	gtk_event_box_set_above_child (_tmp7_, TRUE);
	_tmp8_ = self->priv->decrease_box;
	gtk_event_box_set_visible_window (_tmp8_, FALSE);
	_tmp9_ = self->priv->decrease_box;
	_tmp10_ = decrease;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->decrease_box;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "button-press-event", (GCallback) _slider_assembly_on_button_pressed_gtk_widget_button_press_event, self, 0);
	_tmp12_ = self->priv->decrease_box;
	g_signal_connect_object ((GtkWidget*) _tmp12_, "button-release-event", (GCallback) _slider_assembly_on_button_released_gtk_widget_button_release_event, self, 0);
	_tmp13_ = self->priv->decrease_box;
	g_signal_connect_object ((GtkWidget*) _tmp13_, "leave-notify-event", (GCallback) __slider_assembly___lambda21__gtk_widget_leave_notify_event, self, 0);
	_tmp14_ = self->priv->decrease_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp14_);
	_tmp15_ = g_strdup (_ ("Adjust Zoom"));
	primary_tooltip_text = _tmp15_;
	_tmp16_ = granite_accel_to_string ("<Control>");
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup_printf (_ ("%s + Scroll"), _tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	secondary_tooltip_text = _tmp19_;
	_tmp20_ = primary_tooltip_text;
	_tmp21_ = secondary_tooltip_text;
	_tmp22_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup_printf ("%s\n%s", _tmp20_, _tmp23_);
	_tmp25_ = (GtkScale*) gtk_scale_new (GTK_ORIENTATION_HORIZONTAL, NULL);
	gtk_scale_set_draw_value (_tmp25_, FALSE);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp25_, _tmp24_);
	_g_free0 (_tmp24_);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->slider);
	self->priv->slider = _tmp25_;
	_g_free0 (_tmp23_);
	_tmp26_ = self->priv->slider;
	g_signal_connect_object ((GtkRange*) _tmp26_, "value-changed", (GCallback) _slider_assembly_on_slider_value_changed_gtk_range_value_changed, self, 0);
	_tmp27_ = self->priv->slider;
	gtk_widget_set_size_request ((GtkWidget*) _tmp27_, 150, -1);
	_tmp28_ = self->priv->slider;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp28_);
	_tmp29_ = g_strdup ("<Control>plus");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 1;
	_tmp32_ = granite_markup_accel_tooltip (_tmp31_, (gint) 1, _ ("Zoom In"));
	_tmp33_ = (GtkImage*) gtk_image_new_from_icon_name (RESOURCES_ICON_ZOOM_IN, (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp33_, _tmp32_);
	_g_free0 (_tmp32_);
	g_object_ref_sink (_tmp33_);
	_tmp34_ = _tmp33_;
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	increase = _tmp34_;
	_tmp35_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->increase_box);
	self->priv->increase_box = _tmp35_;
	_tmp36_ = self->priv->increase_box;
	gtk_event_box_set_above_child (_tmp36_, TRUE);
	_tmp37_ = self->priv->increase_box;
	gtk_event_box_set_visible_window (_tmp37_, FALSE);
	_tmp38_ = self->priv->increase_box;
	_tmp39_ = increase;
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = self->priv->increase_box;
	g_signal_connect_object ((GtkWidget*) _tmp40_, "button-press-event", (GCallback) _slider_assembly_on_button_pressed_gtk_widget_button_press_event, self, 0);
	_tmp41_ = self->priv->increase_box;
	g_signal_connect_object ((GtkWidget*) _tmp41_, "button-release-event", (GCallback) _slider_assembly_on_button_released_gtk_widget_button_release_event, self, 0);
	_tmp42_ = self->priv->increase_box;
	g_signal_connect_object ((GtkWidget*) _tmp42_, "leave-notify-event", (GCallback) __slider_assembly___lambda22__gtk_widget_leave_notify_event, self, 0);
	_tmp43_ = self->priv->increase_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp43_);
	_g_object_unref0 (increase);
	_g_free0 (secondary_tooltip_text);
	_g_free0 (primary_tooltip_text);
	_g_object_unref0 (decrease);
	return obj;
}

static void
slider_assembly_class_init (SliderAssemblyClass * klass,
                            gpointer klass_data)
{
	slider_assembly_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SliderAssembly_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slider_assembly_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slider_assembly_set_property;
	G_OBJECT_CLASS (klass)->constructor = slider_assembly_constructor;
	G_OBJECT_CLASS (klass)->finalize = slider_assembly_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLIDER_ASSEMBLY_INVERTED_PROPERTY, slider_assembly_properties[SLIDER_ASSEMBLY_INVERTED_PROPERTY] = g_param_spec_boolean ("inverted", "inverted", "inverted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLIDER_ASSEMBLY_SLIDER_VALUE_PROPERTY, slider_assembly_properties[SLIDER_ASSEMBLY_SLIDER_VALUE_PROPERTY] = g_param_spec_double ("slider-value", "slider-value", "slider-value", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	slider_assembly_signals[SLIDER_ASSEMBLY_VALUE_CHANGED_SIGNAL] = g_signal_new ("value-changed", TYPE_SLIDER_ASSEMBLY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
slider_assembly_instance_init (SliderAssembly * self,
                               gpointer klass)
{
	self->priv = slider_assembly_get_instance_private (self);
	self->priv->click_id = (guint) 0;
	self->priv->initial_wait_id = (guint) 0;
}

static void
slider_assembly_finalize (GObject * obj)
{
	SliderAssembly * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SLIDER_ASSEMBLY, SliderAssembly);
	_g_object_unref0 (self->priv->slider);
	_g_object_unref0 (self->priv->decrease_box);
	_g_object_unref0 (self->priv->increase_box);
	_g_object_unref0 (self->priv->active_box);
	G_OBJECT_CLASS (slider_assembly_parent_class)->finalize (obj);
}

static GType
slider_assembly_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SliderAssemblyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slider_assembly_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SliderAssembly), 0, (GInstanceInitFunc) slider_assembly_instance_init, NULL };
	GType slider_assembly_type_id;
	slider_assembly_type_id = g_type_register_static (gtk_grid_get_type (), "SliderAssembly", &g_define_type_info, 0);
	SliderAssembly_private_offset = g_type_add_instance_private (slider_assembly_type_id, sizeof (SliderAssemblyPrivate));
	return slider_assembly_type_id;
}

GType
slider_assembly_get_type (void)
{
	static volatile gsize slider_assembly_type_id__once = 0;
	if (g_once_init_enter (&slider_assembly_type_id__once)) {
		GType slider_assembly_type_id;
		slider_assembly_type_id = slider_assembly_get_type_once ();
		g_once_init_leave (&slider_assembly_type_id__once, slider_assembly_type_id);
	}
	return slider_assembly_type_id__once;
}

static void
_vala_slider_assembly_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	SliderAssembly * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SLIDER_ASSEMBLY, SliderAssembly);
	switch (property_id) {
		case SLIDER_ASSEMBLY_INVERTED_PROPERTY:
		g_value_set_boolean (value, slider_assembly_get_inverted (self));
		break;
		case SLIDER_ASSEMBLY_SLIDER_VALUE_PROPERTY:
		g_value_set_double (value, slider_assembly_get_slider_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slider_assembly_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	SliderAssembly * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SLIDER_ASSEMBLY, SliderAssembly);
	switch (property_id) {
		case SLIDER_ASSEMBLY_INVERTED_PROPERTY:
		slider_assembly_set_inverted (self, g_value_get_boolean (value));
		break;
		case SLIDER_ASSEMBLY_SLIDER_VALUE_PROPERTY:
		slider_assembly_set_slider_value (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

