/*
   Copyright The containerd Authors.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package types

import "io"

// ManifestAnnotateOptions specifies options for `nerdctl manifest annotate`.
type ManifestAnnotateOptions struct {
	Stdout     io.Writer
	GOptions   GlobalCommandOptions
	Os         string
	Arch       string
	OsVersion  string
	Variant    string
	OsFeatures []string
}

// ManifestCreateOptions specifies options for `nerdctl manifest create`.
type ManifestCreateOptions struct {
	Stdout   io.Writer
	GOptions GlobalCommandOptions
	// Amend an existing manifest list
	Amend bool
	// Allow communication with an insecure registry
	Insecure bool
}

// ManifestInspectOptions specifies options for `nerdctl manifest inspect`.
type ManifestInspectOptions struct {
	Stdout   io.Writer
	GOptions GlobalCommandOptions
	// Verbose output additional info including layers and platform
	Verbose bool
	// Allow communication with an insecure registry
	Insecure bool
}

// ManifestPushOptions specifies options for `nerdctl manifest push`.
type ManifestPushOptions struct {
	Stdout   io.Writer
	GOptions GlobalCommandOptions
	// Allow communication with an insecure registry
	Insecure bool
	// Remove the manifest list after pushing
	Purge bool
}
