
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kacceleratormanager_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KAcceleratorManager_Type = nullptr;
static PyTypeObject *Sbk_KAcceleratorManager_TypeF(void)
{
    return _Sbk_KAcceleratorManager_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KAcceleratorManager_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KAcceleratorManager >()))
        return -1;

    ::KAcceleratorManager *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KAcceleratorManager_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // KAcceleratorManager()
        cptr = new ::KAcceleratorManager();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KAcceleratorManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KAcceleratorManagerFunc_addStandardActionNames(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KAcceleratorManager::addStandardActionNames(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArg)))) {
        overloadId = 0; // addStandardActionNames(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addStandardActionNames", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAcceleratorManager_IDX]);

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addStandardActionNames(QStringList)
            ::KAcceleratorManager::addStandardActionNames(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAcceleratorManagerFunc_last_manage(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "last_manage", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KAcceleratorManager::last_manage(QString&,QString&,QString&)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        overloadId = 0; // last_manage(QString&,QString&,QString&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "last_manage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAcceleratorManager_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // last_manage(QString&,QString&,QString&)
            ::KAcceleratorManager::last_manage(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAcceleratorManagerFunc_manage(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "manage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAcceleratorManager_IDX]);

    if (PyArg_ParseTuple(args, "|OO:manage", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KAcceleratorManager::manage(QWidget*,bool=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // manage(QWidget*,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // manage(QWidget*,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "manage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAcceleratorManager_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"programmers_mode", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "manage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAcceleratorManager_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // manage(QWidget*,bool)
            ::KAcceleratorManager::manage(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAcceleratorManagerFunc_setNoAccel(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KAcceleratorManager::setNoAccel(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // setNoAccel(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setNoAccel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAcceleratorManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setNoAccel(QWidget*)
            ::KAcceleratorManager::setNoAccel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KAcceleratorManager_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KAcceleratorManager_methods[] = {
    {"addStandardActionNames", reinterpret_cast<PyCFunction>(Sbk_KAcceleratorManagerFunc_addStandardActionNames), METH_O|METH_STATIC, nullptr},
    {"last_manage", reinterpret_cast<PyCFunction>(Sbk_KAcceleratorManagerFunc_last_manage), METH_VARARGS|METH_STATIC, nullptr},
    {"manage", reinterpret_cast<PyCFunction>(Sbk_KAcceleratorManagerFunc_manage), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"setNoAccel", reinterpret_cast<PyCFunction>(Sbk_KAcceleratorManagerFunc_setNoAccel), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KAcceleratorManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KAcceleratorManager_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KAcceleratorManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KAcceleratorManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KAcceleratorManager_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KAcceleratorManager_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KAcceleratorManager_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KAcceleratorManager_spec = {
    "1:KWidgetsAddons.KAcceleratorManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KAcceleratorManager_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KAcceleratorManager_PythonToCpp_KAcceleratorManager_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KAcceleratorManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KAcceleratorManager_PythonToCpp_KAcceleratorManager_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KAcceleratorManager_TypeF()))
        return KAcceleratorManager_PythonToCpp_KAcceleratorManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KAcceleratorManager_PTR_CppToPython_KAcceleratorManager(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KAcceleratorManager_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KAcceleratorManager_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KAcceleratorManager_SignatureStrings[] = {
    "KWidgetsAddons.KAcceleratorManager(self)",
    "KWidgetsAddons.KAcceleratorManager.addStandardActionNames(names:QStringList)",
    "KWidgetsAddons.KAcceleratorManager.last_manage(added:QString,changed:QString,removed:QString)",
    "KWidgetsAddons.KAcceleratorManager.manage(widget:PySide6.QtWidgets.QWidget,programmers_mode:bool=false)",
    "KWidgetsAddons.KAcceleratorManager.setNoAccel(widget:PySide6.QtWidgets.QWidget)",
    nullptr}; // Sentinel
#else
static constexpr size_t KAcceleratorManager_SignatureByteSize = 169;
static constexpr uint8_t KAcceleratorManager_SignatureBytes[169] = {
    0x78, 0xda, 0x8d, 0x8d, 0xb1, 0x0a, 0xc2, 0x40, 0x0c, 0x86, 0xf7, 0x3e, 0x49, 0x05, 0xe9, 0xe8,
    0x50, 0x70, 0xe8, 0x5c, 0x2d, 0x96, 0x0e, 0x8e, 0x25, 0x5e, 0xe2, 0x79, 0x70, 0x77, 0x91, 0x24,
    0x28, 0xbe, 0xbd, 0x5a, 0x15, 0xdd, 0xec, 0x12, 0xf2, 0x85, 0x3f, 0xdf, 0xdf, 0xee, 0x03, 0x7a,
    0x32, 0x6d, 0x10, 0x39, 0x6b, 0xd5, 0x36, 0xce, 0x51, 0x24, 0x01, 0x63, 0xd9, 0x42, 0x06, 0x4f,
    0x52, 0x2a, 0xc5, 0xe3, 0xa2, 0x68, 0xff, 0x06, 0x2b, 0x40, 0x1c, 0x0c, 0x32, 0x82, 0x60, 0xe3,
    0x2c, 0x70, 0xee, 0x20, 0x91, 0x96, 0xf9, 0x39, 0xeb, 0x7e, 0x30, 0x09, 0xd9, 0x6f, 0x82, 0xda,
    0x2c, 0x59, 0x04, 0xb5, 0x31, 0x4d, 0x50, 0x3e, 0xc4, 0x84, 0x1f, 0xc3, 0xd2, 0x9d, 0x20, 0xfb,
    0x1f, 0x16, 0x4a, 0x7c, 0xf9, 0xf2, 0x2c, 0xfb, 0x5b, 0x7c, 0x9d, 0x82, 0xf5, 0xee, 0x36, 0x04,
    0xa4, 0x55, 0xd5, 0xdb, 0xfb, 0xb3, 0xea, 0x5f, 0xcb, 0xf2, 0x2c, 0xec, 0x05, 0x52, 0x22, 0xd1,
    0x31, 0x31, 0x52, 0x7d, 0x60, 0x8e, 0xeb, 0x23, 0x44, 0xa5, 0x59, 0x3d, 0x4a, 0xd6, 0xf1, 0x74,
    0xff, 0xdb, 0xb5, 0x28, 0xee, 0x0c, 0x32, 0x93, 0xa9
};
#endif

PyTypeObject *init_KAcceleratorManager(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KAcceleratorManager_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KAcceleratorManager_IDX].type;

    Shiboken::AutoDecRef Sbk_KAcceleratorManager_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KAcceleratorManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KAcceleratorManager",
        "KAcceleratorManager*",
        &Sbk_KAcceleratorManager_spec,
        &Shiboken::callCppDestructor< ::KAcceleratorManager >,
        Sbk_KAcceleratorManager_Type_bases.object(),
        0);
    auto *pyType = Sbk_KAcceleratorManager_TypeF(); // references _Sbk_KAcceleratorManager_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KAcceleratorManager_SignatureStrings);
#else
    InitSignatureBytes(pyType, KAcceleratorManager_SignatureBytes, KAcceleratorManager_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KAcceleratorManager_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KAcceleratorManager_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KAcceleratorManager_PythonToCpp_KAcceleratorManager_PTR,
        is_KAcceleratorManager_PythonToCpp_KAcceleratorManager_PTR_Convertible,
        KAcceleratorManager_PTR_CppToPython_KAcceleratorManager);

    Shiboken::Conversions::registerConverterName(converter, "KAcceleratorManager");
    Shiboken::Conversions::registerConverterName(converter, "KAcceleratorManager*");
    Shiboken::Conversions::registerConverterName(converter, "KAcceleratorManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KAcceleratorManager).name());

    qRegisterMetaType< ::KAcceleratorManager *>();

    return pyType;
}
