/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// ContainerPortApplyConfiguration represents a declarative configuration of the ContainerPort type for use
// with apply.
//
// ContainerPort represents a network port in a single container.
type ContainerPortApplyConfiguration struct {
	// If specified, this must be an IANA_SVC_NAME and unique within the pod. Each
	// named port in a pod must have a unique name. Name for the port that can be
	// referred to by services.
	Name *string `json:"name,omitempty"`
	// Number of port to expose on the host.
	// If specified, this must be a valid port number, 0 < x < 65536.
	// If HostNetwork is specified, this must match ContainerPort.
	// Most containers do not need this.
	HostPort *int32 `json:"hostPort,omitempty"`
	// Number of port to expose on the pod's IP address.
	// This must be a valid port number, 0 < x < 65536.
	ContainerPort *int32 `json:"containerPort,omitempty"`
	// Protocol for port. Must be UDP, TCP, or SCTP.
	// Defaults to "TCP".
	Protocol *corev1.Protocol `json:"protocol,omitempty"`
	// What host IP to bind the external port to.
	HostIP *string `json:"hostIP,omitempty"`
}

// ContainerPortApplyConfiguration constructs a declarative configuration of the ContainerPort type for use with
// apply.
func ContainerPort() *ContainerPortApplyConfiguration {
	return &ContainerPortApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ContainerPortApplyConfiguration) WithName(value string) *ContainerPortApplyConfiguration {
	b.Name = &value
	return b
}

// WithHostPort sets the HostPort field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HostPort field is set to the value of the last call.
func (b *ContainerPortApplyConfiguration) WithHostPort(value int32) *ContainerPortApplyConfiguration {
	b.HostPort = &value
	return b
}

// WithContainerPort sets the ContainerPort field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ContainerPort field is set to the value of the last call.
func (b *ContainerPortApplyConfiguration) WithContainerPort(value int32) *ContainerPortApplyConfiguration {
	b.ContainerPort = &value
	return b
}

// WithProtocol sets the Protocol field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Protocol field is set to the value of the last call.
func (b *ContainerPortApplyConfiguration) WithProtocol(value corev1.Protocol) *ContainerPortApplyConfiguration {
	b.Protocol = &value
	return b
}

// WithHostIP sets the HostIP field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HostIP field is set to the value of the last call.
func (b *ContainerPortApplyConfiguration) WithHostIP(value string) *ContainerPortApplyConfiguration {
	b.HostIP = &value
	return b
}
