
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kruntimeplatform_wrapper.h"

// Argument includes
#include <QStringList>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KRuntimePlatform_Type = nullptr;
static PyTypeObject *Sbk_KRuntimePlatform_TypeF(void)
{
    return _Sbk_KRuntimePlatform_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KRuntimePlatform_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KRuntimePlatform");
    return -1;
}

static PyObject *Sbk_KRuntimePlatformFunc_runtimePlatform(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // runtimePlatform()
        QStringList cppResult = ::KRuntimePlatform::runtimePlatform();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KRuntimePlatform_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KRuntimePlatform_methods[] = {
    {"runtimePlatform", reinterpret_cast<PyCFunction>(Sbk_KRuntimePlatformFunc_runtimePlatform), METH_NOARGS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KRuntimePlatform_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KRuntimePlatform_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KRuntimePlatform_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KRuntimePlatform_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KRuntimePlatform_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KRuntimePlatform_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KRuntimePlatform_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KRuntimePlatform_spec = {
    "1:KCoreAddons.KRuntimePlatform",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KRuntimePlatform_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKRuntimePlatform_SignatureStrings[] = {
    "KCoreAddons.KRuntimePlatform.runtimePlatform()->QStringList",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKRuntimePlatform_SignatureByteSize = 56;
static constexpr uint8_t KCoreAddonsKRuntimePlatform_SignatureBytes[56] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x0e,
    0x2a, 0xcd, 0x2b, 0xc9, 0xcc, 0x4d, 0x0d, 0xc8, 0x49, 0x2c, 0x49, 0xcb, 0x2f, 0xca, 0xd5, 0x2b,
    0x42, 0xe5, 0x6b, 0x68, 0xea, 0xda, 0x05, 0x06, 0x97, 0x14, 0x65, 0xe6, 0xa5, 0xfb, 0x64, 0x16,
    0x97, 0x70, 0x01, 0x00, 0xb6, 0xe5, 0x16, 0x71
};
#endif

PyTypeObject *init_KCoreAddonsKRuntimePlatform(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKRuntimePlatform_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKRuntimePlatform_IDX].type;

    Shiboken::AutoDecRef Sbk_KRuntimePlatform_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KRuntimePlatform_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KRuntimePlatform",
        "KRuntimePlatform",
        &Sbk_KRuntimePlatform_spec,
        nullptr,
        Sbk_KRuntimePlatform_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KRuntimePlatform_Type; // references _Sbk_KRuntimePlatform_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKRuntimePlatform_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKRuntimePlatform_SignatureBytes, KCoreAddonsKRuntimePlatform_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KRuntimePlatform_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKRuntimePlatform_IDX].type = pyType;



    return pyType;
}
