{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Pango.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "namespace Pango"
 , ""
 , "# https://bugzilla.gnome.org/show_bug.cgi?id=766452"
 , "alloc-info Attribute calloc=none copy=pango_attribute_copy free=pango_attribute_destroy"
 , ""
 , "# Wrong annotation"
 , "# https://mail.gnome.org/archives/gir-devel-list/2016-October/msg00000.html"
 , "set-attr Pango/Matrix/transform_pixel_rectangle/@parameters/rect direction in"
 , ""
 , "# Wrongly annotated as caller-allocates"
 , "# https://github.com/haskell-gi/haskell-gi/issues/78"
 , "# https://bugzilla.gnome.org/show_bug.cgi?id=779232"
 , "set-attr Pango/Layout/get_size/@parameters/width caller-allocates 0"
 , "set-attr Pango/Layout/get_size/@parameters/height caller-allocates 0"
 , ""
 , "set-attr Pango/AttrFontDesc/new introspectable 1"
 , "set-attr Pango/AttrFontFeatures/new introspectable 1"
 , "set-attr Pango/AttrLanguage/new introspectable 1"
 , "set-attr Pango/AttrShape/new introspectable 1"
 , "set-attr Pango/AttrSize/new introspectable 1"
 , "set-attr Pango/attr_background_alpha_new introspectable 1"
 , "set-attr Pango/attr_background_new introspectable 1"
 , "set-attr Pango/attr_fallback_new introspectable 1"
 , "set-attr Pango/attr_family_new introspectable 1"
 , "set-attr Pango/attr_foreground_alpha_new introspectable 1"
 , "set-attr Pango/attr_foreground_new introspectable 1"
 , "set-attr Pango/attr_gravity_hint_new introspectable 1"
 , "set-attr Pango/attr_gravity_new introspectable 1"
 , "set-attr Pango/attr_letter_spacing_new introspectable 1"
 , "set-attr Pango/attr_rise_new introspectable 1"
 , "set-attr Pango/attr_scale_new introspectable 1"
 , "set-attr Pango/attr_stretch_new introspectable 1"
 , "set-attr Pango/attr_strikethrough_color_new introspectable 1"
 , "set-attr Pango/attr_strikethrough_new introspectable 1"
 , "set-attr Pango/attr_style_new introspectable 1"
 , "set-attr Pango/attr_underline_color_new introspectable 1"
 , "set-attr Pango/attr_underline_new introspectable 1"
 , "set-attr Pango/attr_variant_new introspectable 1"
 , "set-attr Pango/attr_weight_new introspectable 1"
 , ""
 , "set-attr Pango/Context/set_font_map/@parameters/font_map nullable 1"
 , ""
 , "# Generated from pango 1.40.1 with xsltproc Nullable.xslt Pango-1.0.gir"
 , "set-attr Pango/AttrDataCopyFunc/@return-value nullable 1"
 , "set-attr Pango/AttrDataCopyFunc/@parameters/user_data nullable 1"
 , "set-attr Pango/AttrFilterFunc/@parameters/user_data nullable 1"
 , "set-attr Pango/AttrIterator/get/@return-value nullable 1"
 , "set-attr Pango/AttrIterator/get_font/@parameters/language nullable 1"
 , "set-attr Pango/AttrIterator/get_font/@parameters/extra_attrs nullable 1"
 , "set-attr Pango/AttrList/copy/@return-value nullable 1"
 , "set-attr Pango/AttrList/copy/@parameters/list nullable 1"
 , "set-attr Pango/AttrList/filter/@return-value nullable 1"
 , "set-attr Pango/AttrList/filter/@parameters/data nullable 1"
 , "set-attr Pango/AttrList/ref/@parameters/list nullable 1"
 , "set-attr Pango/AttrList/unref/@parameters/list nullable 1"
 , "set-attr Pango/AttrShape/new_with_data/@parameters/data nullable 1"
 , "set-attr Pango/AttrShape/new_with_data/@parameters/copy_func nullable 1"
 , "set-attr Pango/AttrShape/new_with_data/@parameters/destroy_func nullable 1"
 , "set-attr Pango/AttrType/get_name/@return-value nullable 1"
 , "set-attr Pango/Color/copy/@return-value nullable 1"
 , "set-attr Pango/Color/copy/@parameters/src nullable 1"
 , "set-attr Pango/Color/free/@parameters/color nullable 1"
 , "set-attr Pango/Color/parse/@parameters/color nullable 1"
 , "set-attr Pango/Context/get_matrix/@return-value nullable 1"
 , "set-attr Pango/Context/get_metrics/@parameters/desc nullable 1"
 , "set-attr Pango/Context/get_metrics/@parameters/language nullable 1"
 , "set-attr Pango/Context/load_font/@return-value nullable 1"
 , "set-attr Pango/Context/load_fontset/@return-value nullable 1"
 , "set-attr Pango/Context/set_matrix/@parameters/matrix nullable 1"
 , "set-attr Pango/Coverage/from_bytes/@return-value nullable 1"
 , "set-attr Pango/Font/descriptions_free/@parameters/descs nullable 1"
 , "set-attr Pango/Font/get_font_map/@return-value nullable 1"
 , "set-attr Pango/Font/get_font_map/@parameters/font nullable 1"
 , "set-attr Pango/Font/get_glyph_extents/@parameters/font nullable 1"
 , "set-attr Pango/Font/get_metrics/@parameters/font nullable 1"
 , "set-attr Pango/Font/get_metrics/@parameters/language nullable 1"
 , "set-attr Pango/Font/get_font_map/@return-value nullable 1"
 , "set-attr Pango/Font/get_font_map/@parameters/font nullable 1"
 , "set-attr Pango/Font/get_glyph_extents/@parameters/font nullable 1"
 , "set-attr Pango/Font/get_metrics/@parameters/font nullable 1"
 , "set-attr Pango/Font/get_metrics/@parameters/language nullable 1"
 , "set-attr Pango/FontClass/get_glyph_extents/get_glyph_extents/@parameters/font nullable 1"
 , "set-attr Pango/FontClass/get_metrics/get_metrics/@parameters/font nullable 1"
 , "set-attr Pango/FontClass/get_metrics/get_metrics/@parameters/language nullable 1"
 , "set-attr Pango/FontClass/get_font_map/get_font_map/@return-value nullable 1"
 , "set-attr Pango/FontClass/get_font_map/get_font_map/@parameters/font nullable 1"
 , "set-attr Pango/FontDescription/better_match/@parameters/old_match nullable 1"
 , "set-attr Pango/FontDescription/copy/@return-value nullable 1"
 , "set-attr Pango/FontDescription/copy/@parameters/desc nullable 1"
 , "set-attr Pango/FontDescription/copy_static/@return-value nullable 1"
 , "set-attr Pango/FontDescription/copy_static/@parameters/desc nullable 1"
 , "set-attr Pango/FontDescription/free/@parameters/desc nullable 1"
 , "set-attr Pango/FontDescription/get_family/@return-value nullable 1"
 , "set-attr Pango/FontDescription/merge/@parameters/desc_to_merge nullable 1"
 , "set-attr Pango/FontFace/list_sizes/@parameters/sizes nullable 1"
 , "set-attr Pango/FontFace/list_sizes/@parameters/sizes nullable 1"
 , "set-attr Pango/FontFaceClass/list_sizes/list_sizes/@parameters/sizes nullable 1"
 , "set-attr Pango/FontMap/load_font/@return-value nullable 1"
 , "set-attr Pango/FontMap/load_fontset/@return-value nullable 1"
 , "set-attr Pango/FontMap/load_font/@return-value nullable 1"
 , "set-attr Pango/FontMap/load_fontset/@return-value nullable 1"
 , "set-attr Pango/FontMapClass/load_font/load_font/@return-value nullable 1"
 , "set-attr Pango/FontMapClass/load_fontset/load_fontset/@return-value nullable 1"
 , "set-attr Pango/FontMetrics/ref/@return-value nullable 1"
 , "set-attr Pango/FontMetrics/ref/@parameters/metrics nullable 1"
 , "set-attr Pango/FontMetrics/unref/@parameters/metrics nullable 1"
 , "set-attr Pango/Fontset/foreach/@parameters/data nullable 1"
 , "set-attr Pango/Fontset/foreach/@parameters/data nullable 1"
 , "set-attr Pango/FontsetClass/foreach/foreach/@parameters/data nullable 1"
 , "set-attr Pango/FontsetForeachFunc/@parameters/user_data nullable 1"
 , "set-attr Pango/GlyphItem/copy/@return-value nullable 1"
 , "set-attr Pango/GlyphItem/copy/@parameters/orig nullable 1"
 , "set-attr Pango/GlyphItem/free/@parameters/glyph_item nullable 1"
 , "set-attr Pango/GlyphItemIter/copy/@return-value nullable 1"
 , "set-attr Pango/GlyphItemIter/copy/@parameters/orig nullable 1"
 , "set-attr Pango/GlyphItemIter/free/@parameters/iter nullable 1"
 , "set-attr Pango/GlyphString/copy/@return-value nullable 1"
 , "set-attr Pango/GlyphString/copy/@parameters/string nullable 1"
 , "set-attr Pango/GlyphString/free/@parameters/string nullable 1"
 , "set-attr Pango/Gravity/get_for_matrix/@parameters/matrix nullable 1"
 , "set-attr Pango/Item/copy/@return-value nullable 1"
 , "set-attr Pango/Item/copy/@parameters/item nullable 1"
 , "set-attr Pango/Item/free/@parameters/item nullable 1"
 , "set-attr Pango/Language/get_sample_string/@parameters/language nullable 1"
 , "set-attr Pango/Language/get_scripts/@return-value nullable 1"
 , "set-attr Pango/Language/get_scripts/@parameters/language nullable 1"
 , "set-attr Pango/Language/includes_script/@parameters/language nullable 1"
 , "set-attr Pango/Language/matches/@parameters/language nullable 1"
 , "set-attr Pango/Language/from_string/@return-value nullable 1"
 , "set-attr Pango/Language/from_string/@parameters/language nullable 1"
 , "set-attr Pango/Layout/get_font_description/@return-value nullable 1"
 , "set-attr Pango/Layout/get_line/@return-value nullable 1"
 , "set-attr Pango/Layout/get_line_readonly/@return-value nullable 1"
 , "set-attr Pango/Layout/get_tabs/@return-value nullable 1"
 , "set-attr Pango/Layout/set_attributes/@parameters/attrs nullable 1"
 , "set-attr Pango/Layout/set_font_description/@parameters/desc nullable 1"
 , "set-attr Pango/Layout/set_tabs/@parameters/tabs nullable 1"
 , "set-attr Pango/LayoutIter/copy/@return-value nullable 1"
 , "set-attr Pango/LayoutIter/copy/@parameters/iter nullable 1"
 , "set-attr Pango/LayoutIter/free/@parameters/iter nullable 1"
 , "set-attr Pango/LayoutIter/get_run/@return-value nullable 1"
 , "set-attr Pango/LayoutIter/get_run_readonly/@return-value nullable 1"
 , "set-attr Pango/LayoutLine/ref/@parameters/line nullable 1"
 , "set-attr Pango/Matrix/copy/@return-value nullable 1"
 , "set-attr Pango/Matrix/copy/@parameters/matrix nullable 1"
 , "set-attr Pango/Matrix/free/@parameters/matrix nullable 1"
 , "set-attr Pango/Matrix/get_font_scale_factor/@parameters/matrix nullable 1"
 , "set-attr Pango/Matrix/get_font_scale_factors/@parameters/matrix nullable 1"
 , "set-attr Pango/Matrix/transform_distance/@parameters/matrix nullable 1"
 , "set-attr Pango/Matrix/transform_pixel_rectangle/@parameters/matrix nullable 1"
 , "set-attr Pango/Matrix/transform_pixel_rectangle/@parameters/rect nullable 1"
 , "set-attr Pango/Matrix/transform_point/@parameters/matrix nullable 1"
 , "set-attr Pango/Matrix/transform_rectangle/@parameters/matrix nullable 1"
 , "set-attr Pango/Matrix/transform_rectangle/@parameters/rect nullable 1"
 , "set-attr Pango/Renderer/draw_glyph_item/@parameters/text nullable 1"
 , "set-attr Pango/Renderer/draw_glyph_item/@parameters/text nullable 1"
 , "set-attr Pango/Renderer/get_color/@return-value nullable 1"
 , "set-attr Pango/Renderer/get_layout/@return-value nullable 1"
 , "set-attr Pango/Renderer/get_layout_line/@return-value nullable 1"
 , "set-attr Pango/Renderer/get_matrix/@return-value nullable 1"
 , "set-attr Pango/Renderer/set_color/@parameters/color nullable 1"
 , "set-attr Pango/Renderer/set_matrix/@parameters/matrix nullable 1"
 , "set-attr Pango/RendererClass/draw_glyph_item/draw_glyph_item/@parameters/text nullable 1"
 , "set-attr Pango/Script/get_sample_language/@return-value nullable 1"
 , "set-attr Pango/attr_type_get_name/@return-value nullable 1"
 , "set-attr Pango/default_break/@parameters/analysis nullable 1"
 , "set-attr Pango/extents_to_pixels/@parameters/inclusive nullable 1"
 , "set-attr Pango/extents_to_pixels/@parameters/nearest nullable 1"
 , "set-attr Pango/gravity_get_for_matrix/@parameters/matrix nullable 1"
 , "set-attr Pango/itemize/@parameters/cached_iter nullable 1"
 , "set-attr Pango/itemize_with_base_dir/@parameters/cached_iter nullable 1"
 , "set-attr Pango/language_from_string/@return-value nullable 1"
 , "set-attr Pango/language_from_string/@parameters/language nullable 1"
 , "set-attr Pango/parse_enum/@parameters/str nullable 1"
 , "set-attr Pango/read_line/@parameters/stream nullable 1"
 , "set-attr Pango/script_get_sample_language/@return-value nullable 1"
 , "set-attr Pango/shape_full/@parameters/paragraph_text nullable 1"
 , "set-attr Pango/version_check/@return-value nullable 1"]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.Pango.Config"
 , "GI.Pango"
 , "GI.Pango.Callbacks"
 , "GI.Pango.Constants"
 , "GI.Pango.Enums"
 , "GI.Pango.Flags"
 , "GI.Pango.Functions"
 , "GI.Pango.Objects"
 , "GI.Pango.Objects.Context"
 , "GI.Pango.Objects.Coverage"
 , "GI.Pango.Objects.Font"
 , "GI.Pango.Objects.FontFace"
 , "GI.Pango.Objects.FontFamily"
 , "GI.Pango.Objects.FontMap"
 , "GI.Pango.Objects.Fontset"
 , "GI.Pango.Objects.FontsetSimple"
 , "GI.Pango.Objects.Layout"
 , "GI.Pango.Objects.Renderer"
 , "GI.Pango.Structs"
 , "GI.Pango.Structs.Analysis"
 , "GI.Pango.Structs.AttrClass"
 , "GI.Pango.Structs.AttrColor"
 , "GI.Pango.Structs.AttrFloat"
 , "GI.Pango.Structs.AttrFontDesc"
 , "GI.Pango.Structs.AttrFontFeatures"
 , "GI.Pango.Structs.AttrInt"
 , "GI.Pango.Structs.AttrIterator"
 , "GI.Pango.Structs.AttrLanguage"
 , "GI.Pango.Structs.AttrList"
 , "GI.Pango.Structs.AttrShape"
 , "GI.Pango.Structs.AttrSize"
 , "GI.Pango.Structs.AttrString"
 , "GI.Pango.Structs.Attribute"
 , "GI.Pango.Structs.Color"
 , "GI.Pango.Structs.FontDescription"
 , "GI.Pango.Structs.FontMetrics"
 , "GI.Pango.Structs.GlyphGeometry"
 , "GI.Pango.Structs.GlyphInfo"
 , "GI.Pango.Structs.GlyphItem"
 , "GI.Pango.Structs.GlyphItemIter"
 , "GI.Pango.Structs.GlyphString"
 , "GI.Pango.Structs.GlyphVisAttr"
 , "GI.Pango.Structs.Item"
 , "GI.Pango.Structs.Language"
 , "GI.Pango.Structs.LayoutIter"
 , "GI.Pango.Structs.LayoutLine"
 , "GI.Pango.Structs.LogAttr"
 , "GI.Pango.Structs.Matrix"
 , "GI.Pango.Structs.Rectangle"
 , "GI.Pango.Structs.ScriptIter"
 , "GI.Pango.Structs.TabArray"]
