{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Switches between children using tabs.
-- 
-- \<picture>
--   \<source srcset=\"notebook-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkNotebook\" src=\"notebook.png\">
-- \<\/picture>
-- 
-- There are many configuration options for @GtkNotebook@. Among
-- other things, you can choose on which edge the tabs appear
-- (see 'GI.Gtk.Objects.Notebook.notebookSetTabPos'), whether, if there are
-- too many tabs to fit the notebook should be made bigger or scrolling
-- arrows added (see 'GI.Gtk.Objects.Notebook.notebookSetScrollable'), and whether
-- there will be a popup menu allowing the users to switch pages.
-- (see 'GI.Gtk.Objects.Notebook.notebookPopupEnable').
-- 
-- = GtkNotebook as GtkBuildable
-- 
-- The @GtkNotebook@ implementation of the @GtkBuildable@ interface
-- supports placing children into tabs by specifying “tab” as the
-- “type” attribute of a @\<child>@ element. Note that the content
-- of the tab must be created before the tab can be filled.
-- A tab child can be specified without specifying a @\<child>@
-- type attribute.
-- 
-- To add a child widget in the notebooks action area, specify
-- \"action-start\" or “action-end” as the “type” attribute of the
-- @\<child>@ element.
-- 
-- An example of a UI definition fragment with @GtkNotebook@:
-- 
-- 
-- === /xml code/
-- ><object class="GtkNotebook">
-- >  <child>
-- >    <object class="GtkLabel" id="notebook-content">
-- >      <property name="label">Content</property>
-- >    </object>
-- >  </child>
-- >  <child type="tab">
-- >    <object class="GtkLabel" id="notebook-tab">
-- >      <property name="label">Tab</property>
-- >    </object>
-- >  </child>
-- ></object>
-- 
-- 
-- = Shortcuts and Gestures
-- 
-- @GtkNotebook@ supports the following keyboard shortcuts:
-- 
-- * \<kbd>Shift\<\/kbd>+\<kbd>F10\<\/kbd> or \<kbd>Menu\<\/kbd> opens the context menu.
-- * \<kbd>Home\<\/kbd> moves the focus to the first tab.
-- * \<kbd>End\<\/kbd> moves the focus to the last tab.
-- 
-- 
-- Additionally, the following signals have default keybindings:
-- 
-- * [Notebook::changeCurrentPage]("GI.Gtk.Objects.Notebook#g:signal:changeCurrentPage")
-- * [Notebook::focusTab]("GI.Gtk.Objects.Notebook#g:signal:focusTab")
-- * [Notebook::moveFocusOut]("GI.Gtk.Objects.Notebook#g:signal:moveFocusOut")
-- * [Notebook::reorderTab]("GI.Gtk.Objects.Notebook#g:signal:reorderTab")
-- * [Notebook::selectPage]("GI.Gtk.Objects.Notebook#g:signal:selectPage")
-- 
-- 
-- Tabs support drag-and-drop between notebooks sharing the same @group-name@,
-- or to new windows by handling the @::create-window@ signal.
-- 
-- = Actions
-- 
-- @GtkNotebook@ defines a set of built-in actions:
-- 
-- * @menu.popup@ opens the tabs context menu.
-- 
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >notebook
-- >├── header.top
-- >│   ├── [<action widget>]
-- >│   ├── tabs
-- >│   │   ├── [arrow]
-- >│   │   ├── tab
-- >│   │   │   ╰── <tab label>
-- >┊   ┊   ┊
-- >│   │   ├── tab[.reorderable-page]
-- >│   │   │   ╰── <tab label>
-- >│   │   ╰── [arrow]
-- >│   ╰── [<action widget>]
-- >│
-- >╰── stack
-- >    ├── <child>
-- >    ┊
-- >    ╰── <child>
-- 
-- 
-- @GtkNotebook@ has a main CSS node with name @notebook@, a subnode
-- with name @header@ and below that a subnode with name @tabs@ which
-- contains one subnode per tab with name @tab@.
-- 
-- If action widgets are present, their CSS nodes are placed next
-- to the @tabs@ node. If the notebook is scrollable, CSS nodes with
-- name @arrow@ are placed as first and last child of the @tabs@ node.
-- 
-- The main node gets the @.frame@ style class when the notebook
-- has a border (see 'GI.Gtk.Objects.Notebook.notebookSetShowBorder').
-- 
-- The header node gets one of the style class @.top@, @.bottom@,
-- @.left@ or @.right@, depending on where the tabs are placed. For
-- reorderable pages, the tab node gets the @.reorderable-page@ class.
-- 
-- A @tab@ node gets the @.dnd@ style class while it is moved with drag-and-drop.
-- 
-- The nodes are always arranged from left-to-right, regardless of text direction.
-- 
-- = Accessibility
-- 
-- @GtkNotebook@ uses the following roles:
-- 
-- * 'GI.Gtk.Enums.AccessibleRoleGroup' for the notebook widget
-- * 'GI.Gtk.Enums.AccessibleRoleTabList' for the list of tabs
-- * 'GI.Gtk.Enums.AccessibleRoleTab' role for each tab
-- * 'GI.Gtk.Enums.AccessibleRoleTabPanel' for each page
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Notebook
    ( 

-- * Exported types
    Notebook(..)                            ,
    IsNotebook                              ,
    toNotebook                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [appendPage]("GI.Gtk.Objects.Notebook#g:method:appendPage"), [appendPageMenu]("GI.Gtk.Objects.Notebook#g:method:appendPageMenu"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [detachTab]("GI.Gtk.Objects.Notebook#g:method:detachTab"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [insertPage]("GI.Gtk.Objects.Notebook#g:method:insertPage"), [insertPageMenu]("GI.Gtk.Objects.Notebook#g:method:insertPageMenu"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [nextPage]("GI.Gtk.Objects.Notebook#g:method:nextPage"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pageNum]("GI.Gtk.Objects.Notebook#g:method:pageNum"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [popupDisable]("GI.Gtk.Objects.Notebook#g:method:popupDisable"), [popupEnable]("GI.Gtk.Objects.Notebook#g:method:popupEnable"), [prependPage]("GI.Gtk.Objects.Notebook#g:method:prependPage"), [prependPageMenu]("GI.Gtk.Objects.Notebook#g:method:prependPageMenu"), [prevPage]("GI.Gtk.Objects.Notebook#g:method:prevPage"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removePage]("GI.Gtk.Objects.Notebook#g:method:removePage"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [reorderChild]("GI.Gtk.Objects.Notebook#g:method:reorderChild"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActionWidget]("GI.Gtk.Objects.Notebook#g:method:getActionWidget"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCurrentPage]("GI.Gtk.Objects.Notebook#g:method:getCurrentPage"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getGroupName]("GI.Gtk.Objects.Notebook#g:method:getGroupName"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMenuLabel]("GI.Gtk.Objects.Notebook#g:method:getMenuLabel"), [getMenuLabelText]("GI.Gtk.Objects.Notebook#g:method:getMenuLabelText"), [getNPages]("GI.Gtk.Objects.Notebook#g:method:getNPages"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getNthPage]("GI.Gtk.Objects.Notebook#g:method:getNthPage"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPage]("GI.Gtk.Objects.Notebook#g:method:getPage"), [getPages]("GI.Gtk.Objects.Notebook#g:method:getPages"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getScrollable]("GI.Gtk.Objects.Notebook#g:method:getScrollable"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowBorder]("GI.Gtk.Objects.Notebook#g:method:getShowBorder"), [getShowTabs]("GI.Gtk.Objects.Notebook#g:method:getShowTabs"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTabDetachable]("GI.Gtk.Objects.Notebook#g:method:getTabDetachable"), [getTabLabel]("GI.Gtk.Objects.Notebook#g:method:getTabLabel"), [getTabLabelText]("GI.Gtk.Objects.Notebook#g:method:getTabLabelText"), [getTabPos]("GI.Gtk.Objects.Notebook#g:method:getTabPos"), [getTabReorderable]("GI.Gtk.Objects.Notebook#g:method:getTabReorderable"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setActionWidget]("GI.Gtk.Objects.Notebook#g:method:setActionWidget"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCurrentPage]("GI.Gtk.Objects.Notebook#g:method:setCurrentPage"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setGroupName]("GI.Gtk.Objects.Notebook#g:method:setGroupName"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMenuLabel]("GI.Gtk.Objects.Notebook#g:method:setMenuLabel"), [setMenuLabelText]("GI.Gtk.Objects.Notebook#g:method:setMenuLabelText"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setScrollable]("GI.Gtk.Objects.Notebook#g:method:setScrollable"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowBorder]("GI.Gtk.Objects.Notebook#g:method:setShowBorder"), [setShowTabs]("GI.Gtk.Objects.Notebook#g:method:setShowTabs"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTabDetachable]("GI.Gtk.Objects.Notebook#g:method:setTabDetachable"), [setTabLabel]("GI.Gtk.Objects.Notebook#g:method:setTabLabel"), [setTabLabelText]("GI.Gtk.Objects.Notebook#g:method:setTabLabelText"), [setTabPos]("GI.Gtk.Objects.Notebook#g:method:setTabPos"), [setTabReorderable]("GI.Gtk.Objects.Notebook#g:method:setTabReorderable"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveNotebookMethod                   ,
#endif

-- ** appendPage #method:appendPage#

#if defined(ENABLE_OVERLOADING)
    NotebookAppendPageMethodInfo            ,
#endif
    notebookAppendPage                      ,


-- ** appendPageMenu #method:appendPageMenu#

#if defined(ENABLE_OVERLOADING)
    NotebookAppendPageMenuMethodInfo        ,
#endif
    notebookAppendPageMenu                  ,


-- ** detachTab #method:detachTab#

#if defined(ENABLE_OVERLOADING)
    NotebookDetachTabMethodInfo             ,
#endif
    notebookDetachTab                       ,


-- ** getActionWidget #method:getActionWidget#

#if defined(ENABLE_OVERLOADING)
    NotebookGetActionWidgetMethodInfo       ,
#endif
    notebookGetActionWidget                 ,


-- ** getCurrentPage #method:getCurrentPage#

#if defined(ENABLE_OVERLOADING)
    NotebookGetCurrentPageMethodInfo        ,
#endif
    notebookGetCurrentPage                  ,


-- ** getGroupName #method:getGroupName#

#if defined(ENABLE_OVERLOADING)
    NotebookGetGroupNameMethodInfo          ,
#endif
    notebookGetGroupName                    ,


-- ** getMenuLabel #method:getMenuLabel#

#if defined(ENABLE_OVERLOADING)
    NotebookGetMenuLabelMethodInfo          ,
#endif
    notebookGetMenuLabel                    ,


-- ** getMenuLabelText #method:getMenuLabelText#

#if defined(ENABLE_OVERLOADING)
    NotebookGetMenuLabelTextMethodInfo      ,
#endif
    notebookGetMenuLabelText                ,


-- ** getNPages #method:getNPages#

#if defined(ENABLE_OVERLOADING)
    NotebookGetNPagesMethodInfo             ,
#endif
    notebookGetNPages                       ,


-- ** getNthPage #method:getNthPage#

#if defined(ENABLE_OVERLOADING)
    NotebookGetNthPageMethodInfo            ,
#endif
    notebookGetNthPage                      ,


-- ** getPage #method:getPage#

#if defined(ENABLE_OVERLOADING)
    NotebookGetPageMethodInfo               ,
#endif
    notebookGetPage                         ,


-- ** getPages #method:getPages#

#if defined(ENABLE_OVERLOADING)
    NotebookGetPagesMethodInfo              ,
#endif
    notebookGetPages                        ,


-- ** getScrollable #method:getScrollable#

#if defined(ENABLE_OVERLOADING)
    NotebookGetScrollableMethodInfo         ,
#endif
    notebookGetScrollable                   ,


-- ** getShowBorder #method:getShowBorder#

#if defined(ENABLE_OVERLOADING)
    NotebookGetShowBorderMethodInfo         ,
#endif
    notebookGetShowBorder                   ,


-- ** getShowTabs #method:getShowTabs#

#if defined(ENABLE_OVERLOADING)
    NotebookGetShowTabsMethodInfo           ,
#endif
    notebookGetShowTabs                     ,


-- ** getTabDetachable #method:getTabDetachable#

#if defined(ENABLE_OVERLOADING)
    NotebookGetTabDetachableMethodInfo      ,
#endif
    notebookGetTabDetachable                ,


-- ** getTabLabel #method:getTabLabel#

#if defined(ENABLE_OVERLOADING)
    NotebookGetTabLabelMethodInfo           ,
#endif
    notebookGetTabLabel                     ,


-- ** getTabLabelText #method:getTabLabelText#

#if defined(ENABLE_OVERLOADING)
    NotebookGetTabLabelTextMethodInfo       ,
#endif
    notebookGetTabLabelText                 ,


-- ** getTabPos #method:getTabPos#

#if defined(ENABLE_OVERLOADING)
    NotebookGetTabPosMethodInfo             ,
#endif
    notebookGetTabPos                       ,


-- ** getTabReorderable #method:getTabReorderable#

#if defined(ENABLE_OVERLOADING)
    NotebookGetTabReorderableMethodInfo     ,
#endif
    notebookGetTabReorderable               ,


-- ** insertPage #method:insertPage#

#if defined(ENABLE_OVERLOADING)
    NotebookInsertPageMethodInfo            ,
#endif
    notebookInsertPage                      ,


-- ** insertPageMenu #method:insertPageMenu#

#if defined(ENABLE_OVERLOADING)
    NotebookInsertPageMenuMethodInfo        ,
#endif
    notebookInsertPageMenu                  ,


-- ** new #method:new#

    notebookNew                             ,


-- ** nextPage #method:nextPage#

#if defined(ENABLE_OVERLOADING)
    NotebookNextPageMethodInfo              ,
#endif
    notebookNextPage                        ,


-- ** pageNum #method:pageNum#

#if defined(ENABLE_OVERLOADING)
    NotebookPageNumMethodInfo               ,
#endif
    notebookPageNum                         ,


-- ** popupDisable #method:popupDisable#

#if defined(ENABLE_OVERLOADING)
    NotebookPopupDisableMethodInfo          ,
#endif
    notebookPopupDisable                    ,


-- ** popupEnable #method:popupEnable#

#if defined(ENABLE_OVERLOADING)
    NotebookPopupEnableMethodInfo           ,
#endif
    notebookPopupEnable                     ,


-- ** prependPage #method:prependPage#

#if defined(ENABLE_OVERLOADING)
    NotebookPrependPageMethodInfo           ,
#endif
    notebookPrependPage                     ,


-- ** prependPageMenu #method:prependPageMenu#

#if defined(ENABLE_OVERLOADING)
    NotebookPrependPageMenuMethodInfo       ,
#endif
    notebookPrependPageMenu                 ,


-- ** prevPage #method:prevPage#

#if defined(ENABLE_OVERLOADING)
    NotebookPrevPageMethodInfo              ,
#endif
    notebookPrevPage                        ,


-- ** removePage #method:removePage#

#if defined(ENABLE_OVERLOADING)
    NotebookRemovePageMethodInfo            ,
#endif
    notebookRemovePage                      ,


-- ** reorderChild #method:reorderChild#

#if defined(ENABLE_OVERLOADING)
    NotebookReorderChildMethodInfo          ,
#endif
    notebookReorderChild                    ,


-- ** setActionWidget #method:setActionWidget#

#if defined(ENABLE_OVERLOADING)
    NotebookSetActionWidgetMethodInfo       ,
#endif
    notebookSetActionWidget                 ,


-- ** setCurrentPage #method:setCurrentPage#

#if defined(ENABLE_OVERLOADING)
    NotebookSetCurrentPageMethodInfo        ,
#endif
    notebookSetCurrentPage                  ,


-- ** setGroupName #method:setGroupName#

#if defined(ENABLE_OVERLOADING)
    NotebookSetGroupNameMethodInfo          ,
#endif
    notebookSetGroupName                    ,


-- ** setMenuLabel #method:setMenuLabel#

#if defined(ENABLE_OVERLOADING)
    NotebookSetMenuLabelMethodInfo          ,
#endif
    notebookSetMenuLabel                    ,


-- ** setMenuLabelText #method:setMenuLabelText#

#if defined(ENABLE_OVERLOADING)
    NotebookSetMenuLabelTextMethodInfo      ,
#endif
    notebookSetMenuLabelText                ,


-- ** setScrollable #method:setScrollable#

#if defined(ENABLE_OVERLOADING)
    NotebookSetScrollableMethodInfo         ,
#endif
    notebookSetScrollable                   ,


-- ** setShowBorder #method:setShowBorder#

#if defined(ENABLE_OVERLOADING)
    NotebookSetShowBorderMethodInfo         ,
#endif
    notebookSetShowBorder                   ,


-- ** setShowTabs #method:setShowTabs#

#if defined(ENABLE_OVERLOADING)
    NotebookSetShowTabsMethodInfo           ,
#endif
    notebookSetShowTabs                     ,


-- ** setTabDetachable #method:setTabDetachable#

#if defined(ENABLE_OVERLOADING)
    NotebookSetTabDetachableMethodInfo      ,
#endif
    notebookSetTabDetachable                ,


-- ** setTabLabel #method:setTabLabel#

#if defined(ENABLE_OVERLOADING)
    NotebookSetTabLabelMethodInfo           ,
#endif
    notebookSetTabLabel                     ,


-- ** setTabLabelText #method:setTabLabelText#

#if defined(ENABLE_OVERLOADING)
    NotebookSetTabLabelTextMethodInfo       ,
#endif
    notebookSetTabLabelText                 ,


-- ** setTabPos #method:setTabPos#

#if defined(ENABLE_OVERLOADING)
    NotebookSetTabPosMethodInfo             ,
#endif
    notebookSetTabPos                       ,


-- ** setTabReorderable #method:setTabReorderable#

#if defined(ENABLE_OVERLOADING)
    NotebookSetTabReorderableMethodInfo     ,
#endif
    notebookSetTabReorderable               ,




 -- * Properties


-- ** enablePopup #attr:enablePopup#
-- | If 'P.True', pressing the right mouse button on the notebook shows a page switching menu.

#if defined(ENABLE_OVERLOADING)
    NotebookEnablePopupPropertyInfo         ,
#endif
    constructNotebookEnablePopup            ,
    getNotebookEnablePopup                  ,
#if defined(ENABLE_OVERLOADING)
    notebookEnablePopup                     ,
#endif
    setNotebookEnablePopup                  ,


-- ** groupName #attr:groupName#
-- | Group name for tab drag and drop.

#if defined(ENABLE_OVERLOADING)
    NotebookGroupNamePropertyInfo           ,
#endif
    clearNotebookGroupName                  ,
    constructNotebookGroupName              ,
    getNotebookGroupName                    ,
#if defined(ENABLE_OVERLOADING)
    notebookGroupName                       ,
#endif
    setNotebookGroupName                    ,


-- ** page #attr:page#
-- | The index of the current page.

#if defined(ENABLE_OVERLOADING)
    NotebookPagePropertyInfo                ,
#endif
    constructNotebookPage                   ,
    getNotebookPage                         ,
#if defined(ENABLE_OVERLOADING)
    notebookPage                            ,
#endif
    setNotebookPage                         ,


-- ** pages #attr:pages#
-- | A selection model with the pages.

#if defined(ENABLE_OVERLOADING)
    NotebookPagesPropertyInfo               ,
#endif
    getNotebookPages                        ,
#if defined(ENABLE_OVERLOADING)
    notebookPages                           ,
#endif


-- ** scrollable #attr:scrollable#
-- | If 'P.True', scroll arrows are added if there are too many pages to fit.

#if defined(ENABLE_OVERLOADING)
    NotebookScrollablePropertyInfo          ,
#endif
    constructNotebookScrollable             ,
    getNotebookScrollable                   ,
#if defined(ENABLE_OVERLOADING)
    notebookScrollable                      ,
#endif
    setNotebookScrollable                   ,


-- ** showBorder #attr:showBorder#
-- | Whether the border should be shown.

#if defined(ENABLE_OVERLOADING)
    NotebookShowBorderPropertyInfo          ,
#endif
    constructNotebookShowBorder             ,
    getNotebookShowBorder                   ,
#if defined(ENABLE_OVERLOADING)
    notebookShowBorder                      ,
#endif
    setNotebookShowBorder                   ,


-- ** showTabs #attr:showTabs#
-- | Whether tabs should be shown.

#if defined(ENABLE_OVERLOADING)
    NotebookShowTabsPropertyInfo            ,
#endif
    constructNotebookShowTabs               ,
    getNotebookShowTabs                     ,
#if defined(ENABLE_OVERLOADING)
    notebookShowTabs                        ,
#endif
    setNotebookShowTabs                     ,


-- ** tabPos #attr:tabPos#
-- | Which side of the notebook holds the tabs.

#if defined(ENABLE_OVERLOADING)
    NotebookTabPosPropertyInfo              ,
#endif
    constructNotebookTabPos                 ,
    getNotebookTabPos                       ,
#if defined(ENABLE_OVERLOADING)
    notebookTabPos                          ,
#endif
    setNotebookTabPos                       ,




 -- * Signals


-- ** changeCurrentPage #signal:changeCurrentPage#

    NotebookChangeCurrentPageCallback       ,
#if defined(ENABLE_OVERLOADING)
    NotebookChangeCurrentPageSignalInfo     ,
#endif
    afterNotebookChangeCurrentPage          ,
    onNotebookChangeCurrentPage             ,


-- ** createWindow #signal:createWindow#

    NotebookCreateWindowCallback            ,
#if defined(ENABLE_OVERLOADING)
    NotebookCreateWindowSignalInfo          ,
#endif
    afterNotebookCreateWindow               ,
    onNotebookCreateWindow                  ,


-- ** focusTab #signal:focusTab#

    NotebookFocusTabCallback                ,
#if defined(ENABLE_OVERLOADING)
    NotebookFocusTabSignalInfo              ,
#endif
    afterNotebookFocusTab                   ,
    onNotebookFocusTab                      ,


-- ** moveFocusOut #signal:moveFocusOut#

    NotebookMoveFocusOutCallback            ,
#if defined(ENABLE_OVERLOADING)
    NotebookMoveFocusOutSignalInfo          ,
#endif
    afterNotebookMoveFocusOut               ,
    onNotebookMoveFocusOut                  ,


-- ** pageAdded #signal:pageAdded#

    NotebookPageAddedCallback               ,
#if defined(ENABLE_OVERLOADING)
    NotebookPageAddedSignalInfo             ,
#endif
    afterNotebookPageAdded                  ,
    onNotebookPageAdded                     ,


-- ** pageRemoved #signal:pageRemoved#

    NotebookPageRemovedCallback             ,
#if defined(ENABLE_OVERLOADING)
    NotebookPageRemovedSignalInfo           ,
#endif
    afterNotebookPageRemoved                ,
    onNotebookPageRemoved                   ,


-- ** pageReordered #signal:pageReordered#

    NotebookPageReorderedCallback           ,
#if defined(ENABLE_OVERLOADING)
    NotebookPageReorderedSignalInfo         ,
#endif
    afterNotebookPageReordered              ,
    onNotebookPageReordered                 ,


-- ** reorderTab #signal:reorderTab#

    NotebookReorderTabCallback              ,
#if defined(ENABLE_OVERLOADING)
    NotebookReorderTabSignalInfo            ,
#endif
    afterNotebookReorderTab                 ,
    onNotebookReorderTab                    ,


-- ** selectPage #signal:selectPage#

    NotebookSelectPageCallback              ,
#if defined(ENABLE_OVERLOADING)
    NotebookSelectPageSignalInfo            ,
#endif
    afterNotebookSelectPage                 ,
    onNotebookSelectPage                    ,


-- ** switchPage #signal:switchPage#

    NotebookSwitchPageCallback              ,
#if defined(ENABLE_OVERLOADING)
    NotebookSwitchPageSignalInfo            ,
#endif
    afterNotebookSwitchPage                 ,
    onNotebookSwitchPage                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.NotebookPage as Gtk.NotebookPage
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.NotebookPage as Gtk.NotebookPage
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Notebook = Notebook (SP.ManagedPtr Notebook)
    deriving (Eq)

instance SP.ManagedPtrNewtype Notebook where
    toManagedPtr (Notebook p) = p

foreign import ccall "gtk_notebook_get_type"
    c_gtk_notebook_get_type :: IO B.Types.GType

instance B.Types.TypedObject Notebook where
    glibType = c_gtk_notebook_get_type

instance B.Types.GObject Notebook

-- | Type class for types which can be safely cast to t'Notebook', for instance with `toNotebook`.
class (SP.GObject o, O.IsDescendantOf Notebook o) => IsNotebook o
instance (SP.GObject o, O.IsDescendantOf Notebook o) => IsNotebook o

instance O.HasParentTypes Notebook
type instance O.ParentTypes Notebook = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'Notebook', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toNotebook :: (MIO.MonadIO m, IsNotebook o) => o -> m Notebook
toNotebook = MIO.liftIO . B.ManagedPtr.unsafeCastTo Notebook

-- | Convert t'Notebook' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Notebook) where
    gvalueGType_ = c_gtk_notebook_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Notebook)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Notebook)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Notebook ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveNotebookMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveNotebookMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveNotebookMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveNotebookMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveNotebookMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveNotebookMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveNotebookMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveNotebookMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveNotebookMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveNotebookMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveNotebookMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveNotebookMethod "appendPage" o = NotebookAppendPageMethodInfo
    ResolveNotebookMethod "appendPageMenu" o = NotebookAppendPageMenuMethodInfo
    ResolveNotebookMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveNotebookMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveNotebookMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveNotebookMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveNotebookMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveNotebookMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveNotebookMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveNotebookMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveNotebookMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveNotebookMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveNotebookMethod "detachTab" o = NotebookDetachTabMethodInfo
    ResolveNotebookMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveNotebookMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveNotebookMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveNotebookMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveNotebookMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveNotebookMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveNotebookMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveNotebookMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveNotebookMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveNotebookMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveNotebookMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveNotebookMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveNotebookMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveNotebookMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveNotebookMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveNotebookMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveNotebookMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveNotebookMethod "insertPage" o = NotebookInsertPageMethodInfo
    ResolveNotebookMethod "insertPageMenu" o = NotebookInsertPageMenuMethodInfo
    ResolveNotebookMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveNotebookMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveNotebookMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveNotebookMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveNotebookMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveNotebookMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveNotebookMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveNotebookMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveNotebookMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveNotebookMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveNotebookMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveNotebookMethod "nextPage" o = NotebookNextPageMethodInfo
    ResolveNotebookMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveNotebookMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveNotebookMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveNotebookMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveNotebookMethod "pageNum" o = NotebookPageNumMethodInfo
    ResolveNotebookMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveNotebookMethod "popupDisable" o = NotebookPopupDisableMethodInfo
    ResolveNotebookMethod "popupEnable" o = NotebookPopupEnableMethodInfo
    ResolveNotebookMethod "prependPage" o = NotebookPrependPageMethodInfo
    ResolveNotebookMethod "prependPageMenu" o = NotebookPrependPageMenuMethodInfo
    ResolveNotebookMethod "prevPage" o = NotebookPrevPageMethodInfo
    ResolveNotebookMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveNotebookMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveNotebookMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveNotebookMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveNotebookMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveNotebookMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveNotebookMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveNotebookMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveNotebookMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveNotebookMethod "removePage" o = NotebookRemovePageMethodInfo
    ResolveNotebookMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveNotebookMethod "reorderChild" o = NotebookReorderChildMethodInfo
    ResolveNotebookMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveNotebookMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveNotebookMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveNotebookMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveNotebookMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveNotebookMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveNotebookMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveNotebookMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveNotebookMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveNotebookMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveNotebookMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveNotebookMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveNotebookMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveNotebookMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveNotebookMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveNotebookMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveNotebookMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveNotebookMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveNotebookMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveNotebookMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveNotebookMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveNotebookMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveNotebookMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveNotebookMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveNotebookMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveNotebookMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveNotebookMethod "getActionWidget" o = NotebookGetActionWidgetMethodInfo
    ResolveNotebookMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveNotebookMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveNotebookMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveNotebookMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveNotebookMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveNotebookMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveNotebookMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveNotebookMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveNotebookMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveNotebookMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveNotebookMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveNotebookMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveNotebookMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveNotebookMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveNotebookMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveNotebookMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveNotebookMethod "getCurrentPage" o = NotebookGetCurrentPageMethodInfo
    ResolveNotebookMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveNotebookMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveNotebookMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveNotebookMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveNotebookMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveNotebookMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveNotebookMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveNotebookMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveNotebookMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveNotebookMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveNotebookMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveNotebookMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveNotebookMethod "getGroupName" o = NotebookGetGroupNameMethodInfo
    ResolveNotebookMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveNotebookMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveNotebookMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveNotebookMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveNotebookMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveNotebookMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveNotebookMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveNotebookMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveNotebookMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveNotebookMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveNotebookMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveNotebookMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveNotebookMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveNotebookMethod "getMenuLabel" o = NotebookGetMenuLabelMethodInfo
    ResolveNotebookMethod "getMenuLabelText" o = NotebookGetMenuLabelTextMethodInfo
    ResolveNotebookMethod "getNPages" o = NotebookGetNPagesMethodInfo
    ResolveNotebookMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveNotebookMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveNotebookMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveNotebookMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveNotebookMethod "getNthPage" o = NotebookGetNthPageMethodInfo
    ResolveNotebookMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveNotebookMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveNotebookMethod "getPage" o = NotebookGetPageMethodInfo
    ResolveNotebookMethod "getPages" o = NotebookGetPagesMethodInfo
    ResolveNotebookMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveNotebookMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveNotebookMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveNotebookMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveNotebookMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveNotebookMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveNotebookMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveNotebookMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveNotebookMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveNotebookMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveNotebookMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveNotebookMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveNotebookMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveNotebookMethod "getScrollable" o = NotebookGetScrollableMethodInfo
    ResolveNotebookMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveNotebookMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveNotebookMethod "getShowBorder" o = NotebookGetShowBorderMethodInfo
    ResolveNotebookMethod "getShowTabs" o = NotebookGetShowTabsMethodInfo
    ResolveNotebookMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveNotebookMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveNotebookMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveNotebookMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveNotebookMethod "getTabDetachable" o = NotebookGetTabDetachableMethodInfo
    ResolveNotebookMethod "getTabLabel" o = NotebookGetTabLabelMethodInfo
    ResolveNotebookMethod "getTabLabelText" o = NotebookGetTabLabelTextMethodInfo
    ResolveNotebookMethod "getTabPos" o = NotebookGetTabPosMethodInfo
    ResolveNotebookMethod "getTabReorderable" o = NotebookGetTabReorderableMethodInfo
    ResolveNotebookMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveNotebookMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveNotebookMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveNotebookMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveNotebookMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveNotebookMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveNotebookMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveNotebookMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveNotebookMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveNotebookMethod "setActionWidget" o = NotebookSetActionWidgetMethodInfo
    ResolveNotebookMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveNotebookMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveNotebookMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveNotebookMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveNotebookMethod "setCurrentPage" o = NotebookSetCurrentPageMethodInfo
    ResolveNotebookMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveNotebookMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveNotebookMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveNotebookMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveNotebookMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveNotebookMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveNotebookMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveNotebookMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveNotebookMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveNotebookMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveNotebookMethod "setGroupName" o = NotebookSetGroupNameMethodInfo
    ResolveNotebookMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveNotebookMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveNotebookMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveNotebookMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveNotebookMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveNotebookMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveNotebookMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveNotebookMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveNotebookMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveNotebookMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveNotebookMethod "setMenuLabel" o = NotebookSetMenuLabelMethodInfo
    ResolveNotebookMethod "setMenuLabelText" o = NotebookSetMenuLabelTextMethodInfo
    ResolveNotebookMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveNotebookMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveNotebookMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveNotebookMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveNotebookMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveNotebookMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveNotebookMethod "setScrollable" o = NotebookSetScrollableMethodInfo
    ResolveNotebookMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveNotebookMethod "setShowBorder" o = NotebookSetShowBorderMethodInfo
    ResolveNotebookMethod "setShowTabs" o = NotebookSetShowTabsMethodInfo
    ResolveNotebookMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveNotebookMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveNotebookMethod "setTabDetachable" o = NotebookSetTabDetachableMethodInfo
    ResolveNotebookMethod "setTabLabel" o = NotebookSetTabLabelMethodInfo
    ResolveNotebookMethod "setTabLabelText" o = NotebookSetTabLabelTextMethodInfo
    ResolveNotebookMethod "setTabPos" o = NotebookSetTabPosMethodInfo
    ResolveNotebookMethod "setTabReorderable" o = NotebookSetTabReorderableMethodInfo
    ResolveNotebookMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveNotebookMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveNotebookMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveNotebookMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveNotebookMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveNotebookMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveNotebookMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveNotebookMethod t Notebook, O.OverloadedMethod info Notebook p) => OL.IsLabel t (Notebook -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveNotebookMethod t Notebook, O.OverloadedMethod info Notebook p, R.HasField t Notebook p) => R.HasField t Notebook p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveNotebookMethod t Notebook, O.OverloadedMethodInfo info Notebook) => OL.IsLabel t (O.MethodProxy info Notebook) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Notebook::change-current-page
-- | Emitted when the current page should be changed.
-- 
-- The default bindings for this signal are
-- \<kbd>Ctrl\<\/kbd>+\<kbd>Alt\<\/kbd>+\<kbd>PgUp\<\/kbd>,
-- \<kbd>Ctrl\<\/kbd>+\<kbd>Alt\<\/kbd>+\<kbd>PgDn\<\/kbd>,
-- \<kbd>Ctrl\<\/kbd>+\<kbd>PgUp\<\/kbd> and \<kbd>Ctrl\<\/kbd>+\<kbd>PgDn\<\/kbd>.
type NotebookChangeCurrentPageCallback =
    Int32
    -- ^ /@page@/: the page index
    -> IO Bool
    -- ^ __Returns:__ whether the page was changed

type C_NotebookChangeCurrentPageCallback =
    Ptr Notebook ->                         -- object
    Int32 ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_NotebookChangeCurrentPageCallback`.
foreign import ccall "wrapper"
    mk_NotebookChangeCurrentPageCallback :: C_NotebookChangeCurrentPageCallback -> IO (FunPtr C_NotebookChangeCurrentPageCallback)

wrap_NotebookChangeCurrentPageCallback :: 
    GObject a => (a -> NotebookChangeCurrentPageCallback) ->
    C_NotebookChangeCurrentPageCallback
wrap_NotebookChangeCurrentPageCallback gi'cb gi'selfPtr page _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  page
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [changeCurrentPage](#signal:changeCurrentPage) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' notebook #changeCurrentPage callback
-- @
-- 
-- 
onNotebookChangeCurrentPage :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookChangeCurrentPageCallback) -> m SignalHandlerId
onNotebookChangeCurrentPage obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookChangeCurrentPageCallback wrapped
    wrapped'' <- mk_NotebookChangeCurrentPageCallback wrapped'
    connectSignalFunPtr obj "change-current-page" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changeCurrentPage](#signal:changeCurrentPage) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' notebook #changeCurrentPage callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterNotebookChangeCurrentPage :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookChangeCurrentPageCallback) -> m SignalHandlerId
afterNotebookChangeCurrentPage obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookChangeCurrentPageCallback wrapped
    wrapped'' <- mk_NotebookChangeCurrentPageCallback wrapped'
    connectSignalFunPtr obj "change-current-page" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data NotebookChangeCurrentPageSignalInfo
instance SignalInfo NotebookChangeCurrentPageSignalInfo where
    type HaskellCallbackType NotebookChangeCurrentPageSignalInfo = NotebookChangeCurrentPageCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_NotebookChangeCurrentPageCallback cb
        cb'' <- mk_NotebookChangeCurrentPageCallback cb'
        connectSignalFunPtr obj "change-current-page" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook::change-current-page"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:signal:changeCurrentPage"})

#endif

-- signal Notebook::create-window
-- | The [createWindow](#g:signal:createWindow) signal is emitted when a detachable
-- tab is dropped on the root window.
-- 
-- A handler for this signal can create a window containing
-- a notebook where the tab will be attached. It is also
-- responsible for moving\/resizing the window and adding the
-- necessary properties to the notebook (e.g. the
-- @GtkNotebook@:group-name ).
type NotebookCreateWindowCallback =
    Gtk.Widget.Widget
    -- ^ /@page@/: the tab of /@notebook@/ that is being detached
    -> IO (Maybe Notebook)
    -- ^ __Returns:__ a @GtkNotebook@ that
    --   /@page@/ should be added to

type C_NotebookCreateWindowCallback =
    Ptr Notebook ->                         -- object
    Ptr Gtk.Widget.Widget ->
    Ptr () ->                               -- user_data
    IO (Ptr Notebook)

-- | Generate a function pointer callable from C code, from a `C_NotebookCreateWindowCallback`.
foreign import ccall "wrapper"
    mk_NotebookCreateWindowCallback :: C_NotebookCreateWindowCallback -> IO (FunPtr C_NotebookCreateWindowCallback)

wrap_NotebookCreateWindowCallback :: 
    GObject a => (a -> NotebookCreateWindowCallback) ->
    C_NotebookCreateWindowCallback
wrap_NotebookCreateWindowCallback gi'cb gi'selfPtr page _ = do
    page' <- (newObject Gtk.Widget.Widget) page
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  page'
    maybeM FP.nullPtr result $ \result' -> do
        result'' <- unsafeManagedPtrCastPtr result'
        return result''


-- | Connect a signal handler for the [createWindow](#signal:createWindow) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' notebook #createWindow callback
-- @
-- 
-- 
onNotebookCreateWindow :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookCreateWindowCallback) -> m SignalHandlerId
onNotebookCreateWindow obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookCreateWindowCallback wrapped
    wrapped'' <- mk_NotebookCreateWindowCallback wrapped'
    connectSignalFunPtr obj "create-window" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [createWindow](#signal:createWindow) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' notebook #createWindow callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterNotebookCreateWindow :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookCreateWindowCallback) -> m SignalHandlerId
afterNotebookCreateWindow obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookCreateWindowCallback wrapped
    wrapped'' <- mk_NotebookCreateWindowCallback wrapped'
    connectSignalFunPtr obj "create-window" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data NotebookCreateWindowSignalInfo
instance SignalInfo NotebookCreateWindowSignalInfo where
    type HaskellCallbackType NotebookCreateWindowSignalInfo = NotebookCreateWindowCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_NotebookCreateWindowCallback cb
        cb'' <- mk_NotebookCreateWindowCallback cb'
        connectSignalFunPtr obj "create-window" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook::create-window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:signal:createWindow"})

#endif

-- signal Notebook::focus-tab
-- | Emitted when a tab should be focused.
type NotebookFocusTabCallback =
    Gtk.Enums.NotebookTab
    -- ^ /@tab@/: the notebook tab
    -> IO Bool
    -- ^ __Returns:__ whether the tab has been focused

type C_NotebookFocusTabCallback =
    Ptr Notebook ->                         -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_NotebookFocusTabCallback`.
foreign import ccall "wrapper"
    mk_NotebookFocusTabCallback :: C_NotebookFocusTabCallback -> IO (FunPtr C_NotebookFocusTabCallback)

wrap_NotebookFocusTabCallback :: 
    GObject a => (a -> NotebookFocusTabCallback) ->
    C_NotebookFocusTabCallback
wrap_NotebookFocusTabCallback gi'cb gi'selfPtr tab _ = do
    let tab' = (toEnum . fromIntegral) tab
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  tab'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [focusTab](#signal:focusTab) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' notebook #focusTab callback
-- @
-- 
-- 
onNotebookFocusTab :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookFocusTabCallback) -> m SignalHandlerId
onNotebookFocusTab obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookFocusTabCallback wrapped
    wrapped'' <- mk_NotebookFocusTabCallback wrapped'
    connectSignalFunPtr obj "focus-tab" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [focusTab](#signal:focusTab) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' notebook #focusTab callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterNotebookFocusTab :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookFocusTabCallback) -> m SignalHandlerId
afterNotebookFocusTab obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookFocusTabCallback wrapped
    wrapped'' <- mk_NotebookFocusTabCallback wrapped'
    connectSignalFunPtr obj "focus-tab" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data NotebookFocusTabSignalInfo
instance SignalInfo NotebookFocusTabSignalInfo where
    type HaskellCallbackType NotebookFocusTabSignalInfo = NotebookFocusTabCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_NotebookFocusTabCallback cb
        cb'' <- mk_NotebookFocusTabCallback cb'
        connectSignalFunPtr obj "focus-tab" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook::focus-tab"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:signal:focusTab"})

#endif

-- signal Notebook::move-focus-out
-- | Emitted when focus was moved out.
-- 
-- The default bindings for this signal are
-- \<kbd>Ctrl\<\/kbd>+\<kbd>Tab\<\/kbd>,
-- \<kbd>Ctrl\<\/kbd>+\<kbd>Shift\<\/kbd>+\<kbd>Tab\<\/kbd>,
-- \<kbd>Ctrl\<\/kbd>+\<kbd>←\<\/kbd>, \<kbd>Ctrl\<\/kbd>+\<kbd>→\<\/kbd>,
-- \<kbd>Ctrl\<\/kbd>+\<kbd>↑\<\/kbd> and \<kbd>Ctrl\<\/kbd>+\<kbd>↓\<\/kbd>.
type NotebookMoveFocusOutCallback =
    Gtk.Enums.DirectionType
    -- ^ /@direction@/: the direction to move the focus
    -> IO ()

type C_NotebookMoveFocusOutCallback =
    Ptr Notebook ->                         -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_NotebookMoveFocusOutCallback`.
foreign import ccall "wrapper"
    mk_NotebookMoveFocusOutCallback :: C_NotebookMoveFocusOutCallback -> IO (FunPtr C_NotebookMoveFocusOutCallback)

wrap_NotebookMoveFocusOutCallback :: 
    GObject a => (a -> NotebookMoveFocusOutCallback) ->
    C_NotebookMoveFocusOutCallback
wrap_NotebookMoveFocusOutCallback gi'cb gi'selfPtr direction _ = do
    let direction' = (toEnum . fromIntegral) direction
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  direction'


-- | Connect a signal handler for the [moveFocusOut](#signal:moveFocusOut) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' notebook #moveFocusOut callback
-- @
-- 
-- 
onNotebookMoveFocusOut :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookMoveFocusOutCallback) -> m SignalHandlerId
onNotebookMoveFocusOut obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookMoveFocusOutCallback wrapped
    wrapped'' <- mk_NotebookMoveFocusOutCallback wrapped'
    connectSignalFunPtr obj "move-focus-out" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [moveFocusOut](#signal:moveFocusOut) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' notebook #moveFocusOut callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterNotebookMoveFocusOut :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookMoveFocusOutCallback) -> m SignalHandlerId
afterNotebookMoveFocusOut obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookMoveFocusOutCallback wrapped
    wrapped'' <- mk_NotebookMoveFocusOutCallback wrapped'
    connectSignalFunPtr obj "move-focus-out" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data NotebookMoveFocusOutSignalInfo
instance SignalInfo NotebookMoveFocusOutSignalInfo where
    type HaskellCallbackType NotebookMoveFocusOutSignalInfo = NotebookMoveFocusOutCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_NotebookMoveFocusOutCallback cb
        cb'' <- mk_NotebookMoveFocusOutCallback cb'
        connectSignalFunPtr obj "move-focus-out" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook::move-focus-out"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:signal:moveFocusOut"})

#endif

-- signal Notebook::page-added
-- | the [pageAdded](#g:signal:pageAdded) signal is emitted in the notebook
-- right after a page is added to the notebook.
type NotebookPageAddedCallback =
    Gtk.Widget.Widget
    -- ^ /@child@/: the child @GtkWidget@ affected
    -> Word32
    -- ^ /@pageNum@/: the new page number for /@child@/
    -> IO ()

type C_NotebookPageAddedCallback =
    Ptr Notebook ->                         -- object
    Ptr Gtk.Widget.Widget ->
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_NotebookPageAddedCallback`.
foreign import ccall "wrapper"
    mk_NotebookPageAddedCallback :: C_NotebookPageAddedCallback -> IO (FunPtr C_NotebookPageAddedCallback)

wrap_NotebookPageAddedCallback :: 
    GObject a => (a -> NotebookPageAddedCallback) ->
    C_NotebookPageAddedCallback
wrap_NotebookPageAddedCallback gi'cb gi'selfPtr child pageNum _ = do
    child' <- (newObject Gtk.Widget.Widget) child
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  child' pageNum


-- | Connect a signal handler for the [pageAdded](#signal:pageAdded) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' notebook #pageAdded callback
-- @
-- 
-- 
onNotebookPageAdded :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookPageAddedCallback) -> m SignalHandlerId
onNotebookPageAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookPageAddedCallback wrapped
    wrapped'' <- mk_NotebookPageAddedCallback wrapped'
    connectSignalFunPtr obj "page-added" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [pageAdded](#signal:pageAdded) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' notebook #pageAdded callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterNotebookPageAdded :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookPageAddedCallback) -> m SignalHandlerId
afterNotebookPageAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookPageAddedCallback wrapped
    wrapped'' <- mk_NotebookPageAddedCallback wrapped'
    connectSignalFunPtr obj "page-added" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data NotebookPageAddedSignalInfo
instance SignalInfo NotebookPageAddedSignalInfo where
    type HaskellCallbackType NotebookPageAddedSignalInfo = NotebookPageAddedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_NotebookPageAddedCallback cb
        cb'' <- mk_NotebookPageAddedCallback cb'
        connectSignalFunPtr obj "page-added" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook::page-added"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:signal:pageAdded"})

#endif

-- signal Notebook::page-removed
-- | the [pageRemoved](#g:signal:pageRemoved) signal is emitted in the notebook
-- right after a page is removed from the notebook.
type NotebookPageRemovedCallback =
    Gtk.Widget.Widget
    -- ^ /@child@/: the child @GtkWidget@ affected
    -> Word32
    -- ^ /@pageNum@/: the /@child@/ page number
    -> IO ()

type C_NotebookPageRemovedCallback =
    Ptr Notebook ->                         -- object
    Ptr Gtk.Widget.Widget ->
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_NotebookPageRemovedCallback`.
foreign import ccall "wrapper"
    mk_NotebookPageRemovedCallback :: C_NotebookPageRemovedCallback -> IO (FunPtr C_NotebookPageRemovedCallback)

wrap_NotebookPageRemovedCallback :: 
    GObject a => (a -> NotebookPageRemovedCallback) ->
    C_NotebookPageRemovedCallback
wrap_NotebookPageRemovedCallback gi'cb gi'selfPtr child pageNum _ = do
    child' <- (newObject Gtk.Widget.Widget) child
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  child' pageNum


-- | Connect a signal handler for the [pageRemoved](#signal:pageRemoved) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' notebook #pageRemoved callback
-- @
-- 
-- 
onNotebookPageRemoved :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookPageRemovedCallback) -> m SignalHandlerId
onNotebookPageRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookPageRemovedCallback wrapped
    wrapped'' <- mk_NotebookPageRemovedCallback wrapped'
    connectSignalFunPtr obj "page-removed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [pageRemoved](#signal:pageRemoved) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' notebook #pageRemoved callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterNotebookPageRemoved :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookPageRemovedCallback) -> m SignalHandlerId
afterNotebookPageRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookPageRemovedCallback wrapped
    wrapped'' <- mk_NotebookPageRemovedCallback wrapped'
    connectSignalFunPtr obj "page-removed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data NotebookPageRemovedSignalInfo
instance SignalInfo NotebookPageRemovedSignalInfo where
    type HaskellCallbackType NotebookPageRemovedSignalInfo = NotebookPageRemovedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_NotebookPageRemovedCallback cb
        cb'' <- mk_NotebookPageRemovedCallback cb'
        connectSignalFunPtr obj "page-removed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook::page-removed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:signal:pageRemoved"})

#endif

-- signal Notebook::page-reordered
-- | the [pageReordered](#g:signal:pageReordered) signal is emitted in the notebook
-- right after a page has been reordered.
type NotebookPageReorderedCallback =
    Gtk.Widget.Widget
    -- ^ /@child@/: the child @GtkWidget@ affected
    -> Word32
    -- ^ /@pageNum@/: the new page number for /@child@/
    -> IO ()

type C_NotebookPageReorderedCallback =
    Ptr Notebook ->                         -- object
    Ptr Gtk.Widget.Widget ->
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_NotebookPageReorderedCallback`.
foreign import ccall "wrapper"
    mk_NotebookPageReorderedCallback :: C_NotebookPageReorderedCallback -> IO (FunPtr C_NotebookPageReorderedCallback)

wrap_NotebookPageReorderedCallback :: 
    GObject a => (a -> NotebookPageReorderedCallback) ->
    C_NotebookPageReorderedCallback
wrap_NotebookPageReorderedCallback gi'cb gi'selfPtr child pageNum _ = do
    child' <- (newObject Gtk.Widget.Widget) child
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  child' pageNum


-- | Connect a signal handler for the [pageReordered](#signal:pageReordered) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' notebook #pageReordered callback
-- @
-- 
-- 
onNotebookPageReordered :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookPageReorderedCallback) -> m SignalHandlerId
onNotebookPageReordered obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookPageReorderedCallback wrapped
    wrapped'' <- mk_NotebookPageReorderedCallback wrapped'
    connectSignalFunPtr obj "page-reordered" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [pageReordered](#signal:pageReordered) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' notebook #pageReordered callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterNotebookPageReordered :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookPageReorderedCallback) -> m SignalHandlerId
afterNotebookPageReordered obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookPageReorderedCallback wrapped
    wrapped'' <- mk_NotebookPageReorderedCallback wrapped'
    connectSignalFunPtr obj "page-reordered" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data NotebookPageReorderedSignalInfo
instance SignalInfo NotebookPageReorderedSignalInfo where
    type HaskellCallbackType NotebookPageReorderedSignalInfo = NotebookPageReorderedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_NotebookPageReorderedCallback cb
        cb'' <- mk_NotebookPageReorderedCallback cb'
        connectSignalFunPtr obj "page-reordered" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook::page-reordered"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:signal:pageReordered"})

#endif

-- signal Notebook::reorder-tab
-- | Emitted when the tab should be reordered.
-- 
-- The default bindings for this signal are
-- \<kbd>Alt\<\/kbd>+\<kbd>Home\<\/kbd>, \<kbd>Alt\<\/kbd>+\<kbd>End\<\/kbd>,
-- \<kbd>Alt\<\/kbd>+\<kbd>PgUp\<\/kbd>, \<kbd>Alt\<\/kbd>+\<kbd>PgDn\<\/kbd>,
-- \<kbd>Alt\<\/kbd>+\<kbd>←\<\/kbd>, \<kbd>Alt\<\/kbd>+\<kbd>→\<\/kbd>,
-- \<kbd>Alt\<\/kbd>+\<kbd>↑\<\/kbd> and \<kbd>Alt\<\/kbd>+\<kbd>↓\<\/kbd>.
type NotebookReorderTabCallback =
    Gtk.Enums.DirectionType
    -- ^ /@direction@/: the direction to move the tab
    -> Bool
    -- ^ /@moveToLast@/: whether to move to the last position
    -> IO Bool
    -- ^ __Returns:__ whether the tab was moved.

type C_NotebookReorderTabCallback =
    Ptr Notebook ->                         -- object
    CUInt ->
    CInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_NotebookReorderTabCallback`.
foreign import ccall "wrapper"
    mk_NotebookReorderTabCallback :: C_NotebookReorderTabCallback -> IO (FunPtr C_NotebookReorderTabCallback)

wrap_NotebookReorderTabCallback :: 
    GObject a => (a -> NotebookReorderTabCallback) ->
    C_NotebookReorderTabCallback
wrap_NotebookReorderTabCallback gi'cb gi'selfPtr direction moveToLast _ = do
    let direction' = (toEnum . fromIntegral) direction
    let moveToLast' = (/= 0) moveToLast
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  direction' moveToLast'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [reorderTab](#signal:reorderTab) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' notebook #reorderTab callback
-- @
-- 
-- 
onNotebookReorderTab :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookReorderTabCallback) -> m SignalHandlerId
onNotebookReorderTab obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookReorderTabCallback wrapped
    wrapped'' <- mk_NotebookReorderTabCallback wrapped'
    connectSignalFunPtr obj "reorder-tab" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [reorderTab](#signal:reorderTab) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' notebook #reorderTab callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterNotebookReorderTab :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookReorderTabCallback) -> m SignalHandlerId
afterNotebookReorderTab obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookReorderTabCallback wrapped
    wrapped'' <- mk_NotebookReorderTabCallback wrapped'
    connectSignalFunPtr obj "reorder-tab" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data NotebookReorderTabSignalInfo
instance SignalInfo NotebookReorderTabSignalInfo where
    type HaskellCallbackType NotebookReorderTabSignalInfo = NotebookReorderTabCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_NotebookReorderTabCallback cb
        cb'' <- mk_NotebookReorderTabCallback cb'
        connectSignalFunPtr obj "reorder-tab" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook::reorder-tab"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:signal:reorderTab"})

#endif

-- signal Notebook::select-page
-- | Emitted when a page should be selected.
-- 
-- The default binding for this signal is \<kbd>␣\<\/kbd>.
type NotebookSelectPageCallback =
    Bool
    -- ^ /@moveFocus@/: whether to move focus
    -> IO Bool
    -- ^ __Returns:__ whether the page was selected

type C_NotebookSelectPageCallback =
    Ptr Notebook ->                         -- object
    CInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_NotebookSelectPageCallback`.
foreign import ccall "wrapper"
    mk_NotebookSelectPageCallback :: C_NotebookSelectPageCallback -> IO (FunPtr C_NotebookSelectPageCallback)

wrap_NotebookSelectPageCallback :: 
    GObject a => (a -> NotebookSelectPageCallback) ->
    C_NotebookSelectPageCallback
wrap_NotebookSelectPageCallback gi'cb gi'selfPtr moveFocus _ = do
    let moveFocus' = (/= 0) moveFocus
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  moveFocus'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [selectPage](#signal:selectPage) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' notebook #selectPage callback
-- @
-- 
-- 
onNotebookSelectPage :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookSelectPageCallback) -> m SignalHandlerId
onNotebookSelectPage obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookSelectPageCallback wrapped
    wrapped'' <- mk_NotebookSelectPageCallback wrapped'
    connectSignalFunPtr obj "select-page" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [selectPage](#signal:selectPage) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' notebook #selectPage callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterNotebookSelectPage :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookSelectPageCallback) -> m SignalHandlerId
afterNotebookSelectPage obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookSelectPageCallback wrapped
    wrapped'' <- mk_NotebookSelectPageCallback wrapped'
    connectSignalFunPtr obj "select-page" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data NotebookSelectPageSignalInfo
instance SignalInfo NotebookSelectPageSignalInfo where
    type HaskellCallbackType NotebookSelectPageSignalInfo = NotebookSelectPageCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_NotebookSelectPageCallback cb
        cb'' <- mk_NotebookSelectPageCallback cb'
        connectSignalFunPtr obj "select-page" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook::select-page"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:signal:selectPage"})

#endif

-- signal Notebook::switch-page
-- | Emitted when the user or a function changes the current page.
type NotebookSwitchPageCallback =
    Gtk.Widget.Widget
    -- ^ /@page@/: the new current page
    -> Word32
    -- ^ /@pageNum@/: the index of the page
    -> IO ()

type C_NotebookSwitchPageCallback =
    Ptr Notebook ->                         -- object
    Ptr Gtk.Widget.Widget ->
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_NotebookSwitchPageCallback`.
foreign import ccall "wrapper"
    mk_NotebookSwitchPageCallback :: C_NotebookSwitchPageCallback -> IO (FunPtr C_NotebookSwitchPageCallback)

wrap_NotebookSwitchPageCallback :: 
    GObject a => (a -> NotebookSwitchPageCallback) ->
    C_NotebookSwitchPageCallback
wrap_NotebookSwitchPageCallback gi'cb gi'selfPtr page pageNum _ = do
    page' <- (newObject Gtk.Widget.Widget) page
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  page' pageNum


-- | Connect a signal handler for the [switchPage](#signal:switchPage) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' notebook #switchPage callback
-- @
-- 
-- 
onNotebookSwitchPage :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookSwitchPageCallback) -> m SignalHandlerId
onNotebookSwitchPage obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookSwitchPageCallback wrapped
    wrapped'' <- mk_NotebookSwitchPageCallback wrapped'
    connectSignalFunPtr obj "switch-page" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [switchPage](#signal:switchPage) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' notebook #switchPage callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterNotebookSwitchPage :: (IsNotebook a, MonadIO m) => a -> ((?self :: a) => NotebookSwitchPageCallback) -> m SignalHandlerId
afterNotebookSwitchPage obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_NotebookSwitchPageCallback wrapped
    wrapped'' <- mk_NotebookSwitchPageCallback wrapped'
    connectSignalFunPtr obj "switch-page" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data NotebookSwitchPageSignalInfo
instance SignalInfo NotebookSwitchPageSignalInfo where
    type HaskellCallbackType NotebookSwitchPageSignalInfo = NotebookSwitchPageCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_NotebookSwitchPageCallback cb
        cb'' <- mk_NotebookSwitchPageCallback cb'
        connectSignalFunPtr obj "switch-page" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook::switch-page"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:signal:switchPage"})

#endif

-- VVV Prop "enable-popup"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@enable-popup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebook #enablePopup
-- @
getNotebookEnablePopup :: (MonadIO m, IsNotebook o) => o -> m Bool
getNotebookEnablePopup obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "enable-popup"

-- | Set the value of the “@enable-popup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebook [ #enablePopup 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookEnablePopup :: (MonadIO m, IsNotebook o) => o -> Bool -> m ()
setNotebookEnablePopup obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "enable-popup" val

-- | Construct a t'GValueConstruct' with valid value for the “@enable-popup@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookEnablePopup :: (IsNotebook o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructNotebookEnablePopup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "enable-popup" val

#if defined(ENABLE_OVERLOADING)
data NotebookEnablePopupPropertyInfo
instance AttrInfo NotebookEnablePopupPropertyInfo where
    type AttrAllowedOps NotebookEnablePopupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint NotebookEnablePopupPropertyInfo = IsNotebook
    type AttrSetTypeConstraint NotebookEnablePopupPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint NotebookEnablePopupPropertyInfo = (~) Bool
    type AttrTransferType NotebookEnablePopupPropertyInfo = Bool
    type AttrGetType NotebookEnablePopupPropertyInfo = Bool
    type AttrLabel NotebookEnablePopupPropertyInfo = "enable-popup"
    type AttrOrigin NotebookEnablePopupPropertyInfo = Notebook
    attrGet = getNotebookEnablePopup
    attrSet = setNotebookEnablePopup
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookEnablePopup
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.enablePopup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:attr:enablePopup"
        })
#endif

-- VVV Prop "group-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@group-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebook #groupName
-- @
getNotebookGroupName :: (MonadIO m, IsNotebook o) => o -> m (Maybe T.Text)
getNotebookGroupName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "group-name"

-- | Set the value of the “@group-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebook [ #groupName 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookGroupName :: (MonadIO m, IsNotebook o) => o -> T.Text -> m ()
setNotebookGroupName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "group-name" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@group-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookGroupName :: (IsNotebook o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructNotebookGroupName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "group-name" (P.Just val)

-- | Set the value of the “@group-name@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #groupName
-- @
clearNotebookGroupName :: (MonadIO m, IsNotebook o) => o -> m ()
clearNotebookGroupName obj = liftIO $ B.Properties.setObjectPropertyString obj "group-name" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data NotebookGroupNamePropertyInfo
instance AttrInfo NotebookGroupNamePropertyInfo where
    type AttrAllowedOps NotebookGroupNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint NotebookGroupNamePropertyInfo = IsNotebook
    type AttrSetTypeConstraint NotebookGroupNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint NotebookGroupNamePropertyInfo = (~) T.Text
    type AttrTransferType NotebookGroupNamePropertyInfo = T.Text
    type AttrGetType NotebookGroupNamePropertyInfo = (Maybe T.Text)
    type AttrLabel NotebookGroupNamePropertyInfo = "group-name"
    type AttrOrigin NotebookGroupNamePropertyInfo = Notebook
    attrGet = getNotebookGroupName
    attrSet = setNotebookGroupName
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookGroupName
    attrClear = clearNotebookGroupName
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.groupName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:attr:groupName"
        })
#endif

-- VVV Prop "page"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@page@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebook #page
-- @
getNotebookPage :: (MonadIO m, IsNotebook o) => o -> m Int32
getNotebookPage obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "page"

-- | Set the value of the “@page@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebook [ #page 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookPage :: (MonadIO m, IsNotebook o) => o -> Int32 -> m ()
setNotebookPage obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "page" val

-- | Construct a t'GValueConstruct' with valid value for the “@page@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookPage :: (IsNotebook o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructNotebookPage val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "page" val

#if defined(ENABLE_OVERLOADING)
data NotebookPagePropertyInfo
instance AttrInfo NotebookPagePropertyInfo where
    type AttrAllowedOps NotebookPagePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint NotebookPagePropertyInfo = IsNotebook
    type AttrSetTypeConstraint NotebookPagePropertyInfo = (~) Int32
    type AttrTransferTypeConstraint NotebookPagePropertyInfo = (~) Int32
    type AttrTransferType NotebookPagePropertyInfo = Int32
    type AttrGetType NotebookPagePropertyInfo = Int32
    type AttrLabel NotebookPagePropertyInfo = "page"
    type AttrOrigin NotebookPagePropertyInfo = Notebook
    attrGet = getNotebookPage
    attrSet = setNotebookPage
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookPage
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.page"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:attr:page"
        })
#endif

-- VVV Prop "pages"
   -- Type: TInterface (Name {namespace = "Gio", name = "ListModel"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@pages@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebook #pages
-- @
getNotebookPages :: (MonadIO m, IsNotebook o) => o -> m (Maybe Gio.ListModel.ListModel)
getNotebookPages obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "pages" Gio.ListModel.ListModel

#if defined(ENABLE_OVERLOADING)
data NotebookPagesPropertyInfo
instance AttrInfo NotebookPagesPropertyInfo where
    type AttrAllowedOps NotebookPagesPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint NotebookPagesPropertyInfo = IsNotebook
    type AttrSetTypeConstraint NotebookPagesPropertyInfo = (~) ()
    type AttrTransferTypeConstraint NotebookPagesPropertyInfo = (~) ()
    type AttrTransferType NotebookPagesPropertyInfo = ()
    type AttrGetType NotebookPagesPropertyInfo = (Maybe Gio.ListModel.ListModel)
    type AttrLabel NotebookPagesPropertyInfo = "pages"
    type AttrOrigin NotebookPagesPropertyInfo = Notebook
    attrGet = getNotebookPages
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.pages"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:attr:pages"
        })
#endif

-- VVV Prop "scrollable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@scrollable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebook #scrollable
-- @
getNotebookScrollable :: (MonadIO m, IsNotebook o) => o -> m Bool
getNotebookScrollable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "scrollable"

-- | Set the value of the “@scrollable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebook [ #scrollable 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookScrollable :: (MonadIO m, IsNotebook o) => o -> Bool -> m ()
setNotebookScrollable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "scrollable" val

-- | Construct a t'GValueConstruct' with valid value for the “@scrollable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookScrollable :: (IsNotebook o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructNotebookScrollable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "scrollable" val

#if defined(ENABLE_OVERLOADING)
data NotebookScrollablePropertyInfo
instance AttrInfo NotebookScrollablePropertyInfo where
    type AttrAllowedOps NotebookScrollablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint NotebookScrollablePropertyInfo = IsNotebook
    type AttrSetTypeConstraint NotebookScrollablePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint NotebookScrollablePropertyInfo = (~) Bool
    type AttrTransferType NotebookScrollablePropertyInfo = Bool
    type AttrGetType NotebookScrollablePropertyInfo = Bool
    type AttrLabel NotebookScrollablePropertyInfo = "scrollable"
    type AttrOrigin NotebookScrollablePropertyInfo = Notebook
    attrGet = getNotebookScrollable
    attrSet = setNotebookScrollable
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookScrollable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.scrollable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:attr:scrollable"
        })
#endif

-- VVV Prop "show-border"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-border@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebook #showBorder
-- @
getNotebookShowBorder :: (MonadIO m, IsNotebook o) => o -> m Bool
getNotebookShowBorder obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-border"

-- | Set the value of the “@show-border@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebook [ #showBorder 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookShowBorder :: (MonadIO m, IsNotebook o) => o -> Bool -> m ()
setNotebookShowBorder obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-border" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-border@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookShowBorder :: (IsNotebook o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructNotebookShowBorder val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-border" val

#if defined(ENABLE_OVERLOADING)
data NotebookShowBorderPropertyInfo
instance AttrInfo NotebookShowBorderPropertyInfo where
    type AttrAllowedOps NotebookShowBorderPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint NotebookShowBorderPropertyInfo = IsNotebook
    type AttrSetTypeConstraint NotebookShowBorderPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint NotebookShowBorderPropertyInfo = (~) Bool
    type AttrTransferType NotebookShowBorderPropertyInfo = Bool
    type AttrGetType NotebookShowBorderPropertyInfo = Bool
    type AttrLabel NotebookShowBorderPropertyInfo = "show-border"
    type AttrOrigin NotebookShowBorderPropertyInfo = Notebook
    attrGet = getNotebookShowBorder
    attrSet = setNotebookShowBorder
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookShowBorder
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.showBorder"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:attr:showBorder"
        })
#endif

-- VVV Prop "show-tabs"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-tabs@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebook #showTabs
-- @
getNotebookShowTabs :: (MonadIO m, IsNotebook o) => o -> m Bool
getNotebookShowTabs obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-tabs"

-- | Set the value of the “@show-tabs@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebook [ #showTabs 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookShowTabs :: (MonadIO m, IsNotebook o) => o -> Bool -> m ()
setNotebookShowTabs obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-tabs" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-tabs@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookShowTabs :: (IsNotebook o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructNotebookShowTabs val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-tabs" val

#if defined(ENABLE_OVERLOADING)
data NotebookShowTabsPropertyInfo
instance AttrInfo NotebookShowTabsPropertyInfo where
    type AttrAllowedOps NotebookShowTabsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint NotebookShowTabsPropertyInfo = IsNotebook
    type AttrSetTypeConstraint NotebookShowTabsPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint NotebookShowTabsPropertyInfo = (~) Bool
    type AttrTransferType NotebookShowTabsPropertyInfo = Bool
    type AttrGetType NotebookShowTabsPropertyInfo = Bool
    type AttrLabel NotebookShowTabsPropertyInfo = "show-tabs"
    type AttrOrigin NotebookShowTabsPropertyInfo = Notebook
    attrGet = getNotebookShowTabs
    attrSet = setNotebookShowTabs
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookShowTabs
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.showTabs"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:attr:showTabs"
        })
#endif

-- VVV Prop "tab-pos"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PositionType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@tab-pos@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebook #tabPos
-- @
getNotebookTabPos :: (MonadIO m, IsNotebook o) => o -> m Gtk.Enums.PositionType
getNotebookTabPos obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "tab-pos"

-- | Set the value of the “@tab-pos@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebook [ #tabPos 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookTabPos :: (MonadIO m, IsNotebook o) => o -> Gtk.Enums.PositionType -> m ()
setNotebookTabPos obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "tab-pos" val

-- | Construct a t'GValueConstruct' with valid value for the “@tab-pos@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookTabPos :: (IsNotebook o, MIO.MonadIO m) => Gtk.Enums.PositionType -> m (GValueConstruct o)
constructNotebookTabPos val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "tab-pos" val

#if defined(ENABLE_OVERLOADING)
data NotebookTabPosPropertyInfo
instance AttrInfo NotebookTabPosPropertyInfo where
    type AttrAllowedOps NotebookTabPosPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint NotebookTabPosPropertyInfo = IsNotebook
    type AttrSetTypeConstraint NotebookTabPosPropertyInfo = (~) Gtk.Enums.PositionType
    type AttrTransferTypeConstraint NotebookTabPosPropertyInfo = (~) Gtk.Enums.PositionType
    type AttrTransferType NotebookTabPosPropertyInfo = Gtk.Enums.PositionType
    type AttrGetType NotebookTabPosPropertyInfo = Gtk.Enums.PositionType
    type AttrLabel NotebookTabPosPropertyInfo = "tab-pos"
    type AttrOrigin NotebookTabPosPropertyInfo = Notebook
    attrGet = getNotebookTabPos
    attrSet = setNotebookTabPos
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookTabPos
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.tabPos"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#g:attr:tabPos"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Notebook
type instance O.AttributeList Notebook = NotebookAttributeList
type NotebookAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("enablePopup", NotebookEnablePopupPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("groupName", NotebookGroupNamePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("page", NotebookPagePropertyInfo), '("pages", NotebookPagesPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("scrollable", NotebookScrollablePropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showBorder", NotebookShowBorderPropertyInfo), '("showTabs", NotebookShowTabsPropertyInfo), '("tabPos", NotebookTabPosPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
notebookEnablePopup :: AttrLabelProxy "enablePopup"
notebookEnablePopup = AttrLabelProxy

notebookGroupName :: AttrLabelProxy "groupName"
notebookGroupName = AttrLabelProxy

notebookPage :: AttrLabelProxy "page"
notebookPage = AttrLabelProxy

notebookPages :: AttrLabelProxy "pages"
notebookPages = AttrLabelProxy

notebookScrollable :: AttrLabelProxy "scrollable"
notebookScrollable = AttrLabelProxy

notebookShowBorder :: AttrLabelProxy "showBorder"
notebookShowBorder = AttrLabelProxy

notebookShowTabs :: AttrLabelProxy "showTabs"
notebookShowTabs = AttrLabelProxy

notebookTabPos :: AttrLabelProxy "tabPos"
notebookTabPos = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Notebook = NotebookSignalList
type NotebookSignalList = ('[ '("changeCurrentPage", NotebookChangeCurrentPageSignalInfo), '("createWindow", NotebookCreateWindowSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("focusTab", NotebookFocusTabSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("moveFocusOut", NotebookMoveFocusOutSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("pageAdded", NotebookPageAddedSignalInfo), '("pageRemoved", NotebookPageRemovedSignalInfo), '("pageReordered", NotebookPageReorderedSignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("reorderTab", NotebookReorderTabSignalInfo), '("selectPage", NotebookSelectPageSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("switchPage", NotebookSwitchPageSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Notebook::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Notebook" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_new" gtk_notebook_new :: 
    IO (Ptr Notebook)

-- | Creates a new @GtkNotebook@ widget with no pages.
notebookNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Notebook
    -- ^ __Returns:__ the newly created @GtkNotebook@
notebookNew  = liftIO $ do
    result <- gtk_notebook_new
    checkUnexpectedReturnNULL "notebookNew" result
    result' <- (newObject Notebook) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Notebook::append_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `GtkWidget` to use as the contents of the page"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tab_label"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the `GtkWidget` to be used as the label\n  for the page, or %NULL to use the default label, \8220page N\8221"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_append_page" gtk_notebook_append_page :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- tab_label : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO Int32

-- | Appends a page to /@notebook@/.
notebookAppendPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the @GtkWidget@ to use as the contents of the page
    -> Maybe (c)
    -- ^ /@tabLabel@/: the @GtkWidget@ to be used as the label
    --   for the page, or 'P.Nothing' to use the default label, “page N”
    -> m Int32
    -- ^ __Returns:__ the index (starting from 0) of the appended
    --   page in the notebook, or -1 if function fails
notebookAppendPage notebook child tabLabel = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    maybeTabLabel <- case tabLabel of
        Nothing -> return FP.nullPtr
        Just jTabLabel -> do
            jTabLabel' <- unsafeManagedPtrCastPtr jTabLabel
            return jTabLabel'
    result <- gtk_notebook_append_page notebook' child' maybeTabLabel
    touchManagedPtr notebook
    touchManagedPtr child
    whenJust tabLabel touchManagedPtr
    return result

#if defined(ENABLE_OVERLOADING)
data NotebookAppendPageMethodInfo
instance (signature ~ (b -> Maybe (c) -> m Int32), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) => O.OverloadedMethod NotebookAppendPageMethodInfo a signature where
    overloadedMethod = notebookAppendPage

instance O.OverloadedMethodInfo NotebookAppendPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookAppendPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookAppendPage"
        })


#endif

-- method Notebook::append_page_menu
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `GtkWidget` to use as the contents of the page"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tab_label"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the `GtkWidget` to be used as the label\n  for the page, or %NULL to use the default label, \8220page N\8221"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "menu_label"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the widget to use as a label for the\n  page-switch menu, if that is enabled. If %NULL, and @tab_label\n  is a `GtkLabel` or %NULL, then the menu label will be a newly\n  created label with the same text as @tab_label; if @tab_label\n  is not a `GtkLabel`, @menu_label must be specified if the\n  page-switch menu is to be used."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_append_page_menu" gtk_notebook_append_page_menu :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- tab_label : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- menu_label : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO Int32

-- | Appends a page to /@notebook@/, specifying the widget to use as the
-- label in the popup menu.
notebookAppendPageMenu ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c, Gtk.Widget.IsWidget d) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the @GtkWidget@ to use as the contents of the page
    -> Maybe (c)
    -- ^ /@tabLabel@/: the @GtkWidget@ to be used as the label
    --   for the page, or 'P.Nothing' to use the default label, “page N”
    -> Maybe (d)
    -- ^ /@menuLabel@/: the widget to use as a label for the
    --   page-switch menu, if that is enabled. If 'P.Nothing', and /@tabLabel@/
    --   is a @GtkLabel@ or 'P.Nothing', then the menu label will be a newly
    --   created label with the same text as /@tabLabel@/; if /@tabLabel@/
    --   is not a @GtkLabel@, /@menuLabel@/ must be specified if the
    --   page-switch menu is to be used.
    -> m Int32
    -- ^ __Returns:__ the index (starting from 0) of the appended
    --   page in the notebook, or -1 if function fails
notebookAppendPageMenu notebook child tabLabel menuLabel = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    maybeTabLabel <- case tabLabel of
        Nothing -> return FP.nullPtr
        Just jTabLabel -> do
            jTabLabel' <- unsafeManagedPtrCastPtr jTabLabel
            return jTabLabel'
    maybeMenuLabel <- case menuLabel of
        Nothing -> return FP.nullPtr
        Just jMenuLabel -> do
            jMenuLabel' <- unsafeManagedPtrCastPtr jMenuLabel
            return jMenuLabel'
    result <- gtk_notebook_append_page_menu notebook' child' maybeTabLabel maybeMenuLabel
    touchManagedPtr notebook
    touchManagedPtr child
    whenJust tabLabel touchManagedPtr
    whenJust menuLabel touchManagedPtr
    return result

#if defined(ENABLE_OVERLOADING)
data NotebookAppendPageMenuMethodInfo
instance (signature ~ (b -> Maybe (c) -> Maybe (d) -> m Int32), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c, Gtk.Widget.IsWidget d) => O.OverloadedMethod NotebookAppendPageMenuMethodInfo a signature where
    overloadedMethod = notebookAppendPageMenu

instance O.OverloadedMethodInfo NotebookAppendPageMenuMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookAppendPageMenu",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookAppendPageMenu"
        })


#endif

-- method Notebook::detach_tab
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_detach_tab" gtk_notebook_detach_tab :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Removes the child from the notebook.
-- 
-- This function is very similar to 'GI.Gtk.Objects.Notebook.notebookRemovePage',
-- but additionally informs the notebook that the removal
-- is happening as part of a tab DND operation, which should
-- not be cancelled.
notebookDetachTab ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: a child
    -> m ()
notebookDetachTab notebook child = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    gtk_notebook_detach_tab notebook' child'
    touchManagedPtr notebook
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookDetachTabMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookDetachTabMethodInfo a signature where
    overloadedMethod = notebookDetachTab

instance O.OverloadedMethodInfo NotebookDetachTabMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookDetachTab",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookDetachTab"
        })


#endif

-- method Notebook::get_action_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pack_type"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PackType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pack type of the action widget to receive"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_action_widget" gtk_notebook_get_action_widget :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    CUInt ->                                -- pack_type : TInterface (Name {namespace = "Gtk", name = "PackType"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets one of the action widgets.
-- 
-- See 'GI.Gtk.Objects.Notebook.notebookSetActionWidget'.
notebookGetActionWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> Gtk.Enums.PackType
    -- ^ /@packType@/: pack type of the action widget to receive
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ The action widget
    --   with the given /@packType@/ or 'P.Nothing' when this action
    --   widget has not been set
notebookGetActionWidget notebook packType = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    let packType' = (fromIntegral . fromEnum) packType
    result <- gtk_notebook_get_action_widget notebook' packType'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr notebook
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data NotebookGetActionWidgetMethodInfo
instance (signature ~ (Gtk.Enums.PackType -> m (Maybe Gtk.Widget.Widget)), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookGetActionWidgetMethodInfo a signature where
    overloadedMethod = notebookGetActionWidget

instance O.OverloadedMethodInfo NotebookGetActionWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetActionWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetActionWidget"
        })


#endif

-- method Notebook::get_current_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_current_page" gtk_notebook_get_current_page :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    IO Int32

-- | Returns the page number of the current page.
notebookGetCurrentPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> m Int32
    -- ^ __Returns:__ the index (starting from 0) of the current
    --   page in the notebook. If the notebook has no pages,
    --   then -1 will be returned.
notebookGetCurrentPage notebook = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    result <- gtk_notebook_get_current_page notebook'
    touchManagedPtr notebook
    return result

#if defined(ENABLE_OVERLOADING)
data NotebookGetCurrentPageMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookGetCurrentPageMethodInfo a signature where
    overloadedMethod = notebookGetCurrentPage

instance O.OverloadedMethodInfo NotebookGetCurrentPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetCurrentPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetCurrentPage"
        })


#endif

-- method Notebook::get_group_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_group_name" gtk_notebook_get_group_name :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    IO CString

-- | Gets the current group name for /@notebook@/.
notebookGetGroupName ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the group name,
    --   or 'P.Nothing' if none is set
notebookGetGroupName notebook = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    result <- gtk_notebook_get_group_name notebook'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr notebook
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data NotebookGetGroupNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookGetGroupNameMethodInfo a signature where
    overloadedMethod = notebookGetGroupName

instance O.OverloadedMethodInfo NotebookGetGroupNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetGroupName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetGroupName"
        })


#endif

-- method Notebook::get_menu_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget contained in a page of @notebook"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_menu_label" gtk_notebook_get_menu_label :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO (Ptr Gtk.Widget.Widget)

-- | Retrieves the menu label widget of the page containing /@child@/.
notebookGetMenuLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: a widget contained in a page of /@notebook@/
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the menu label, or 'P.Nothing'
    --   if the notebook page does not have a menu label other than
    --   the default (the tab label).
notebookGetMenuLabel notebook child = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_notebook_get_menu_label notebook' child'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr notebook
    touchManagedPtr child
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data NotebookGetMenuLabelMethodInfo
instance (signature ~ (b -> m (Maybe Gtk.Widget.Widget)), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookGetMenuLabelMethodInfo a signature where
    overloadedMethod = notebookGetMenuLabel

instance O.OverloadedMethodInfo NotebookGetMenuLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetMenuLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetMenuLabel"
        })


#endif

-- method Notebook::get_menu_label_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget of a page of the notebook."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_menu_label_text" gtk_notebook_get_menu_label_text :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO CString

-- | Retrieves the text of the menu label for the page containing
-- /@child@/.
notebookGetMenuLabelText ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the child widget of a page of the notebook.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the text of the tab label, or 'P.Nothing' if
    --   the widget does not have a menu label other than the default
    --   menu label, or the menu label widget is not a @GtkLabel@.
    --   The string is owned by the widget and must not be freed.
notebookGetMenuLabelText notebook child = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_notebook_get_menu_label_text notebook' child'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr notebook
    touchManagedPtr child
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data NotebookGetMenuLabelTextMethodInfo
instance (signature ~ (b -> m (Maybe T.Text)), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookGetMenuLabelTextMethodInfo a signature where
    overloadedMethod = notebookGetMenuLabelText

instance O.OverloadedMethodInfo NotebookGetMenuLabelTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetMenuLabelText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetMenuLabelText"
        })


#endif

-- method Notebook::get_n_pages
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_n_pages" gtk_notebook_get_n_pages :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    IO Int32

-- | Gets the number of pages in a notebook.
notebookGetNPages ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> m Int32
    -- ^ __Returns:__ the number of pages in the notebook
notebookGetNPages notebook = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    result <- gtk_notebook_get_n_pages notebook'
    touchManagedPtr notebook
    return result

#if defined(ENABLE_OVERLOADING)
data NotebookGetNPagesMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookGetNPagesMethodInfo a signature where
    overloadedMethod = notebookGetNPages

instance O.OverloadedMethodInfo NotebookGetNPagesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetNPages",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetNPages"
        })


#endif

-- method Notebook::get_nth_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the index of a page in the notebook, or -1\n  to get the last page"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_nth_page" gtk_notebook_get_nth_page :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Int32 ->                                -- page_num : TBasicType TInt
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the child widget contained in page number /@pageNum@/.
notebookGetNthPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> Int32
    -- ^ /@pageNum@/: the index of a page in the notebook, or -1
    --   to get the last page
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget, or 'P.Nothing' if /@pageNum@/
    -- is out of bounds
notebookGetNthPage notebook pageNum = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    result <- gtk_notebook_get_nth_page notebook' pageNum
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr notebook
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data NotebookGetNthPageMethodInfo
instance (signature ~ (Int32 -> m (Maybe Gtk.Widget.Widget)), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookGetNthPageMethodInfo a signature where
    overloadedMethod = notebookGetNthPage

instance O.OverloadedMethodInfo NotebookGetNthPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetNthPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetNthPage"
        })


#endif

-- method Notebook::get_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child of @notebook"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "NotebookPage" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_page" gtk_notebook_get_page :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO (Ptr Gtk.NotebookPage.NotebookPage)

-- | Returns the @GtkNotebookPage@ for /@child@/.
notebookGetPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: a child of /@notebook@/
    -> m Gtk.NotebookPage.NotebookPage
    -- ^ __Returns:__ the @GtkNotebookPage@ for /@child@/
notebookGetPage notebook child = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_notebook_get_page notebook' child'
    checkUnexpectedReturnNULL "notebookGetPage" result
    result' <- (newObject Gtk.NotebookPage.NotebookPage) result
    touchManagedPtr notebook
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data NotebookGetPageMethodInfo
instance (signature ~ (b -> m Gtk.NotebookPage.NotebookPage), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookGetPageMethodInfo a signature where
    overloadedMethod = notebookGetPage

instance O.OverloadedMethodInfo NotebookGetPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetPage"
        })


#endif

-- method Notebook::get_pages
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_pages" gtk_notebook_get_pages :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    IO (Ptr Gio.ListModel.ListModel)

-- | Returns a @GListModel@ that contains the pages of the notebook.
-- 
-- This can be used to keep an up-to-date view. The model also
-- implements t'GI.Gtk.Interfaces.SelectionModel.SelectionModel' and can be used to track
-- and modify the visible page.
notebookGetPages ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> m Gio.ListModel.ListModel
    -- ^ __Returns:__ a
    --   @GListModel@ for the notebook\'s children
notebookGetPages notebook = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    result <- gtk_notebook_get_pages notebook'
    checkUnexpectedReturnNULL "notebookGetPages" result
    result' <- (wrapObject Gio.ListModel.ListModel) result
    touchManagedPtr notebook
    return result'

#if defined(ENABLE_OVERLOADING)
data NotebookGetPagesMethodInfo
instance (signature ~ (m Gio.ListModel.ListModel), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookGetPagesMethodInfo a signature where
    overloadedMethod = notebookGetPages

instance O.OverloadedMethodInfo NotebookGetPagesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetPages",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetPages"
        })


#endif

-- method Notebook::get_scrollable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_scrollable" gtk_notebook_get_scrollable :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    IO CInt

-- | Returns whether the tab label area has arrows for scrolling.
notebookGetScrollable ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if arrows for scrolling are present
notebookGetScrollable notebook = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    result <- gtk_notebook_get_scrollable notebook'
    let result' = (/= 0) result
    touchManagedPtr notebook
    return result'

#if defined(ENABLE_OVERLOADING)
data NotebookGetScrollableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookGetScrollableMethodInfo a signature where
    overloadedMethod = notebookGetScrollable

instance O.OverloadedMethodInfo NotebookGetScrollableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetScrollable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetScrollable"
        })


#endif

-- method Notebook::get_show_border
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_show_border" gtk_notebook_get_show_border :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    IO CInt

-- | Returns whether a bevel will be drawn around the notebook pages.
notebookGetShowBorder ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the bevel is drawn
notebookGetShowBorder notebook = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    result <- gtk_notebook_get_show_border notebook'
    let result' = (/= 0) result
    touchManagedPtr notebook
    return result'

#if defined(ENABLE_OVERLOADING)
data NotebookGetShowBorderMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookGetShowBorderMethodInfo a signature where
    overloadedMethod = notebookGetShowBorder

instance O.OverloadedMethodInfo NotebookGetShowBorderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetShowBorder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetShowBorder"
        })


#endif

-- method Notebook::get_show_tabs
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_show_tabs" gtk_notebook_get_show_tabs :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    IO CInt

-- | Returns whether the tabs of the notebook are shown.
notebookGetShowTabs ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the tabs are shown
notebookGetShowTabs notebook = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    result <- gtk_notebook_get_show_tabs notebook'
    let result' = (/= 0) result
    touchManagedPtr notebook
    return result'

#if defined(ENABLE_OVERLOADING)
data NotebookGetShowTabsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookGetShowTabsMethodInfo a signature where
    overloadedMethod = notebookGetShowTabs

instance O.OverloadedMethodInfo NotebookGetShowTabsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetShowTabs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetShowTabs"
        })


#endif

-- method Notebook::get_tab_detachable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child `GtkWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_tab_detachable" gtk_notebook_get_tab_detachable :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO CInt

-- | Returns whether the tab contents can be detached from /@notebook@/.
notebookGetTabDetachable ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: a child @GtkWidget@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the tab is detachable.
notebookGetTabDetachable notebook child = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_notebook_get_tab_detachable notebook' child'
    let result' = (/= 0) result
    touchManagedPtr notebook
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data NotebookGetTabDetachableMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookGetTabDetachableMethodInfo a signature where
    overloadedMethod = notebookGetTabDetachable

instance O.OverloadedMethodInfo NotebookGetTabDetachableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetTabDetachable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetTabDetachable"
        })


#endif

-- method Notebook::get_tab_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the page" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_tab_label" gtk_notebook_get_tab_label :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the tab label widget for the page /@child@/.
-- 
-- 'P.Nothing' is returned if /@child@/ is not in /@notebook@/ or
-- if no tab label has specifically been set for /@child@/.
notebookGetTabLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the page
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the tab label
notebookGetTabLabel notebook child = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_notebook_get_tab_label notebook' child'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr notebook
    touchManagedPtr child
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data NotebookGetTabLabelMethodInfo
instance (signature ~ (b -> m (Maybe Gtk.Widget.Widget)), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookGetTabLabelMethodInfo a signature where
    overloadedMethod = notebookGetTabLabel

instance O.OverloadedMethodInfo NotebookGetTabLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetTabLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetTabLabel"
        })


#endif

-- method Notebook::get_tab_label_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget contained in a page of @notebook"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_tab_label_text" gtk_notebook_get_tab_label_text :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO CString

-- | Retrieves the text of the tab label for the page containing
-- /@child@/.
notebookGetTabLabelText ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: a widget contained in a page of /@notebook@/
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the text of the tab label, or 'P.Nothing' if
    --   the tab label widget is not a @GtkLabel@. The string is owned
    --   by the widget and must not be freed.
notebookGetTabLabelText notebook child = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_notebook_get_tab_label_text notebook' child'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr notebook
    touchManagedPtr child
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data NotebookGetTabLabelTextMethodInfo
instance (signature ~ (b -> m (Maybe T.Text)), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookGetTabLabelTextMethodInfo a signature where
    overloadedMethod = notebookGetTabLabelText

instance O.OverloadedMethodInfo NotebookGetTabLabelTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetTabLabelText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetTabLabelText"
        })


#endif

-- method Notebook::get_tab_pos
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "PositionType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_tab_pos" gtk_notebook_get_tab_pos :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    IO CUInt

-- | Gets the edge at which the tabs are drawn.
notebookGetTabPos ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> m Gtk.Enums.PositionType
    -- ^ __Returns:__ the edge at which the tabs are drawn
notebookGetTabPos notebook = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    result <- gtk_notebook_get_tab_pos notebook'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr notebook
    return result'

#if defined(ENABLE_OVERLOADING)
data NotebookGetTabPosMethodInfo
instance (signature ~ (m Gtk.Enums.PositionType), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookGetTabPosMethodInfo a signature where
    overloadedMethod = notebookGetTabPos

instance O.OverloadedMethodInfo NotebookGetTabPosMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetTabPos",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetTabPos"
        })


#endif

-- method Notebook::get_tab_reorderable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child `GtkWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_get_tab_reorderable" gtk_notebook_get_tab_reorderable :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO CInt

-- | Gets whether the tab can be reordered via drag and drop or not.
notebookGetTabReorderable ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: a child @GtkWidget@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the tab is reorderable.
notebookGetTabReorderable notebook child = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_notebook_get_tab_reorderable notebook' child'
    let result' = (/= 0) result
    touchManagedPtr notebook
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data NotebookGetTabReorderableMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookGetTabReorderableMethodInfo a signature where
    overloadedMethod = notebookGetTabReorderable

instance O.OverloadedMethodInfo NotebookGetTabReorderableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookGetTabReorderable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookGetTabReorderable"
        })


#endif

-- method Notebook::insert_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `GtkWidget` to use as the contents of the page"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tab_label"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the `GtkWidget` to be used as the label\n  for the page, or %NULL to use the default label, \8220page N\8221"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the index (starting at 0) at which to insert the page,\n  or -1 to append the page after all other pages"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_insert_page" gtk_notebook_insert_page :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- tab_label : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Int32 ->                                -- position : TBasicType TInt
    IO Int32

-- | Insert a page into /@notebook@/ at the given position.
notebookInsertPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the @GtkWidget@ to use as the contents of the page
    -> Maybe (c)
    -- ^ /@tabLabel@/: the @GtkWidget@ to be used as the label
    --   for the page, or 'P.Nothing' to use the default label, “page N”
    -> Int32
    -- ^ /@position@/: the index (starting at 0) at which to insert the page,
    --   or -1 to append the page after all other pages
    -> m Int32
    -- ^ __Returns:__ the index (starting from 0) of the inserted
    --   page in the notebook, or -1 if function fails
notebookInsertPage notebook child tabLabel position = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    maybeTabLabel <- case tabLabel of
        Nothing -> return FP.nullPtr
        Just jTabLabel -> do
            jTabLabel' <- unsafeManagedPtrCastPtr jTabLabel
            return jTabLabel'
    result <- gtk_notebook_insert_page notebook' child' maybeTabLabel position
    touchManagedPtr notebook
    touchManagedPtr child
    whenJust tabLabel touchManagedPtr
    return result

#if defined(ENABLE_OVERLOADING)
data NotebookInsertPageMethodInfo
instance (signature ~ (b -> Maybe (c) -> Int32 -> m Int32), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) => O.OverloadedMethod NotebookInsertPageMethodInfo a signature where
    overloadedMethod = notebookInsertPage

instance O.OverloadedMethodInfo NotebookInsertPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookInsertPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookInsertPage"
        })


#endif

-- method Notebook::insert_page_menu
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `GtkWidget` to use as the contents of the page"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tab_label"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the `GtkWidget` to be used as the label\n  for the page, or %NULL to use the default label, \8220page N\8221"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "menu_label"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the widget to use as a label for the\n  page-switch menu, if that is enabled. If %NULL, and @tab_label\n  is a `GtkLabel` or %NULL, then the menu label will be a newly\n  created label with the same text as @tab_label; if @tab_label\n  is not a `GtkLabel`, @menu_label must be specified if the\n  page-switch menu is to be used."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the index (starting at 0) at which to insert the page,\n  or -1 to append the page after all other pages."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_insert_page_menu" gtk_notebook_insert_page_menu :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- tab_label : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- menu_label : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Int32 ->                                -- position : TBasicType TInt
    IO Int32

-- | Insert a page into /@notebook@/ at the given position, specifying
-- the widget to use as the label in the popup menu.
notebookInsertPageMenu ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c, Gtk.Widget.IsWidget d) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the @GtkWidget@ to use as the contents of the page
    -> Maybe (c)
    -- ^ /@tabLabel@/: the @GtkWidget@ to be used as the label
    --   for the page, or 'P.Nothing' to use the default label, “page N”
    -> Maybe (d)
    -- ^ /@menuLabel@/: the widget to use as a label for the
    --   page-switch menu, if that is enabled. If 'P.Nothing', and /@tabLabel@/
    --   is a @GtkLabel@ or 'P.Nothing', then the menu label will be a newly
    --   created label with the same text as /@tabLabel@/; if /@tabLabel@/
    --   is not a @GtkLabel@, /@menuLabel@/ must be specified if the
    --   page-switch menu is to be used.
    -> Int32
    -- ^ /@position@/: the index (starting at 0) at which to insert the page,
    --   or -1 to append the page after all other pages.
    -> m Int32
    -- ^ __Returns:__ the index (starting from 0) of the inserted
    --   page in the notebook
notebookInsertPageMenu notebook child tabLabel menuLabel position = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    maybeTabLabel <- case tabLabel of
        Nothing -> return FP.nullPtr
        Just jTabLabel -> do
            jTabLabel' <- unsafeManagedPtrCastPtr jTabLabel
            return jTabLabel'
    maybeMenuLabel <- case menuLabel of
        Nothing -> return FP.nullPtr
        Just jMenuLabel -> do
            jMenuLabel' <- unsafeManagedPtrCastPtr jMenuLabel
            return jMenuLabel'
    result <- gtk_notebook_insert_page_menu notebook' child' maybeTabLabel maybeMenuLabel position
    touchManagedPtr notebook
    touchManagedPtr child
    whenJust tabLabel touchManagedPtr
    whenJust menuLabel touchManagedPtr
    return result

#if defined(ENABLE_OVERLOADING)
data NotebookInsertPageMenuMethodInfo
instance (signature ~ (b -> Maybe (c) -> Maybe (d) -> Int32 -> m Int32), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c, Gtk.Widget.IsWidget d) => O.OverloadedMethod NotebookInsertPageMenuMethodInfo a signature where
    overloadedMethod = notebookInsertPageMenu

instance O.OverloadedMethodInfo NotebookInsertPageMenuMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookInsertPageMenu",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookInsertPageMenu"
        })


#endif

-- method Notebook::next_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_next_page" gtk_notebook_next_page :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    IO ()

-- | Switches to the next page.
-- 
-- Nothing happens if the current page is the last page.
notebookNextPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> m ()
notebookNextPage notebook = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    gtk_notebook_next_page notebook'
    touchManagedPtr notebook
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookNextPageMethodInfo
instance (signature ~ (m ()), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookNextPageMethodInfo a signature where
    overloadedMethod = notebookNextPage

instance O.OverloadedMethodInfo NotebookNextPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookNextPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookNextPage"
        })


#endif

-- method Notebook::page_num
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_page_num" gtk_notebook_page_num :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO Int32

-- | Finds the index of the page which contains the given child
-- widget.
notebookPageNum ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: a @GtkWidget@
    -> m Int32
    -- ^ __Returns:__ the index of the page containing /@child@/, or
    --   -1 if /@child@/ is not in the notebook
notebookPageNum notebook child = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_notebook_page_num notebook' child'
    touchManagedPtr notebook
    touchManagedPtr child
    return result

#if defined(ENABLE_OVERLOADING)
data NotebookPageNumMethodInfo
instance (signature ~ (b -> m Int32), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookPageNumMethodInfo a signature where
    overloadedMethod = notebookPageNum

instance O.OverloadedMethodInfo NotebookPageNumMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookPageNum",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookPageNum"
        })


#endif

-- method Notebook::popup_disable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_popup_disable" gtk_notebook_popup_disable :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    IO ()

-- | Disables the popup menu.
notebookPopupDisable ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> m ()
notebookPopupDisable notebook = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    gtk_notebook_popup_disable notebook'
    touchManagedPtr notebook
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookPopupDisableMethodInfo
instance (signature ~ (m ()), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookPopupDisableMethodInfo a signature where
    overloadedMethod = notebookPopupDisable

instance O.OverloadedMethodInfo NotebookPopupDisableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookPopupDisable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookPopupDisable"
        })


#endif

-- method Notebook::popup_enable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_popup_enable" gtk_notebook_popup_enable :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    IO ()

-- | Enables the popup menu.
-- 
-- If the user clicks with the right mouse button on the tab labels,
-- a menu with all the pages will be popped up.
notebookPopupEnable ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> m ()
notebookPopupEnable notebook = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    gtk_notebook_popup_enable notebook'
    touchManagedPtr notebook
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookPopupEnableMethodInfo
instance (signature ~ (m ()), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookPopupEnableMethodInfo a signature where
    overloadedMethod = notebookPopupEnable

instance O.OverloadedMethodInfo NotebookPopupEnableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookPopupEnable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookPopupEnable"
        })


#endif

-- method Notebook::prepend_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `GtkWidget` to use as the contents of the page"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tab_label"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the `GtkWidget` to be used as the label\n  for the page, or %NULL to use the default label, \8220page N\8221"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_prepend_page" gtk_notebook_prepend_page :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- tab_label : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO Int32

-- | Prepends a page to /@notebook@/.
notebookPrependPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the @GtkWidget@ to use as the contents of the page
    -> Maybe (c)
    -- ^ /@tabLabel@/: the @GtkWidget@ to be used as the label
    --   for the page, or 'P.Nothing' to use the default label, “page N”
    -> m Int32
    -- ^ __Returns:__ the index (starting from 0) of the prepended
    --   page in the notebook, or -1 if function fails
notebookPrependPage notebook child tabLabel = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    maybeTabLabel <- case tabLabel of
        Nothing -> return FP.nullPtr
        Just jTabLabel -> do
            jTabLabel' <- unsafeManagedPtrCastPtr jTabLabel
            return jTabLabel'
    result <- gtk_notebook_prepend_page notebook' child' maybeTabLabel
    touchManagedPtr notebook
    touchManagedPtr child
    whenJust tabLabel touchManagedPtr
    return result

#if defined(ENABLE_OVERLOADING)
data NotebookPrependPageMethodInfo
instance (signature ~ (b -> Maybe (c) -> m Int32), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) => O.OverloadedMethod NotebookPrependPageMethodInfo a signature where
    overloadedMethod = notebookPrependPage

instance O.OverloadedMethodInfo NotebookPrependPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookPrependPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookPrependPage"
        })


#endif

-- method Notebook::prepend_page_menu
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `GtkWidget` to use as the contents of the page"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tab_label"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the `GtkWidget` to be used as the label\n  for the page, or %NULL to use the default label, \8220page N\8221"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "menu_label"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the widget to use as a label for the\n  page-switch menu, if that is enabled. If %NULL, and @tab_label\n  is a `GtkLabel` or %NULL, then the menu label will be a newly\n  created label with the same text as @tab_label; if @tab_label\n  is not a `GtkLabel`, @menu_label must be specified if the\n  page-switch menu is to be used."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_prepend_page_menu" gtk_notebook_prepend_page_menu :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- tab_label : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- menu_label : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO Int32

-- | Prepends a page to /@notebook@/, specifying the widget to use as the
-- label in the popup menu.
notebookPrependPageMenu ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c, Gtk.Widget.IsWidget d) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the @GtkWidget@ to use as the contents of the page
    -> Maybe (c)
    -- ^ /@tabLabel@/: the @GtkWidget@ to be used as the label
    --   for the page, or 'P.Nothing' to use the default label, “page N”
    -> Maybe (d)
    -- ^ /@menuLabel@/: the widget to use as a label for the
    --   page-switch menu, if that is enabled. If 'P.Nothing', and /@tabLabel@/
    --   is a @GtkLabel@ or 'P.Nothing', then the menu label will be a newly
    --   created label with the same text as /@tabLabel@/; if /@tabLabel@/
    --   is not a @GtkLabel@, /@menuLabel@/ must be specified if the
    --   page-switch menu is to be used.
    -> m Int32
    -- ^ __Returns:__ the index (starting from 0) of the prepended
    --   page in the notebook, or -1 if function fails
notebookPrependPageMenu notebook child tabLabel menuLabel = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    maybeTabLabel <- case tabLabel of
        Nothing -> return FP.nullPtr
        Just jTabLabel -> do
            jTabLabel' <- unsafeManagedPtrCastPtr jTabLabel
            return jTabLabel'
    maybeMenuLabel <- case menuLabel of
        Nothing -> return FP.nullPtr
        Just jMenuLabel -> do
            jMenuLabel' <- unsafeManagedPtrCastPtr jMenuLabel
            return jMenuLabel'
    result <- gtk_notebook_prepend_page_menu notebook' child' maybeTabLabel maybeMenuLabel
    touchManagedPtr notebook
    touchManagedPtr child
    whenJust tabLabel touchManagedPtr
    whenJust menuLabel touchManagedPtr
    return result

#if defined(ENABLE_OVERLOADING)
data NotebookPrependPageMenuMethodInfo
instance (signature ~ (b -> Maybe (c) -> Maybe (d) -> m Int32), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c, Gtk.Widget.IsWidget d) => O.OverloadedMethod NotebookPrependPageMenuMethodInfo a signature where
    overloadedMethod = notebookPrependPageMenu

instance O.OverloadedMethodInfo NotebookPrependPageMenuMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookPrependPageMenu",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookPrependPageMenu"
        })


#endif

-- method Notebook::prev_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_prev_page" gtk_notebook_prev_page :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    IO ()

-- | Switches to the previous page.
-- 
-- Nothing happens if the current page is the first page.
notebookPrevPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> m ()
notebookPrevPage notebook = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    gtk_notebook_prev_page notebook'
    touchManagedPtr notebook
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookPrevPageMethodInfo
instance (signature ~ (m ()), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookPrevPageMethodInfo a signature where
    overloadedMethod = notebookPrevPage

instance O.OverloadedMethodInfo NotebookPrevPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookPrevPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookPrevPage"
        })


#endif

-- method Notebook::remove_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the index of a notebook page, starting\n  from 0. If -1, the last page will be removed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_remove_page" gtk_notebook_remove_page :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Int32 ->                                -- page_num : TBasicType TInt
    IO ()

-- | Removes a page from the notebook given its index
-- in the notebook.
notebookRemovePage ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> Int32
    -- ^ /@pageNum@/: the index of a notebook page, starting
    --   from 0. If -1, the last page will be removed.
    -> m ()
notebookRemovePage notebook pageNum = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    gtk_notebook_remove_page notebook' pageNum
    touchManagedPtr notebook
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookRemovePageMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookRemovePageMethodInfo a signature where
    overloadedMethod = notebookRemovePage

instance O.OverloadedMethodInfo NotebookRemovePageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookRemovePage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookRemovePage"
        })


#endif

-- method Notebook::reorder_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child to move" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new position, or -1 to move to the end"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_reorder_child" gtk_notebook_reorder_child :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Int32 ->                                -- position : TBasicType TInt
    IO ()

-- | Reorders the page containing /@child@/, so that it appears in position
-- /@position@/.
-- 
-- If /@position@/ is greater than or equal to the number of children in
-- the list or negative, /@child@/ will be moved to the end of the list.
notebookReorderChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the child to move
    -> Int32
    -- ^ /@position@/: the new position, or -1 to move to the end
    -> m ()
notebookReorderChild notebook child position = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    gtk_notebook_reorder_child notebook' child' position
    touchManagedPtr notebook
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookReorderChildMethodInfo
instance (signature ~ (b -> Int32 -> m ()), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookReorderChildMethodInfo a signature where
    overloadedMethod = notebookReorderChild

instance O.OverloadedMethodInfo NotebookReorderChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookReorderChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookReorderChild"
        })


#endif

-- method Notebook::set_action_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pack_type"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PackType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pack type of the action widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_action_widget" gtk_notebook_set_action_widget :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CUInt ->                                -- pack_type : TInterface (Name {namespace = "Gtk", name = "PackType"})
    IO ()

-- | Sets /@widget@/ as one of the action widgets.
-- 
-- Depending on the pack type the widget will be placed before
-- or after the tabs. You can use a @GtkBox@ if you need to pack
-- more than one widget on the same side.
notebookSetActionWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@widget@/: a @GtkWidget@
    -> Gtk.Enums.PackType
    -- ^ /@packType@/: pack type of the action widget
    -> m ()
notebookSetActionWidget notebook widget packType = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    widget' <- unsafeManagedPtrCastPtr widget
    let packType' = (fromIntegral . fromEnum) packType
    gtk_notebook_set_action_widget notebook' widget' packType'
    touchManagedPtr notebook
    touchManagedPtr widget
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetActionWidgetMethodInfo
instance (signature ~ (b -> Gtk.Enums.PackType -> m ()), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookSetActionWidgetMethodInfo a signature where
    overloadedMethod = notebookSetActionWidget

instance O.OverloadedMethodInfo NotebookSetActionWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetActionWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetActionWidget"
        })


#endif

-- method Notebook::set_current_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "index of the page to switch to, starting from 0.\n  If negative, the last page will be used. If greater\n  than the number of pages in the notebook, nothing\n  will be done."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_current_page" gtk_notebook_set_current_page :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Int32 ->                                -- page_num : TBasicType TInt
    IO ()

-- | Switches to the page number /@pageNum@/.
-- 
-- Note that due to historical reasons, GtkNotebook refuses
-- to switch to a page unless the child widget is visible.
-- Therefore, it is recommended to show child widgets before
-- adding them to a notebook.
notebookSetCurrentPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> Int32
    -- ^ /@pageNum@/: index of the page to switch to, starting from 0.
    --   If negative, the last page will be used. If greater
    --   than the number of pages in the notebook, nothing
    --   will be done.
    -> m ()
notebookSetCurrentPage notebook pageNum = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    gtk_notebook_set_current_page notebook' pageNum
    touchManagedPtr notebook
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetCurrentPageMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookSetCurrentPageMethodInfo a signature where
    overloadedMethod = notebookSetCurrentPage

instance O.OverloadedMethodInfo NotebookSetCurrentPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetCurrentPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetCurrentPage"
        })


#endif

-- method Notebook::set_group_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "group_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the name of the notebook group,\n  or %NULL to unset it"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_group_name" gtk_notebook_set_group_name :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    CString ->                              -- group_name : TBasicType TUTF8
    IO ()

-- | Sets a group name for /@notebook@/.
-- 
-- Notebooks with the same name will be able to exchange tabs
-- via drag and drop. A notebook with a 'P.Nothing' group name will
-- not be able to exchange tabs with any other notebook.
notebookSetGroupName ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> Maybe (T.Text)
    -- ^ /@groupName@/: the name of the notebook group,
    --   or 'P.Nothing' to unset it
    -> m ()
notebookSetGroupName notebook groupName = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    maybeGroupName <- case groupName of
        Nothing -> return FP.nullPtr
        Just jGroupName -> do
            jGroupName' <- textToCString jGroupName
            return jGroupName'
    gtk_notebook_set_group_name notebook' maybeGroupName
    touchManagedPtr notebook
    freeMem maybeGroupName
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetGroupNameMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookSetGroupNameMethodInfo a signature where
    overloadedMethod = notebookSetGroupName

instance O.OverloadedMethodInfo NotebookSetGroupNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetGroupName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetGroupName"
        })


#endif

-- method Notebook::set_menu_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "menu_label"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the menu label, or %NULL for default"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_menu_label" gtk_notebook_set_menu_label :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- menu_label : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Changes the menu label for the page containing /@child@/.
notebookSetMenuLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the child widget
    -> Maybe (c)
    -- ^ /@menuLabel@/: the menu label, or 'P.Nothing' for default
    -> m ()
notebookSetMenuLabel notebook child menuLabel = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    maybeMenuLabel <- case menuLabel of
        Nothing -> return FP.nullPtr
        Just jMenuLabel -> do
            jMenuLabel' <- unsafeManagedPtrCastPtr jMenuLabel
            return jMenuLabel'
    gtk_notebook_set_menu_label notebook' child' maybeMenuLabel
    touchManagedPtr notebook
    touchManagedPtr child
    whenJust menuLabel touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetMenuLabelMethodInfo
instance (signature ~ (b -> Maybe (c) -> m ()), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) => O.OverloadedMethod NotebookSetMenuLabelMethodInfo a signature where
    overloadedMethod = notebookSetMenuLabel

instance O.OverloadedMethodInfo NotebookSetMenuLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetMenuLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetMenuLabel"
        })


#endif

-- method Notebook::set_menu_label_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "menu_text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the label text" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_menu_label_text" gtk_notebook_set_menu_label_text :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CString ->                              -- menu_text : TBasicType TUTF8
    IO ()

-- | Creates a new label and sets it as the menu label of /@child@/.
notebookSetMenuLabelText ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the child widget
    -> T.Text
    -- ^ /@menuText@/: the label text
    -> m ()
notebookSetMenuLabelText notebook child menuText = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    menuText' <- textToCString menuText
    gtk_notebook_set_menu_label_text notebook' child' menuText'
    touchManagedPtr notebook
    touchManagedPtr child
    freeMem menuText'
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetMenuLabelTextMethodInfo
instance (signature ~ (b -> T.Text -> m ()), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookSetMenuLabelTextMethodInfo a signature where
    overloadedMethod = notebookSetMenuLabelText

instance O.OverloadedMethodInfo NotebookSetMenuLabelTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetMenuLabelText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetMenuLabelText"
        })


#endif

-- method Notebook::set_scrollable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scrollable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if scroll arrows should be added"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_scrollable" gtk_notebook_set_scrollable :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    CInt ->                                 -- scrollable : TBasicType TBoolean
    IO ()

-- | Sets whether the tab label area will have arrows for
-- scrolling if there are too many tabs to fit in the area.
notebookSetScrollable ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> Bool
    -- ^ /@scrollable@/: 'P.True' if scroll arrows should be added
    -> m ()
notebookSetScrollable notebook scrollable = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    let scrollable' = (P.fromIntegral . P.fromEnum) scrollable
    gtk_notebook_set_scrollable notebook' scrollable'
    touchManagedPtr notebook
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetScrollableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookSetScrollableMethodInfo a signature where
    overloadedMethod = notebookSetScrollable

instance O.OverloadedMethodInfo NotebookSetScrollableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetScrollable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetScrollable"
        })


#endif

-- method Notebook::set_show_border
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "show_border"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if a bevel should be drawn around the notebook"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_show_border" gtk_notebook_set_show_border :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    CInt ->                                 -- show_border : TBasicType TBoolean
    IO ()

-- | Sets whether a bevel will be drawn around the notebook pages.
-- 
-- This only has a visual effect when the tabs are not shown.
notebookSetShowBorder ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> Bool
    -- ^ /@showBorder@/: 'P.True' if a bevel should be drawn around the notebook
    -> m ()
notebookSetShowBorder notebook showBorder = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    let showBorder' = (P.fromIntegral . P.fromEnum) showBorder
    gtk_notebook_set_show_border notebook' showBorder'
    touchManagedPtr notebook
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetShowBorderMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookSetShowBorderMethodInfo a signature where
    overloadedMethod = notebookSetShowBorder

instance O.OverloadedMethodInfo NotebookSetShowBorderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetShowBorder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetShowBorder"
        })


#endif

-- method Notebook::set_show_tabs
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "show_tabs"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if the tabs should be shown"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_show_tabs" gtk_notebook_set_show_tabs :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    CInt ->                                 -- show_tabs : TBasicType TBoolean
    IO ()

-- | Sets whether to show the tabs for the notebook or not.
notebookSetShowTabs ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> Bool
    -- ^ /@showTabs@/: 'P.True' if the tabs should be shown
    -> m ()
notebookSetShowTabs notebook showTabs = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    let showTabs' = (P.fromIntegral . P.fromEnum) showTabs
    gtk_notebook_set_show_tabs notebook' showTabs'
    touchManagedPtr notebook
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetShowTabsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookSetShowTabsMethodInfo a signature where
    overloadedMethod = notebookSetShowTabs

instance O.OverloadedMethodInfo NotebookSetShowTabsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetShowTabs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetShowTabs"
        })


#endif

-- method Notebook::set_tab_detachable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child `GtkWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detachable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the tab is detachable or not"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_tab_detachable" gtk_notebook_set_tab_detachable :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CInt ->                                 -- detachable : TBasicType TBoolean
    IO ()

-- | Sets whether the tab can be detached from /@notebook@/ to another
-- notebook or widget.
-- 
-- Note that two notebooks must share a common group identifier
-- (see 'GI.Gtk.Objects.Notebook.notebookSetGroupName') to allow automatic tabs
-- interchange between them.
-- 
-- If you want a widget to interact with a notebook through DnD
-- (i.e.: accept dragged tabs from it) it must be set as a drop
-- destination by adding to it a t'GI.Gtk.Objects.DropTarget.DropTarget' controller that accepts
-- the GType @GTK_TYPE_NOTEBOOK_PAGE@. The @:value@ of said drop target will be
-- preloaded with a t'GI.Gtk.Objects.NotebookPage.NotebookPage' object that corresponds to the
-- dropped tab, so you can process the value via @::accept@ or @::drop@ signals.
-- 
-- Note that you should use 'GI.Gtk.Objects.Notebook.notebookDetachTab' instead
-- of 'GI.Gtk.Objects.Notebook.notebookRemovePage' if you want to remove the tab
-- from the source notebook as part of accepting a drop. Otherwise,
-- the source notebook will think that the dragged tab was removed
-- from underneath the ongoing drag operation, and will initiate a
-- drag cancel animation.
-- 
-- 
-- === /c code/
-- >static void
-- >on_drag_data_received (GtkWidget        *widget,
-- >                       GdkDrop          *drop,
-- >                       GtkSelectionData *data,
-- >                       guint             time,
-- >                       gpointer          user_data)
-- >{
-- >  GtkDrag *drag;
-- >  GtkWidget *notebook;
-- >  GtkWidget **child;
-- >
-- >  drag = gtk_drop_get_drag (drop);
-- >  notebook = g_object_get_data (drag, "gtk-notebook-drag-origin");
-- >  child = (void*) gtk_selection_data_get_data (data);
-- >
-- >  // process_widget (*child);
-- >
-- >  gtk_notebook_detach_tab (GTK_NOTEBOOK (notebook), *child);
-- >}
-- 
-- 
-- If you want a notebook to accept drags from other widgets,
-- you will have to set your own DnD code to do it.
notebookSetTabDetachable ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: a child @GtkWidget@
    -> Bool
    -- ^ /@detachable@/: whether the tab is detachable or not
    -> m ()
notebookSetTabDetachable notebook child detachable = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    let detachable' = (P.fromIntegral . P.fromEnum) detachable
    gtk_notebook_set_tab_detachable notebook' child' detachable'
    touchManagedPtr notebook
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetTabDetachableMethodInfo
instance (signature ~ (b -> Bool -> m ()), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookSetTabDetachableMethodInfo a signature where
    overloadedMethod = notebookSetTabDetachable

instance O.OverloadedMethodInfo NotebookSetTabDetachableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetTabDetachable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetTabDetachable"
        })


#endif

-- method Notebook::set_tab_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the page" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tab_label"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the tab label widget to use, or %NULL\n  for default tab label"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_tab_label" gtk_notebook_set_tab_label :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- tab_label : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Changes the tab label for /@child@/.
-- 
-- If 'P.Nothing' is specified for /@tabLabel@/, then the page will
-- have the label “page N”.
notebookSetTabLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the page
    -> Maybe (c)
    -- ^ /@tabLabel@/: the tab label widget to use, or 'P.Nothing'
    --   for default tab label
    -> m ()
notebookSetTabLabel notebook child tabLabel = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    maybeTabLabel <- case tabLabel of
        Nothing -> return FP.nullPtr
        Just jTabLabel -> do
            jTabLabel' <- unsafeManagedPtrCastPtr jTabLabel
            return jTabLabel'
    gtk_notebook_set_tab_label notebook' child' maybeTabLabel
    touchManagedPtr notebook
    touchManagedPtr child
    whenJust tabLabel touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetTabLabelMethodInfo
instance (signature ~ (b -> Maybe (c) -> m ()), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) => O.OverloadedMethod NotebookSetTabLabelMethodInfo a signature where
    overloadedMethod = notebookSetTabLabel

instance O.OverloadedMethodInfo NotebookSetTabLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetTabLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetTabLabel"
        })


#endif

-- method Notebook::set_tab_label_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the page" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tab_text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the label text" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_tab_label_text" gtk_notebook_set_tab_label_text :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CString ->                              -- tab_text : TBasicType TUTF8
    IO ()

-- | Creates a new label and sets it as the tab label for the page
-- containing /@child@/.
notebookSetTabLabelText ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: the page
    -> T.Text
    -- ^ /@tabText@/: the label text
    -> m ()
notebookSetTabLabelText notebook child tabText = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    tabText' <- textToCString tabText
    gtk_notebook_set_tab_label_text notebook' child' tabText'
    touchManagedPtr notebook
    touchManagedPtr child
    freeMem tabText'
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetTabLabelTextMethodInfo
instance (signature ~ (b -> T.Text -> m ()), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookSetTabLabelTextMethodInfo a signature where
    overloadedMethod = notebookSetTabLabelText

instance O.OverloadedMethodInfo NotebookSetTabLabelTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetTabLabelText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetTabLabelText"
        })


#endif

-- method Notebook::set_tab_pos
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pos"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PositionType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the edge to draw the tabs at"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_tab_pos" gtk_notebook_set_tab_pos :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    CUInt ->                                -- pos : TInterface (Name {namespace = "Gtk", name = "PositionType"})
    IO ()

-- | Sets the edge at which the tabs are drawn.
notebookSetTabPos ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@.
    -> Gtk.Enums.PositionType
    -- ^ /@pos@/: the edge to draw the tabs at
    -> m ()
notebookSetTabPos notebook pos = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    let pos' = (fromIntegral . fromEnum) pos
    gtk_notebook_set_tab_pos notebook' pos'
    touchManagedPtr notebook
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetTabPosMethodInfo
instance (signature ~ (Gtk.Enums.PositionType -> m ()), MonadIO m, IsNotebook a) => O.OverloadedMethod NotebookSetTabPosMethodInfo a signature where
    overloadedMethod = notebookSetTabPos

instance O.OverloadedMethodInfo NotebookSetTabPosMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetTabPos",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetTabPos"
        })


#endif

-- method Notebook::set_tab_reorderable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "notebook"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Notebook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebook`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child `GtkWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "reorderable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the tab is reorderable or not"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_set_tab_reorderable" gtk_notebook_set_tab_reorderable :: 
    Ptr Notebook ->                         -- notebook : TInterface (Name {namespace = "Gtk", name = "Notebook"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CInt ->                                 -- reorderable : TBasicType TBoolean
    IO ()

-- | Sets whether the notebook tab can be reordered
-- via drag and drop or not.
notebookSetTabReorderable ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@notebook@/: a @GtkNotebook@
    -> b
    -- ^ /@child@/: a child @GtkWidget@
    -> Bool
    -- ^ /@reorderable@/: whether the tab is reorderable or not
    -> m ()
notebookSetTabReorderable notebook child reorderable = liftIO $ do
    notebook' <- unsafeManagedPtrCastPtr notebook
    child' <- unsafeManagedPtrCastPtr child
    let reorderable' = (P.fromIntegral . P.fromEnum) reorderable
    gtk_notebook_set_tab_reorderable notebook' child' reorderable'
    touchManagedPtr notebook
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data NotebookSetTabReorderableMethodInfo
instance (signature ~ (b -> Bool -> m ()), MonadIO m, IsNotebook a, Gtk.Widget.IsWidget b) => O.OverloadedMethod NotebookSetTabReorderableMethodInfo a signature where
    overloadedMethod = notebookSetTabReorderable

instance O.OverloadedMethodInfo NotebookSetTabReorderableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Notebook.notebookSetTabReorderable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Notebook.html#v:notebookSetTabReorderable"
        })


#endif


