{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.TestLogBuffer
    ( 

-- * Exported types
    TestLogBuffer(..)                       ,
    newZeroTestLogBuffer                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [free]("GI.GLib.Structs.TestLogBuffer#g:method:free"), [push]("GI.GLib.Structs.TestLogBuffer#g:method:push").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTestLogBufferMethod              ,
#endif

-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    TestLogBufferFreeMethodInfo             ,
#endif
    testLogBufferFree                       ,


-- ** push #method:push#

#if defined(ENABLE_OVERLOADING)
    TestLogBufferPushMethodInfo             ,
#endif
    testLogBufferPush                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype TestLogBuffer = TestLogBuffer (SP.ManagedPtr TestLogBuffer)
    deriving (Eq)

instance SP.ManagedPtrNewtype TestLogBuffer where
    toManagedPtr (TestLogBuffer p) = p

instance BoxedPtr TestLogBuffer where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr TestLogBuffer)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TestLogBuffer where
    boxedPtrCalloc = callocBytes 16


-- | Construct a t'TestLogBuffer' struct initialized to zero.
newZeroTestLogBuffer :: MonadIO m => m TestLogBuffer
newZeroTestLogBuffer = liftIO $ boxedPtrCalloc >>= wrapPtr TestLogBuffer

instance tag ~ 'AttrSet => Constructible TestLogBuffer tag where
    new _ attrs = do
        o <- newZeroTestLogBuffer
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TestLogBuffer
type instance O.AttributeList TestLogBuffer = TestLogBufferAttributeList
type TestLogBufferAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method TestLogBuffer::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tbuffer"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestLogBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_log_buffer_free" g_test_log_buffer_free :: 
    Ptr TestLogBuffer ->                    -- tbuffer : TInterface (Name {namespace = "GLib", name = "TestLogBuffer"})
    IO ()

-- | Internal function for gtester to free test log messages, no ABI guarantees provided.
testLogBufferFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TestLogBuffer
    -> m ()
testLogBufferFree tbuffer = liftIO $ do
    tbuffer' <- unsafeManagedPtrGetPtr tbuffer
    g_test_log_buffer_free tbuffer'
    touchManagedPtr tbuffer
    return ()

#if defined(ENABLE_OVERLOADING)
data TestLogBufferFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod TestLogBufferFreeMethodInfo TestLogBuffer signature where
    overloadedMethod = testLogBufferFree

instance O.OverloadedMethodInfo TestLogBufferFreeMethodInfo TestLogBuffer where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestLogBuffer.testLogBufferFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-TestLogBuffer.html#v:testLogBufferFree"
        })


#endif

-- method TestLogBuffer::push
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tbuffer"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestLogBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes"
--           , argType = TBasicType TUInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_log_buffer_push" g_test_log_buffer_push :: 
    Ptr TestLogBuffer ->                    -- tbuffer : TInterface (Name {namespace = "GLib", name = "TestLogBuffer"})
    Word32 ->                               -- n_bytes : TBasicType TUInt
    Word8 ->                                -- bytes : TBasicType TUInt8
    IO ()

-- | Internal function for gtester to decode test log messages, no ABI guarantees provided.
testLogBufferPush ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TestLogBuffer
    -> Word32
    -> Word8
    -> m ()
testLogBufferPush tbuffer nBytes bytes = liftIO $ do
    tbuffer' <- unsafeManagedPtrGetPtr tbuffer
    g_test_log_buffer_push tbuffer' nBytes bytes
    touchManagedPtr tbuffer
    return ()

#if defined(ENABLE_OVERLOADING)
data TestLogBufferPushMethodInfo
instance (signature ~ (Word32 -> Word8 -> m ()), MonadIO m) => O.OverloadedMethod TestLogBufferPushMethodInfo TestLogBuffer signature where
    overloadedMethod = testLogBufferPush

instance O.OverloadedMethodInfo TestLogBufferPushMethodInfo TestLogBuffer where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestLogBuffer.testLogBufferPush",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-TestLogBuffer.html#v:testLogBufferPush"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTestLogBufferMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTestLogBufferMethod "free" o = TestLogBufferFreeMethodInfo
    ResolveTestLogBufferMethod "push" o = TestLogBufferPushMethodInfo
    ResolveTestLogBufferMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTestLogBufferMethod t TestLogBuffer, O.OverloadedMethod info TestLogBuffer p) => OL.IsLabel t (TestLogBuffer -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTestLogBufferMethod t TestLogBuffer, O.OverloadedMethod info TestLogBuffer p, R.HasField t TestLogBuffer p) => R.HasField t TestLogBuffer p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTestLogBufferMethod t TestLogBuffer, O.OverloadedMethodInfo info TestLogBuffer) => OL.IsLabel t (O.MethodProxy info TestLogBuffer) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


