{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An event related to a scrolling motion.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.ScrollEvent
    ( 

-- * Exported types
    ScrollEvent(..)                         ,
    IsScrollEvent                           ,
    toScrollEvent                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [isStop]("GI.Gdk.Objects.ScrollEvent#g:method:isStop"), [ref]("GI.Gdk.Objects.Event#g:method:ref"), [triggersContextMenu]("GI.Gdk.Objects.Event#g:method:triggersContextMenu"), [unref]("GI.Gdk.Objects.Event#g:method:unref").
-- 
-- ==== Getters
-- [getAxes]("GI.Gdk.Objects.Event#g:method:getAxes"), [getAxis]("GI.Gdk.Objects.Event#g:method:getAxis"), [getDeltas]("GI.Gdk.Objects.ScrollEvent#g:method:getDeltas"), [getDevice]("GI.Gdk.Objects.Event#g:method:getDevice"), [getDeviceTool]("GI.Gdk.Objects.Event#g:method:getDeviceTool"), [getDirection]("GI.Gdk.Objects.ScrollEvent#g:method:getDirection"), [getDisplay]("GI.Gdk.Objects.Event#g:method:getDisplay"), [getEventSequence]("GI.Gdk.Objects.Event#g:method:getEventSequence"), [getEventType]("GI.Gdk.Objects.Event#g:method:getEventType"), [getHistory]("GI.Gdk.Objects.Event#g:method:getHistory"), [getModifierState]("GI.Gdk.Objects.Event#g:method:getModifierState"), [getPointerEmulated]("GI.Gdk.Objects.Event#g:method:getPointerEmulated"), [getPosition]("GI.Gdk.Objects.Event#g:method:getPosition"), [getSeat]("GI.Gdk.Objects.Event#g:method:getSeat"), [getSurface]("GI.Gdk.Objects.Event#g:method:getSurface"), [getTime]("GI.Gdk.Objects.Event#g:method:getTime"), [getUnit]("GI.Gdk.Objects.ScrollEvent#g:method:getUnit").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveScrollEventMethod                ,
#endif

-- ** getDeltas #method:getDeltas#

#if defined(ENABLE_OVERLOADING)
    ScrollEventGetDeltasMethodInfo          ,
#endif
    scrollEventGetDeltas                    ,


-- ** getDirection #method:getDirection#

#if defined(ENABLE_OVERLOADING)
    ScrollEventGetDirectionMethodInfo       ,
#endif
    scrollEventGetDirection                 ,


-- ** getRelativeDirection #method:getRelativeDirection#

    scrollEventGetRelativeDirection         ,


-- ** getUnit #method:getUnit#

#if defined(ENABLE_OVERLOADING)
    ScrollEventGetUnitMethodInfo            ,
#endif
    scrollEventGetUnit                      ,


-- ** isStop #method:isStop#

#if defined(ENABLE_OVERLOADING)
    ScrollEventIsStopMethodInfo             ,
#endif
    scrollEventIsStop                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event

#endif

-- | Memory-managed wrapper type.
newtype ScrollEvent = ScrollEvent (SP.ManagedPtr ScrollEvent)
    deriving (Eq)

instance SP.ManagedPtrNewtype ScrollEvent where
    toManagedPtr (ScrollEvent p) = p

foreign import ccall "gdk_scroll_event_get_type"
    c_gdk_scroll_event_get_type :: IO B.Types.GType

instance B.Types.TypedObject ScrollEvent where
    glibType = c_gdk_scroll_event_get_type

-- | Type class for types which can be safely cast to t'ScrollEvent', for instance with `toScrollEvent`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ScrollEvent o) => IsScrollEvent o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ScrollEvent o) => IsScrollEvent o

instance O.HasParentTypes ScrollEvent
type instance O.ParentTypes ScrollEvent = '[Gdk.Event.Event]

-- | Cast to t'ScrollEvent', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toScrollEvent :: (MIO.MonadIO m, IsScrollEvent o) => o -> m ScrollEvent
toScrollEvent = MIO.liftIO . B.ManagedPtr.unsafeCastTo ScrollEvent

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveScrollEventMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveScrollEventMethod "isStop" o = ScrollEventIsStopMethodInfo
    ResolveScrollEventMethod "ref" o = Gdk.Event.EventRefMethodInfo
    ResolveScrollEventMethod "triggersContextMenu" o = Gdk.Event.EventTriggersContextMenuMethodInfo
    ResolveScrollEventMethod "unref" o = Gdk.Event.EventUnrefMethodInfo
    ResolveScrollEventMethod "getAxes" o = Gdk.Event.EventGetAxesMethodInfo
    ResolveScrollEventMethod "getAxis" o = Gdk.Event.EventGetAxisMethodInfo
    ResolveScrollEventMethod "getDeltas" o = ScrollEventGetDeltasMethodInfo
    ResolveScrollEventMethod "getDevice" o = Gdk.Event.EventGetDeviceMethodInfo
    ResolveScrollEventMethod "getDeviceTool" o = Gdk.Event.EventGetDeviceToolMethodInfo
    ResolveScrollEventMethod "getDirection" o = ScrollEventGetDirectionMethodInfo
    ResolveScrollEventMethod "getDisplay" o = Gdk.Event.EventGetDisplayMethodInfo
    ResolveScrollEventMethod "getEventSequence" o = Gdk.Event.EventGetEventSequenceMethodInfo
    ResolveScrollEventMethod "getEventType" o = Gdk.Event.EventGetEventTypeMethodInfo
    ResolveScrollEventMethod "getHistory" o = Gdk.Event.EventGetHistoryMethodInfo
    ResolveScrollEventMethod "getModifierState" o = Gdk.Event.EventGetModifierStateMethodInfo
    ResolveScrollEventMethod "getPointerEmulated" o = Gdk.Event.EventGetPointerEmulatedMethodInfo
    ResolveScrollEventMethod "getPosition" o = Gdk.Event.EventGetPositionMethodInfo
    ResolveScrollEventMethod "getSeat" o = Gdk.Event.EventGetSeatMethodInfo
    ResolveScrollEventMethod "getSurface" o = Gdk.Event.EventGetSurfaceMethodInfo
    ResolveScrollEventMethod "getTime" o = Gdk.Event.EventGetTimeMethodInfo
    ResolveScrollEventMethod "getUnit" o = ScrollEventGetUnitMethodInfo
    ResolveScrollEventMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveScrollEventMethod t ScrollEvent, O.OverloadedMethod info ScrollEvent p) => OL.IsLabel t (ScrollEvent -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveScrollEventMethod t ScrollEvent, O.OverloadedMethod info ScrollEvent p, R.HasField t ScrollEvent p) => R.HasField t ScrollEvent p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveScrollEventMethod t ScrollEvent, O.OverloadedMethodInfo info ScrollEvent) => OL.IsLabel t (O.MethodProxy info ScrollEvent) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr ScrollEvent where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method ScrollEvent::get_deltas
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ScrollEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a scroll event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "delta_x"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for x scroll delta"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "delta_y"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for y scroll delta"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_scroll_event_get_deltas" gdk_scroll_event_get_deltas :: 
    Ptr ScrollEvent ->                      -- event : TInterface (Name {namespace = "Gdk", name = "ScrollEvent"})
    Ptr CDouble ->                          -- delta_x : TBasicType TDouble
    Ptr CDouble ->                          -- delta_y : TBasicType TDouble
    IO ()

-- | Extracts the scroll deltas of a scroll event.
-- 
-- The deltas will be zero unless the scroll direction
-- is 'GI.Gdk.Enums.ScrollDirectionSmooth'.
-- 
-- For the representation unit of these deltas, see
-- 'GI.Gdk.Objects.ScrollEvent.scrollEventGetUnit'.
scrollEventGetDeltas ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrollEvent a) =>
    a
    -- ^ /@event@/: a scroll event
    -> m ((Double, Double))
scrollEventGetDeltas event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    deltaX <- allocMem :: IO (Ptr CDouble)
    deltaY <- allocMem :: IO (Ptr CDouble)
    gdk_scroll_event_get_deltas event' deltaX deltaY
    deltaX' <- peek deltaX
    let deltaX'' = realToFrac deltaX'
    deltaY' <- peek deltaY
    let deltaY'' = realToFrac deltaY'
    touchManagedPtr event
    freeMem deltaX
    freeMem deltaY
    return (deltaX'', deltaY'')

#if defined(ENABLE_OVERLOADING)
data ScrollEventGetDeltasMethodInfo
instance (signature ~ (m ((Double, Double))), MonadIO m, IsScrollEvent a) => O.OverloadedMethod ScrollEventGetDeltasMethodInfo a signature where
    overloadedMethod = scrollEventGetDeltas

instance O.OverloadedMethodInfo ScrollEventGetDeltasMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ScrollEvent.scrollEventGetDeltas",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ScrollEvent.html#v:scrollEventGetDeltas"
        })


#endif

-- method ScrollEvent::get_direction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ScrollEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a scroll event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ScrollDirection" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_scroll_event_get_direction" gdk_scroll_event_get_direction :: 
    Ptr ScrollEvent ->                      -- event : TInterface (Name {namespace = "Gdk", name = "ScrollEvent"})
    IO CUInt

-- | Extracts the direction of a scroll event.
scrollEventGetDirection ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrollEvent a) =>
    a
    -- ^ /@event@/: a scroll event
    -> m Gdk.Enums.ScrollDirection
    -- ^ __Returns:__ the scroll direction of /@event@/
scrollEventGetDirection event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_scroll_event_get_direction event'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrollEventGetDirectionMethodInfo
instance (signature ~ (m Gdk.Enums.ScrollDirection), MonadIO m, IsScrollEvent a) => O.OverloadedMethod ScrollEventGetDirectionMethodInfo a signature where
    overloadedMethod = scrollEventGetDirection

instance O.OverloadedMethodInfo ScrollEventGetDirectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ScrollEvent.scrollEventGetDirection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ScrollEvent.html#v:scrollEventGetDirection"
        })


#endif

-- method ScrollEvent::get_unit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ScrollEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a scroll event." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "ScrollUnit" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_scroll_event_get_unit" gdk_scroll_event_get_unit :: 
    Ptr ScrollEvent ->                      -- event : TInterface (Name {namespace = "Gdk", name = "ScrollEvent"})
    IO CUInt

-- | Extracts the scroll delta unit of a scroll event.
-- 
-- The unit will always be 'GI.Gdk.Enums.ScrollUnitWheel' if the scroll direction is not
-- 'GI.Gdk.Enums.ScrollDirectionSmooth'.
-- 
-- /Since: 4.8/
scrollEventGetUnit ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrollEvent a) =>
    a
    -- ^ /@event@/: a scroll event.
    -> m Gdk.Enums.ScrollUnit
    -- ^ __Returns:__ the scroll unit.
scrollEventGetUnit event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_scroll_event_get_unit event'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrollEventGetUnitMethodInfo
instance (signature ~ (m Gdk.Enums.ScrollUnit), MonadIO m, IsScrollEvent a) => O.OverloadedMethod ScrollEventGetUnitMethodInfo a signature where
    overloadedMethod = scrollEventGetUnit

instance O.OverloadedMethodInfo ScrollEventGetUnitMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ScrollEvent.scrollEventGetUnit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ScrollEvent.html#v:scrollEventGetUnit"
        })


#endif

-- method ScrollEvent::is_stop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ScrollEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a scroll event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_scroll_event_is_stop" gdk_scroll_event_is_stop :: 
    Ptr ScrollEvent ->                      -- event : TInterface (Name {namespace = "Gdk", name = "ScrollEvent"})
    IO CInt

-- | Check whether a scroll event is a stop scroll event.
-- 
-- Scroll sequences with smooth scroll information may provide
-- a stop scroll event once the interaction with the device finishes,
-- e.g. by lifting a finger. This stop scroll event is the signal
-- that a widget may trigger kinetic scrolling based on the current
-- velocity.
-- 
-- Stop scroll events always have a delta of 0\/0.
scrollEventIsStop ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrollEvent a) =>
    a
    -- ^ /@event@/: a scroll event
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the event is a scroll stop event
scrollEventIsStop event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_scroll_event_is_stop event'
    let result' = (/= 0) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrollEventIsStopMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsScrollEvent a) => O.OverloadedMethod ScrollEventIsStopMethodInfo a signature where
    overloadedMethod = scrollEventIsStop

instance O.OverloadedMethodInfo ScrollEventIsStopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ScrollEvent.scrollEventIsStop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ScrollEvent.html#v:scrollEventIsStop"
        })


#endif

-- method ScrollEvent::get_relative_direction
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gdk" , name = "ScrollRelativeDirection" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_scroll_event_get_relative_direction" gdk_scroll_event_get_relative_direction :: 
    Ptr Gdk.Event.Event ->                  -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO CUInt

-- | /No description available in the introspection data./
scrollEventGetRelativeDirection ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Event.IsEvent a) =>
    a
    -> m Gdk.Enums.ScrollRelativeDirection
scrollEventGetRelativeDirection event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_scroll_event_get_relative_direction event'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


