{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GdkTexture@ representing image data in memory.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.MemoryTexture
    ( 

-- * Exported types
    MemoryTexture(..)                       ,
    IsMemoryTexture                         ,
    toMemoryTexture                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [computeConcreteSize]("GI.Gdk.Interfaces.Paintable#g:method:computeConcreteSize"), [download]("GI.Gdk.Objects.Texture#g:method:download"), [equal]("GI.Gio.Interfaces.Icon#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hash]("GI.Gio.Interfaces.Icon#g:method:hash"), [invalidateContents]("GI.Gdk.Interfaces.Paintable#g:method:invalidateContents"), [invalidateSize]("GI.Gdk.Interfaces.Paintable#g:method:invalidateSize"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [load]("GI.Gio.Interfaces.LoadableIcon#g:method:load"), [loadAsync]("GI.Gio.Interfaces.LoadableIcon#g:method:loadAsync"), [loadFinish]("GI.Gio.Interfaces.LoadableIcon#g:method:loadFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [saveToPng]("GI.Gdk.Objects.Texture#g:method:saveToPng"), [saveToPngBytes]("GI.Gdk.Objects.Texture#g:method:saveToPngBytes"), [saveToTiff]("GI.Gdk.Objects.Texture#g:method:saveToTiff"), [saveToTiffBytes]("GI.Gdk.Objects.Texture#g:method:saveToTiffBytes"), [serialize]("GI.Gio.Interfaces.Icon#g:method:serialize"), [snapshot]("GI.Gdk.Interfaces.Paintable#g:method:snapshot"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gio.Interfaces.Icon#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getColorState]("GI.Gdk.Objects.Texture#g:method:getColorState"), [getCurrentImage]("GI.Gdk.Interfaces.Paintable#g:method:getCurrentImage"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFlags]("GI.Gdk.Interfaces.Paintable#g:method:getFlags"), [getFormat]("GI.Gdk.Objects.Texture#g:method:getFormat"), [getHeight]("GI.Gdk.Objects.Texture#g:method:getHeight"), [getIntrinsicAspectRatio]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicAspectRatio"), [getIntrinsicHeight]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicHeight"), [getIntrinsicWidth]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicWidth"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWidth]("GI.Gdk.Objects.Texture#g:method:getWidth").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMemoryTextureMethod              ,
#endif

-- ** new #method:new#

    memoryTextureNew                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon

#else
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon

#endif

-- | Memory-managed wrapper type.
newtype MemoryTexture = MemoryTexture (SP.ManagedPtr MemoryTexture)
    deriving (Eq)

instance SP.ManagedPtrNewtype MemoryTexture where
    toManagedPtr (MemoryTexture p) = p

foreign import ccall "gdk_memory_texture_get_type"
    c_gdk_memory_texture_get_type :: IO B.Types.GType

instance B.Types.TypedObject MemoryTexture where
    glibType = c_gdk_memory_texture_get_type

instance B.Types.GObject MemoryTexture

-- | Type class for types which can be safely cast to t'MemoryTexture', for instance with `toMemoryTexture`.
class (SP.GObject o, O.IsDescendantOf MemoryTexture o) => IsMemoryTexture o
instance (SP.GObject o, O.IsDescendantOf MemoryTexture o) => IsMemoryTexture o

instance O.HasParentTypes MemoryTexture
type instance O.ParentTypes MemoryTexture = '[Gdk.Texture.Texture, GObject.Object.Object, Gdk.Paintable.Paintable, Gio.Icon.Icon, Gio.LoadableIcon.LoadableIcon]

-- | Cast to t'MemoryTexture', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toMemoryTexture :: (MIO.MonadIO m, IsMemoryTexture o) => o -> m MemoryTexture
toMemoryTexture = MIO.liftIO . B.ManagedPtr.unsafeCastTo MemoryTexture

-- | Convert t'MemoryTexture' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MemoryTexture) where
    gvalueGType_ = c_gdk_memory_texture_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MemoryTexture)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MemoryTexture)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MemoryTexture ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMemoryTextureMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMemoryTextureMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMemoryTextureMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMemoryTextureMethod "computeConcreteSize" o = Gdk.Paintable.PaintableComputeConcreteSizeMethodInfo
    ResolveMemoryTextureMethod "download" o = Gdk.Texture.TextureDownloadMethodInfo
    ResolveMemoryTextureMethod "equal" o = Gio.Icon.IconEqualMethodInfo
    ResolveMemoryTextureMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMemoryTextureMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMemoryTextureMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMemoryTextureMethod "hash" o = Gio.Icon.IconHashMethodInfo
    ResolveMemoryTextureMethod "invalidateContents" o = Gdk.Paintable.PaintableInvalidateContentsMethodInfo
    ResolveMemoryTextureMethod "invalidateSize" o = Gdk.Paintable.PaintableInvalidateSizeMethodInfo
    ResolveMemoryTextureMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMemoryTextureMethod "load" o = Gio.LoadableIcon.LoadableIconLoadMethodInfo
    ResolveMemoryTextureMethod "loadAsync" o = Gio.LoadableIcon.LoadableIconLoadAsyncMethodInfo
    ResolveMemoryTextureMethod "loadFinish" o = Gio.LoadableIcon.LoadableIconLoadFinishMethodInfo
    ResolveMemoryTextureMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMemoryTextureMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMemoryTextureMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMemoryTextureMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMemoryTextureMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMemoryTextureMethod "saveToPng" o = Gdk.Texture.TextureSaveToPngMethodInfo
    ResolveMemoryTextureMethod "saveToPngBytes" o = Gdk.Texture.TextureSaveToPngBytesMethodInfo
    ResolveMemoryTextureMethod "saveToTiff" o = Gdk.Texture.TextureSaveToTiffMethodInfo
    ResolveMemoryTextureMethod "saveToTiffBytes" o = Gdk.Texture.TextureSaveToTiffBytesMethodInfo
    ResolveMemoryTextureMethod "serialize" o = Gio.Icon.IconSerializeMethodInfo
    ResolveMemoryTextureMethod "snapshot" o = Gdk.Paintable.PaintableSnapshotMethodInfo
    ResolveMemoryTextureMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMemoryTextureMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMemoryTextureMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMemoryTextureMethod "toString" o = Gio.Icon.IconToStringMethodInfo
    ResolveMemoryTextureMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMemoryTextureMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMemoryTextureMethod "getColorState" o = Gdk.Texture.TextureGetColorStateMethodInfo
    ResolveMemoryTextureMethod "getCurrentImage" o = Gdk.Paintable.PaintableGetCurrentImageMethodInfo
    ResolveMemoryTextureMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMemoryTextureMethod "getFlags" o = Gdk.Paintable.PaintableGetFlagsMethodInfo
    ResolveMemoryTextureMethod "getFormat" o = Gdk.Texture.TextureGetFormatMethodInfo
    ResolveMemoryTextureMethod "getHeight" o = Gdk.Texture.TextureGetHeightMethodInfo
    ResolveMemoryTextureMethod "getIntrinsicAspectRatio" o = Gdk.Paintable.PaintableGetIntrinsicAspectRatioMethodInfo
    ResolveMemoryTextureMethod "getIntrinsicHeight" o = Gdk.Paintable.PaintableGetIntrinsicHeightMethodInfo
    ResolveMemoryTextureMethod "getIntrinsicWidth" o = Gdk.Paintable.PaintableGetIntrinsicWidthMethodInfo
    ResolveMemoryTextureMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMemoryTextureMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMemoryTextureMethod "getWidth" o = Gdk.Texture.TextureGetWidthMethodInfo
    ResolveMemoryTextureMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMemoryTextureMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMemoryTextureMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMemoryTextureMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMemoryTextureMethod t MemoryTexture, O.OverloadedMethod info MemoryTexture p) => OL.IsLabel t (MemoryTexture -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMemoryTextureMethod t MemoryTexture, O.OverloadedMethod info MemoryTexture p, R.HasField t MemoryTexture p) => R.HasField t MemoryTexture p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMemoryTextureMethod t MemoryTexture, O.OverloadedMethodInfo info MemoryTexture) => OL.IsLabel t (O.MethodProxy info MemoryTexture) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MemoryTexture
type instance O.AttributeList MemoryTexture = MemoryTextureAttributeList
type MemoryTextureAttributeList = ('[ '("colorState", Gdk.Texture.TextureColorStatePropertyInfo), '("height", Gdk.Texture.TextureHeightPropertyInfo), '("width", Gdk.Texture.TextureWidthPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MemoryTexture = MemoryTextureSignalList
type MemoryTextureSignalList = ('[ '("invalidateContents", Gdk.Paintable.PaintableInvalidateContentsSignalInfo), '("invalidateSize", Gdk.Paintable.PaintableInvalidateSizeSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MemoryTexture::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the width of the texture"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the height of the texture"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "MemoryFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the format of the data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes"
--           , argType = TInterface Name { namespace = "GLib" , name = "Bytes" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GBytes` containing the pixel data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stride"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rowstride for the data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "MemoryTexture" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_new" gdk_memory_texture_new :: 
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    CUInt ->                                -- format : TInterface (Name {namespace = "Gdk", name = "MemoryFormat"})
    Ptr GLib.Bytes.Bytes ->                 -- bytes : TInterface (Name {namespace = "GLib", name = "Bytes"})
    FCT.CSize ->                            -- stride : TBasicType TSize
    IO (Ptr MemoryTexture)

-- | Creates a new texture for a blob of image data.
-- 
-- The @GBytes@ must contain /@stride@/ × /@height@/ pixels
-- in the given format.
memoryTextureNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@width@/: the width of the texture
    -> Int32
    -- ^ /@height@/: the height of the texture
    -> Gdk.Enums.MemoryFormat
    -- ^ /@format@/: the format of the data
    -> GLib.Bytes.Bytes
    -- ^ /@bytes@/: the @GBytes@ containing the pixel data
    -> FCT.CSize
    -- ^ /@stride@/: rowstride for the data
    -> m MemoryTexture
    -- ^ __Returns:__ A newly-created @GdkTexture@
memoryTextureNew width height format bytes stride = liftIO $ do
    let format' = (fromIntegral . fromEnum) format
    bytes' <- unsafeManagedPtrGetPtr bytes
    result <- gdk_memory_texture_new width height format' bytes' stride
    checkUnexpectedReturnNULL "memoryTextureNew" result
    result' <- (wrapObject MemoryTexture) result
    touchManagedPtr bytes
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


