/* number-picker.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from number-picker.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "libsudoku.h"
#include <glib.h>
#include <adwaita.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU_NUMBER_PICKER (sudoku_number_picker_get_type ())
#define SUDOKU_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_NUMBER_PICKER, SudokuNumberPicker))
#define SUDOKU_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_NUMBER_PICKER, SudokuNumberPickerClass))
#define IS_SUDOKU_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_NUMBER_PICKER))
#define IS_SUDOKU_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_NUMBER_PICKER))
#define SUDOKU_NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_NUMBER_PICKER, SudokuNumberPickerClass))

typedef struct _SudokuNumberPicker SudokuNumberPicker;
typedef struct _SudokuNumberPickerClass SudokuNumberPickerClass;
typedef struct _SudokuNumberPickerPrivate SudokuNumberPickerPrivate;
typedef enum  {
	NUMBER_PICKER_STATE_NONE,
	NUMBER_PICKER_STATE_VALUE_PICKER,
	NUMBER_PICKER_STATE_EARMARK_PICKER
} NumberPickerState;

#define TYPE_NUMBER_PICKER_STATE (number_picker_state_get_type ())

#define TYPE_PICKER_BASE (picker_base_get_type ())
#define PICKER_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PICKER_BASE, PickerBase))
#define PICKER_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PICKER_BASE, PickerBaseClass))
#define IS_PICKER_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PICKER_BASE))
#define IS_PICKER_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PICKER_BASE))
#define PICKER_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PICKER_BASE, PickerBaseClass))

typedef struct _PickerBase PickerBase;
typedef struct _PickerBaseClass PickerBaseClass;

#define TYPE_VALUE_PICKER (value_picker_get_type ())
#define VALUE_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALUE_PICKER, ValuePicker))
#define VALUE_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALUE_PICKER, ValuePickerClass))
#define IS_VALUE_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALUE_PICKER))
#define IS_VALUE_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALUE_PICKER))
#define VALUE_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALUE_PICKER, ValuePickerClass))

typedef struct _ValuePicker ValuePicker;
typedef struct _ValuePickerClass ValuePickerClass;

#define TYPE_EARMARK_PICKER (earmark_picker_get_type ())
#define EARMARK_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EARMARK_PICKER, EarmarkPicker))
#define EARMARK_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EARMARK_PICKER, EarmarkPickerClass))
#define IS_EARMARK_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EARMARK_PICKER))
#define IS_EARMARK_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EARMARK_PICKER))
#define EARMARK_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EARMARK_PICKER, EarmarkPickerClass))

typedef struct _EarmarkPicker EarmarkPicker;
typedef struct _EarmarkPickerClass EarmarkPickerClass;
enum  {
	SUDOKU_NUMBER_PICKER_0_PROPERTY,
	SUDOKU_NUMBER_PICKER_NUM_PROPERTIES
};
static GParamSpec* sudoku_number_picker_properties[SUDOKU_NUMBER_PICKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SUDOKU_CELL (sudoku_cell_get_type ())
#define SUDOKU_CELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL, SudokuCell))
#define SUDOKU_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL, SudokuCellClass))
#define IS_SUDOKU_CELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL))
#define IS_SUDOKU_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL))
#define SUDOKU_CELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL, SudokuCellClass))

typedef struct _SudokuCell SudokuCell;
typedef struct _SudokuCellClass SudokuCellClass;

#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _PickerBasePrivate PickerBasePrivate;
enum  {
	PICKER_BASE_0_PROPERTY,
	PICKER_BASE_NUM_PROPERTIES
};
static GParamSpec* picker_base_properties[PICKER_BASE_NUM_PROPERTIES];
typedef struct _ValuePickerPrivate ValuePickerPrivate;
enum  {
	VALUE_PICKER_0_PROPERTY,
	VALUE_PICKER_NUM_PROPERTIES
};
static GParamSpec* value_picker_properties[VALUE_PICKER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _EarmarkPickerPrivate EarmarkPickerPrivate;
enum  {
	EARMARK_PICKER_0_PROPERTY,
	EARMARK_PICKER_NUM_PROPERTIES
};
static GParamSpec* earmark_picker_properties[EARMARK_PICKER_NUM_PROPERTIES];
typedef struct _Block4Data Block4Data;

struct _SudokuNumberPicker {
	GtkPopover parent_instance;
	SudokuNumberPickerPrivate * priv;
	NumberPickerState state;
};

struct _SudokuNumberPickerClass {
	GtkPopoverClass parent_class;
};

struct _SudokuNumberPickerPrivate {
	ValuePicker* value_picker;
	EarmarkPicker* earmark_picker;
	GtkStack* picker_stack;
};

struct _PickerBase {
	GtkGrid parent_instance;
	PickerBasePrivate * priv;
	SudokuNumberPicker* number_picker;
	SudokuCell* cell;
	SudokuGame* game;
	GtkButton* clear_button;
};

struct _PickerBaseClass {
	GtkGridClass parent_class;
	void (*value_changed_cb) (PickerBase* self, gint row, gint col, gint old_val, gint new_val);
	void (*earmark_changed_cb) (PickerBase* self, gint row, gint col, gint num, gboolean enabled);
	void (*connect_picker) (PickerBase* self, SudokuCell* cell);
	void (*disconnect_picker) (PickerBase* self);
};

struct _ValuePicker {
	PickerBase parent_instance;
	ValuePickerPrivate * priv;
};

struct _ValuePickerClass {
	PickerBaseClass parent_class;
};

struct _ValuePickerPrivate {
	GtkButton** value_buttons;
	gint value_buttons_length1;
	gint _value_buttons_size_;
};

struct _EarmarkPicker {
	PickerBase parent_instance;
	EarmarkPickerPrivate * priv;
};

struct _EarmarkPickerClass {
	PickerBaseClass parent_class;
};

struct _EarmarkPickerPrivate {
	GtkToggleButton** earmark_buttons;
	gint earmark_buttons_length1;
	gint _earmark_buttons_size_;
	GtkToggleButton* lock_button;
};

struct _Block4Data {
	int _ref_count_;
	EarmarkPicker* self;
	SudokuNumberPicker* number_picker;
};

static gint SudokuNumberPicker_private_offset;
static gpointer sudoku_number_picker_parent_class = NULL;
VALA_EXTERN Sudoku* sudoku_app;
static gpointer picker_base_parent_class = NULL;
static gint ValuePicker_private_offset;
static gpointer value_picker_parent_class = NULL;
static gint EarmarkPicker_private_offset;
static gpointer earmark_picker_parent_class = NULL;

VALA_EXTERN GType sudoku_number_picker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuNumberPicker, g_object_unref)
VALA_EXTERN GType number_picker_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType picker_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PickerBase, g_object_unref)
VALA_EXTERN GType value_picker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValuePicker, g_object_unref)
VALA_EXTERN GType earmark_picker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EarmarkPicker, g_object_unref)
VALA_EXTERN SudokuNumberPicker* sudoku_number_picker_new (SudokuGame* game);
VALA_EXTERN SudokuNumberPicker* sudoku_number_picker_construct (GType object_type,
                                                    SudokuGame* game);
VALA_EXTERN ValuePicker* value_picker_new (SudokuGame* game,
                               SudokuNumberPicker* number_picker);
VALA_EXTERN ValuePicker* value_picker_construct (GType object_type,
                                     SudokuGame* game,
                                     SudokuNumberPicker* number_picker);
VALA_EXTERN EarmarkPicker* earmark_picker_new (SudokuGame* game,
                                   SudokuNumberPicker* number_picker);
VALA_EXTERN EarmarkPicker* earmark_picker_construct (GType object_type,
                                         SudokuGame* game,
                                         SudokuNumberPicker* number_picker);
VALA_EXTERN GType sudoku_cell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuCell, g_object_unref)
VALA_EXTERN void sudoku_number_picker_show_earmark_picker (SudokuNumberPicker* self,
                                               SudokuCell* cell);
VALA_EXTERN void picker_base_disconnect_picker (PickerBase* self);
VALA_EXTERN void picker_base_connect_picker (PickerBase* self,
                                 SudokuCell* cell);
VALA_EXTERN GType sudoku_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Sudoku, g_object_unref)
VALA_EXTERN gboolean sudoku_get_earmark_mode (Sudoku* self);
VALA_EXTERN void sudoku_number_picker_show_value_picker (SudokuNumberPicker* self,
                                             SudokuCell* cell);
static void sudoku_number_picker_real_closed (GtkPopover* base);
static void sudoku_number_picker_finalize (GObject * obj);
static GType sudoku_number_picker_get_type_once (void);
VALA_EXTERN void picker_base_value_changed_cb (PickerBase* self,
                                   gint row,
                                   gint col,
                                   gint old_val,
                                   gint new_val);
VALA_EXTERN void picker_base_earmark_changed_cb (PickerBase* self,
                                     gint row,
                                     gint col,
                                     gint num,
                                     gboolean enabled);
static PickerBase* picker_base_construct (GType object_type,
                                   SudokuGame* game,
                                   SudokuNumberPicker* number_picker);
static void __lambda4_ (PickerBase* self);
VALA_EXTERN void sudoku_cell_set_value (SudokuCell* self,
                            gint value);
static void ___lambda4__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void picker_base_real_dispose (GObject* base);
static void picker_base_real_value_changed_cb (PickerBase* self,
                                        gint row,
                                        gint col,
                                        gint old_val,
                                        gint new_val);
static void picker_base_real_earmark_changed_cb (PickerBase* self,
                                          gint row,
                                          gint col,
                                          gint num,
                                          gboolean enabled);
static void picker_base_real_connect_picker (PickerBase* self,
                                      SudokuCell* cell);
static void _picker_base_earmark_changed_cb_sudoku_board_earmark_changed (SudokuBoard* _sender,
                                                                   gint row,
                                                                   gint col,
                                                                   gint num,
                                                                   gboolean enabled,
                                                                   gpointer self);
static void _picker_base_value_changed_cb_sudoku_board_value_changed (SudokuBoard* _sender,
                                                               gint row,
                                                               gint col,
                                                               gint old_val,
                                                               gint new_val,
                                                               gpointer self);
static void picker_base_real_disconnect_picker (PickerBase* self);
static void picker_base_finalize (GObject * obj);
static GType picker_base_get_type_once (void);
static void _gtk_popover_popdown_gtk_button_clicked (GtkButton* _sender,
                                              gpointer self);
static void value_picker_value_picked_cb (ValuePicker* self,
                                   GtkButton* button);
static void _value_picker_value_picked_cb_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void value_picker_real_connect_picker (PickerBase* base,
                                       SudokuCell* cell);
VALA_EXTERN gint sudoku_cell_get_value (SudokuCell* self);
VALA_EXTERN gint sudoku_cell_get_row (SudokuCell* self);
VALA_EXTERN gint sudoku_cell_get_col (SudokuCell* self);
static void value_picker_real_value_changed_cb (PickerBase* base,
                                         gint row,
                                         gint col,
                                         gint old_val,
                                         gint new_val);
static void value_picker_real_earmark_changed_cb (PickerBase* base,
                                           gint row,
                                           gint col,
                                           gint num,
                                           gboolean enabled);
static void value_picker_real_dispose (GObject* base);
static void value_picker_finalize (GObject * obj);
static GType value_picker_get_type_once (void);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void earmark_picker_lock_button_toggled_cb (EarmarkPicker* self);
static void _earmark_picker_lock_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void __lambda17_ (Block4Data* _data4_);
static void ___lambda17__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void earmark_picker_real_connect_picker (PickerBase* base,
                                         SudokuCell* cell);
static void earmark_picker_set_buttons_active (EarmarkPicker* self,
                                        gint row,
                                        gint col);
static void earmark_picker_set_buttons_sensitive (EarmarkPicker* self,
                                           gboolean enabled);
static void earmark_picker_earmark_picked_cb (EarmarkPicker* self,
                                       GtkToggleButton* button);
static void _earmark_picker_earmark_picked_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self);
static void earmark_picker_real_disconnect_picker (PickerBase* base);
static void earmark_picker_real_value_changed_cb (PickerBase* base,
                                           gint row,
                                           gint col,
                                           gint old_val,
                                           gint new_val);
static void earmark_picker_real_earmark_changed_cb (PickerBase* base,
                                             gint row,
                                             gint col,
                                             gint num,
                                             gboolean enabled);
static void earmark_picker_real_dispose (GObject* base);
static void earmark_picker_finalize (GObject * obj);
static GType earmark_picker_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
sudoku_number_picker_get_instance_private (SudokuNumberPicker* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuNumberPicker_private_offset);
}

SudokuNumberPicker*
sudoku_number_picker_construct (GType object_type,
                                SudokuGame* game)
{
	SudokuNumberPicker * self = NULL;
	ValuePicker* _tmp0_;
	EarmarkPicker* _tmp1_;
	GtkStack* _tmp2_;
	GtkStack* _tmp3_;
	ValuePicker* _tmp4_;
	GtkStack* _tmp5_;
	EarmarkPicker* _tmp6_;
	GtkStack* _tmp7_;
	GtkStack* _tmp8_;
	GtkStack* _tmp9_;
	g_return_val_if_fail (game != NULL, NULL);
	self = (SudokuNumberPicker*) g_object_new (object_type, NULL);
	_tmp0_ = value_picker_new (game, self);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->value_picker);
	self->priv->value_picker = _tmp0_;
	_tmp1_ = earmark_picker_new (game, self);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->earmark_picker);
	self->priv->earmark_picker = _tmp1_;
	_tmp2_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->picker_stack);
	self->priv->picker_stack = _tmp2_;
	_tmp3_ = self->priv->picker_stack;
	_tmp4_ = self->priv->value_picker;
	gtk_stack_add_child (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->picker_stack;
	_tmp6_ = self->priv->earmark_picker;
	gtk_stack_add_child (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->picker_stack;
	gtk_stack_set_vhomogeneous (_tmp7_, FALSE);
	_tmp8_ = self->priv->picker_stack;
	gtk_stack_set_interpolate_size (_tmp8_, TRUE);
	_tmp9_ = self->priv->picker_stack;
	gtk_popover_set_child ((GtkPopover*) self, (GtkWidget*) _tmp9_);
	gtk_popover_set_autohide ((GtkPopover*) self, FALSE);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	return self;
}

SudokuNumberPicker*
sudoku_number_picker_new (SudokuGame* game)
{
	return sudoku_number_picker_construct (TYPE_SUDOKU_NUMBER_PICKER, game);
}

void
sudoku_number_picker_show_earmark_picker (SudokuNumberPicker* self,
                                          SudokuCell* cell)
{
	EarmarkPicker* _tmp1_;
	Sudoku* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkStack* _tmp7_;
	EarmarkPicker* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell != NULL);
	if (self->state == NUMBER_PICKER_STATE_EARMARK_PICKER) {
		gtk_popover_popdown ((GtkPopover*) self);
		return;
	} else {
		if (self->state == NUMBER_PICKER_STATE_VALUE_PICKER) {
			ValuePicker* _tmp0_;
			_tmp0_ = self->priv->value_picker;
			picker_base_disconnect_picker ((PickerBase*) _tmp0_);
		} else {
			gtk_widget_set_parent ((GtkWidget*) self, (GtkWidget*) cell);
		}
	}
	self->state = NUMBER_PICKER_STATE_EARMARK_PICKER;
	_tmp1_ = self->priv->earmark_picker;
	picker_base_connect_picker ((PickerBase*) _tmp1_, cell);
	_tmp2_ = sudoku_app;
	_tmp3_ = sudoku_get_earmark_mode (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		GtkStack* _tmp5_;
		_tmp5_ = self->priv->picker_stack;
		gtk_stack_set_transition_type (_tmp5_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
	} else {
		GtkStack* _tmp6_;
		_tmp6_ = self->priv->picker_stack;
		gtk_stack_set_transition_type (_tmp6_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
	}
	_tmp7_ = self->priv->picker_stack;
	_tmp8_ = self->priv->earmark_picker;
	gtk_stack_set_visible_child (_tmp7_, (GtkWidget*) _tmp8_);
	gtk_popover_popup ((GtkPopover*) self);
}

void
sudoku_number_picker_show_value_picker (SudokuNumberPicker* self,
                                        SudokuCell* cell)
{
	ValuePicker* _tmp1_;
	Sudoku* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkStack* _tmp7_;
	ValuePicker* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell != NULL);
	if (self->state == NUMBER_PICKER_STATE_VALUE_PICKER) {
		gtk_popover_popdown ((GtkPopover*) self);
		return;
	} else {
		if (self->state == NUMBER_PICKER_STATE_EARMARK_PICKER) {
			EarmarkPicker* _tmp0_;
			_tmp0_ = self->priv->earmark_picker;
			picker_base_disconnect_picker ((PickerBase*) _tmp0_);
		} else {
			gtk_widget_set_parent ((GtkWidget*) self, (GtkWidget*) cell);
		}
	}
	self->state = NUMBER_PICKER_STATE_VALUE_PICKER;
	_tmp1_ = self->priv->value_picker;
	picker_base_connect_picker ((PickerBase*) _tmp1_, cell);
	_tmp2_ = sudoku_app;
	_tmp3_ = sudoku_get_earmark_mode (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		GtkStack* _tmp5_;
		_tmp5_ = self->priv->picker_stack;
		gtk_stack_set_transition_type (_tmp5_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
	} else {
		GtkStack* _tmp6_;
		_tmp6_ = self->priv->picker_stack;
		gtk_stack_set_transition_type (_tmp6_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
	}
	_tmp7_ = self->priv->picker_stack;
	_tmp8_ = self->priv->value_picker;
	gtk_stack_set_visible_child (_tmp7_, (GtkWidget*) _tmp8_);
	gtk_popover_popup ((GtkPopover*) self);
}

static void
sudoku_number_picker_real_closed (GtkPopover* base)
{
	SudokuNumberPicker * self;
	self = (SudokuNumberPicker*) base;
	if (self->state == NUMBER_PICKER_STATE_VALUE_PICKER) {
		ValuePicker* _tmp0_;
		_tmp0_ = self->priv->value_picker;
		picker_base_disconnect_picker ((PickerBase*) _tmp0_);
	} else {
		if (self->state == NUMBER_PICKER_STATE_EARMARK_PICKER) {
			EarmarkPicker* _tmp1_;
			_tmp1_ = self->priv->earmark_picker;
			picker_base_disconnect_picker ((PickerBase*) _tmp1_);
		}
	}
	self->state = NUMBER_PICKER_STATE_NONE;
	gtk_widget_unparent ((GtkWidget*) self);
}

static void
sudoku_number_picker_class_init (SudokuNumberPickerClass * klass,
                                 gpointer klass_data)
{
	sudoku_number_picker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuNumberPicker_private_offset);
	((GtkPopoverClass *) klass)->closed = (void (*) (GtkPopover*)) sudoku_number_picker_real_closed;
	G_OBJECT_CLASS (klass)->finalize = sudoku_number_picker_finalize;
}

static void
sudoku_number_picker_instance_init (SudokuNumberPicker * self,
                                    gpointer klass)
{
	self->priv = sudoku_number_picker_get_instance_private (self);
}

static void
sudoku_number_picker_finalize (GObject * obj)
{
	SudokuNumberPicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_NUMBER_PICKER, SudokuNumberPicker);
	_g_object_unref0 (self->priv->value_picker);
	_g_object_unref0 (self->priv->earmark_picker);
	_g_object_unref0 (self->priv->picker_stack);
	G_OBJECT_CLASS (sudoku_number_picker_parent_class)->finalize (obj);
}

static GType
sudoku_number_picker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuNumberPickerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_number_picker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuNumberPicker), 0, (GInstanceInitFunc) sudoku_number_picker_instance_init, NULL };
	GType sudoku_number_picker_type_id;
	sudoku_number_picker_type_id = g_type_register_static (gtk_popover_get_type (), "SudokuNumberPicker", &g_define_type_info, 0);
	SudokuNumberPicker_private_offset = g_type_add_instance_private (sudoku_number_picker_type_id, sizeof (SudokuNumberPickerPrivate));
	return sudoku_number_picker_type_id;
}

GType
sudoku_number_picker_get_type (void)
{
	static volatile gsize sudoku_number_picker_type_id__once = 0;
	if (g_once_init_enter (&sudoku_number_picker_type_id__once)) {
		GType sudoku_number_picker_type_id;
		sudoku_number_picker_type_id = sudoku_number_picker_get_type_once ();
		g_once_init_leave (&sudoku_number_picker_type_id__once, sudoku_number_picker_type_id);
	}
	return sudoku_number_picker_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda4_ (PickerBase* self)
{
	SudokuCell* _tmp0_;
	_tmp0_ = self->cell;
	sudoku_cell_set_value (_tmp0_, 0);
}

static void
___lambda4__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda4_ ((PickerBase*) self);
}

static PickerBase*
picker_base_construct (GType object_type,
                       SudokuGame* game,
                       SudokuNumberPicker* number_picker)
{
	PickerBase * self = NULL;
	SudokuGame* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (number_picker != NULL, NULL);
	self = (PickerBase*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (self->game);
	self->game = _tmp0_;
	self->number_picker = number_picker;
	_tmp1_ = (GtkButton*) gtk_button_new_with_label (_ ("Clear"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->clear_button);
	self->clear_button = _tmp1_;
	_tmp2_ = self->clear_button;
	g_signal_connect_object (_tmp2_, "clicked", (GCallback) ___lambda4__gtk_button_clicked, self, 0);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 3);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 3);
	return self;
}

static void
picker_base_real_dispose (GObject* base)
{
	PickerBase * self;
	GtkButton* _tmp0_;
	self = (PickerBase*) base;
	G_OBJECT_CLASS (picker_base_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid));
	_tmp0_ = self->clear_button;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
}

static void
picker_base_real_value_changed_cb (PickerBase* self,
                                   gint row,
                                   gint col,
                                   gint old_val,
                                   gint new_val)
{
	g_critical ("Type `%s' does not implement abstract method `picker_base_value_changed_cb'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
picker_base_value_changed_cb (PickerBase* self,
                              gint row,
                              gint col,
                              gint old_val,
                              gint new_val)
{
	PickerBaseClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PICKER_BASE_GET_CLASS (self);
	if (_klass_->value_changed_cb) {
		_klass_->value_changed_cb (self, row, col, old_val, new_val);
	}
}

static void
picker_base_real_earmark_changed_cb (PickerBase* self,
                                     gint row,
                                     gint col,
                                     gint num,
                                     gboolean enabled)
{
	g_critical ("Type `%s' does not implement abstract method `picker_base_earmark_changed_cb'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
picker_base_earmark_changed_cb (PickerBase* self,
                                gint row,
                                gint col,
                                gint num,
                                gboolean enabled)
{
	PickerBaseClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PICKER_BASE_GET_CLASS (self);
	if (_klass_->earmark_changed_cb) {
		_klass_->earmark_changed_cb (self, row, col, num, enabled);
	}
}

static void
_picker_base_earmark_changed_cb_sudoku_board_earmark_changed (SudokuBoard* _sender,
                                                              gint row,
                                                              gint col,
                                                              gint num,
                                                              gboolean enabled,
                                                              gpointer self)
{
	picker_base_earmark_changed_cb ((PickerBase*) self, row, col, num, enabled);
}

static void
_picker_base_value_changed_cb_sudoku_board_value_changed (SudokuBoard* _sender,
                                                          gint row,
                                                          gint col,
                                                          gint old_val,
                                                          gint new_val,
                                                          gpointer self)
{
	picker_base_value_changed_cb ((PickerBase*) self, row, col, old_val, new_val);
}

static void
picker_base_real_connect_picker (PickerBase* self,
                                 SudokuCell* cell)
{
	SudokuCell* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuBoard* _tmp2_;
	SudokuBoard* _tmp3_;
	SudokuGame* _tmp4_;
	SudokuBoard* _tmp5_;
	SudokuBoard* _tmp6_;
	g_return_if_fail (cell != NULL);
	_tmp0_ = _g_object_ref0 (cell);
	_g_object_unref0 (self->cell);
	self->cell = _tmp0_;
	_tmp1_ = self->game;
	_tmp2_ = sudoku_game_get_board (_tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "earmark-changed", (GCallback) _picker_base_earmark_changed_cb_sudoku_board_earmark_changed, self, 0);
	_tmp4_ = self->game;
	_tmp5_ = sudoku_game_get_board (_tmp4_);
	_tmp6_ = _tmp5_;
	g_signal_connect_object (_tmp6_, "value-changed", (GCallback) _picker_base_value_changed_cb_sudoku_board_value_changed, self, 0);
}

void
picker_base_connect_picker (PickerBase* self,
                            SudokuCell* cell)
{
	PickerBaseClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PICKER_BASE_GET_CLASS (self);
	if (_klass_->connect_picker) {
		_klass_->connect_picker (self, cell);
	}
}

static void
picker_base_real_disconnect_picker (PickerBase* self)
{
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	guint _tmp3_;
	SudokuGame* _tmp4_;
	SudokuBoard* _tmp5_;
	SudokuBoard* _tmp6_;
	guint _tmp7_;
	_g_object_unref0 (self->cell);
	self->cell = NULL;
	_tmp0_ = self->game;
	_tmp1_ = sudoku_game_get_board (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_parse_name ("earmark-changed", TYPE_SUDOKU_BOARD, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _picker_base_earmark_changed_cb_sudoku_board_earmark_changed, self);
	_tmp4_ = self->game;
	_tmp5_ = sudoku_game_get_board (_tmp4_);
	_tmp6_ = _tmp5_;
	g_signal_parse_name ("value-changed", TYPE_SUDOKU_BOARD, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _picker_base_value_changed_cb_sudoku_board_value_changed, self);
}

void
picker_base_disconnect_picker (PickerBase* self)
{
	PickerBaseClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PICKER_BASE_GET_CLASS (self);
	if (_klass_->disconnect_picker) {
		_klass_->disconnect_picker (self);
	}
}

static void
picker_base_class_init (PickerBaseClass * klass,
                        gpointer klass_data)
{
	picker_base_parent_class = g_type_class_peek_parent (klass);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) picker_base_real_dispose;
	((PickerBaseClass *) klass)->value_changed_cb = (void (*) (PickerBase*, gint, gint, gint, gint)) picker_base_real_value_changed_cb;
	((PickerBaseClass *) klass)->earmark_changed_cb = (void (*) (PickerBase*, gint, gint, gint, gboolean)) picker_base_real_earmark_changed_cb;
	((PickerBaseClass *) klass)->connect_picker = (void (*) (PickerBase*, SudokuCell*)) picker_base_real_connect_picker;
	((PickerBaseClass *) klass)->disconnect_picker = (void (*) (PickerBase*)) picker_base_real_disconnect_picker;
	G_OBJECT_CLASS (klass)->finalize = picker_base_finalize;
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "sudoku-picker");
}

static void
picker_base_instance_init (PickerBase * self,
                           gpointer klass)
{
}

static void
picker_base_finalize (GObject * obj)
{
	PickerBase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PICKER_BASE, PickerBase);
	_g_object_unref0 (self->cell);
	_g_object_unref0 (self->game);
	_g_object_unref0 (self->clear_button);
	G_OBJECT_CLASS (picker_base_parent_class)->finalize (obj);
}

static GType
picker_base_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PickerBaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) picker_base_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PickerBase), 0, (GInstanceInitFunc) picker_base_instance_init, NULL };
	GType picker_base_type_id;
	picker_base_type_id = g_type_register_static (gtk_grid_get_type (), "PickerBase", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return picker_base_type_id;
}

GType
picker_base_get_type (void)
{
	static volatile gsize picker_base_type_id__once = 0;
	if (g_once_init_enter (&picker_base_type_id__once)) {
		GType picker_base_type_id;
		picker_base_type_id = picker_base_get_type_once ();
		g_once_init_leave (&picker_base_type_id__once, picker_base_type_id);
	}
	return picker_base_type_id__once;
}

static inline gpointer
value_picker_get_instance_private (ValuePicker* self)
{
	return G_STRUCT_MEMBER_P (self, ValuePicker_private_offset);
}

static void
_gtk_popover_popdown_gtk_button_clicked (GtkButton* _sender,
                                         gpointer self)
{
	gtk_popover_popdown ((GtkPopover*) self);
}

static void
_value_picker_value_picked_cb_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	value_picker_value_picked_cb ((ValuePicker*) self, _sender);
}

ValuePicker*
value_picker_construct (GType object_type,
                        SudokuGame* game,
                        SudokuNumberPicker* number_picker)
{
	ValuePicker * self = NULL;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	SudokuBoard* _tmp2_;
	SudokuBoard* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	SudokuBoard* _tmp6_;
	SudokuBoard* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GtkButton** _tmp10_;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (number_picker != NULL, NULL);
	self = (ValuePicker*) picker_base_construct (object_type, game, number_picker);
	_tmp0_ = ((PickerBase*) self)->clear_button;
	g_signal_connect_object (_tmp0_, "clicked", (GCallback) _gtk_popover_popdown_gtk_button_clicked, (GtkPopover*) number_picker, 0);
	_tmp1_ = ((PickerBase*) self)->clear_button;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp1_, 0, 4, 3, 1);
	_tmp2_ = sudoku_game_get_board (game);
	_tmp3_ = _tmp2_;
	_tmp4_ = sudoku_board_get_block_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = sudoku_game_get_board (game);
	_tmp7_ = _tmp6_;
	_tmp8_ = sudoku_board_get_block_rows (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_new0 (GtkButton*, (_tmp5_ * _tmp9_) + 1);
	self->priv->value_buttons = (_vala_array_free (self->priv->value_buttons, self->priv->value_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->value_buttons = _tmp10_;
	self->priv->value_buttons_length1 = _tmp5_ * _tmp9_;
	self->priv->_value_buttons_size_ = self->priv->value_buttons_length1;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				SudokuBoard* _tmp13_;
				SudokuBoard* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = col;
					col = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = sudoku_game_get_board (game);
				_tmp14_ = _tmp13_;
				_tmp15_ = sudoku_board_get_block_cols (_tmp14_);
				_tmp16_ = _tmp15_;
				if (!(col < _tmp16_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp17_ = FALSE;
						_tmp17_ = TRUE;
						while (TRUE) {
							SudokuBoard* _tmp19_;
							SudokuBoard* _tmp20_;
							gint _tmp21_;
							gint _tmp22_;
							gint n = 0;
							SudokuBoard* _tmp23_;
							SudokuBoard* _tmp24_;
							gint _tmp25_;
							gint _tmp26_;
							SudokuBoard* _tmp27_;
							SudokuBoard* _tmp28_;
							gint _tmp29_;
							gint _tmp30_;
							GtkButton* button = NULL;
							gchar* _tmp31_;
							gchar* _tmp32_;
							GtkButton* _tmp33_;
							GtkButton* _tmp34_;
							GtkButton* _tmp35_;
							GtkLabel* label = NULL;
							GtkButton* _tmp36_;
							GtkWidget* _tmp37_;
							GtkWidget* _tmp38_;
							GtkLabel* _tmp39_;
							GtkLabel* _tmp40_;
							GtkLabel* _tmp41_;
							GtkButton** _tmp42_;
							gint _tmp42__length1;
							GtkButton* _tmp43_;
							GtkButton* _tmp44_;
							GtkButton** _tmp45_;
							gint _tmp45__length1;
							GtkButton* _tmp46_;
							if (!_tmp17_) {
								gint _tmp18_;
								_tmp18_ = row;
								row = _tmp18_ + 1;
							}
							_tmp17_ = FALSE;
							_tmp19_ = sudoku_game_get_board (game);
							_tmp20_ = _tmp19_;
							_tmp21_ = sudoku_board_get_block_rows (_tmp20_);
							_tmp22_ = _tmp21_;
							if (!(row < _tmp22_)) {
								break;
							}
							_tmp23_ = sudoku_game_get_board (game);
							_tmp24_ = _tmp23_;
							_tmp25_ = sudoku_board_get_block_rows (_tmp24_);
							_tmp26_ = _tmp25_;
							_tmp27_ = sudoku_game_get_board (game);
							_tmp28_ = _tmp27_;
							_tmp29_ = sudoku_board_get_block_cols (_tmp28_);
							_tmp30_ = _tmp29_;
							n = (col + (((_tmp26_ - 1) - row) * _tmp30_)) + 1;
							_tmp31_ = g_strdup_printf ("%i", n);
							_tmp32_ = _tmp31_;
							_tmp33_ = (GtkButton*) gtk_button_new_with_label (_tmp32_);
							g_object_ref_sink (_tmp33_);
							_tmp34_ = _tmp33_;
							_g_free0 (_tmp32_);
							button = _tmp34_;
							_tmp35_ = button;
							gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp35_, col, row, 1, 1);
							_tmp36_ = button;
							_tmp37_ = gtk_button_get_child (_tmp36_);
							_tmp38_ = _tmp37_;
							_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp38_) : NULL);
							label = _tmp39_;
							_tmp40_ = label;
							gtk_widget_add_css_class ((GtkWidget*) _tmp40_, "numeric");
							_tmp41_ = label;
							gtk_widget_add_css_class ((GtkWidget*) _tmp41_, "value");
							_tmp42_ = self->priv->value_buttons;
							_tmp42__length1 = self->priv->value_buttons_length1;
							_tmp43_ = button;
							_tmp44_ = _g_object_ref0 (_tmp43_);
							_g_object_unref0 (_tmp42_[n - 1]);
							_tmp42_[n - 1] = _tmp44_;
							_tmp45_ = self->priv->value_buttons;
							_tmp45__length1 = self->priv->value_buttons_length1;
							_tmp46_ = _tmp45_[n - 1];
							g_signal_connect_object (_tmp46_, "clicked", (GCallback) _value_picker_value_picked_cb_gtk_button_clicked, self, 0);
							_g_object_unref0 (label);
							_g_object_unref0 (button);
						}
					}
				}
			}
		}
	}
	return self;
}

ValuePicker*
value_picker_new (SudokuGame* game,
                  SudokuNumberPicker* number_picker)
{
	return value_picker_construct (TYPE_VALUE_PICKER, game, number_picker);
}

static void
value_picker_real_connect_picker (PickerBase* base,
                                  SudokuCell* cell)
{
	ValuePicker * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	GtkButton* _tmp10_;
	gboolean _tmp11_ = FALSE;
	SudokuGame* _tmp12_;
	SudokuBoard* _tmp13_;
	SudokuBoard* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GtkButton* _tmp21_;
	self = (ValuePicker*) base;
	g_return_if_fail (cell != NULL);
	PICKER_BASE_CLASS (value_picker_parent_class)->connect_picker (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PICKER_BASE, PickerBase), cell);
	_tmp1_ = sudoku_cell_get_value (cell);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		_tmp0_ = TRUE;
	} else {
		SudokuGame* _tmp3_;
		SudokuBoard* _tmp4_;
		SudokuBoard* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp3_ = ((PickerBase*) self)->game;
		_tmp4_ = sudoku_game_get_board (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = sudoku_cell_get_row (cell);
		_tmp7_ = _tmp6_;
		_tmp8_ = sudoku_cell_get_col (cell);
		_tmp9_ = _tmp8_;
		_tmp0_ = sudoku_board_has_earmarks (_tmp5_, _tmp7_, _tmp9_);
	}
	_tmp10_ = ((PickerBase*) self)->clear_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp10_, _tmp0_);
	_tmp12_ = ((PickerBase*) self)->game;
	_tmp13_ = sudoku_game_get_board (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = sudoku_cell_get_row (cell);
	_tmp16_ = _tmp15_;
	_tmp17_ = sudoku_cell_get_col (cell);
	_tmp18_ = _tmp17_;
	if (sudoku_board_has_earmarks (_tmp14_, _tmp16_, _tmp18_)) {
		_tmp11_ = TRUE;
	} else {
		gint _tmp19_;
		gint _tmp20_;
		_tmp19_ = sudoku_cell_get_value (cell);
		_tmp20_ = _tmp19_;
		_tmp11_ = _tmp20_ > 0;
	}
	_tmp21_ = ((PickerBase*) self)->clear_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp21_, _tmp11_);
}

static void
value_picker_value_picked_cb (ValuePicker* self,
                              GtkButton* button)
{
	SudokuCell* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	SudokuNumberPicker* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = ((PickerBase*) self)->cell;
	_tmp1_ = gtk_button_get_label (button);
	_tmp2_ = _tmp1_;
	sudoku_cell_set_value (_tmp0_, atoi (_tmp2_));
	_tmp3_ = ((PickerBase*) self)->number_picker;
	gtk_popover_popdown ((GtkPopover*) _tmp3_);
}

static void
value_picker_real_value_changed_cb (PickerBase* base,
                                    gint row,
                                    gint col,
                                    gint old_val,
                                    gint new_val)
{
	ValuePicker * self;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	SudokuNumberPicker* _tmp2_;
	self = (ValuePicker*) base;
	_tmp0_ = ((PickerBase*) self)->clear_button;
	_tmp1_ = ((PickerBase*) self)->clear_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, new_val != 0);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, new_val != 0);
	_tmp2_ = ((PickerBase*) self)->number_picker;
	gtk_popover_present ((GtkPopover*) _tmp2_);
}

static void
value_picker_real_earmark_changed_cb (PickerBase* base,
                                      gint row,
                                      gint col,
                                      gint num,
                                      gboolean enabled)
{
	ValuePicker * self;
	GtkButton* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuBoard* _tmp2_;
	SudokuBoard* _tmp3_;
	SudokuCell* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	SudokuCell* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_ = FALSE;
	SudokuCell* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GtkButton* _tmp23_;
	SudokuNumberPicker* _tmp24_;
	self = (ValuePicker*) base;
	_tmp0_ = ((PickerBase*) self)->clear_button;
	_tmp1_ = ((PickerBase*) self)->game;
	_tmp2_ = sudoku_game_get_board (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = ((PickerBase*) self)->cell;
	_tmp5_ = sudoku_cell_get_row (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = ((PickerBase*) self)->cell;
	_tmp8_ = sudoku_cell_get_col (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, sudoku_board_has_earmarks (_tmp3_, _tmp6_, _tmp9_));
	_tmp11_ = ((PickerBase*) self)->cell;
	_tmp12_ = sudoku_cell_get_value (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ > 0) {
		_tmp10_ = TRUE;
	} else {
		SudokuGame* _tmp14_;
		SudokuBoard* _tmp15_;
		SudokuBoard* _tmp16_;
		SudokuCell* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		SudokuCell* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp14_ = ((PickerBase*) self)->game;
		_tmp15_ = sudoku_game_get_board (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = ((PickerBase*) self)->cell;
		_tmp18_ = sudoku_cell_get_row (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = ((PickerBase*) self)->cell;
		_tmp21_ = sudoku_cell_get_col (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp10_ = sudoku_board_has_earmarks (_tmp16_, _tmp19_, _tmp22_);
	}
	_tmp23_ = ((PickerBase*) self)->clear_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp23_, _tmp10_);
	_tmp24_ = ((PickerBase*) self)->number_picker;
	gtk_popover_present ((GtkPopover*) _tmp24_);
}

static void
value_picker_real_dispose (GObject* base)
{
	ValuePicker * self;
	GtkButton** _tmp0_;
	gint _tmp0__length1;
	self = (ValuePicker*) base;
	G_OBJECT_CLASS (value_picker_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PICKER_BASE, PickerBase));
	_tmp0_ = self->priv->value_buttons;
	_tmp0__length1 = self->priv->value_buttons_length1;
	{
		GtkButton** button_collection = NULL;
		gint button_collection_length1 = 0;
		gint _button_collection_size_ = 0;
		gint button_it = 0;
		button_collection = _tmp0_;
		button_collection_length1 = _tmp0__length1;
		for (button_it = 0; button_it < button_collection_length1; button_it = button_it + 1) {
			GtkButton* _tmp1_;
			GtkButton* button = NULL;
			_tmp1_ = _g_object_ref0 (button_collection[button_it]);
			button = _tmp1_;
			{
				GtkButton* _tmp2_;
				_tmp2_ = button;
				gtk_widget_unparent ((GtkWidget*) _tmp2_);
				_g_object_unref0 (button);
			}
		}
	}
}

static void
value_picker_class_init (ValuePickerClass * klass,
                         gpointer klass_data)
{
	value_picker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValuePicker_private_offset);
	((PickerBaseClass *) klass)->connect_picker = (void (*) (PickerBase*, SudokuCell*)) value_picker_real_connect_picker;
	((PickerBaseClass *) klass)->value_changed_cb = (void (*) (PickerBase*, gint, gint, gint, gint)) value_picker_real_value_changed_cb;
	((PickerBaseClass *) klass)->earmark_changed_cb = (void (*) (PickerBase*, gint, gint, gint, gboolean)) value_picker_real_earmark_changed_cb;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) value_picker_real_dispose;
	G_OBJECT_CLASS (klass)->finalize = value_picker_finalize;
}

static void
value_picker_instance_init (ValuePicker * self,
                            gpointer klass)
{
	self->priv = value_picker_get_instance_private (self);
}

static void
value_picker_finalize (GObject * obj)
{
	ValuePicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VALUE_PICKER, ValuePicker);
	self->priv->value_buttons = (_vala_array_free (self->priv->value_buttons, self->priv->value_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (value_picker_parent_class)->finalize (obj);
}

static GType
value_picker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValuePickerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) value_picker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValuePicker), 0, (GInstanceInitFunc) value_picker_instance_init, NULL };
	GType value_picker_type_id;
	value_picker_type_id = g_type_register_static (TYPE_PICKER_BASE, "ValuePicker", &g_define_type_info, 0);
	ValuePicker_private_offset = g_type_add_instance_private (value_picker_type_id, sizeof (ValuePickerPrivate));
	return value_picker_type_id;
}

GType
value_picker_get_type (void)
{
	static volatile gsize value_picker_type_id__once = 0;
	if (g_once_init_enter (&value_picker_type_id__once)) {
		GType value_picker_type_id;
		value_picker_type_id = value_picker_get_type_once ();
		g_once_init_leave (&value_picker_type_id__once, value_picker_type_id);
	}
	return value_picker_type_id__once;
}

static inline gpointer
earmark_picker_get_instance_private (EarmarkPicker* self)
{
	return G_STRUCT_MEMBER_P (self, EarmarkPicker_private_offset);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		EarmarkPicker* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->number_picker);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_earmark_picker_lock_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	earmark_picker_lock_button_toggled_cb ((EarmarkPicker*) self);
}

static void
__lambda17_ (Block4Data* _data4_)
{
	EarmarkPicker* self;
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data4_->self;
	_tmp0_ = self->priv->lock_button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gtk_popover_popdown ((GtkPopover*) _data4_->number_picker);
	}
}

static void
___lambda17__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda17_ (self);
}

EarmarkPicker*
earmark_picker_construct (GType object_type,
                          SudokuGame* game,
                          SudokuNumberPicker* number_picker)
{
	EarmarkPicker * self = NULL;
	Block4Data* _data4_;
	SudokuNumberPicker* _tmp0_;
	GtkToggleButton* _tmp1_;
	GtkToggleButton* _tmp2_;
	GtkToggleButton* _tmp3_;
	GtkToggleButton* _tmp4_;
	GtkToggleButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	SudokuBoard* _tmp8_;
	SudokuBoard* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	SudokuBoard* _tmp12_;
	SudokuBoard* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GtkToggleButton** _tmp16_;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (number_picker != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (number_picker);
	_g_object_unref0 (_data4_->number_picker);
	_data4_->number_picker = _tmp0_;
	self = (EarmarkPicker*) picker_base_construct (object_type, game, _data4_->number_picker);
	_data4_->self = g_object_ref (self);
	_tmp1_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->lock_button);
	self->priv->lock_button = _tmp1_;
	_tmp2_ = self->priv->lock_button;
	gtk_button_set_icon_name ((GtkButton*) _tmp2_, "lock-symbolic");
	_tmp3_ = self->priv->lock_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _ ("Lock"));
	_tmp4_ = self->priv->lock_button;
	g_signal_connect_object (_tmp4_, "toggled", (GCallback) _earmark_picker_lock_button_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp5_ = self->priv->lock_button;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp5_, 2, 4, 1, 1);
	_tmp6_ = ((PickerBase*) self)->clear_button;
	g_signal_connect_data (_tmp6_, "clicked", (GCallback) ___lambda17__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp7_ = ((PickerBase*) self)->clear_button;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp7_, 0, 4, 2, 1);
	_tmp8_ = sudoku_game_get_board (game);
	_tmp9_ = _tmp8_;
	_tmp10_ = sudoku_board_get_block_cols (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = sudoku_game_get_board (game);
	_tmp13_ = _tmp12_;
	_tmp14_ = sudoku_board_get_block_rows (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_new0 (GtkToggleButton*, (_tmp11_ * _tmp15_) + 1);
	self->priv->earmark_buttons = (_vala_array_free (self->priv->earmark_buttons, self->priv->earmark_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->earmark_buttons = _tmp16_;
	self->priv->earmark_buttons_length1 = _tmp11_ * _tmp15_;
	self->priv->_earmark_buttons_size_ = self->priv->earmark_buttons_length1;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				SudokuBoard* _tmp19_;
				SudokuBoard* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = col;
					col = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = sudoku_game_get_board (game);
				_tmp20_ = _tmp19_;
				_tmp21_ = sudoku_board_get_block_cols (_tmp20_);
				_tmp22_ = _tmp21_;
				if (!(col < _tmp22_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							SudokuBoard* _tmp25_;
							SudokuBoard* _tmp26_;
							gint _tmp27_;
							gint _tmp28_;
							gint n = 0;
							SudokuBoard* _tmp29_;
							SudokuBoard* _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							SudokuBoard* _tmp33_;
							SudokuBoard* _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							GtkToggleButton* button = NULL;
							gchar* _tmp37_;
							gchar* _tmp38_;
							GtkToggleButton* _tmp39_;
							GtkToggleButton* _tmp40_;
							GtkToggleButton* _tmp41_;
							GtkLabel* label = NULL;
							GtkToggleButton* _tmp42_;
							GtkWidget* _tmp43_;
							GtkWidget* _tmp44_;
							GtkLabel* _tmp45_;
							GtkLabel* _tmp46_;
							GtkLabel* _tmp47_;
							GtkToggleButton* _tmp48_;
							GtkLabel* _tmp49_;
							GtkToggleButton** _tmp50_;
							gint _tmp50__length1;
							GtkToggleButton* _tmp51_;
							GtkToggleButton* _tmp52_;
							if (!_tmp23_) {
								gint _tmp24_;
								_tmp24_ = row;
								row = _tmp24_ + 1;
							}
							_tmp23_ = FALSE;
							_tmp25_ = sudoku_game_get_board (game);
							_tmp26_ = _tmp25_;
							_tmp27_ = sudoku_board_get_block_rows (_tmp26_);
							_tmp28_ = _tmp27_;
							if (!(row < _tmp28_)) {
								break;
							}
							_tmp29_ = sudoku_game_get_board (game);
							_tmp30_ = _tmp29_;
							_tmp31_ = sudoku_board_get_block_rows (_tmp30_);
							_tmp32_ = _tmp31_;
							_tmp33_ = sudoku_game_get_board (game);
							_tmp34_ = _tmp33_;
							_tmp35_ = sudoku_board_get_block_cols (_tmp34_);
							_tmp36_ = _tmp35_;
							n = (col + (((_tmp32_ - 1) - row) * _tmp36_)) + 1;
							_tmp37_ = g_strdup_printf ("%i", n);
							_tmp38_ = _tmp37_;
							_tmp39_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_tmp38_);
							g_object_ref_sink (_tmp39_);
							_tmp40_ = _tmp39_;
							_g_free0 (_tmp38_);
							button = _tmp40_;
							_tmp41_ = button;
							gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp41_, col, row, 1, 1);
							_tmp42_ = button;
							_tmp43_ = gtk_button_get_child ((GtkButton*) _tmp42_);
							_tmp44_ = _tmp43_;
							_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp44_) : NULL);
							label = _tmp45_;
							_tmp46_ = label;
							gtk_widget_add_css_class ((GtkWidget*) _tmp46_, "numeric");
							_tmp47_ = label;
							gtk_widget_add_css_class ((GtkWidget*) _tmp47_, "earmark");
							_tmp48_ = button;
							_tmp49_ = label;
							gtk_button_set_child ((GtkButton*) _tmp48_, (GtkWidget*) _tmp49_);
							_tmp50_ = self->priv->earmark_buttons;
							_tmp50__length1 = self->priv->earmark_buttons_length1;
							_tmp51_ = button;
							_tmp52_ = _g_object_ref0 (_tmp51_);
							_g_object_unref0 (_tmp50_[n - 1]);
							_tmp50_[n - 1] = _tmp52_;
							_g_object_unref0 (label);
							_g_object_unref0 (button);
						}
					}
				}
			}
		}
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return self;
}

EarmarkPicker*
earmark_picker_new (SudokuGame* game,
                    SudokuNumberPicker* number_picker)
{
	return earmark_picker_construct (TYPE_EARMARK_PICKER, game, number_picker);
}

static void
_earmark_picker_earmark_picked_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                             gpointer self)
{
	earmark_picker_earmark_picked_cb ((EarmarkPicker*) self, _sender);
}

static void
earmark_picker_real_connect_picker (PickerBase* base,
                                    SudokuCell* cell)
{
	EarmarkPicker * self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkButton* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_;
	gint _tmp9_;
	GtkButton* _tmp17_;
	GtkToggleButton** _tmp18_;
	gint _tmp18__length1;
	self = (EarmarkPicker*) base;
	g_return_if_fail (cell != NULL);
	PICKER_BASE_CLASS (earmark_picker_parent_class)->connect_picker (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PICKER_BASE, PickerBase), cell);
	_tmp0_ = sudoku_cell_get_row (cell);
	_tmp1_ = _tmp0_;
	_tmp2_ = sudoku_cell_get_col (cell);
	_tmp3_ = _tmp2_;
	earmark_picker_set_buttons_active (self, _tmp1_, _tmp3_);
	_tmp4_ = sudoku_cell_get_value (cell);
	_tmp5_ = _tmp4_;
	earmark_picker_set_buttons_sensitive (self, _tmp5_ == 0);
	_tmp6_ = ((PickerBase*) self)->clear_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
	_tmp8_ = sudoku_cell_get_value (cell);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != 0) {
		_tmp7_ = TRUE;
	} else {
		SudokuGame* _tmp10_;
		SudokuBoard* _tmp11_;
		SudokuBoard* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp10_ = ((PickerBase*) self)->game;
		_tmp11_ = sudoku_game_get_board (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = sudoku_cell_get_row (cell);
		_tmp14_ = _tmp13_;
		_tmp15_ = sudoku_cell_get_col (cell);
		_tmp16_ = _tmp15_;
		_tmp7_ = sudoku_board_has_earmarks (_tmp12_, _tmp14_, _tmp16_);
	}
	_tmp17_ = ((PickerBase*) self)->clear_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, _tmp7_);
	_tmp18_ = self->priv->earmark_buttons;
	_tmp18__length1 = self->priv->earmark_buttons_length1;
	{
		GtkToggleButton** button_collection = NULL;
		gint button_collection_length1 = 0;
		gint _button_collection_size_ = 0;
		gint button_it = 0;
		button_collection = _tmp18_;
		button_collection_length1 = _tmp18__length1;
		for (button_it = 0; button_it < button_collection_length1; button_it = button_it + 1) {
			GtkToggleButton* _tmp19_;
			GtkToggleButton* button = NULL;
			_tmp19_ = _g_object_ref0 (button_collection[button_it]);
			button = _tmp19_;
			{
				GtkToggleButton* _tmp20_;
				_tmp20_ = button;
				g_signal_connect_object (_tmp20_, "toggled", (GCallback) _earmark_picker_earmark_picked_cb_gtk_toggle_button_toggled, self, 0);
				_g_object_unref0 (button);
			}
		}
	}
}

static void
earmark_picker_real_disconnect_picker (PickerBase* base)
{
	EarmarkPicker * self;
	GtkToggleButton** _tmp0_;
	gint _tmp0__length1;
	self = (EarmarkPicker*) base;
	PICKER_BASE_CLASS (earmark_picker_parent_class)->disconnect_picker (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PICKER_BASE, PickerBase));
	_tmp0_ = self->priv->earmark_buttons;
	_tmp0__length1 = self->priv->earmark_buttons_length1;
	{
		GtkToggleButton** button_collection = NULL;
		gint button_collection_length1 = 0;
		gint _button_collection_size_ = 0;
		gint button_it = 0;
		button_collection = _tmp0_;
		button_collection_length1 = _tmp0__length1;
		for (button_it = 0; button_it < button_collection_length1; button_it = button_it + 1) {
			GtkToggleButton* _tmp1_;
			GtkToggleButton* button = NULL;
			_tmp1_ = _g_object_ref0 (button_collection[button_it]);
			button = _tmp1_;
			{
				GtkToggleButton* _tmp2_;
				guint _tmp3_;
				_tmp2_ = button;
				g_signal_parse_name ("toggled", gtk_toggle_button_get_type (), &_tmp3_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _earmark_picker_earmark_picked_cb_gtk_toggle_button_toggled, self);
				_g_object_unref0 (button);
			}
		}
	}
}

static void
earmark_picker_earmark_picked_cb (EarmarkPicker* self,
                                  GtkToggleButton* button)
{
	gint number_picked = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_button_get_label ((GtkButton*) button);
	_tmp1_ = _tmp0_;
	number_picked = atoi (_tmp1_);
	if (gtk_toggle_button_get_active (button)) {
		SudokuGame* _tmp2_;
		SudokuBoard* _tmp3_;
		SudokuBoard* _tmp4_;
		SudokuCell* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		SudokuCell* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp2_ = ((PickerBase*) self)->game;
		_tmp3_ = sudoku_game_get_board (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = ((PickerBase*) self)->cell;
		_tmp6_ = sudoku_cell_get_row (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = ((PickerBase*) self)->cell;
		_tmp9_ = sudoku_cell_get_col (_tmp8_);
		_tmp10_ = _tmp9_;
		if (!sudoku_board_is_earmark_enabled (_tmp4_, _tmp7_, _tmp10_, number_picked)) {
			SudokuGame* _tmp11_;
			SudokuCell* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			SudokuCell* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			GtkToggleButton* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_tmp11_ = ((PickerBase*) self)->game;
			_tmp12_ = ((PickerBase*) self)->cell;
			_tmp13_ = sudoku_cell_get_row (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = ((PickerBase*) self)->cell;
			_tmp16_ = sudoku_cell_get_col (_tmp15_);
			_tmp17_ = _tmp16_;
			sudoku_game_enable_earmark (_tmp11_, _tmp14_, _tmp17_, number_picked);
			_tmp18_ = self->priv->lock_button;
			_tmp19_ = gtk_toggle_button_get_active (_tmp18_);
			_tmp20_ = _tmp19_;
			if (!_tmp20_) {
				SudokuNumberPicker* _tmp21_;
				_tmp21_ = ((PickerBase*) self)->number_picker;
				gtk_popover_popdown ((GtkPopover*) _tmp21_);
			}
		}
	} else {
		SudokuGame* _tmp22_;
		SudokuBoard* _tmp23_;
		SudokuBoard* _tmp24_;
		SudokuCell* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		SudokuCell* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp22_ = ((PickerBase*) self)->game;
		_tmp23_ = sudoku_game_get_board (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = ((PickerBase*) self)->cell;
		_tmp26_ = sudoku_cell_get_row (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = ((PickerBase*) self)->cell;
		_tmp29_ = sudoku_cell_get_col (_tmp28_);
		_tmp30_ = _tmp29_;
		if (sudoku_board_is_earmark_enabled (_tmp24_, _tmp27_, _tmp30_, number_picked)) {
			SudokuGame* _tmp31_;
			SudokuCell* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			SudokuCell* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			GtkToggleButton* _tmp38_;
			gboolean _tmp39_;
			gboolean _tmp40_;
			_tmp31_ = ((PickerBase*) self)->game;
			_tmp32_ = ((PickerBase*) self)->cell;
			_tmp33_ = sudoku_cell_get_row (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = ((PickerBase*) self)->cell;
			_tmp36_ = sudoku_cell_get_col (_tmp35_);
			_tmp37_ = _tmp36_;
			sudoku_game_disable_earmark (_tmp31_, _tmp34_, _tmp37_, number_picked);
			_tmp38_ = self->priv->lock_button;
			_tmp39_ = gtk_toggle_button_get_active (_tmp38_);
			_tmp40_ = _tmp39_;
			if (!_tmp40_) {
				SudokuNumberPicker* _tmp41_;
				_tmp41_ = ((PickerBase*) self)->number_picker;
				gtk_popover_popdown ((GtkPopover*) _tmp41_);
			}
		}
	}
}

static void
earmark_picker_lock_button_toggled_cb (EarmarkPicker* self)
{
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->lock_button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkToggleButton* _tmp3_;
		_tmp3_ = self->priv->lock_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _ ("Unlock"));
	} else {
		GtkToggleButton* _tmp4_;
		SudokuNumberPicker* _tmp5_;
		_tmp4_ = self->priv->lock_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _ ("Lock"));
		_tmp5_ = ((PickerBase*) self)->number_picker;
		gtk_popover_popdown ((GtkPopover*) _tmp5_);
	}
}

static void
earmark_picker_real_value_changed_cb (PickerBase* base,
                                      gint row,
                                      gint col,
                                      gint old_val,
                                      gint new_val)
{
	EarmarkPicker * self;
	SudokuCell* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkButton* _tmp3_;
	SudokuCell* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	self = (EarmarkPicker*) base;
	_tmp0_ = ((PickerBase*) self)->cell;
	_tmp1_ = sudoku_cell_get_value (_tmp0_);
	_tmp2_ = _tmp1_;
	earmark_picker_set_buttons_sensitive (self, _tmp2_ == 0);
	_tmp3_ = ((PickerBase*) self)->clear_button;
	_tmp4_ = ((PickerBase*) self)->cell;
	_tmp5_ = sudoku_cell_get_value (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp6_ != 0);
}

static void
earmark_picker_real_earmark_changed_cb (PickerBase* base,
                                        gint row,
                                        gint col,
                                        gint num,
                                        gboolean enabled)
{
	EarmarkPicker * self;
	GtkButton* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuBoard* _tmp2_;
	SudokuBoard* _tmp3_;
	SudokuCell* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	SudokuCell* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GtkToggleButton** _tmp10_;
	gint _tmp10__length1;
	GtkToggleButton* _tmp11_;
	self = (EarmarkPicker*) base;
	_tmp0_ = ((PickerBase*) self)->clear_button;
	_tmp1_ = ((PickerBase*) self)->game;
	_tmp2_ = sudoku_game_get_board (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = ((PickerBase*) self)->cell;
	_tmp5_ = sudoku_cell_get_row (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = ((PickerBase*) self)->cell;
	_tmp8_ = sudoku_cell_get_col (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, sudoku_board_has_earmarks (_tmp3_, _tmp6_, _tmp9_));
	_tmp10_ = self->priv->earmark_buttons;
	_tmp10__length1 = self->priv->earmark_buttons_length1;
	_tmp11_ = _tmp10_[num - 1];
	gtk_toggle_button_set_active (_tmp11_, enabled);
}

static void
earmark_picker_set_buttons_sensitive (EarmarkPicker* self,
                                      gboolean enabled)
{
	GtkToggleButton** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmark_buttons;
	_tmp0__length1 = self->priv->earmark_buttons_length1;
	{
		GtkToggleButton** button_collection = NULL;
		gint button_collection_length1 = 0;
		gint _button_collection_size_ = 0;
		gint button_it = 0;
		button_collection = _tmp0_;
		button_collection_length1 = _tmp0__length1;
		for (button_it = 0; button_it < button_collection_length1; button_it = button_it + 1) {
			GtkToggleButton* _tmp1_;
			GtkToggleButton* button = NULL;
			_tmp1_ = _g_object_ref0 (button_collection[button_it]);
			button = _tmp1_;
			{
				GtkToggleButton* _tmp2_;
				_tmp2_ = button;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, enabled);
				_g_object_unref0 (button);
			}
		}
	}
}

static void
earmark_picker_set_buttons_active (EarmarkPicker* self,
                                   gint row,
                                   gint col)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp2_;
				SudokuBoard* _tmp3_;
				SudokuBoard* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				GtkToggleButton** _tmp7_;
				gint _tmp7__length1;
				GtkToggleButton* _tmp8_;
				SudokuGame* _tmp9_;
				SudokuBoard* _tmp10_;
				SudokuBoard* _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ((PickerBase*) self)->game;
				_tmp3_ = sudoku_game_get_board (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = sudoku_board_get_max_val (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(i <= _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->earmark_buttons;
				_tmp7__length1 = self->priv->earmark_buttons_length1;
				_tmp8_ = _tmp7_[i - 1];
				_tmp9_ = ((PickerBase*) self)->game;
				_tmp10_ = sudoku_game_get_board (_tmp9_);
				_tmp11_ = _tmp10_;
				gtk_toggle_button_set_active (_tmp8_, sudoku_board_is_earmark_enabled (_tmp11_, row, col, i));
			}
		}
	}
}

static void
earmark_picker_real_dispose (GObject* base)
{
	EarmarkPicker * self;
	GtkToggleButton* _tmp0_;
	GtkToggleButton** _tmp1_;
	gint _tmp1__length1;
	self = (EarmarkPicker*) base;
	G_OBJECT_CLASS (earmark_picker_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PICKER_BASE, PickerBase));
	_tmp0_ = self->priv->lock_button;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->earmark_buttons;
	_tmp1__length1 = self->priv->earmark_buttons_length1;
	{
		GtkToggleButton** button_collection = NULL;
		gint button_collection_length1 = 0;
		gint _button_collection_size_ = 0;
		gint button_it = 0;
		button_collection = _tmp1_;
		button_collection_length1 = _tmp1__length1;
		for (button_it = 0; button_it < button_collection_length1; button_it = button_it + 1) {
			GtkToggleButton* _tmp2_;
			GtkToggleButton* button = NULL;
			_tmp2_ = _g_object_ref0 (button_collection[button_it]);
			button = _tmp2_;
			{
				GtkToggleButton* _tmp3_;
				_tmp3_ = button;
				gtk_widget_unparent ((GtkWidget*) _tmp3_);
				_g_object_unref0 (button);
			}
		}
	}
}

static void
earmark_picker_class_init (EarmarkPickerClass * klass,
                           gpointer klass_data)
{
	earmark_picker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EarmarkPicker_private_offset);
	((PickerBaseClass *) klass)->connect_picker = (void (*) (PickerBase*, SudokuCell*)) earmark_picker_real_connect_picker;
	((PickerBaseClass *) klass)->disconnect_picker = (void (*) (PickerBase*)) earmark_picker_real_disconnect_picker;
	((PickerBaseClass *) klass)->value_changed_cb = (void (*) (PickerBase*, gint, gint, gint, gint)) earmark_picker_real_value_changed_cb;
	((PickerBaseClass *) klass)->earmark_changed_cb = (void (*) (PickerBase*, gint, gint, gint, gboolean)) earmark_picker_real_earmark_changed_cb;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) earmark_picker_real_dispose;
	G_OBJECT_CLASS (klass)->finalize = earmark_picker_finalize;
}

static void
earmark_picker_instance_init (EarmarkPicker * self,
                              gpointer klass)
{
	self->priv = earmark_picker_get_instance_private (self);
}

static void
earmark_picker_finalize (GObject * obj)
{
	EarmarkPicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EARMARK_PICKER, EarmarkPicker);
	self->priv->earmark_buttons = (_vala_array_free (self->priv->earmark_buttons, self->priv->earmark_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->lock_button);
	G_OBJECT_CLASS (earmark_picker_parent_class)->finalize (obj);
}

static GType
earmark_picker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EarmarkPickerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) earmark_picker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EarmarkPicker), 0, (GInstanceInitFunc) earmark_picker_instance_init, NULL };
	GType earmark_picker_type_id;
	earmark_picker_type_id = g_type_register_static (TYPE_PICKER_BASE, "EarmarkPicker", &g_define_type_info, 0);
	EarmarkPicker_private_offset = g_type_add_instance_private (earmark_picker_type_id, sizeof (EarmarkPickerPrivate));
	return earmark_picker_type_id;
}

GType
earmark_picker_get_type (void)
{
	static volatile gsize earmark_picker_type_id__once = 0;
	if (g_once_init_enter (&earmark_picker_type_id__once)) {
		GType earmark_picker_type_id;
		earmark_picker_type_id = earmark_picker_get_type_once ();
		g_once_init_leave (&earmark_picker_type_id__once, earmark_picker_type_id);
	}
	return earmark_picker_type_id__once;
}

static GType
number_picker_state_get_type_once (void)
{
	static const GEnumValue values[] = {{NUMBER_PICKER_STATE_NONE, "NUMBER_PICKER_STATE_NONE", "none"}, {NUMBER_PICKER_STATE_VALUE_PICKER, "NUMBER_PICKER_STATE_VALUE_PICKER", "value-picker"}, {NUMBER_PICKER_STATE_EARMARK_PICKER, "NUMBER_PICKER_STATE_EARMARK_PICKER", "earmark-picker"}, {0, NULL, NULL}};
	GType number_picker_state_type_id;
	number_picker_state_type_id = g_enum_register_static ("NumberPickerState", values);
	return number_picker_state_type_id;
}

GType
number_picker_state_get_type (void)
{
	static volatile gsize number_picker_state_type_id__once = 0;
	if (g_once_init_enter (&number_picker_state_type_id__once)) {
		GType number_picker_state_type_id;
		number_picker_state_type_id = number_picker_state_get_type_once ();
		g_once_init_leave (&number_picker_state_type_id__once, number_picker_state_type_id);
	}
	return number_picker_state_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

