static const uint32_t iso88597_to_ucs4[96] = {
  [0xa0 - 0xA0] = 0x00A0,
  [0xa1 - 0xA0] = 0x2018,
  [0xa2 - 0xA0] = 0x2019,
  [0xa3 - 0xA0] = 0x00A3,
  [0xa4 - 0xA0] = 0x20AC,
  [0xa5 - 0xA0] = 0x20AF,
  [0xa6 - 0xA0] = 0x00A6,
  [0xa7 - 0xA0] = 0x00A7,
  [0xa8 - 0xA0] = 0x00A8,
  [0xa9 - 0xA0] = 0x00A9,
  [0xaa - 0xA0] = 0x037A,
  [0xab - 0xA0] = 0x00AB,
  [0xac - 0xA0] = 0x00AC,
  [0xad - 0xA0] = 0x00AD,
  [0xaf - 0xA0] = 0x2015,
  [0xb0 - 0xA0] = 0x00B0,
  [0xb1 - 0xA0] = 0x00B1,
  [0xb2 - 0xA0] = 0x00B2,
  [0xb3 - 0xA0] = 0x00B3,
  [0xb4 - 0xA0] = 0x0384,
  [0xb5 - 0xA0] = 0x0385,
  [0xb6 - 0xA0] = 0x0386,
  [0xb7 - 0xA0] = 0x00B7,
  [0xb8 - 0xA0] = 0x0388,
  [0xb9 - 0xA0] = 0x0389,
  [0xba - 0xA0] = 0x038A,
  [0xbb - 0xA0] = 0x00BB,
  [0xbc - 0xA0] = 0x038C,
  [0xbd - 0xA0] = 0x00BD,
  [0xbe - 0xA0] = 0x038E,
  [0xbf - 0xA0] = 0x038F,
  [0xc0 - 0xA0] = 0x0390,
  [0xc1 - 0xA0] = 0x0391,
  [0xc2 - 0xA0] = 0x0392,
  [0xc3 - 0xA0] = 0x0393,
  [0xc4 - 0xA0] = 0x0394,
  [0xc5 - 0xA0] = 0x0395,
  [0xc6 - 0xA0] = 0x0396,
  [0xc7 - 0xA0] = 0x0397,
  [0xc8 - 0xA0] = 0x0398,
  [0xc9 - 0xA0] = 0x0399,
  [0xca - 0xA0] = 0x039A,
  [0xcb - 0xA0] = 0x039B,
  [0xcc - 0xA0] = 0x039C,
  [0xcd - 0xA0] = 0x039D,
  [0xce - 0xA0] = 0x039E,
  [0xcf - 0xA0] = 0x039F,
  [0xd0 - 0xA0] = 0x03A0,
  [0xd1 - 0xA0] = 0x03A1,
  [0xd3 - 0xA0] = 0x03A3,
  [0xd4 - 0xA0] = 0x03A4,
  [0xd5 - 0xA0] = 0x03A5,
  [0xd6 - 0xA0] = 0x03A6,
  [0xd7 - 0xA0] = 0x03A7,
  [0xd8 - 0xA0] = 0x03A8,
  [0xd9 - 0xA0] = 0x03A9,
  [0xda - 0xA0] = 0x03AA,
  [0xdb - 0xA0] = 0x03AB,
  [0xdc - 0xA0] = 0x03AC,
  [0xdd - 0xA0] = 0x03AD,
  [0xde - 0xA0] = 0x03AE,
  [0xdf - 0xA0] = 0x03AF,
  [0xe0 - 0xA0] = 0x03B0,
  [0xe1 - 0xA0] = 0x03B1,
  [0xe2 - 0xA0] = 0x03B2,
  [0xe3 - 0xA0] = 0x03B3,
  [0xe4 - 0xA0] = 0x03B4,
  [0xe5 - 0xA0] = 0x03B5,
  [0xe6 - 0xA0] = 0x03B6,
  [0xe7 - 0xA0] = 0x03B7,
  [0xe8 - 0xA0] = 0x03B8,
  [0xe9 - 0xA0] = 0x03B9,
  [0xea - 0xA0] = 0x03BA,
  [0xeb - 0xA0] = 0x03BB,
  [0xec - 0xA0] = 0x03BC,
  [0xed - 0xA0] = 0x03BD,
  [0xee - 0xA0] = 0x03BE,
  [0xef - 0xA0] = 0x03BF,
  [0xf0 - 0xA0] = 0x03C0,
  [0xf1 - 0xA0] = 0x03C1,
  [0xf2 - 0xA0] = 0x03C2,
  [0xf3 - 0xA0] = 0x03C3,
  [0xf4 - 0xA0] = 0x03C4,
  [0xf5 - 0xA0] = 0x03C5,
  [0xf6 - 0xA0] = 0x03C6,
  [0xf7 - 0xA0] = 0x03C7,
  [0xf8 - 0xA0] = 0x03C8,
  [0xf9 - 0xA0] = 0x03C9,
  [0xfa - 0xA0] = 0x03CA,
  [0xfb - 0xA0] = 0x03CB,
  [0xfc - 0xA0] = 0x03CC,
  [0xfd - 0xA0] = 0x03CD,
  [0xfe - 0xA0] = 0x03CE,
};
static const struct gap from_idx[] = {
  { .start = 0x00a0, .end = 0x00bd, .idx =     0 },
  { .start = 0x037a, .end = 0x037a, .idx =  -700 },
  { .start = 0x0384, .end = 0x03ce, .idx =  -709 },
  { .start = 0x2015, .end = 0x2019, .idx = -7947 },
  { .start = 0x20ac, .end = 0x20af, .idx = -8093 },
  { .start = 0xffff, .end = 0xffff, .idx =     0 }
};
static const char iso88597_from_ucs4[] = {

  '\xa0', '\x00', '\x00', '\xa3', '\x00', '\x00', '\xa6', '\xa7',
  '\xa8', '\xa9', '\x00', '\xab', '\xac', '\xad', '\x00', '\x00',
  '\xb0', '\xb1', '\xb2', '\xb3', '\x00', '\x00', '\x00', '\xb7',
  '\x00', '\x00', '\x00', '\xbb', '\x00', '\xbd', '\xaa', '\xb4',
  '\xb5', '\xb6', '\x00', '\xb8', '\xb9', '\xba', '\x00', '\xbc',
  '\x00', '\xbe', '\xbf', '\xc0', '\xc1', '\xc2', '\xc3', '\xc4',
  '\xc5', '\xc6', '\xc7', '\xc8', '\xc9', '\xca', '\xcb', '\xcc',
  '\xcd', '\xce', '\xcf', '\xd0', '\xd1', '\x00', '\xd3', '\xd4',
  '\xd5', '\xd6', '\xd7', '\xd8', '\xd9', '\xda', '\xdb', '\xdc',
  '\xdd', '\xde', '\xdf', '\xe0', '\xe1', '\xe2', '\xe3', '\xe4',
  '\xe5', '\xe6', '\xe7', '\xe8', '\xe9', '\xea', '\xeb', '\xec',
  '\xed', '\xee', '\xef', '\xf0', '\xf1', '\xf2', '\xf3', '\xf4',
  '\xf5', '\xf6', '\xf7', '\xf8', '\xf9', '\xfa', '\xfb', '\xfc',
  '\xfd', '\xfe', '\xaf', '\x00', '\x00', '\xa1', '\xa2', '\xa4',
  '\x00', '\x00', '\xa5',
};
