/* postal-address-details.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from postal-address-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_POSTAL_ADDRESS_0_PROPERTY,
	FOLKS_POSTAL_ADDRESS_PO_BOX_PROPERTY,
	FOLKS_POSTAL_ADDRESS_EXTENSION_PROPERTY,
	FOLKS_POSTAL_ADDRESS_STREET_PROPERTY,
	FOLKS_POSTAL_ADDRESS_LOCALITY_PROPERTY,
	FOLKS_POSTAL_ADDRESS_REGION_PROPERTY,
	FOLKS_POSTAL_ADDRESS_POSTAL_CODE_PROPERTY,
	FOLKS_POSTAL_ADDRESS_COUNTRY_PROPERTY,
	FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT_PROPERTY,
	FOLKS_POSTAL_ADDRESS_UID_PROPERTY,
	FOLKS_POSTAL_ADDRESS_NUM_PROPERTIES
};
static GParamSpec* folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_0_PROPERTY,
	FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_ID_PROPERTY,
	FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_NUM_PROPERTIES
};
static GParamSpec* folks_postal_address_field_details_properties[FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksPostalAddressDetailsChangePostalAddressesData FolksPostalAddressDetailsChangePostalAddressesData;

struct _FolksPostalAddressPrivate {
	gchar* _po_box;
	gchar* _extension;
	gchar* _street;
	gchar* _locality;
	gchar* _region;
	gchar* _postal_code;
	gchar* _country;
	gchar* _address_format;
	gchar* _uid;
};

struct _FolksPostalAddressFieldDetailsPrivate {
	gchar* _id;
};

struct _FolksPostalAddressDetailsChangePostalAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksPostalAddressDetails* self;
	GeeSet* postal_addresses;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gint FolksPostalAddress_private_offset;
static gpointer folks_postal_address_parent_class = NULL;
static gint FolksPostalAddressFieldDetails_private_offset;
static gpointer folks_postal_address_field_details_parent_class = NULL;

static void folks_postal_address_finalize (GObject * obj);
static GType folks_postal_address_get_type_once (void);
static void _vala_folks_postal_address_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_folks_postal_address_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static gboolean folks_postal_address_field_details_real_equal (FolksAbstractFieldDetails* base,
                                                        FolksAbstractFieldDetails* that);
static guint folks_postal_address_field_details_real_hash (FolksAbstractFieldDetails* base);
static GObject * folks_postal_address_field_details_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
static void _folks_postal_address_field_details___lambda4_ (FolksPostalAddressFieldDetails* self,
                                                     GObject* s,
                                                     GParamSpec* p);
static void __folks_postal_address_field_details___lambda4__g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void folks_postal_address_field_details_finalize (GObject * obj);
static GType folks_postal_address_field_details_get_type_once (void);
static void _vala_folks_postal_address_field_details_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_folks_postal_address_field_details_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);
static void folks_postal_address_details_real_change_postal_addresses_data_free (gpointer _data);
static void folks_postal_address_details_real_change_postal_addresses (FolksPostalAddressDetails* self,
                                                                GeeSet* postal_addresses,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
static gboolean folks_postal_address_details_real_change_postal_addresses_co (FolksPostalAddressDetailsChangePostalAddressesData* _data_);
static GType folks_postal_address_details_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
folks_postal_address_get_instance_private (FolksPostalAddress* self)
{
	return G_STRUCT_MEMBER_P (self, FolksPostalAddress_private_offset);
}

/**
   * Create a PostalAddress.
   *
   * You can pass ``null`` if a component is not set.
   *
   * @param po_box the PO Box
   * @param extension the address extension
   * @param street the street name and number
   * @param locality the locality (city, town or village) name
   * @param region the region (state or province) name
   * @param postal_code the postal code
   * @param country the country name
   * @param address_format the address format
   * @param uid external UID for the address instance
   * @since 0.5.1
   */
FolksPostalAddress*
folks_postal_address_construct (GType object_type,
                                const gchar* po_box,
                                const gchar* extension,
                                const gchar* street,
                                const gchar* locality,
                                const gchar* region,
                                const gchar* postal_code,
                                const gchar* country,
                                const gchar* address_format,
                                const gchar* uid)
{
	FolksPostalAddress * self = NULL;
	self = (FolksPostalAddress*) g_object_new (object_type, "po-box", po_box, "extension", extension, "street", street, "locality", locality, "region", region, "postal-code", postal_code, "country", country, "address-format", address_format, "uid", uid, NULL);
	return self;
}

FolksPostalAddress*
folks_postal_address_new (const gchar* po_box,
                          const gchar* extension,
                          const gchar* street,
                          const gchar* locality,
                          const gchar* region,
                          const gchar* postal_code,
                          const gchar* country,
                          const gchar* address_format,
                          const gchar* uid)
{
	return folks_postal_address_construct (FOLKS_TYPE_POSTAL_ADDRESS, po_box, extension, street, locality, region, postal_code, country, address_format, uid);
}

/**
   * Whether none of the components is set.
   *
   * @return ``true`` if all the components are the empty string, ``false``
   * otherwise.
   *
   * @since 0.6.7
   */
gboolean
folks_postal_address_is_empty (FolksPostalAddress* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp7_ = folks_postal_address_get_po_box (self);
	_tmp8_ = _tmp7_;
	if (g_strcmp0 (_tmp8_, "") == 0) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = folks_postal_address_get_extension (self);
		_tmp10_ = _tmp9_;
		_tmp6_ = g_strcmp0 (_tmp10_, "") == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = folks_postal_address_get_street (self);
		_tmp12_ = _tmp11_;
		_tmp5_ = g_strcmp0 (_tmp12_, "") == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = folks_postal_address_get_locality (self);
		_tmp14_ = _tmp13_;
		_tmp4_ = g_strcmp0 (_tmp14_, "") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = folks_postal_address_get_region (self);
		_tmp16_ = _tmp15_;
		_tmp3_ = g_strcmp0 (_tmp16_, "") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = folks_postal_address_get_postal_code (self);
		_tmp18_ = _tmp17_;
		_tmp2_ = g_strcmp0 (_tmp18_, "") == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp19_ = folks_postal_address_get_country (self);
		_tmp20_ = _tmp19_;
		_tmp1_ = g_strcmp0 (_tmp20_, "") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = folks_postal_address_get_address_format (self);
		_tmp22_ = _tmp21_;
		_tmp0_ = g_strcmp0 (_tmp22_, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
   * Compare if two postal addresses are equal. Addresses are equal if all their
   * components are equal (where ``null`` compares equal only with ``null``) and
   * they have the same set of types (or both have no types).
   *
   * This does not factor in the {@link PostalAddress.uid}.
   *
   * @param with another postal address to compare with
   * @return ``true`` if the addresses are equal, ``false`` otherwise
   */
gboolean
folks_postal_address_equal (FolksPostalAddress* self,
                            FolksPostalAddress* with)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (with != NULL, FALSE);
	_tmp7_ = folks_postal_address_get_po_box (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = folks_postal_address_get_po_box (with);
	_tmp10_ = _tmp9_;
	if (g_strcmp0 (_tmp8_, _tmp10_) != 0) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = folks_postal_address_get_extension (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = folks_postal_address_get_extension (with);
		_tmp14_ = _tmp13_;
		_tmp6_ = g_strcmp0 (_tmp12_, _tmp14_) != 0;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = folks_postal_address_get_street (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = folks_postal_address_get_street (with);
		_tmp18_ = _tmp17_;
		_tmp5_ = g_strcmp0 (_tmp16_, _tmp18_) != 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp19_ = folks_postal_address_get_locality (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = folks_postal_address_get_locality (with);
		_tmp22_ = _tmp21_;
		_tmp4_ = g_strcmp0 (_tmp20_, _tmp22_) != 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp23_ = folks_postal_address_get_region (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = folks_postal_address_get_region (with);
		_tmp26_ = _tmp25_;
		_tmp3_ = g_strcmp0 (_tmp24_, _tmp26_) != 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		_tmp27_ = folks_postal_address_get_postal_code (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = folks_postal_address_get_postal_code (with);
		_tmp30_ = _tmp29_;
		_tmp2_ = g_strcmp0 (_tmp28_, _tmp30_) != 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		_tmp31_ = folks_postal_address_get_country (self);
		_tmp32_ = _tmp31_;
		_tmp33_ = folks_postal_address_get_country (with);
		_tmp34_ = _tmp33_;
		_tmp1_ = g_strcmp0 (_tmp32_, _tmp34_) != 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp35_ = folks_postal_address_get_address_format (self);
		_tmp36_ = _tmp35_;
		_tmp37_ = folks_postal_address_get_address_format (with);
		_tmp38_ = _tmp37_;
		_tmp0_ = g_strcmp0 (_tmp36_, _tmp38_) != 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

/**
   * Get a formatted version of the address. The format is localised, and by
   * default is comma-separated.
   *
   * @return a formatted address.
   *
   * @since 0.4.0
   */
gchar*
folks_postal_address_to_string (FolksPostalAddress* self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (_ ("%s, %s, %s, %s, %s, %s, %s"));
	str = _tmp0_;
	_tmp1_ = folks_postal_address_get_po_box (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_postal_address_get_extension (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = folks_postal_address_get_street (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = folks_postal_address_get_locality (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = folks_postal_address_get_region (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = folks_postal_address_get_postal_code (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = folks_postal_address_get_country (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf (str, _tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp10_, _tmp12_, _tmp14_);
	result = _tmp15_;
	_g_free0 (str);
	return result;
}

const gchar*
folks_postal_address_get_po_box (FolksPostalAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_po_box;
	result = _tmp0_;
	return result;
}

void
folks_postal_address_set_po_box (FolksPostalAddress* self,
                                 const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_po_box);
	self->priv->_po_box = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_PO_BOX_PROPERTY]);
}

const gchar*
folks_postal_address_get_extension (FolksPostalAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extension;
	result = _tmp0_;
	return result;
}

void
folks_postal_address_set_extension (FolksPostalAddress* self,
                                    const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_extension);
	self->priv->_extension = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_EXTENSION_PROPERTY]);
}

const gchar*
folks_postal_address_get_street (FolksPostalAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_street;
	result = _tmp0_;
	return result;
}

void
folks_postal_address_set_street (FolksPostalAddress* self,
                                 const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_street);
	self->priv->_street = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_STREET_PROPERTY]);
}

const gchar*
folks_postal_address_get_locality (FolksPostalAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_locality;
	result = _tmp0_;
	return result;
}

void
folks_postal_address_set_locality (FolksPostalAddress* self,
                                   const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_locality);
	self->priv->_locality = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_LOCALITY_PROPERTY]);
}

const gchar*
folks_postal_address_get_region (FolksPostalAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_region;
	result = _tmp0_;
	return result;
}

void
folks_postal_address_set_region (FolksPostalAddress* self,
                                 const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_region);
	self->priv->_region = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_REGION_PROPERTY]);
}

const gchar*
folks_postal_address_get_postal_code (FolksPostalAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_postal_code;
	result = _tmp0_;
	return result;
}

void
folks_postal_address_set_postal_code (FolksPostalAddress* self,
                                      const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_postal_code);
	self->priv->_postal_code = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_POSTAL_CODE_PROPERTY]);
}

const gchar*
folks_postal_address_get_country (FolksPostalAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_country;
	result = _tmp0_;
	return result;
}

void
folks_postal_address_set_country (FolksPostalAddress* self,
                                  const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_country);
	self->priv->_country = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_COUNTRY_PROPERTY]);
}

const gchar*
folks_postal_address_get_address_format (FolksPostalAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_address_format;
	result = _tmp0_;
	return result;
}

void
folks_postal_address_set_address_format (FolksPostalAddress* self,
                                         const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_address_format);
	self->priv->_address_format = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT_PROPERTY]);
}

const gchar*
folks_postal_address_get_uid (FolksPostalAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uid;
	result = _tmp0_;
	return result;
}

void
folks_postal_address_set_uid (FolksPostalAddress* self,
                              const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uid);
	self->priv->_uid = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_UID_PROPERTY]);
}

static void
folks_postal_address_class_init (FolksPostalAddressClass * klass,
                                 gpointer klass_data)
{
	folks_postal_address_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksPostalAddress_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_postal_address_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_postal_address_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_postal_address_finalize;
	/**
	   * The PO Box.
	   *
	   * The PO Box (also known as Postal office box or Postal box).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_PO_BOX_PROPERTY, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_PO_BOX_PROPERTY] = g_param_spec_string ("po-box", "po-box", "po-box", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The address extension.
	   *
	   * Any additional part of the address, for instance a flat number.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_EXTENSION_PROPERTY, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_EXTENSION_PROPERTY] = g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The street name and number.
	   *
	   * The street name including the optional building number.
	   * The number can be before or after the street name based on the
	   * language and country.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_STREET_PROPERTY, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_STREET_PROPERTY] = g_param_spec_string ("street", "street", "street", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The locality.
	   *
	   * The locality, for instance the city name.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_LOCALITY_PROPERTY, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_LOCALITY_PROPERTY] = g_param_spec_string ("locality", "locality", "locality", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The region.
	   *
	   * The region, for instance the name of the state or province.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_REGION_PROPERTY, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_REGION_PROPERTY] = g_param_spec_string ("region", "region", "region", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The postal code.
	   *
	   * The postal code (also known as post code, postcode or ZIP code).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_POSTAL_CODE_PROPERTY, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_POSTAL_CODE_PROPERTY] = g_param_spec_string ("postal-code", "postal-code", "postal-code", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The country.
	   *
	   * The name of the country.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_COUNTRY_PROPERTY, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_COUNTRY_PROPERTY] = g_param_spec_string ("country", "country", "country", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The address format.
	   *
	   * The two letter country code that determines the format or exact
	   * meaning of the other fields.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT_PROPERTY, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT_PROPERTY] = g_param_spec_string ("address-format", "address-format", "address-format", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The UID of the Postal Address (if any).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_UID_PROPERTY, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_UID_PROPERTY] = g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT | G_PARAM_DEPRECATED));
}

static void
folks_postal_address_instance_init (FolksPostalAddress * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self->priv = folks_postal_address_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_po_box = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_extension = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_street = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_locality = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_region = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->_postal_code = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->priv->_country = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->priv->_address_format = _tmp7_;
	_tmp8_ = g_strdup ("");
	self->priv->_uid = _tmp8_;
}

static void
folks_postal_address_finalize (GObject * obj)
{
	FolksPostalAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress);
	_g_free0 (self->priv->_po_box);
	_g_free0 (self->priv->_extension);
	_g_free0 (self->priv->_street);
	_g_free0 (self->priv->_locality);
	_g_free0 (self->priv->_region);
	_g_free0 (self->priv->_postal_code);
	_g_free0 (self->priv->_country);
	_g_free0 (self->priv->_address_format);
	_g_free0 (self->priv->_uid);
	G_OBJECT_CLASS (folks_postal_address_parent_class)->finalize (obj);
}

/**
 * Object representing a postal mail address.
 *
 * The components of the address are never ``null``: an empty string
 * indicates that a property is not set.
 */
static GType
folks_postal_address_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksPostalAddressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_postal_address_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPostalAddress), 0, (GInstanceInitFunc) folks_postal_address_instance_init, NULL };
	GType folks_postal_address_type_id;
	folks_postal_address_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPostalAddress", &g_define_type_info, 0);
	FolksPostalAddress_private_offset = g_type_add_instance_private (folks_postal_address_type_id, sizeof (FolksPostalAddressPrivate));
	return folks_postal_address_type_id;
}

GType
folks_postal_address_get_type (void)
{
	static volatile gsize folks_postal_address_type_id__once = 0;
	if (g_once_init_enter (&folks_postal_address_type_id__once)) {
		GType folks_postal_address_type_id;
		folks_postal_address_type_id = folks_postal_address_get_type_once ();
		g_once_init_leave (&folks_postal_address_type_id__once, folks_postal_address_type_id);
	}
	return folks_postal_address_type_id__once;
}

static void
_vala_folks_postal_address_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	FolksPostalAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress);
	switch (property_id) {
		case FOLKS_POSTAL_ADDRESS_PO_BOX_PROPERTY:
		g_value_set_string (value, folks_postal_address_get_po_box (self));
		break;
		case FOLKS_POSTAL_ADDRESS_EXTENSION_PROPERTY:
		g_value_set_string (value, folks_postal_address_get_extension (self));
		break;
		case FOLKS_POSTAL_ADDRESS_STREET_PROPERTY:
		g_value_set_string (value, folks_postal_address_get_street (self));
		break;
		case FOLKS_POSTAL_ADDRESS_LOCALITY_PROPERTY:
		g_value_set_string (value, folks_postal_address_get_locality (self));
		break;
		case FOLKS_POSTAL_ADDRESS_REGION_PROPERTY:
		g_value_set_string (value, folks_postal_address_get_region (self));
		break;
		case FOLKS_POSTAL_ADDRESS_POSTAL_CODE_PROPERTY:
		g_value_set_string (value, folks_postal_address_get_postal_code (self));
		break;
		case FOLKS_POSTAL_ADDRESS_COUNTRY_PROPERTY:
		g_value_set_string (value, folks_postal_address_get_country (self));
		break;
		case FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT_PROPERTY:
		g_value_set_string (value, folks_postal_address_get_address_format (self));
		break;
		case FOLKS_POSTAL_ADDRESS_UID_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		g_value_set_string (value, folks_postal_address_get_uid (self));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_postal_address_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	FolksPostalAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress);
	switch (property_id) {
		case FOLKS_POSTAL_ADDRESS_PO_BOX_PROPERTY:
		folks_postal_address_set_po_box (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_EXTENSION_PROPERTY:
		folks_postal_address_set_extension (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_STREET_PROPERTY:
		folks_postal_address_set_street (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_LOCALITY_PROPERTY:
		folks_postal_address_set_locality (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_REGION_PROPERTY:
		folks_postal_address_set_region (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_POSTAL_CODE_PROPERTY:
		folks_postal_address_set_postal_code (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_COUNTRY_PROPERTY:
		folks_postal_address_set_country (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT_PROPERTY:
		folks_postal_address_set_address_format (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_UID_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		folks_postal_address_set_uid (self, g_value_get_string (value));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
folks_postal_address_field_details_get_instance_private (FolksPostalAddressFieldDetails* self)
{
	return G_STRUCT_MEMBER_P (self, FolksPostalAddressFieldDetails_private_offset);
}

/**
   * Create a new PostalAddressFieldDetails.
   *
   * @param value the value of the field, a non-empty {@link PostalAddress}
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A ``null`` value is equivalent to
   * an empty map of parameters.
   *
   *
   * @return a new PostalAddressFieldDetails
   *
   * @since 0.6.0
   */
FolksPostalAddressFieldDetails*
folks_postal_address_field_details_construct (GType object_type,
                                              FolksPostalAddress* value,
                                              GeeMultiMap* parameters)
{
	FolksPostalAddressFieldDetails * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (value != NULL, NULL);
	if (folks_postal_address_is_empty (value)) {
		g_warning ("postal-address-details.vala:285: Empty postal address passed to Postal" \
"AddressFieldDetails.");
	}
	_tmp0_ = folks_postal_address_get_uid (value);
	_tmp1_ = _tmp0_;
	self = (FolksPostalAddressFieldDetails*) g_object_new (object_type, "t-type", FOLKS_TYPE_POSTAL_ADDRESS, "t-dup-func", (GBoxedCopyFunc) g_object_ref, "t-destroy-func", (GDestroyNotify) g_object_unref, "value", value, "parameters", parameters, "id", _tmp1_, NULL);
	return self;
}

FolksPostalAddressFieldDetails*
folks_postal_address_field_details_new (FolksPostalAddress* value,
                                        GeeMultiMap* parameters)
{
	return folks_postal_address_field_details_construct (FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, value, parameters);
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean
folks_postal_address_field_details_real_equal (FolksAbstractFieldDetails* base,
                                               FolksAbstractFieldDetails* that)
{
	FolksPostalAddressFieldDetails * self;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gconstpointer _tmp4_;
	gconstpointer _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean result;
	self = (FolksPostalAddressFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	if (!FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_postal_address_field_details_parent_class)->parameters_equal (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails), that)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_postal_address_to_string ((FolksPostalAddress*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_abstract_field_details_get_value (that);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_postal_address_to_string ((FolksPostalAddress*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strcmp0 (_tmp3_, _tmp7_) == 0;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp3_);
	result = _tmp8_;
	return result;
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint
folks_postal_address_field_details_real_hash (FolksAbstractFieldDetails* base)
{
	FolksPostalAddressFieldDetails * self;
	GHashFunc _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	guint _tmp5_;
	guint result;
	self = (FolksPostalAddressFieldDetails*) base;
	_tmp0_ = g_str_hash;
	_tmp1_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_postal_address_to_string ((FolksPostalAddress*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_ (_tmp4_);
	_g_free0 (_tmp4_);
	result = _tmp5_;
	return result;
}

static const gchar*
folks_postal_address_field_details_real_get_id (FolksAbstractFieldDetails* base)
{
	const gchar* result;
	FolksPostalAddressFieldDetails* self;
	const gchar* _tmp0_;
	self = (FolksPostalAddressFieldDetails*) base;
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
folks_postal_address_field_details_real_set_id (FolksAbstractFieldDetails* base,
                                                const gchar* value)
{
	FolksPostalAddressFieldDetails* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	gconstpointer _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	self = (FolksPostalAddressFieldDetails*) base;
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	_tmp2_ = self->priv->_id;
	_tmp3_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = folks_postal_address_get_uid ((FolksPostalAddress*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (g_strcmp0 (_tmp2_, _tmp6_) != 0) {
		gconstpointer _tmp7_;
		gconstpointer _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->_id;
		folks_postal_address_set_uid ((FolksPostalAddress*) _tmp8_, _tmp9_);
	}
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_field_details_properties[FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_ID_PROPERTY]);
}

static void
_folks_postal_address_field_details___lambda4_ (FolksPostalAddressFieldDetails* self,
                                                GObject* s,
                                                GParamSpec* p)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	gconstpointer _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_postal_address_get_uid ((FolksPostalAddress*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp1_, _tmp5_) != 0) {
		gconstpointer _tmp6_;
		gconstpointer _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = folks_postal_address_get_uid ((FolksPostalAddress*) _tmp7_);
		_tmp9_ = _tmp8_;
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) self, _tmp9_);
	}
}

static void
__folks_postal_address_field_details___lambda4__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	_folks_postal_address_field_details___lambda4_ ((FolksPostalAddressFieldDetails*) self, _sender, pspec);
}

static GObject *
folks_postal_address_field_details_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksPostalAddressFieldDetails * self;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	parent_class = G_OBJECT_CLASS (folks_postal_address_field_details_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails);
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((GObject*) ((FolksPostalAddress*) _tmp1_), "notify::uid", (GCallback) __folks_postal_address_field_details___lambda4__g_object_notify, self, 0);
	return obj;
}

static void
folks_postal_address_field_details_class_init (FolksPostalAddressFieldDetailsClass * klass,
                                               gpointer klass_data)
{
	folks_postal_address_field_details_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksPostalAddressFieldDetails_private_offset);
	((FolksAbstractFieldDetailsClass *) klass)->equal = (gboolean (*) (FolksAbstractFieldDetails*, FolksAbstractFieldDetails*)) folks_postal_address_field_details_real_equal;
	((FolksAbstractFieldDetailsClass *) klass)->hash = (guint (*) (FolksAbstractFieldDetails*)) folks_postal_address_field_details_real_hash;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_id = (const gchar* (*) (FolksAbstractFieldDetails*)) folks_postal_address_field_details_real_get_id;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_id = (void (*) (FolksAbstractFieldDetails*, const gchar*)) folks_postal_address_field_details_real_set_id;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_postal_address_field_details_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_postal_address_field_details_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_postal_address_field_details_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_postal_address_field_details_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_ID_PROPERTY, folks_postal_address_field_details_properties[FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
folks_postal_address_field_details_instance_init (FolksPostalAddressFieldDetails * self,
                                                  gpointer klass)
{
	self->priv = folks_postal_address_field_details_get_instance_private (self);
}

static void
folks_postal_address_field_details_finalize (GObject * obj)
{
	FolksPostalAddressFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_postal_address_field_details_parent_class)->finalize (obj);
}

/**
 * Object representing a PostalAddress value that can have some parameters
 * associated with it.
 *
 * See {@link Folks.AbstractFieldDetails} for details on common parameter names
 * and values.
 *
 * @since 0.6.0
 */
static GType
folks_postal_address_field_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksPostalAddressFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_postal_address_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPostalAddressFieldDetails), 0, (GInstanceInitFunc) folks_postal_address_field_details_instance_init, NULL };
	GType folks_postal_address_field_details_type_id;
	folks_postal_address_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksPostalAddressFieldDetails", &g_define_type_info, 0);
	FolksPostalAddressFieldDetails_private_offset = g_type_add_instance_private (folks_postal_address_field_details_type_id, sizeof (FolksPostalAddressFieldDetailsPrivate));
	return folks_postal_address_field_details_type_id;
}

GType
folks_postal_address_field_details_get_type (void)
{
	static volatile gsize folks_postal_address_field_details_type_id__once = 0;
	if (g_once_init_enter (&folks_postal_address_field_details_type_id__once)) {
		GType folks_postal_address_field_details_type_id;
		folks_postal_address_field_details_type_id = folks_postal_address_field_details_get_type_once ();
		g_once_init_leave (&folks_postal_address_field_details_type_id__once, folks_postal_address_field_details_type_id);
	}
	return folks_postal_address_field_details_type_id__once;
}

static void
_vala_folks_postal_address_field_details_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	FolksPostalAddressFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails);
	switch (property_id) {
		case FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_ID_PROPERTY:
		g_value_set_string (value, folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_postal_address_field_details_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	FolksPostalAddressFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails);
	switch (property_id) {
		case FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_ID_PROPERTY:
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
folks_postal_address_details_real_change_postal_addresses_data_free (gpointer _data)
{
	FolksPostalAddressDetailsChangePostalAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->postal_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksPostalAddressDetailsChangePostalAddressesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_postal_address_details_real_change_postal_addresses (FolksPostalAddressDetails* self,
                                                           GeeSet* postal_addresses,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	FolksPostalAddressDetailsChangePostalAddressesData* _data_;
	FolksPostalAddressDetails* _tmp0_;
	GeeSet* _tmp1_;
	g_return_if_fail (postal_addresses != NULL);
	_data_ = g_slice_new0 (FolksPostalAddressDetailsChangePostalAddressesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_postal_address_details_real_change_postal_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (postal_addresses);
	_g_object_unref0 (_data_->postal_addresses);
	_data_->postal_addresses = _tmp1_;
	folks_postal_address_details_real_change_postal_addresses_co (_data_);
}

static void
folks_postal_address_details_real_change_postal_addresses_finish (FolksPostalAddressDetails* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error)
{
	FolksPostalAddressDetailsChangePostalAddressesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's postal addresses.
   *
   * It's preferred to call this rather than setting
   * {@link PostalAddressDetails.postal_addresses} directly, as this method
   * gives error notification and will only return once the addresses have been
   * written to the relevant backing store (or the operation's failed).
   *
   * @param postal_addresses the set of postal addresses
   * @throws PropertyError if setting the addresses failed
   * @since 0.6.2
   */
static gboolean
folks_postal_address_details_real_change_postal_addresses_co (FolksPostalAddressDetailsChangePostalAddressesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("Postal addresses are not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_postal_address_details_change_postal_addresses (FolksPostalAddressDetails* self,
                                                      GeeSet* postal_addresses,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	FolksPostalAddressDetailsIface* _iface_;
	_iface_ = FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_postal_addresses) {
		_iface_->change_postal_addresses (self, postal_addresses, _callback_, _user_data_);
	}
}

void
folks_postal_address_details_change_postal_addresses_finish (FolksPostalAddressDetails* self,
                                                             GAsyncResult* _res_,
                                                             GError** error)
{
	FolksPostalAddressDetailsIface* _iface_;
	_iface_ = FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_postal_addresses_finish) {
		_iface_->change_postal_addresses_finish (self, _res_, error);
	}
}

GeeSet*
folks_postal_address_details_get_postal_addresses (FolksPostalAddressDetails* self)
{
	FolksPostalAddressDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_postal_addresses) {
		return _iface_->get_postal_addresses (self);
	}
	return NULL;
}

void
folks_postal_address_details_set_postal_addresses (FolksPostalAddressDetails* self,
                                                   GeeSet* value)
{
	FolksPostalAddressDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_postal_addresses) {
		_iface_->set_postal_addresses (self, value);
	}
}

static void
folks_postal_address_details_default_init (FolksPostalAddressDetailsIface * iface,
                                           gpointer iface_data)
{
	/**
	   * The postal addresses of the contact.
	   *
	   * A list of postal addresses associated to the contact.
	   *
	   * @since 0.5.1
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("postal-addresses", "postal-addresses", "postal-addresses", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->change_postal_addresses = folks_postal_address_details_real_change_postal_addresses;
	iface->change_postal_addresses_finish = folks_postal_address_details_real_change_postal_addresses_finish;
}

/**
 * Interface for classes that can provide postal addresses, such as
 * {@link Persona} and {@link Individual}.
 */
static GType
folks_postal_address_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksPostalAddressDetailsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_postal_address_details_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType folks_postal_address_details_type_id;
	folks_postal_address_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksPostalAddressDetails", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (folks_postal_address_details_type_id, G_TYPE_OBJECT);
	return folks_postal_address_details_type_id;
}

GType
folks_postal_address_details_get_type (void)
{
	static volatile gsize folks_postal_address_details_type_id__once = 0;
	if (g_once_init_enter (&folks_postal_address_details_type_id__once)) {
		GType folks_postal_address_details_type_id;
		folks_postal_address_details_type_id = folks_postal_address_details_get_type_once ();
		g_once_init_leave (&folks_postal_address_details_type_id__once, folks_postal_address_details_type_id);
	}
	return folks_postal_address_details_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

