/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.rules.ImmutableIntersectToSemiJoinRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class IntersectToSemiJoinRule
extends RelRule<Config>
implements TransformationRule {
    protected IntersectToSemiJoinRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Intersect intersect = (Intersect)call.rel(0);
        if (intersect.all) {
            return;
        }
        RelBuilder builder = call.builder();
        RexBuilder rexBuilder = builder.getRexBuilder();
        List<RelNode> inputs = intersect.getInputs();
        if (inputs.size() < 2) {
            return;
        }
        RelDataType leastRowType = intersect.getRowType();
        RelNode current = inputs.get(0);
        for (int i = 1; i < inputs.size(); ++i) {
            RelNode next = inputs.get(i);
            RelNode leftCasted = this.projectJoinInput(builder, leastRowType, current);
            RelNode rightCasted = this.projectJoinInput(builder, leastRowType, next);
            builder.push(leftCasted).push(rightCasted);
            int fieldCount = leastRowType.getFieldCount();
            ArrayList<RexNode> joinPredicates = new ArrayList<RexNode>(fieldCount);
            for (int j = 0; j < fieldCount; ++j) {
                joinPredicates.add(builder.isNotDistinctFrom(builder.field(2, 0, j), builder.field(2, 1, j)));
            }
            RexNode condition = RexUtil.composeConjunction(rexBuilder, joinPredicates);
            builder.join(JoinRelType.SEMI, condition);
            current = builder.peek();
        }
        builder.distinct().convert(leastRowType, true);
        call.transformTo(builder.build());
    }

    private RelNode projectJoinInput(RelBuilder builder, RelDataType leastRowType, RelNode joinInput) {
        builder.push(joinInput);
        int fieldCount = joinInput.getRowType().getFieldCount();
        List<String> names = leastRowType.getFieldNames();
        ArrayList<RexNode> joinKeys = new ArrayList<RexNode>(fieldCount);
        RexBuilder rexBuilder = builder.getRexBuilder();
        for (int j = 0; j < fieldCount; ++j) {
            RelDataType leastType = leastRowType.getFieldList().get(j).getType();
            joinKeys.add(rexBuilder.makeCast(leastType, builder.field(j)));
        }
        return builder.project(joinKeys, names).build();
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableIntersectToSemiJoinRule.Config.of().withOperandFor(LogicalIntersect.class);

        @Override
        default public IntersectToSemiJoinRule toRule() {
            return new IntersectToSemiJoinRule(this);
        }

        default public Config withOperandFor(Class<? extends Intersect> intersectClass) {
            return this.withOperandSupplier(b -> b.operand(intersectClass).anyInputs()).as(Config.class);
        }
    }
}

