/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.contextmanager;

import lombok.Generated;
import org.opensearch.ml.common.contextmanager.ActivationRule;
import org.opensearch.ml.common.contextmanager.ContextManagerContext;

public class TokensExceedRule
implements ActivationRule {
    private final int tokenThreshold;

    @Override
    public boolean evaluate(ContextManagerContext context) {
        if (context == null) {
            return false;
        }
        int currentTokenCount = context.getEstimatedTokenCount();
        return currentTokenCount > this.tokenThreshold;
    }

    @Override
    public String getDescription() {
        return "tokens_exceed: " + this.tokenThreshold;
    }

    @Generated
    public TokensExceedRule(int tokenThreshold) {
        this.tokenThreshold = tokenThreshold;
    }

    @Generated
    public int getTokenThreshold() {
        return this.tokenThreshold;
    }
}

