/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.sample;

import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.execute.samplecalculator.LocalSampleCalculatorInput;
import org.opensearch.ml.common.output.Output;
import org.opensearch.ml.common.output.execute.samplecalculator.LocalSampleCalculatorOutput;
import org.opensearch.ml.engine.Executable;
import org.opensearch.ml.engine.annotation.Function;
import org.opensearch.transport.client.Client;

@Function(value=FunctionName.LOCAL_SAMPLE_CALCULATOR)
public class LocalSampleCalculator
implements Executable {
    private Client client;
    private Settings settings;

    public LocalSampleCalculator(Client client, Settings settings) {
        this.client = client;
        this.settings = settings;
    }

    @Override
    public void execute(Input input, ActionListener<Output> listener) {
        if (!(input instanceof LocalSampleCalculatorInput)) {
            throw new IllegalArgumentException("wrong input");
        }
        LocalSampleCalculatorInput sampleCalculatorInput = (LocalSampleCalculatorInput)input;
        String operation = sampleCalculatorInput.getOperation();
        List inputData = sampleCalculatorInput.getInputData();
        switch (operation) {
            case "sum": {
                double sum = inputData.stream().mapToDouble(f -> f).sum();
                listener.onResponse((Object)new LocalSampleCalculatorOutput(Double.valueOf(sum)));
                return;
            }
            case "max": {
                double max = (Double)inputData.stream().max(Comparator.naturalOrder()).get();
                listener.onResponse((Object)new LocalSampleCalculatorOutput(Double.valueOf(max)));
                return;
            }
            case "min": {
                double min = (Double)inputData.stream().min(Comparator.naturalOrder()).get();
                listener.onResponse((Object)new LocalSampleCalculatorOutput(Double.valueOf(min)));
                return;
            }
        }
        throw new IllegalArgumentException("can't support this operation");
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalSampleCalculator)) {
            return false;
        }
        LocalSampleCalculator other = (LocalSampleCalculator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Client this$client = this.getClient();
        Client other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        return !(this$settings == null ? other$settings != null : !this$settings.equals(other$settings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocalSampleCalculator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Client $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        Settings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LocalSampleCalculator(client=" + String.valueOf(this.getClient()) + ", settings=" + String.valueOf(this.getSettings()) + ")";
    }

    @Generated
    public LocalSampleCalculator() {
    }
}

