/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data;

import com.oracle.labs.mlrg.olcut.command.Command;
import com.oracle.labs.mlrg.olcut.command.CommandGroup;
import com.oracle.labs.mlrg.olcut.command.CommandInterpreter;
import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.builtins.Completers;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.NullCompleter;
import org.tribuo.Dataset;
import org.tribuo.VariableInfo;
import org.tribuo.data.csv.CSVSaver;
import org.tribuo.provenance.DatasetProvenance;

public final class DatasetExplorer
implements CommandGroup {
    private static final Logger logger = Logger.getLogger(DatasetExplorer.class.getName());
    private final CommandInterpreter shell = new CommandInterpreter();
    private Dataset<?> dataset;

    public DatasetExplorer() {
        this.shell.setPrompt("dataset sh% ");
    }

    public String getName() {
        return "Dataset Explorer";
    }

    public String getDescription() {
        return "Commands for inspecting a Dataset.";
    }

    public Completer[] fileCompleter() {
        return new Completer[]{new Completers.FileNameCompleter(), new NullCompleter()};
    }

    public void startShell() {
        this.shell.add((CommandGroup)this);
        this.shell.start();
    }

    @Command(usage="<filename> - Load a dataset from disk.", completers="fileCompleter")
    public String loadDataset(CommandInterpreter ci, File path) {
        try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(path)));){
            this.dataset = (Dataset)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to load class from stream " + path.getAbsolutePath(), e);
            return "Failed to load dataset";
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to open file " + path.getAbsolutePath(), e);
            return "Failed to load dataset";
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IOException when reading from file " + path.getAbsolutePath(), e);
            return "Failed to load dataset";
        }
        return "Loaded dataset from path " + path.toString();
    }

    @Command(usage="Shows the information on a particular feature")
    public String featureInfo(CommandInterpreter ci, String featureName) {
        VariableInfo f = this.dataset.getFeatureMap().get(featureName);
        if (f != null) {
            return "" + f.toString();
        }
        return "Feature " + featureName + " not found.";
    }

    @Command(usage="Shows the output information.")
    public String outputInfo(CommandInterpreter ci) {
        return this.dataset.getOutputInfo().toReadableString();
    }

    @Command(usage="Shows the number of rows in the dataset")
    public String numExamples(CommandInterpreter ci) {
        return "" + this.dataset.getData().size();
    }

    @Command(usage="Shows the number of features in the dataset")
    public String numFeatures(CommandInterpreter ci) {
        return "" + this.dataset.getFeatureMap().size();
    }

    @Command(usage="<min count> - Shows the number of features that occurred more than min count times.")
    public String minCount(CommandInterpreter ci, int minCount) {
        int counter = 0;
        for (VariableInfo f : this.dataset.getFeatureMap()) {
            if (f.getCount() <= minCount) continue;
            ++counter;
        }
        return counter + " features occurred more than " + minCount + " times.";
    }

    @Command(usage="Shows the output statistics")
    public String showOutputStats(CommandInterpreter ci) {
        return "Output statistics: \n" + this.dataset.getOutputInfo().toReadableString();
    }

    @Command(usage="Saves out the data as a CSV.")
    public String saveCSV(CommandInterpreter ci, String path) {
        CSVSaver saver = new CSVSaver();
        try {
            saver.save(Paths.get(path, new String[0]), this.dataset, "Response");
            return "Saved";
        }
        catch (IOException e) {
            e.printStackTrace(ci.out);
            return "Failed to save to CSV.";
        }
    }

    @Command(usage="Shows the dataset provenance")
    public String showProvenance(CommandInterpreter ci) {
        return ((DatasetProvenance)this.dataset.getProvenance()).toString();
    }

    public static void main(String[] args) {
        DatasetExplorerOptions options = new DatasetExplorerOptions();
        ConfigurationManager cm = new ConfigurationManager(args, (Options)options, false);
        DatasetExplorer driver = new DatasetExplorer();
        if (options.modelFilename != null) {
            logger.log(Level.INFO, driver.loadDataset(driver.shell, new File(options.modelFilename)));
        }
        driver.startShell();
    }

    public static class DatasetExplorerOptions
    implements Options {
        @Option(charName=102, longName="filename", usage="Dataset file to load. Optional.")
        public String modelFilename;
    }
}

