/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.state.tree;

import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.state.IContextualStateMapper;
import com.amazon.randomcutforest.state.store.NodeStoreState;
import com.amazon.randomcutforest.state.tree.CompactRandomCutTreeContext;
import com.amazon.randomcutforest.tree.AbstractNodeStore;
import com.amazon.randomcutforest.util.ArrayPacking;
import java.util.concurrent.ArrayBlockingQueue;
import lombok.Generated;

public class AbstractNodeStoreMapper
implements IContextualStateMapper<AbstractNodeStore, NodeStoreState, CompactRandomCutTreeContext> {
    private int root;

    @Override
    public AbstractNodeStore toModel(NodeStoreState state, CompactRandomCutTreeContext compactRandomCutTreeContext, long seed) {
        int capacity = state.getCapacity();
        int[] cutDimension = null;
        int[] leftIndex = null;
        int[] rightIndex = null;
        float[] cutValue = null;
        if (this.root != AbstractNodeStore.Null && this.root < capacity) {
            cutDimension = ArrayPacking.unpackInts(state.getCutDimension(), capacity, state.isCompressed());
            cutValue = ArrayPacking.unpackFloats(state.getCutValueData(), capacity);
            leftIndex = ArrayPacking.unpackInts(state.getLeftIndex(), capacity, state.isCompressed());
            rightIndex = ArrayPacking.unpackInts(state.getRightIndex(), capacity, state.isCompressed());
            if (state.isCanonicalAndNotALeaf()) {
                AbstractNodeStoreMapper.reverseBits(state.getSize(), leftIndex, rightIndex, capacity);
            } else {
                AbstractNodeStoreMapper.replaceLeaves(leftIndex, capacity);
                AbstractNodeStoreMapper.replaceLeaves(rightIndex, capacity);
            }
        }
        return ((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)AbstractNodeStore.builder().capacity(capacity)).useRoot(this.root)).leftIndex(leftIndex)).rightIndex(rightIndex)).cutDimension(cutDimension)).cutValues(cutValue)).dimensions(compactRandomCutTreeContext.getPointStore().getDimensions())).pointStoreView(compactRandomCutTreeContext.getPointStore())).build();
    }

    @Override
    public NodeStoreState toState(AbstractNodeStore model) {
        NodeStoreState state = new NodeStoreState();
        int capacity = model.getCapacity();
        state.setVersion("3.0");
        state.setCapacity(capacity);
        state.setCompressed(true);
        state.setPartialTreeStateEnabled(true);
        state.setPrecision(Precision.FLOAT_32.name());
        int[] leftIndex = model.getLeftIndex();
        int[] rightIndex = model.getRightIndex();
        int[] cutDimension = model.getCutDimension();
        float[] cutValues = model.getCutValues();
        int[] map = new int[capacity];
        int size = this.reorderNodesInBreadthFirstOrder(map, leftIndex, rightIndex, capacity);
        state.setSize(size);
        boolean check = this.root != AbstractNodeStore.Null && this.root < capacity;
        state.setCanonicalAndNotALeaf(check);
        if (check) {
            int[] reorderedLeftArray = new int[size];
            int[] reorderedRightArray = new int[size];
            int[] reorderedCutDimension = new int[size];
            float[] reorderedCutValue = new float[size];
            for (int i = 0; i < size; ++i) {
                reorderedLeftArray[i] = leftIndex[map[i]] < capacity ? 1 : 0;
                reorderedRightArray[i] = rightIndex[map[i]] < capacity ? 1 : 0;
                reorderedCutDimension[i] = cutDimension[map[i]];
                reorderedCutValue[i] = cutValues[map[i]];
            }
            state.setLeftIndex(ArrayPacking.pack(reorderedLeftArray, state.isCompressed()));
            state.setRightIndex(ArrayPacking.pack(reorderedRightArray, state.isCompressed()));
            state.setSize(model.size());
            state.setCutDimension(ArrayPacking.pack(reorderedCutDimension, state.isCompressed()));
            state.setCutValueData(ArrayPacking.pack(reorderedCutValue));
        }
        return state;
    }

    protected static void reverseBits(int size, int[] leftIndex, int[] rightIndex, int capacity) {
        int i;
        int nodeCounter = 1;
        for (i = 0; i < size; ++i) {
            leftIndex[i] = leftIndex[i] != 0 ? nodeCounter++ : capacity;
            rightIndex[i] = rightIndex[i] != 0 ? nodeCounter++ : capacity;
        }
        for (i = size; i < leftIndex.length; ++i) {
            leftIndex[i] = rightIndex[i] = capacity;
        }
    }

    protected static void replaceLeaves(int[] array, int capacity) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = Math.min(array[i], capacity);
        }
    }

    public int reorderNodesInBreadthFirstOrder(int[] map, int[] leftIndex, int[] rightIndex, int capacity) {
        if (this.root != AbstractNodeStore.Null && this.root < capacity) {
            int currentNode = 0;
            ArrayBlockingQueue<Integer> nodeQueue = new ArrayBlockingQueue<Integer>(capacity);
            nodeQueue.add(this.root);
            while (!nodeQueue.isEmpty()) {
                int rightChild;
                int head = (Integer)nodeQueue.poll();
                int leftChild = leftIndex[head];
                if (leftChild < capacity) {
                    nodeQueue.add(leftChild);
                }
                if ((rightChild = rightIndex[head]) < capacity) {
                    nodeQueue.add(rightChild);
                }
                map[currentNode] = head;
                ++currentNode;
            }
            return currentNode;
        }
        return 0;
    }

    @Generated
    public int getRoot() {
        return this.root;
    }

    @Generated
    public void setRoot(int root) {
        this.root = root;
    }
}

