/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.handlers;

import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.ast.tree.DefaultBin;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.utils.BinTimeSpanUtils;
import org.opensearch.sql.calcite.utils.binning.BinFieldValidator;
import org.opensearch.sql.calcite.utils.binning.BinHandler;
import org.opensearch.sql.calcite.utils.binning.BinnableField;
import org.opensearch.sql.calcite.utils.binning.RangeFormatter;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLFuncImpTable;

public class DefaultBinHandler
implements BinHandler {
    @Override
    public RexNode createExpression(Bin node, RexNode fieldExpr, CalcitePlanContext context, CalciteRexNodeVisitor visitor) {
        DefaultBin defaultBin = (DefaultBin)node;
        String fieldName = BinFieldValidator.extractFieldName(node);
        BinnableField field = new BinnableField(fieldExpr, fieldExpr.getType(), fieldName);
        if (field.isTimeBased()) {
            BinFieldValidator.validateFieldExists(fieldName, context);
            return BinTimeSpanUtils.createBinTimeSpanExpression(fieldExpr, 1, "h", 0L, context);
        }
        return this.createNumericDefaultBinning(fieldExpr, context);
    }

    private RexNode createNumericDefaultBinning(RexNode fieldExpr, CalcitePlanContext context) {
        RexNode minValue = context.relBuilder.min(fieldExpr).over().toRex();
        RexNode maxValue = context.relBuilder.max(fieldExpr).over().toRex();
        RexNode dataRange = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.SUBTRACT, maxValue, minValue);
        RexNode log10Range = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.LOG10, new RexNode[]{dataRange});
        RexNode magnitude = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, new RexNode[]{log10Range});
        RexLiteral tenLiteral = context.relBuilder.literal(10.0);
        RexNode defaultWidth = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.POWER, new RexNode[]{tenLiteral, magnitude});
        RexNode widthInt = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, new RexNode[]{defaultWidth});
        RexNode binStartValue = this.calculateBinValue(fieldExpr, widthInt, context);
        RexNode binEndValue = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.ADD, binStartValue, widthInt);
        return RangeFormatter.createRangeString(binStartValue, binEndValue, context);
    }

    private RexNode calculateBinValue(RexNode fieldExpr, RexNode width, CalcitePlanContext context) {
        RexNode divided = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.DIVIDE, fieldExpr, width);
        RexNode floored = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, new RexNode[]{divided});
        return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.MULTIPLY, floored, width);
    }
}

