/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.sandbox.search.DocValuesMultiRangeQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocValuesRangeIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.LongBitSet;

public class SortedSetDocValuesMultiRangeQuery
extends Query {
    protected final String fieldName;
    protected final List<DocValuesMultiRangeQuery.ByteRange> rangeClauses;

    protected SortedSetDocValuesMultiRangeQuery(String fieldName, List<DocValuesMultiRangeQuery.ByteRange> clauses) {
        this.fieldName = fieldName;
        ArrayList<DocValuesMultiRangeQuery.ByteRange> sortedClauses = new ArrayList<DocValuesMultiRangeQuery.ByteRange>(clauses);
        sortedClauses.sort(Comparator.comparing(r -> r.lower).thenComparing(r -> r.upper));
        this.rangeClauses = sortedClauses;
    }

    public String toString(String fld) {
        return (String)(Objects.equals(this.fieldName, fld) ? "" : this.fieldName + ":") + String.valueOf(this.rangeClauses);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new MultiRangeWeight(boost, scoreMode);
    }

    protected void createOrdRanges(SortedSetDocValues values, Collection<OrdRange> ordRanges) throws IOException {
        TermsEnum termsEnum = values.termsEnum();
        OrdRange previous = null;
        block9: for (DocValuesMultiRangeQuery.ByteRange range : this.rangeClauses) {
            TermsEnum.SeekStatus seekStatus = termsEnum.seekCeil(range.lower);
            long lowerOrd = -1L;
            switch (seekStatus) {
                case END: {
                    break block9;
                }
                case FOUND: 
                case NOT_FOUND: {
                    lowerOrd = termsEnum.ord();
                }
                default: {
                    if (range.lower != range.upper) {
                        seekStatus = termsEnum.seekCeil(range.upper);
                    }
                    long upperOrd = -1L;
                    switch (seekStatus) {
                        case END: {
                            upperOrd = values.getValueCount() - 1L;
                            break;
                        }
                        case FOUND: {
                            upperOrd = termsEnum.ord();
                            break;
                        }
                        case NOT_FOUND: {
                            if (termsEnum.ord() == 0L) continue block9;
                            upperOrd = termsEnum.ord() - 1L;
                        }
                    }
                    if (lowerOrd > upperOrd) continue block9;
                    if (previous == null || previous.upper < lowerOrd - 1L) {
                        previous = new OrdRange(lowerOrd, upperOrd);
                        ordRanges.add(previous);
                        continue block9;
                    }
                    previous.upper = Math.max(upperOrd, previous.upper);
                    continue block9;
                }
            }
        }
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SortedSetDocValuesMultiRangeQuery that = (SortedSetDocValuesMultiRangeQuery)((Object)o);
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.rangeClauses, that.rangeClauses);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.rangeClauses);
    }

    protected class MultiRangeWeight
    extends ConstantScoreWeight {
        final ScoreMode scoreMode;

        public MultiRangeWeight(float boost, ScoreMode scoreMode) {
            super((Query)SortedSetDocValuesMultiRangeQuery.this, boost);
            this.scoreMode = scoreMode;
        }

        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            if (context.reader().getFieldInfos().fieldInfo(SortedSetDocValuesMultiRangeQuery.this.fieldName) == null) {
                return null;
            }
            SortedSetDocValues values = DocValues.getSortedSet((LeafReader)context.reader(), (String)SortedSetDocValuesMultiRangeQuery.this.fieldName);
            return new MultiRangeScorerSupplier(values, context);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{SortedSetDocValuesMultiRangeQuery.this.fieldName});
        }

        protected class MultiRangeScorerSupplier
        extends ScorerSupplier {
            final SortedSetDocValues values;
            protected final LeafReaderContext context;

            public MultiRangeScorerSupplier(SortedSetDocValues values, LeafReaderContext context) {
                this.values = values;
                this.context = context;
            }

            public Scorer get(long leadCost) throws IOException {
                ArrayList<OrdRange> ordRanges = new ArrayList<OrdRange>();
                SortedSetDocValuesMultiRangeQuery.this.createOrdRanges(this.values, ordRanges);
                if (ordRanges.isEmpty()) {
                    return this.empty();
                }
                LongBitSet matchingOrdsShifted = null;
                final long minOrd = ((OrdRange)ordRanges.getFirst()).lower;
                final long maxOrd = ((OrdRange)ordRanges.getLast()).upper;
                DocValuesSkipper skipper = this.context.reader().getDocValuesSkipper(SortedSetDocValuesMultiRangeQuery.this.fieldName);
                if (skipper != null && (minOrd > skipper.maxValue() || maxOrd < skipper.minValue())) {
                    return this.empty();
                }
                if (ordRanges.size() > 1) {
                    matchingOrdsShifted = new LongBitSet(maxOrd + 1L - minOrd);
                    for (OrdRange range : ordRanges) {
                        matchingOrdsShifted.set(range.lower - minOrd, range.upper - minOrd + 1L);
                    }
                }
                final LongBitSet finalMatchingOrdsShifted = matchingOrdsShifted;
                TwoPhaseIterator iterator = new TwoPhaseIterator((DocIdSetIterator)this.values){

                    public boolean matches() throws IOException {
                        for (int i = 0; i < MultiRangeScorerSupplier.this.values.docValueCount(); ++i) {
                            long ord = MultiRangeScorerSupplier.this.values.nextOrd();
                            if (ord < minOrd || ord > maxOrd || finalMatchingOrdsShifted != null && !finalMatchingOrdsShifted.get(ord - minOrd)) continue;
                            return true;
                        }
                        return false;
                    }

                    public float matchCost() {
                        return 2.0f;
                    }
                };
                if (skipper != null) {
                    iterator = new DocValuesRangeIterator(iterator, skipper, minOrd, maxOrd, matchingOrdsShifted != null);
                }
                return new ConstantScoreScorer(MultiRangeWeight.this.score(), MultiRangeWeight.this.scoreMode, iterator);
            }

            protected ConstantScoreScorer empty() {
                return new ConstantScoreScorer(MultiRangeWeight.this.score(), MultiRangeWeight.this.scoreMode, DocIdSetIterator.empty());
            }

            public long cost() {
                return this.values.cost();
            }
        }
    }

    protected static final class OrdRange {
        final long lower;
        long upper;

        public OrdRange(long lower, long upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }
}

