/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import oracle.jdbc.DatabaseFunction;

public interface TraceEventListener {
    public Object roundTrip(Sequence var1, TraceContext var2, Object var3);

    default public Object onExecutionEventReceived(JdbcExecutionEvent event, Object userContext, Object ... params) {
        return null;
    }

    default public boolean isDesiredEvent(JdbcExecutionEvent event) {
        return false;
    }

    public static enum JdbcExecutionEvent {
        VIP_RETRY("VIP is down. Trying another VIP."),
        AC_REPLAY_STARTED("AC replay driver detected failure. Replaying."),
        AC_REPLAY_SUCCESSFUL("AC replay driver detected failure. Replay successful.");

        private final String description;

        private JdbcExecutionEvent(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static interface TraceContext {
        public String getConnectionId();

        public String databaseOperation();

        public DatabaseFunction databaseFunction();

        public String originalSqlText();

        public String actualSqlText();

        public String user();

        public String tenant();

        public String getSqlId();

        public Boolean isCompletedExceptionally();

        public void setClientInfo(String var1, String var2) throws SQLClientInfoException;

        public String getClientInfo(String var1) throws SQLException;
    }

    public static enum Sequence {
        BEFORE,
        AFTER;

    }
}

