/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.internal.arjuna.recovery.Connection;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;

public class Listener
extends Thread {
    private ServerSocket _listener_socket;
    private int _listener_port;
    private boolean _stop_listener = false;
    private int _listener_socket_timeout_in_msecs = 1500;
    private Service _listener_service;
    private List<Socket> connections;
    private static final boolean setTimeout = recoveryPropertyManager.getRecoveryEnvironmentBean().isTimeoutSocket();

    public Listener(int port, Service service) throws IOException {
        super("Listener:" + port);
        this._listener_port = port;
        this._listener_service = service;
        this._listener_socket = new ServerSocket(this._listener_port);
        if (setTimeout) {
            this._listener_socket.setSoTimeout(this._listener_socket_timeout_in_msecs);
        }
        this.connections = new LinkedList<Socket>();
    }

    public Listener(ServerSocket serverSocket, Service service) throws IOException {
        super("Listener:" + serverSocket.getLocalPort());
        this._listener_port = serverSocket.getLocalPort();
        this._listener_service = service;
        this._listener_socket = serverSocket;
        if (setTimeout) {
            this._listener_socket.setSoTimeout(this._listener_socket_timeout_in_msecs);
        }
        this.connections = new LinkedList<Socket>();
    }

    @Override
    public void run() {
        while (!this.stopRequested()) {
            try {
                final Socket conn = this._listener_socket.accept();
                if (!this.addConnection(conn)) continue;
                Connection.Callback callback = new Connection.Callback(){
                    private Socket _conn;
                    {
                        this._conn = conn;
                    }

                    @Override
                    public void run() {
                        Listener.this.removeConnection(this._conn);
                    }
                };
                Connection new_conn = new Connection(conn, this._listener_service, callback);
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)("Connected to " + conn.getInetAddress().getHostAddress() + " on port " + conn.getPort() + " on listener port " + conn.getLocalPort() + " for service " + this._listener_service.getClass().getName()));
                }
                new_conn.start();
            }
            catch (InterruptedIOException iioex) {
                if (!tsLogger.logger.isDebugEnabled()) continue;
                tsLogger.logger.debug((Object)("Timeout on the listener socket expired. Exception: " + String.valueOf(iioex)));
            }
            catch (SocketException ex) {
                if (!tsLogger.logger.isDebugEnabled()) continue;
                tsLogger.logger.debug((Object)("Recovery listener existing " + this._listener_service.getClass().getName()));
            }
            catch (Exception ex) {
                if (!tsLogger.logger.isDebugEnabled()) continue;
                tsLogger.logger.debug((Object)("Listener - Exception: " + String.valueOf(ex)));
            }
        }
    }

    public synchronized boolean addConnection(Socket conn) {
        if (!this._stop_listener) {
            this.connections.add(conn);
            return true;
        }
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)"Transaction listener is stopped. No new connection will be processed.");
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            tsLogger.i18NLogger.warn_could_not_close_transaction_listener_connection(conn, e);
        }
        return false;
    }

    public synchronized void removeConnection(Socket conn) {
        this.connections.remove(conn);
        try {
            conn.close();
        }
        catch (IOException ioe) {
            tsLogger.i18NLogger.warn_could_not_close_transaction_listener_connection(conn, ioe);
        }
        finally {
            this.notifyAll();
        }
    }

    public synchronized void closeListenerSockets() {
        this._stop_listener = true;
        try {
            this._listener_socket.close();
        }
        catch (Exception ex) {
            tsLogger.i18NLogger.warn_could_not_close_transaction_listener_socket(this._listener_socket, ex);
        }
    }

    public synchronized void stopListener() {
        this.closeListenerSockets();
        while (!this.connections.isEmpty()) {
            Socket conn = this.connections.get(0);
            try {
                conn.close();
            }
            catch (Exception e) {
                tsLogger.i18NLogger.warn_could_not_close_transaction_listener_connection(conn, e);
            }
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                tsLogger.logger.debug((Object)"Waiting for connection close was interrupted", (Throwable)ie);
            }
        }
        try {
            this.join();
        }
        catch (InterruptedException ie) {
            tsLogger.logger.debug((Object)"Waiting to ensure the listener thread has exited was interrupted", (Throwable)ie);
        }
    }

    private synchronized boolean stopRequested() {
        return this._stop_listener;
    }
}

