/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportProvider;
import org.keycloak.exportimport.ImportProvider;
import org.keycloak.exportimport.ImportProviderFactory;
import org.keycloak.exportimport.Strategy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class ExportImportManager {
    private static final Logger logger = Logger.getLogger(ExportImportManager.class);
    private final KeycloakSessionFactory sessionFactory;
    private final KeycloakSession session;
    private ExportProvider exportProvider;
    private List<ImportProvider> importProviders = List.of();

    public ExportImportManager(KeycloakSession session) {
        this.sessionFactory = session.getKeycloakSessionFactory();
        this.session = session;
        String exportImportAction = ExportImportConfig.getAction();
        if ("export".equals(exportImportAction)) {
            String providerId = System.getProperty("keycloak.migration.provider", Config.scope((String[])new String[]{"export"}).get("exporter", "dir"));
            this.exportProvider = (ExportProvider)session.getProvider(ExportProvider.class, providerId);
            if (this.exportProvider == null) {
                throw new RuntimeException("Export provider '" + providerId + "' not found");
            }
        } else if ("import".equals(exportImportAction)) {
            String providerId = System.getProperty("keycloak.migration.provider", Config.scope((String[])new String[]{"import"}).get("importer", "dir"));
            ImportProvider importProvider = (ImportProvider)session.getProvider(ImportProvider.class, providerId);
            if (importProvider == null) {
                throw new RuntimeException("Import provider '" + providerId + "' not found");
            }
            this.importProviders = List.of(importProvider);
        } else if (ExportImportConfig.getDir().isPresent()) {
            ExportImportConfig.setStrategy(Strategy.IGNORE_EXISTING);
            ExportImportConfig.setReplacePlaceholders(true);
            ExportImportConfig.setAction("import");
            this.importProviders = this.getStartupImportProviders();
        }
    }

    public boolean isImportMasterIncluded() {
        return this.importProviders.stream().anyMatch(provider -> {
            try {
                return provider.isMasterRealmExported();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to run import", e);
            }
        });
    }

    public boolean isRunExport() {
        return this.exportProvider != null;
    }

    public void runImport() {
        this.importProviders.forEach(ip -> {
            try {
                ip.importModel();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to run import", e);
            }
        });
    }

    private List<ImportProvider> getStartupImportProviders() {
        Optional<String> dirProp = ExportImportConfig.getDir();
        if (dirProp.isEmpty()) {
            return List.of();
        }
        String dir = dirProp.get();
        Stream factories = this.sessionFactory.getProviderFactoriesStream(ImportProvider.class);
        return factories.flatMap(factory -> {
            String providerId = factory.getId();
            if ("dir".equals(providerId)) {
                return Stream.of((ImportProvider)this.session.getProvider(ImportProvider.class, providerId));
            }
            if ("singleFile".equals(providerId)) {
                HashSet<String> filesToImport = new HashSet<String>();
                File[] files = Paths.get(dir, new String[0]).toFile().listFiles();
                Objects.requireNonNull(files, "directory not found");
                for (File file2 : files) {
                    Path filePath = file2.toPath();
                    if (!(Files.exists(filePath, new LinkOption[0]) && Files.isRegularFile(filePath, new LinkOption[0]) && filePath.toString().endsWith(".json"))) {
                        logger.debugf("Ignoring import file because it is not a valid file: %s", (Object)file2);
                        continue;
                    }
                    String fileName = file2.getName();
                    if (fileName.contains("-realm.json") || fileName.contains("-users-")) continue;
                    filesToImport.add(file2.getAbsolutePath());
                }
                if (factory instanceof ImportProviderFactory) {
                    return filesToImport.stream().map(file -> ((ImportProviderFactory)factory).create(this.session, Map.of("keycloak.migration.file", file)));
                }
            }
            return Stream.empty();
        }).toList();
    }

    public void runExport() {
        try {
            this.exportProvider.exportModel();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to run export", e);
        }
    }
}

