/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.query.sql.spi.SqlTranslationEngine;
import org.hibernate.type.spi.TypeConfiguration;

public class SqlTranslationEngineImpl
implements SqlTranslationEngine {
    private final SessionFactoryImplementor factory;
    private final TypeConfiguration typeConfiguration;
    private final Map<String, FetchProfile> fetchProfiles;

    public SqlTranslationEngineImpl(SessionFactoryImplementor factory, TypeConfiguration typeConfiguration, Map<String, FetchProfile> fetchProfiles) {
        this.factory = factory;
        this.typeConfiguration = typeConfiguration;
        this.fetchProfiles = fetchProfiles;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.factory;
    }

    @Override
    public MappingMetamodelImplementor getMappingMetamodel() {
        return this.factory.getMappingMetamodel();
    }

    @Override
    public Integer getMaximumFetchDepth() {
        return this.factory.getSessionFactoryOptions().getMaximumFetchDepth();
    }

    @Override
    public boolean isJpaQueryComplianceEnabled() {
        return this.factory.getSessionFactoryOptions().getJpaCompliance().isJpaQueryComplianceEnabled();
    }

    @Override
    public JpaMetamodel getJpaMetamodel() {
        return this.factory.getJpaMetamodel();
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.fetchProfiles.get(name);
    }

    @Override
    public boolean containsFetchProfileDefinition(String name) {
        return this.fetchProfiles.containsKey(name);
    }

    @Override
    public Set<String> getDefinedFetchProfileNames() {
        return Collections.unmodifiableSet(this.fetchProfiles.keySet());
    }
}

