/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.streams.kstream.EmitStrategy;

public class DslSessionParams {
    private final String name;
    private final Duration retentionPeriod;
    private final EmitStrategy emitStrategy;

    public DslSessionParams(String name, Duration retentionPeriod, EmitStrategy emitStrategy) {
        Objects.requireNonNull(name);
        this.name = name;
        this.retentionPeriod = retentionPeriod;
        this.emitStrategy = emitStrategy;
    }

    public String name() {
        return this.name;
    }

    public Duration retentionPeriod() {
        return this.retentionPeriod;
    }

    public EmitStrategy emitStrategy() {
        return this.emitStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DslSessionParams that = (DslSessionParams)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.retentionPeriod, that.retentionPeriod) && Objects.equals(this.emitStrategy, that.emitStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.retentionPeriod, this.emitStrategy);
    }

    public String toString() {
        return "DslSessionParams{name='" + this.name + "', retentionPeriod=" + String.valueOf(this.retentionPeriod) + ", emitStrategy=" + String.valueOf(this.emitStrategy) + "}";
    }
}

