/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class MetadataXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, Metadata metadata) throws IOException {
        MXSerializer serializer2 = new MXSerializer();
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
        serializer2.setOutput(writer);
        serializer2.startDocument(metadata.getModelEncoding(), null);
        this.writeMetadata(metadata, "metadata", serializer2);
        serializer2.endDocument();
    }

    public void write(OutputStream stream, Metadata metadata) throws IOException {
        MXSerializer serializer2 = new MXSerializer();
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
        serializer2.setOutput(stream, metadata.getModelEncoding());
        serializer2.startDocument(metadata.getModelEncoding(), null);
        this.writeMetadata(metadata, "metadata", serializer2);
        serializer2.endDocument();
    }

    private void writeMetadata(Metadata metadata, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (metadata.getModelVersion() != null) {
            serializer2.attribute(NAMESPACE, "modelVersion", metadata.getModelVersion());
        }
        if (metadata.getGroupId() != null) {
            serializer2.startTag(NAMESPACE, "groupId").text(metadata.getGroupId()).endTag(NAMESPACE, "groupId");
        }
        if (metadata.getArtifactId() != null) {
            serializer2.startTag(NAMESPACE, "artifactId").text(metadata.getArtifactId()).endTag(NAMESPACE, "artifactId");
        }
        if (metadata.getVersioning() != null) {
            this.writeVersioning(metadata.getVersioning(), "versioning", serializer2);
        }
        if (metadata.getVersion() != null) {
            serializer2.startTag(NAMESPACE, "version").text(metadata.getVersion()).endTag(NAMESPACE, "version");
        }
        if (metadata.getPlugins() != null && metadata.getPlugins().size() > 0) {
            serializer2.startTag(NAMESPACE, "plugins");
            for (Plugin o : metadata.getPlugins()) {
                this.writePlugin(o, "plugin", serializer2);
            }
            serializer2.endTag(NAMESPACE, "plugins");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writePlugin(Plugin plugin, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (plugin.getName() != null) {
            serializer2.startTag(NAMESPACE, "name").text(plugin.getName()).endTag(NAMESPACE, "name");
        }
        if (plugin.getPrefix() != null) {
            serializer2.startTag(NAMESPACE, "prefix").text(plugin.getPrefix()).endTag(NAMESPACE, "prefix");
        }
        if (plugin.getArtifactId() != null) {
            serializer2.startTag(NAMESPACE, "artifactId").text(plugin.getArtifactId()).endTag(NAMESPACE, "artifactId");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeSnapshot(Snapshot snapshot, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (snapshot.getTimestamp() != null) {
            serializer2.startTag(NAMESPACE, "timestamp").text(snapshot.getTimestamp()).endTag(NAMESPACE, "timestamp");
        }
        if (snapshot.getBuildNumber() != 0) {
            serializer2.startTag(NAMESPACE, "buildNumber").text(String.valueOf(snapshot.getBuildNumber())).endTag(NAMESPACE, "buildNumber");
        }
        if (snapshot.isLocalCopy()) {
            serializer2.startTag(NAMESPACE, "localCopy").text(String.valueOf(snapshot.isLocalCopy())).endTag(NAMESPACE, "localCopy");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeSnapshotVersion(SnapshotVersion snapshotVersion, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (snapshotVersion.getClassifier() != null && !snapshotVersion.getClassifier().equals("")) {
            serializer2.startTag(NAMESPACE, "classifier").text(snapshotVersion.getClassifier()).endTag(NAMESPACE, "classifier");
        }
        if (snapshotVersion.getExtension() != null) {
            serializer2.startTag(NAMESPACE, "extension").text(snapshotVersion.getExtension()).endTag(NAMESPACE, "extension");
        }
        if (snapshotVersion.getVersion() != null) {
            serializer2.startTag(NAMESPACE, "value").text(snapshotVersion.getVersion()).endTag(NAMESPACE, "value");
        }
        if (snapshotVersion.getUpdated() != null) {
            serializer2.startTag(NAMESPACE, "updated").text(snapshotVersion.getUpdated()).endTag(NAMESPACE, "updated");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeVersioning(Versioning versioning, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (versioning.getLatest() != null) {
            serializer2.startTag(NAMESPACE, "latest").text(versioning.getLatest()).endTag(NAMESPACE, "latest");
        }
        if (versioning.getRelease() != null) {
            serializer2.startTag(NAMESPACE, "release").text(versioning.getRelease()).endTag(NAMESPACE, "release");
        }
        if (versioning.getVersions() != null && versioning.getVersions().size() > 0) {
            serializer2.startTag(NAMESPACE, "versions");
            for (String version : versioning.getVersions()) {
                serializer2.startTag(NAMESPACE, "version").text(version).endTag(NAMESPACE, "version");
            }
            serializer2.endTag(NAMESPACE, "versions");
        }
        if (versioning.getLastUpdated() != null) {
            serializer2.startTag(NAMESPACE, "lastUpdated").text(versioning.getLastUpdated()).endTag(NAMESPACE, "lastUpdated");
        }
        if (versioning.getSnapshot() != null) {
            this.writeSnapshot(versioning.getSnapshot(), "snapshot", serializer2);
        }
        if (versioning.getSnapshotVersions() != null && versioning.getSnapshotVersions().size() > 0) {
            serializer2.startTag(NAMESPACE, "snapshotVersions");
            for (SnapshotVersion o : versioning.getSnapshotVersions()) {
                this.writeSnapshotVersion(o, "snapshotVersion", serializer2);
            }
            serializer2.endTag(NAMESPACE, "snapshotVersions");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }
}

