/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SystemProperties {
    private SystemProperties() {
    }

    @NotNull
    public static String getUserHome() {
        String string = System.getProperty("user.home");
        if (string == null) {
            SystemProperties.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getUserName() {
        String string = System.getProperty("user.name");
        if (string == null) {
            SystemProperties.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getJavaHome() {
        String string = System.getProperty("java.home");
        if (string == null) {
            SystemProperties.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static int getIntProperty(@NotNull String key, int defaultValue) {
        String value;
        if (key == null) {
            SystemProperties.$$$reportNull$$$0(3);
        }
        if ((value = System.getProperty(key)) != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getLongProperty(@NotNull String key, long defaultValue) {
        String value;
        if (key == null) {
            SystemProperties.$$$reportNull$$$0(4);
        }
        if ((value = System.getProperty(key)) != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float getFloatProperty(@NotNull String key, float defaultValue) {
        String value;
        if (key == null) {
            SystemProperties.$$$reportNull$$$0(5);
        }
        if ((value = System.getProperty(key)) != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanProperty(@NotNull String key, boolean defaultValue) {
        String value;
        if (key == null) {
            SystemProperties.$$$reportNull$$$0(6);
        }
        return (value = System.getProperty(key)) != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    @Nullable
    public static String setProperty(@NotNull String key, @Nullable String value) {
        if (key == null) {
            SystemProperties.$$$reportNull$$$0(7);
        }
        return value != null ? System.setProperty(key, value) : System.clearProperty(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/SystemProperties";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserHome";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaHome";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/SystemProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIntProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLongProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFloatProperty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

