/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateBlockCommentPair;
import org.jetbrains.plugins.textmate.language.TextMateCommentPrefixes;
import org.jetbrains.plugins.textmate.language.preferences.IndentationRules;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/textmate/language/PreferencesReadUtil;", "", "<init>", "()V", "retrieveSettingsPlist", "Lkotlin/Pair;", "", "Lorg/jetbrains/plugins/textmate/plist/Plist;", "rootPlist", "readPairs", "", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateBracePair;", "pairsValue", "Lorg/jetbrains/plugins/textmate/plist/PListValue;", "getPattern", "name", "from", "loadIndentationRules", "Lorg/jetbrains/plugins/textmate/language/preferences/IndentationRules;", "plist", "readCommentPrefixes", "Lorg/jetbrains/plugins/textmate/language/TextMateCommentPrefixes;", "registry", "Lorg/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry;", "scope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "intellij.textmate.core"})
public final class PreferencesReadUtil {
    @NotNull
    public static final PreferencesReadUtil INSTANCE = new PreferencesReadUtil();

    private PreferencesReadUtil() {
    }

    @JvmStatic
    @Nullable
    public static final Pair<String, Plist> retrieveSettingsPlist(@NotNull Plist rootPlist) {
        Intrinsics.checkNotNullParameter((Object)rootPlist, (String)"rootPlist");
        String scopeName = null;
        Plist settingsValuePlist = null;
        PListValue value = rootPlist.getPlistValue("scope");
        if (value != null) {
            scopeName = value.getString();
            PListValue settingsValue = rootPlist.getPlistValue("settings");
            if (scopeName != null && !(((CharSequence)scopeName).length() == 0) && settingsValue != null) {
                settingsValuePlist = settingsValue.getPlist();
            }
        }
        return scopeName != null && settingsValuePlist != null ? TuplesKt.to((Object)scopeName, settingsValuePlist) : null;
    }

    @Nullable
    public final Set<TextMateBracePair> readPairs(@Nullable PListValue pairsValue) {
        Set set;
        if (pairsValue == null) {
            return null;
        }
        Set $this$readPairs_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        List<PListValue> pairs = pairsValue.getArray();
        for (PListValue pair : pairs) {
            List<PListValue> chars = pair.getArray();
            if (chars.size() != 2) continue;
            String left = chars.get(0).getString();
            String right = chars.get(1).getString();
            CharSequence charSequence = left;
            if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)right) == null || charSequence.length() == 0) continue;
            $this$readPairs_u24lambda_u240.add(new TextMateBracePair(left, right));
        }
        return SetsKt.build((Set)set);
    }

    private final String getPattern(String name, Plist from) {
        PListValue value = from.getPlistValue(name);
        if (value == null) {
            return null;
        }
        return value.getString();
    }

    @NotNull
    public final IndentationRules loadIndentationRules(@NotNull Plist plist) {
        Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
        PListValue rulesValue = plist.getPlistValue("indentationRules");
        if (rulesValue == null) {
            return IndentationRules.Companion.empty();
        }
        Plist rules = rulesValue.getPlist();
        return new IndentationRules(this.getPattern("increaseIndentPattern", rules), this.getPattern("decreaseIndentPattern", rules), this.getPattern("indentNextLinePattern", rules), this.getPattern("unIndentedLinePattern", rules));
    }

    @JvmStatic
    @NotNull
    public static final TextMateCommentPrefixes readCommentPrefixes(@NotNull ShellVariablesRegistry registry, @NotNull TextMateScope scope) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        String lineCommentPrefix = null;
        TextMateBlockCommentPair blockCommentPair = null;
        int index = 1;
        while (lineCommentPrefix == null || blockCommentPair == null) {
            Object variableSuffix = index > 1 ? "_" + index : "";
            TextMateShellVariable start = registry.getVariableValue("TM_COMMENT_START" + (String)variableSuffix, scope);
            TextMateShellVariable end = registry.getVariableValue("TM_COMMENT_END" + (String)variableSuffix, scope);
            ++index;
            if (start == null) break;
            if (!(end != null && Intrinsics.areEqual((Object)end.getScopeSelector(), (Object)start.getScopeSelector()) || lineCommentPrefix != null)) {
                lineCommentPrefix = start.getValue();
            }
            if (end == null || !Intrinsics.areEqual((Object)end.getScopeSelector(), (Object)start.getScopeSelector()) || blockCommentPair != null) continue;
            blockCommentPair = new TextMateBlockCommentPair(start.getValue(), end.getValue());
        }
        return new TextMateCommentPrefixes(lineCommentPrefix, blockCommentPair);
    }
}

