/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sourceToSink;

import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.sourceToSink.DeepTaintAnalyzerException;
import com.intellij.codeInspection.sourceToSink.NonMarkedElement;
import com.intellij.codeInspection.sourceToSink.TaintAnalyzer;
import com.intellij.codeInspection.sourceToSink.TaintAnalyzerKt;
import com.intellij.codeInspection.sourceToSink.TaintValue;
import com.intellij.codeInspection.sourceToSink.TaintValueFactory;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UBreakExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UContinueExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPostfixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UUnknownExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UYieldExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.internal.ImplementationUtilsKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u0000 Z2\u00020\u0001:\u0003YZ[B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\tH\u0007J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0016\u001a\u00020 H\u0002J\u001e\u0010!\u001a\u0004\u0018\u00010\t2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\b\u0002\u0010$\u001a\u00020\u0019H\u0002J\u001c\u0010%\u001a\u00020&2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010'\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u001dH\u0002J&\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u00102\u001a\u0004\u0018\u00010\t2\u0006\u00103\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J*\u00104\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u00105\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00106\u001a\u000207H\u0002J\"\u00108\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00109\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010:\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010;\u001a\u00020-H\u0002J:\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010,\u001a\u00020-2\u0006\u0010>\u001a\u00020?2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010@\u001a\u0004\u0018\u00010\u00172\u0006\u0010A\u001a\u00020\u0019H\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\bH\u0002J$\u0010E\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010F\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010G\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010F\u001a\u00020\b2\u0006\u0010H\u001a\u00020\u001dH\u0002J\u001a\u0010I\u001a\u0004\u0018\u00010\t2\u0006\u0010F\u001a\u00020\b2\u0006\u0010H\u001a\u00020\u001dH\u0002J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010,\u001a\u00020-H\u0002J&\u0010K\u001a\u00020\t2\u0006\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020\u001d2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0002J\u001a\u0010M\u001a\u00020\t2\b\u0010N\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010O\u001a\u00020\t2\b\u0010P\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010Q\u001a\u00020\t2\u0006\u0010N\u001a\u00020\u00172\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\t0SH\u0002J\u0012\u0010T\u001a\u00020\u00192\b\u0010U\u001a\u0004\u0018\u00010VH\u0002J\u001a\u0010W\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u00170X2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000b\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\f\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00100\r8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006\\"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer;", "", "myTaintValueFactory", "Lcom/intellij/codeInspection/sourceToSink/TaintValueFactory;", "<init>", "(Lcom/intellij/codeInspection/sourceToSink/TaintValueFactory;)V", "myVisited", "", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInspection/sourceToSink/TaintValue;", "myCurrentParameters", "myVisitedMethods", "Lkotlin/Pair;", "", "myNonMarkedElements", "", "Lcom/intellij/codeInspection/sourceToSink/NonMarkedElement;", "safeLambdaClass", "", "", "skipClasses", "analyzeExpression", "expression", "Lorg/jetbrains/uast/UExpression;", "collectOuterUsages", "", "untilTaintValue", "analyzeInner", "analyzeContext", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$AnalyzeContext;", "getClazzFromReceiver", "Lcom/intellij/psi/PsiClass;", "Lorg/jetbrains/uast/UResolvable;", "checkAndPrepareVisited", "uElement", "Lorg/jetbrains/uast/UElement;", "prepare", "addToVisited", "", "result", "fromCall", "sourceExpression", "sourceContext", "getNotEmptyParameters", "uMethod", "Lorg/jetbrains/uast/UMethod;", "Lorg/jetbrains/uast/UCallExpression;", "nonMarkedElements", "getNonMarkedElements", "()Ljava/util/List;", "fromModifierListOwner", "sourcePsiTarget", "addNonMarked", "taintValue", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "fromLocalVar", "sourceTarget", "possibleToSkipCheckAfterReference", "containingMethod", "analyzeVar", "initValue", "uVariable", "Lorg/jetbrains/uast/UVariable;", "usedReference", "skipAfterReference", "getVariableFlow", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow;", "sourcePsi", "fromParam", "target", "fromField", "context", "fromMethod", "getEmptyParameters", "analyzeMethod", "arguments", "fromExpressionWithoutCollection", "uExpression", "fromExpressionInner", "sourceUExpression", "withCache", "block", "Lkotlin/Function0;", "skipClass", "type", "Lcom/intellij/psi/PsiType;", "join", "", "AnalyzeContext", "Companion", "VariableFlow", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nTaintAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaintAnalyzer.kt\ncom/intellij/codeInspection/sourceToSink/TaintAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 UResolvable.kt\norg/jetbrains/uast/UResolvableKt\n*L\n1#1,1218:1\n1869#2,2:1219\n1869#2,2:1221\n1563#2:1224\n1634#2,3:1225\n774#2:1228\n865#2,2:1229\n1761#2,3:1231\n1869#2,2:1234\n43#3:1223\n*S KotlinDebug\n*F\n+ 1 TaintAnalyzer.kt\ncom/intellij/codeInspection/sourceToSink/TaintAnalyzer\n*L\n283#1:1219,2\n331#1:1221,2\n468#1:1224\n468#1:1225,3\n674#1:1228\n674#1:1229,2\n755#1:1231,3\n763#1:1234,2\n396#1:1223\n*E\n"})
public final class TaintAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TaintValueFactory myTaintValueFactory;
    @NotNull
    private final Map<PsiElement, TaintValue> myVisited;
    @NotNull
    private final Map<PsiElement, TaintValue> myCurrentParameters;
    @NotNull
    private final Map<Pair<PsiElement, List<TaintValue>>, TaintValue> myVisitedMethods;
    @NotNull
    private final List<NonMarkedElement> myNonMarkedElements;
    @NotNull
    private final Set<String> safeLambdaClass;
    @NotNull
    private final Set<String> skipClasses;

    public TaintAnalyzer(@NotNull TaintValueFactory myTaintValueFactory) {
        Intrinsics.checkNotNullParameter((Object)myTaintValueFactory, (String)"myTaintValueFactory");
        this.myTaintValueFactory = myTaintValueFactory;
        this.myVisited = new HashMap();
        this.myCurrentParameters = new HashMap();
        this.myVisitedMethods = new HashMap();
        this.myNonMarkedElements = new ArrayList();
        Object[] objectArray = new String[]{"java.lang.Iterable", "java.util.Collection", "java.util.Map", "kotlin.collections.CollectionsKt___CollectionsKt"};
        this.safeLambdaClass = SetsKt.setOf((Object[])objectArray);
        this.skipClasses = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)this.myTaintValueFactory.getConfiguration().getSkipClasses()));
    }

    @JvmOverloads
    @NotNull
    public final TaintValue analyzeExpression(@NotNull UExpression expression, boolean collectOuterUsages, @NotNull TaintValue untilTaintValue) throws DeepTaintAnalyzerException {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)untilTaintValue), (String)"untilTaintValue");
        UFile uFile = UastUtils.getContainingUFile((UElement)((UElement)expression));
        if (uFile == null) {
            return TaintValue.UNKNOWN;
        }
        UFile file = uFile;
        AnalyzeContext context = AnalyzeContext.Companion.create(this.myTaintValueFactory.getConfiguration().getProcessOuterMethodAsQualifierAndArguments(), this.myTaintValueFactory.getConfiguration().getProcessInnerMethodAsQualifierAndArguments(), file, collectOuterUsages, false, 1, this.myTaintValueFactory.getConfiguration().getDepthOutsideMethods(), 20, this.myTaintValueFactory.getConfiguration().getDepthInside(), this.myTaintValueFactory.getConfiguration().getDepthNestedMethods(), true, untilTaintValue, this.myTaintValueFactory.getConfiguration().getParameterOfPrivateMethodIsUntainted(), this.myTaintValueFactory.getConfiguration().getPrivateOrFinalFieldSafe());
        return this.fromExpressionInner(expression, context);
    }

    public static /* synthetic */ TaintValue analyzeExpression$default(TaintAnalyzer taintAnalyzer, UExpression uExpression, boolean bl, TaintValue taintValue, int n, Object object) throws DeepTaintAnalyzerException {
        if ((n & 4) != 0) {
            taintValue = TaintValue.TAINTED;
        }
        return taintAnalyzer.analyzeExpression(uExpression, bl, taintValue);
    }

    private final TaintValue analyzeInner(UExpression expression, AnalyzeContext analyzeContext) {
        TaintValue value;
        TaintValue taintValue;
        UResolvable uResolvable = expression instanceof UResolvable ? (UResolvable)expression : null;
        if (uResolvable == null) {
            return TaintValue.UNKNOWN;
        }
        UResolvable uResolvable2 = uResolvable;
        if (expression.getSourcePsi() == null) {
            return TaintValue.UNKNOWN;
        }
        PsiElement sourceTarget = uResolvable2.resolve();
        if (sourceTarget == null) {
            TaintValue taintValue2 = this.fromCall(expression, analyzeContext);
            if (taintValue2 == null) {
                taintValue2 = TaintValue.UNKNOWN;
            }
            return taintValue2;
        }
        if (!(sourceTarget instanceof PsiModifierListOwner) && UastContextKt.toUElement((PsiElement)sourceTarget.getParent()) instanceof UForEachExpression) {
            UElement uElement = UastContextKt.toUElement((PsiElement)sourceTarget.getParent());
            Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UForEachExpression");
            UForEachExpression uForEachExpression = (UForEachExpression)uElement;
            TaintValue taintValue3 = TaintValue.UNTAINTED.joinUntil(analyzeContext.getUntilTaintValue(), () -> TaintAnalyzer.analyzeInner$lambda$0(this, uForEachExpression, analyzeContext));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)taintValue3), (String)"joinUntil(...)");
            return taintValue3;
        }
        TaintValue taintValue4 = this.myTaintValueFactory.fromElement(sourceTarget, this.getClazzFromReceiver((UResolvable)expression));
        if (taintValue4 == null) {
            taintValue4 = TaintValue.UNKNOWN;
        }
        if ((taintValue = taintValue4) != TaintValue.UNKNOWN) {
            return taintValue;
        }
        TaintValue taintValue5 = value = TaintAnalyzer.checkAndPrepareVisited$default(this, (UElement)expression, false, 2, null);
        if (taintValue5 != null) {
            return taintValue5;
        }
        TaintValue taintValue6 = this.fromModifierListOwner(sourceTarget, expression, analyzeContext);
        if (taintValue6 == null) {
            taintValue6 = TaintValue.UNKNOWN;
        }
        taintValue = taintValue6;
        this.addToVisited((UElement)expression, taintValue);
        return taintValue;
    }

    private final PsiClass getClazzFromReceiver(UResolvable expression) {
        UResolvable uResolvable = expression;
        PsiType type = uResolvable instanceof UQualifiedReferenceExpression ? ((UQualifiedReferenceExpression)expression).getReceiver().getExpressionType() : (uResolvable instanceof UCallExpression ? ((UCallExpression)expression).getReceiverType() : null);
        return PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
    }

    private final TaintValue checkAndPrepareVisited(UElement uElement, boolean prepare) {
        if (uElement == null) {
            return null;
        }
        PsiElement sourcePsi = uElement.getSourcePsi();
        if (sourcePsi != null) {
            TaintValue value = this.myVisited.get(sourcePsi);
            if (value != null) {
                return value;
            }
            if (prepare) {
                this.addToVisited(uElement, TaintValue.UNKNOWN);
            }
        }
        return null;
    }

    static /* synthetic */ TaintValue checkAndPrepareVisited$default(TaintAnalyzer taintAnalyzer, UElement uElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return taintAnalyzer.checkAndPrepareVisited(uElement, bl);
    }

    private final void addToVisited(UElement uElement, TaintValue result) {
        PsiElement sourcePsi;
        UElement uElement2 = uElement;
        Object object = sourcePsi = uElement2 != null ? uElement2.getSourcePsi() : null;
        if (sourcePsi == null) {
            return;
        }
        if (result == null) {
            this.myVisited.remove(sourcePsi);
            return;
        }
        this.myVisited.put(sourcePsi, result);
    }

    private final TaintValue fromCall(UExpression sourceExpression, AnalyzeContext sourceContext) {
        JvmModifiersOwner jvmModifiersOwner;
        TaintValue fromReceiver;
        UElement uMethod;
        Ref.ObjectRef expression = new Ref.ObjectRef();
        expression.element = sourceExpression;
        Ref.ObjectRef analyzeContext = new Ref.ObjectRef();
        analyzeContext.element = sourceContext;
        if (((AnalyzeContext)analyzeContext.element).getProcessOnlyConstant()) {
            return null;
        }
        if (!((AnalyzeContext)analyzeContext.element).getCollectReferences()) {
            analyzeContext.element = ((AnalyzeContext)analyzeContext.element).notCollectMarkedByDefault();
        }
        if (expression.element instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)expression.element).getSelector() instanceof UReferenceExpression && (uMethod = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)expression.element))) instanceof UMethod) {
            boolean equalFiles = TaintAnalyzer.Companion.equalFiles((AnalyzeContext)analyzeContext.element, uMethod);
            if (this.myTaintValueFactory.getConfiguration().getProcessOuterMethodAsQualifierAndArguments() && !equalFiles && (fromReceiver = this.fromExpressionWithoutCollection(((UQualifiedReferenceExpression)expression.element).getReceiver(), ((AnalyzeContext)analyzeContext.element).notCollectMarkedByDefault())) == TaintValue.UNTAINTED && ((UMethod)uMethod).getUastParameters().isEmpty()) {
                return fromReceiver;
            }
        }
        if (expression.element instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)expression.element).getSelector() instanceof UCallExpression) {
            expression.element = ((UQualifiedReferenceExpression)expression.element).getSelector();
        }
        if (expression.element instanceof UArrayAccessExpression) {
            ((AnalyzeContext)analyzeContext.element).checkInside(1 + ((UArrayAccessExpression)expression.element).getIndices().size());
            TaintValue result = null;
            result = this.fromExpressionWithoutCollection(((UArrayAccessExpression)expression.element).getReceiver(), (AnalyzeContext)analyzeContext.element);
            Iterable $this$forEach$iv = ((UArrayAccessExpression)expression.element).getIndices();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UExpression it = (UExpression)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)result.joinUntil(((AnalyzeContext)analyzeContext.element).getUntilTaintValue(), () -> TaintAnalyzer.fromCall$lambda$2$lambda$1(this, it, analyzeContext))), (String)"joinUntil(...)");
            }
            return result;
        }
        if (!(expression.element instanceof UCallExpression)) {
            return null;
        }
        uMethod = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)expression.element));
        if (uMethod instanceof UMethod && TaintAnalyzer.Companion.equalFiles((AnalyzeContext)analyzeContext.element, uMethod) && !((UMethod)uMethod).isConstructor() && !((AnalyzeContext)analyzeContext.element).getProcessInnerMethodAsQualifierAndArguments()) {
            JvmModifiersOwner jvmModifiersOwner2 = (JvmModifiersOwner)uMethod;
            fromReceiver = this.fromExpressionWithoutCollection(((UCallExpression)expression.element).getReceiver(), (AnalyzeContext)analyzeContext.element);
            if (fromReceiver == TaintValue.UNTAINTED && (jvmModifiersOwner2.hasModifier(JvmModifier.FINAL) || jvmModifiersOwner2.hasModifier(JvmModifier.STATIC) || jvmModifiersOwner2.hasModifier(JvmModifier.PRIVATE))) {
                return this.analyzeMethod((UMethod)uMethod, (AnalyzeContext)analyzeContext.element, this.getNotEmptyParameters((UMethod)uMethod, (UCallExpression)expression.element, (AnalyzeContext)analyzeContext.element));
            }
            if (((AnalyzeContext)analyzeContext.element).getCollectReferences()) {
                this.analyzeMethod((UMethod)uMethod, ((AnalyzeContext)analyzeContext.element).notCollectReferences().notCheckPropagationNext(), this.getEmptyParameters((UMethod)uMethod));
            }
            return TaintValue.UNKNOWN;
        }
        if (uMethod instanceof UMethod && !TaintAnalyzer.Companion.equalFiles((AnalyzeContext)analyzeContext.element, uMethod) && !TaintAnalyzer.Companion.isLibraryCode(uMethod) && (jvmModifiersOwner = (JvmModifiersOwner)uMethod).hasModifier(JvmModifier.STATIC) && ((AnalyzeContext)analyzeContext.element).getDepthOutsideMethods() > 0) {
            analyzeContext.element = ((AnalyzeContext)analyzeContext.element).withDecrementedExternalMethods();
            return this.analyzeMethod((UMethod)uMethod, (AnalyzeContext)analyzeContext.element, this.getNotEmptyParameters((UMethod)uMethod, (UCallExpression)expression.element, (AnalyzeContext)analyzeContext.element));
        }
        if (((AnalyzeContext)analyzeContext.element).getProcessOuterMethodAsQualifierAndArguments() || ((AnalyzeContext)analyzeContext.element).getProcessInnerMethodAsQualifierAndArguments()) {
            TaintValue taintValue = null;
            taintValue = TaintValue.UNTAINTED;
            if (!(uMethod instanceof JvmModifiersOwner) || !((JvmModifiersOwner)uMethod).hasModifier(JvmModifier.STATIC)) {
                TaintValue taintValue2 = taintValue.joinUntil(((AnalyzeContext)analyzeContext.element).getUntilTaintValue(), () -> TaintAnalyzer.fromCall$lambda$3(this, expression, analyzeContext));
                Intrinsics.checkNotNullExpressionValue((Object)((Object)taintValue2), (String)"joinUntil(...)");
                taintValue = taintValue2;
            }
            ((AnalyzeContext)analyzeContext.element).checkInside(((UCallExpression)expression.element).getValueArguments().size());
            Iterable $this$forEach$iv = ((UCallExpression)expression.element).getValueArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UExpression argument = (UExpression)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)taintValue.joinUntil(((AnalyzeContext)analyzeContext.element).getUntilTaintValue(), () -> TaintAnalyzer.fromCall$lambda$5$lambda$4(this, argument, analyzeContext))), (String)"joinUntil(...)");
            }
            return taintValue;
        }
        return TaintValue.UNKNOWN;
    }

    private final List<TaintValue> getNotEmptyParameters(UMethod uMethod, UCallExpression expression, AnalyzeContext analyzeContext) {
        int parameterSize = uMethod.getUastParameters().size();
        analyzeContext.checkInside(expression.getValueArguments().size());
        List values = new ArrayList();
        for (int i = 0; i < parameterSize; ++i) {
            UExpression argument = expression.getArgumentForParameter(i);
            boolean bl = argument instanceof UExpressionList ? values.add(TaintValue.UNKNOWN) : values.add(this.fromExpressionWithoutCollection(argument, analyzeContext));
        }
        return values;
    }

    @NotNull
    public final List<NonMarkedElement> getNonMarkedElements() {
        return CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)this.myNonMarkedElements));
    }

    private final TaintValue fromModifierListOwner(PsiElement sourcePsiTarget, UExpression expression, AnalyzeContext analyzeContext) {
        PsiModifierListOwner psiModifierListOwner = sourcePsiTarget instanceof PsiModifierListOwner ? (PsiModifierListOwner)sourcePsiTarget : null;
        if (psiModifierListOwner == null) {
            return null;
        }
        PsiModifierListOwner owner = psiModifierListOwner;
        TaintValue taintValue = this.fromLocalVar(expression, (PsiElement)owner, analyzeContext);
        if (taintValue != null) {
            return taintValue;
        }
        taintValue = this.fromField(expression, (PsiElement)owner, analyzeContext);
        if (taintValue == null) {
            taintValue = this.fromCall(expression, analyzeContext);
        }
        if (taintValue == null) {
            taintValue = this.fromParam(expression, (PsiElement)owner, analyzeContext);
        }
        if (taintValue == null) {
            taintValue = this.fromMethod((PsiElement)owner, analyzeContext);
        }
        this.addNonMarked(analyzeContext, taintValue, expression, owner);
        TaintValue taintValue2 = taintValue;
        if (taintValue2 == null) {
            taintValue2 = TaintValue.UNKNOWN;
        }
        return taintValue2;
    }

    private final void addNonMarked(AnalyzeContext analyzeContext, TaintValue taintValue, UExpression expression, PsiModifierListOwner owner) {
        PsiElement sourcePsi;
        if (!analyzeContext.getCollectReferences() && analyzeContext.getCollectMarkedByDefault() && (taintValue == null || taintValue == TaintValue.UNKNOWN) && (sourcePsi = expression.getSourcePsi()) != null) {
            this.myNonMarkedElements.add(new NonMarkedElement(owner, sourcePsi, analyzeContext.getCheckPropagationNext()));
        }
    }

    private final TaintValue fromLocalVar(UExpression expression, PsiElement sourceTarget, AnalyzeContext analyzeContext) {
        Object object;
        block12: {
            TaintValue taintValue;
            block11: {
                UResolvable uResolvable;
                block10: {
                    block9: {
                        if (!(sourceTarget instanceof PsiLocalVariable)) {
                            return null;
                        }
                        uResolvable = expression instanceof UResolvable ? (UResolvable)expression : null;
                        if (uResolvable == null) break block9;
                        UResolvable $this$resolveToUElementOfType$iv = uResolvable;
                        boolean $i$f$resolveToUElementOfType = false;
                        UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                        if (!(uElement instanceof ULocalVariable)) {
                            uElement = null;
                        }
                        if ((uResolvable = (ULocalVariable)((UElement)((ULocalVariable)uElement))) != null) break block10;
                    }
                    return null;
                }
                UResolvable localVariable = uResolvable;
                UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)localVariable));
                if (uMethod == null) {
                    return null;
                }
                UMethod containingMethod = uMethod;
                boolean skipAfterReference = this.possibleToSkipCheckAfterReference(expression, containingMethod);
                UExpression uInitializer = localVariable.getUastInitializer();
                taintValue = this.fromExpressionWithoutCollection(uInitializer, analyzeContext);
                UMethod uMethod2 = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)localVariable), UMethod.class, (boolean)false, (int)2, null);
                object = uMethod2;
                if (object == null) break block11;
                UMethod it = object;
                boolean bl = false;
                TaintValue taintValue2 = this.analyzeVar(taintValue, it, (UVariable)localVariable, analyzeContext, expression, skipAfterReference);
                object = taintValue2;
                if (taintValue2 != null) break block12;
            }
            object = taintValue;
        }
        return object;
    }

    private final boolean possibleToSkipCheckAfterReference(UExpression expression, UMethod containingMethod) {
        boolean checkLocalAfterUsing = true;
        for (UElement uastParent = expression.getUastParent(); uastParent != null && !Intrinsics.areEqual((Object)uastParent, (Object)containingMethod); uastParent = uastParent.getUastParent()) {
            if (!(uastParent instanceof ULambdaExpression) && !(uastParent instanceof UAnonymousClass)) continue;
            checkLocalAfterUsing = false;
            break;
        }
        return checkLocalAfterUsing;
    }

    private final TaintValue analyzeVar(TaintValue initValue, UMethod uMethod, UVariable uVariable, AnalyzeContext analyzeContext, UExpression usedReference, boolean skipAfterReference) {
        PsiElement sourcePsi = uMethod.getSourcePsi();
        if (sourcePsi == null) {
            return TaintValue.UNKNOWN;
        }
        VariableFlow variableFlow = this.getVariableFlow(sourcePsi);
        return variableFlow.process(this, initValue, uVariable, analyzeContext, usedReference, skipAfterReference, this.myTaintValueFactory).getTaintValue();
    }

    private final VariableFlow getVariableFlow(PsiElement sourcePsi) {
        Object object = CachedValuesManager.getManager((Project)sourcePsi.getProject()).getCachedValue((UserDataHolder)sourcePsi, () -> TaintAnalyzer.getVariableFlow$lambda$7(sourcePsi));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (VariableFlow)object;
    }

    /*
     * WARNING - void declaration
     */
    private final TaintValue fromParam(UExpression expression, PsiElement target, AnalyzeContext analyzeContext) {
        UBlockExpression uBlock;
        TaintValue previousValue;
        UExpression valueArgument;
        Object valueArguments;
        ULambdaExpression lambda;
        PsiElement psiElement;
        UForEachExpression forEach;
        PsiParameter psiParameter = target instanceof PsiParameter ? (PsiParameter)target : null;
        if (psiParameter == null) {
            return null;
        }
        PsiParameter psiParameter2 = psiParameter;
        UParameter uParameter = (UParameter)UastContextKt.toUElement((PsiElement)target, UParameter.class);
        if (uParameter == null) {
            return null;
        }
        UParameter uParameter2 = uParameter;
        PsiElement sourcePsi = uParameter2.getSourcePsi();
        if (expression instanceof UQualifiedReferenceExpression && analyzeContext.getProcessOuterMethodAsQualifierAndArguments()) {
            return this.fromExpressionWithoutCollection(((UQualifiedReferenceExpression)expression).getReceiver(), analyzeContext);
        }
        TaintValue taintValue = TaintValue.UNTAINTED;
        PsiElement psiElement2 = uParameter2.getSourcePsi();
        UElement uElement = UastContextKt.toUElement((PsiElement)(psiElement2 != null ? psiElement2.getParent() : null));
        UForEachExpression uForEachExpression = forEach = uElement instanceof UForEachExpression ? (UForEachExpression)uElement : null;
        if (forEach != null && uParameter2.getSourcePsi() != null) {
            UParameter uParameter3 = forEach.getParameter();
            if (Intrinsics.areEqual((Object)(uParameter3 != null ? uParameter3.getSourcePsi() : null), (Object)uParameter2.getSourcePsi())) {
                return taintValue.joinUntil(analyzeContext.getUntilTaintValue(), () -> TaintAnalyzer.fromParam$lambda$8(this, forEach, analyzeContext));
            }
        }
        UElement uElement2 = UastContextKt.toUElement((psiElement = uParameter2.getSourcePsi()) != null && (psiElement = psiElement.getParent()) != null ? psiElement.getParent() : null);
        ULambdaExpression uLambdaExpression = lambda = uElement2 instanceof ULambdaExpression ? (ULambdaExpression)uElement2 : null;
        if (lambda != null && lambda.getUastParent() instanceof UCallExpression && lambda.getSourcePsi() != null) {
            PsiElement targetPsi = lambda.getSourcePsi();
            UElement uElement3 = lambda.getUastParent();
            UCallExpression uCallExpression = uElement3 instanceof UCallExpression ? (UCallExpression)uElement3 : null;
            if (uCallExpression == null) {
                return TaintValue.TAINTED;
            }
            UCallExpression callExpression = uCallExpression;
            valueArguments = callExpression.getValueArguments();
            if (analyzeContext.getProcessOuterMethodAsQualifierAndArguments()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)valueArguments;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    UExpression uExpression = (UExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getSourcePsi());
                }
                if (((List)destination$iv$iv).contains(targetPsi)) {
                    PsiMember psiMember;
                    Object $i$f$map2 = callExpression.resolve();
                    PsiMember psiMember2 = psiMember = $i$f$map2 instanceof PsiMember ? (PsiMember)$i$f$map2 : null;
                    if (psiMember != null) {
                        Object object = psiMember.getContainingClass();
                        if (object == null || (object = object.getQualifiedName()) == null) {
                            object = "";
                        }
                        if (this.safeLambdaClass.contains(object)) {
                            TaintValue taintValue2 = taintValue.joinUntil(analyzeContext.getUntilTaintValue(), () -> TaintAnalyzer.fromParam$lambda$10(this, callExpression, analyzeContext));
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)taintValue2), (String)"joinUntil(...)");
                            taintValue = taintValue2;
                            $i$f$map2 = valueArguments.iterator();
                            while ($i$f$map2.hasNext()) {
                                valueArgument = (UExpression)$i$f$map2.next();
                                if (targetPsi != null && Intrinsics.areEqual((Object)valueArgument.getSourcePsi(), (Object)targetPsi)) continue;
                                Intrinsics.checkNotNullExpressionValue((Object)((Object)taintValue.joinUntil(analyzeContext.getUntilTaintValue(), () -> TaintAnalyzer.fromParam$lambda$11(this, valueArgument, analyzeContext))), (String)"joinUntil(...)");
                            }
                            return taintValue;
                        }
                    }
                }
            }
        }
        UMethod uMethod = (valueArguments = uParameter2.getUastParent()) instanceof UMethod ? (UMethod)valueArguments : null;
        if (uMethod == null) {
            return TaintValue.UNKNOWN;
        }
        UMethod uMethod2 = uMethod;
        PsiMethod methodJavaPsi = uMethod2.getJavaPsi();
        boolean fromInvocation = false;
        if (sourcePsi != null && (previousValue = this.myCurrentParameters.get(sourcePsi)) != null) {
            fromInvocation = true;
            taintValue = previousValue;
        }
        if (methodJavaPsi.hasModifier(JvmModifier.PRIVATE) && !fromInvocation) {
            if (analyzeContext.getParameterOfPrivateMethodIsUntainted()) {
                TaintValue taintValue3 = taintValue.join(TaintValue.UNTAINTED);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)taintValue3), (String)"join(...)");
                taintValue = taintValue3;
            } else {
                TaintValue taintValue4 = taintValue.join(TaintValue.UNKNOWN);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)taintValue4), (String)"join(...)");
                taintValue = taintValue4;
            }
        } else if (!fromInvocation) {
            TaintValue taintValue5 = taintValue.join(TaintValue.UNKNOWN);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)taintValue5), (String)"join(...)");
            taintValue = taintValue5;
        }
        UExpression uInitializer = uParameter2.getUastInitializer();
        TaintValue taintValue6 = taintValue.joinUntil(analyzeContext.getUntilTaintValue(), () -> TaintAnalyzer.fromParam$lambda$12(this, uInitializer, analyzeContext));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)taintValue6), (String)"joinUntil(...)");
        taintValue = taintValue6;
        valueArgument = uMethod2.getUastBody();
        UBlockExpression uBlockExpression = uBlock = valueArgument instanceof UBlockExpression ? (UBlockExpression)valueArgument : null;
        if (uBlock != null) {
            taintValue = this.analyzeVar(taintValue, uMethod2, (UVariable)uParameter2, analyzeContext, expression, this.possibleToSkipCheckAfterReference(expression, uMethod2));
        }
        SmartList nonMarkedElements = new SmartList();
        if (uBlock == null && analyzeContext.getCollectReferences() && taintValue != TaintValue.TAINTED) {
            nonMarkedElements.addAll(TaintAnalyzer.Companion.findAssignments((PsiElement)psiParameter2));
        }
        if (analyzeContext.getCollectReferences() && taintValue != TaintValue.TAINTED) {
            int paramIdx = uMethod2.getUastParameters().indexOf(uParameter2);
            nonMarkedElements.addAll(TaintAnalyzer.Companion.findNonMarkedArgs(methodJavaPsi, paramIdx));
        }
        this.myNonMarkedElements.addAll(CollectionsKt.filterNotNull((Iterable)((Iterable)nonMarkedElements)));
        return taintValue;
    }

    private final TaintValue fromField(UExpression expression, PsiElement target, AnalyzeContext context) {
        AnalyzeContext currentContext = context;
        UElement uElement = UastContextKt.toUElement((PsiElement)target);
        UField uField = uElement instanceof UField ? (UField)uElement : null;
        if (uField == null) {
            return null;
        }
        UField uElement2 = uField;
        if (!TaintAnalyzer.Companion.equalFiles(currentContext, (UElement)uElement2)) {
            currentContext = currentContext.withDecrementedExternalFields();
        }
        if (currentContext.getDepthOutsideFields() < 0) {
            return TaintValue.UNTAINTED;
        }
        JvmModifiersOwner jvmModifiersOwner = (JvmModifiersOwner)uElement2;
        boolean equalFiles = TaintAnalyzer.Companion.equalFiles(currentContext, (UElement)uElement2);
        if (!equalFiles && jvmModifiersOwner.hasModifier(JvmModifier.FINAL) && expression instanceof UQualifiedReferenceExpression && this.skipClass(((UQualifiedReferenceExpression)expression).getReceiver().getExpressionType())) {
            return TaintValue.UNTAINTED;
        }
        if (equalFiles) {
            boolean isImmutable;
            Object[] objectArray;
            if (currentContext.getPrivateOrFinalFieldSafe() && (jvmModifiersOwner.hasModifier(JvmModifier.PRIVATE) || jvmModifiersOwner.hasModifier(JvmModifier.FINAL))) {
                return TaintValue.UNTAINTED;
            }
            boolean bl = ClassUtils.isImmutable((PsiType)uElement2.getType()) || target instanceof PsiModifierListOwner && SetsKt.setOf((Object[])(objectArray = new Mutability[]{Mutability.UNMODIFIABLE, Mutability.UNMODIFIABLE_VIEW})).contains(Mutability.getMutability((PsiModifierListOwner)((PsiModifierListOwner)target))) ? true : (isImmutable = false);
            if (isImmutable && (jvmModifiersOwner.hasModifier(JvmModifier.FINAL) && (uElement2.getUastInitializer() != null || TaintAnalyzer.Companion.fieldAssignedOnlyWithLiterals(uElement2, currentContext)) || jvmModifiersOwner.hasModifier(JvmModifier.PRIVATE) && TaintAnalyzer.Companion.fieldAssignedOnlyWithLiterals(uElement2, currentContext))) {
                UExpression uastInitializer = uElement2.getUastInitializer();
                if (uastInitializer == null) {
                    return TaintValue.UNTAINTED;
                }
                return this.fromExpressionWithoutCollection(uElement2.getUastInitializer(), currentContext.notCheckPropagationNext());
            }
        }
        if (!equalFiles && ClassUtils.isImmutable((PsiType)uElement2.getType()) && jvmModifiersOwner.hasModifier(JvmModifier.FINAL) && jvmModifiersOwner.hasModifier(JvmModifier.STATIC)) {
            return TaintValue.UNTAINTED;
        }
        if (currentContext.getProcessOnlyConstant()) {
            return null;
        }
        if (currentContext.getCollectReferences()) {
            List children = new ArrayList();
            NonMarkedElement initializer = NonMarkedElement.create((UElement)uElement2.getUastInitializer(), currentContext.getCheckPropagationNext());
            if (initializer != null) {
                children.add(initializer);
            }
            children.addAll(TaintAnalyzer.Companion.findAssignments(target));
            this.myNonMarkedElements.addAll(CollectionsKt.filterNotNull((Iterable)children));
        }
        return TaintValue.UNKNOWN;
    }

    private final TaintValue fromMethod(PsiElement target, AnalyzeContext context) {
        AnalyzeContext analyzeContext = context;
        if (analyzeContext.getProcessOnlyConstant()) {
            return null;
        }
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)target, UMethod.class);
        if (uMethod == null) {
            return null;
        }
        UMethod uMethod2 = uMethod;
        if (!TaintAnalyzer.Companion.equalFiles(analyzeContext, (UElement)uMethod2)) {
            analyzeContext = analyzeContext.withDecrementedExternalMethods();
        }
        return this.analyzeMethod(uMethod2, analyzeContext, this.getEmptyParameters(uMethod2));
    }

    private final List<TaintValue> getEmptyParameters(UMethod uMethod) {
        List values = new ArrayList();
        List parameters = uMethod.getUastParameters();
        int n = ((Collection)parameters).size();
        for (int i = 0; i < n; ++i) {
            values.add(TaintValue.UNKNOWN);
        }
        return values;
    }

    private final TaintValue analyzeMethod(UMethod uMethod, AnalyzeContext sourceContext, List<? extends TaintValue> arguments) {
        if (!(TaintAnalyzer.Companion.equalFiles(sourceContext, (UElement)uMethod) || sourceContext.getDepthOutsideMethods() >= 0 && sourceContext.getDepthOutsideFields() >= 0)) {
            return TaintValue.UNKNOWN;
        }
        PsiElement psiElement = uMethod.getSourcePsi();
        if (psiElement == null) {
            return TaintValue.UNKNOWN;
        }
        PsiElement psiElement2 = psiElement;
        Pair key = new Pair((Object)psiElement2, arguments);
        TaintValue value = this.myVisitedMethods.get(key);
        if (value != null) {
            return value;
        }
        AnalyzeContext analyzeContext = sourceContext;
        UExpression uExpression = uMethod.getUastBody();
        UBlockExpression methodBody = uExpression instanceof UBlockExpression ? (UBlockExpression)uExpression : null;
        PsiElement psiElement3 = uMethod.getSourcePsi();
        if (psiElement3 == null) {
            return TaintValue.UNKNOWN;
        }
        PsiElement sourcePsi = psiElement3;
        if (methodBody == null) {
            TaintValue taintValue = this.fromField(null, sourcePsi, analyzeContext.withDecrementedSteps());
            TaintValue taintValue2 = taintValue;
            if (taintValue2 == null) {
                taintValue2 = TaintValue.UNKNOWN;
            }
            return taintValue2;
        }
        analyzeContext = analyzeContext.withDecrementedMethods();
        Set allReturns = TaintAnalyzer.Companion.getAllReturns(sourcePsi);
        this.myVisitedMethods.put((Pair<PsiElement, List<TaintValue>>)key, TaintValue.UNKNOWN);
        HashMap<PsiElement, TaintValue> previousVisited = new HashMap<PsiElement, TaintValue>(this.myVisited);
        HashMap<PsiElement, TaintValue> previousTemporary = new HashMap<PsiElement, TaintValue>(this.myCurrentParameters);
        if (!arguments.isEmpty()) {
            List parameters = uMethod.getUastParameters();
            int n = ((Collection)parameters).size();
            for (int i = 0; i < n; ++i) {
                PsiElement parameterSourcePsi;
                if (((UParameter)parameters.get(i)).getSourcePsi() == null || arguments.size() <= i) continue;
                this.myCurrentParameters.put(parameterSourcePsi, arguments.get(i));
            }
        }
        this.myVisited.put(psiElement2, TaintValue.UNKNOWN);
        TaintValue returnValue = this.join(allReturns, analyzeContext.withDecrementedParts(allReturns.size()));
        this.myCurrentParameters.clear();
        this.myCurrentParameters.putAll((Map<PsiElement, TaintValue>)previousTemporary);
        this.myVisited.clear();
        this.myVisited.putAll((Map<PsiElement, TaintValue>)previousVisited);
        this.myVisitedMethods.put((Pair<PsiElement, List<TaintValue>>)key, returnValue);
        return returnValue;
    }

    private final TaintValue fromExpressionWithoutCollection(UExpression uExpression, AnalyzeContext analyzeContext) {
        return this.fromExpressionInner(uExpression, analyzeContext.notCollectReferences());
    }

    /*
     * WARNING - void declaration
     */
    private final TaintValue fromExpressionInner(UExpression sourceUExpression, AnalyzeContext analyzeContext) {
        Ref.ObjectRef uExpression = new Ref.ObjectRef();
        UExpression uExpression2 = sourceUExpression;
        if (uExpression2 == null) {
            return TaintValue.UNTAINTED;
        }
        uExpression.element = uExpression2;
        if (analyzeContext.getDepthOutsideFields() < 0) {
            return TaintValue.UNKNOWN;
        }
        if (analyzeContext.getDepthOutsideMethods() < 0) {
            return TaintValue.UNKNOWN;
        }
        PsiType type = ((UExpression)uExpression.element).getExpressionType();
        if (type != null && this.skipClass(type)) {
            return TaintValue.UNTAINTED;
        }
        uExpression.element = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)uExpression.element));
        UPolyadicExpression uConcatenation = TaintAnalyzer.Companion.getConcatenation((UExpression)uExpression.element);
        if (uConcatenation != null) {
            void $this$filterTo$iv$iv;
            List operands = uConcatenation.getOperands();
            Iterable $this$filter$iv = operands;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UExpression it = (UExpression)element$iv$iv;
                boolean bl = false;
                if (!(!(it instanceof ULiteralExpression) && !(it instanceof UPolyadicExpression))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int size = ((List)destination$iv$iv).size();
            return this.withCache((UExpression)uExpression.element, (Function0<? extends TaintValue>)((Function0)() -> TaintAnalyzer.fromExpressionInner$lambda$14(this, operands, analyzeContext, size)));
        }
        UExpression uExpression3 = (UExpression)uExpression.element;
        if (uExpression3 instanceof UUnknownExpression) {
            return TaintValue.UNKNOWN;
        }
        if (uExpression3 instanceof UThisExpression) {
            return TaintValue.UNTAINTED;
        }
        if (uExpression3 instanceof ULiteralExpression) {
            return TaintValue.UNTAINTED;
        }
        if (uExpression3 instanceof ULambdaExpression) {
            return TaintValue.UNKNOWN;
        }
        if (uExpression3 instanceof UClassLiteralExpression) {
            return TaintValue.UNTAINTED;
        }
        if (uExpression3 instanceof UBinaryExpressionWithType) {
            return this.withCache((UExpression)uExpression.element, (Function0<? extends TaintValue>)((Function0)() -> TaintAnalyzer.fromExpressionInner$lambda$15(this, uExpression, analyzeContext)));
        }
        if (uExpression3 instanceof UResolvable) {
            if (uExpression.element instanceof UPostfixExpression && Intrinsics.areEqual((Object)((UPostfixExpression)uExpression.element).getOperator().getText(), (Object)"!!")) {
                return this.withCache((UExpression)uExpression.element, (Function0<? extends TaintValue>)((Function0)() -> TaintAnalyzer.fromExpressionInner$lambda$16(this, uExpression, analyzeContext)));
            }
            return this.withCache((UExpression)uExpression.element, (Function0<? extends TaintValue>)((Function0)() -> TaintAnalyzer.fromExpressionInner$lambda$17(this, uExpression, analyzeContext)));
        }
        if (uExpression3 instanceof UUnaryExpression) {
            return this.withCache((UExpression)uExpression.element, (Function0<? extends TaintValue>)((Function0)() -> TaintAnalyzer.fromExpressionInner$lambda$18(this, uExpression, analyzeContext)));
        }
        if (uExpression3 instanceof UBinaryExpression) {
            return this.withCache((UExpression)uExpression.element, (Function0<? extends TaintValue>)((Function0)() -> TaintAnalyzer.fromExpressionInner$lambda$19(this, uExpression, analyzeContext)));
        }
        if (uExpression3 instanceof ULabeledExpression) {
            return this.withCache((UExpression)uExpression.element, (Function0<? extends TaintValue>)((Function0)() -> TaintAnalyzer.fromExpressionInner$lambda$20(this, uExpression, analyzeContext)));
        }
        if (uExpression3 instanceof UIfExpression || uExpression3 instanceof USwitchExpression || uExpression3 instanceof UBlockExpression) {
            if (uExpression.element instanceof UIfExpression) {
                UExpression condition = ((UIfExpression)uExpression.element).getCondition();
                Object value = TaintAnalyzerKt.access$getConstant(condition);
                UExpression thenExpression = ((UIfExpression)uExpression.element).getThenExpression();
                UExpression elseExpression = ((UIfExpression)uExpression.element).getElseExpression();
                if (Intrinsics.areEqual((Object)value, (Object)true) && thenExpression != null) {
                    return this.withCache(thenExpression, (Function0<? extends TaintValue>)((Function0)() -> TaintAnalyzer.fromExpressionInner$lambda$21(this, thenExpression, analyzeContext)));
                }
                if (Intrinsics.areEqual((Object)value, (Object)false) && elseExpression != null) {
                    return this.withCache(elseExpression, (Function0<? extends TaintValue>)((Function0)() -> TaintAnalyzer.fromExpressionInner$lambda$22(this, elseExpression, analyzeContext)));
                }
            }
            return this.withCache((UExpression)uExpression.element, (Function0<? extends TaintValue>)((Function0)() -> TaintAnalyzer.fromExpressionInner$lambda$23(uExpression, this, analyzeContext)));
        }
        return TaintValue.UNKNOWN;
    }

    private final TaintValue withCache(UExpression uExpression, Function0<? extends TaintValue> block) {
        TaintValue visited = this.checkAndPrepareVisited((UElement)uExpression, false);
        if (visited != null) {
            return visited;
        }
        TaintValue taintValue = (TaintValue)((Object)block.invoke());
        this.addToVisited((UElement)uExpression, taintValue);
        return taintValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean skipClass(PsiType type) {
        boolean bl;
        if (type == null) {
            return false;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        if (this.skipClasses.contains(type.getCanonicalText())) return true;
        Iterable $this$any$iv = this.skipClasses;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                String cl = (String)element$iv;
                boolean bl2 = false;
                if (cl != null && InheritanceUtil.isInheritor((PsiType)type, (String)cl)) {
                    return true;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (aClass == null) return false;
        if (aClass.isAnnotationType()) return true;
        if (!aClass.isEnum()) return false;
        return true;
    }

    private final TaintValue join(Iterable<? extends UExpression> $this$join, AnalyzeContext analyzeContext) {
        TaintValue result = null;
        result = TaintValue.UNTAINTED;
        Iterable<? extends UExpression> $this$forEach$iv = $this$join;
        boolean $i$f$forEach = false;
        Iterator<? extends UExpression> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            UExpression element$iv;
            UExpression it = element$iv = iterator.next();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)result.joinUntil(analyzeContext.getUntilTaintValue(), () -> TaintAnalyzer.join$lambda$26$lambda$25(this, it, analyzeContext))), (String)"joinUntil(...)");
        }
        return result;
    }

    @JvmOverloads
    @NotNull
    public final TaintValue analyzeExpression(@NotNull UExpression expression, boolean collectOuterUsages) throws DeepTaintAnalyzerException {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return TaintAnalyzer.analyzeExpression$default(this, expression, collectOuterUsages, null, 4, null);
    }

    private static final TaintValue analyzeInner$lambda$0(TaintAnalyzer this$0, UForEachExpression $uForEachExpression, AnalyzeContext $analyzeContext) {
        return this$0.fromExpressionWithoutCollection($uForEachExpression.getIteratedValue(), $analyzeContext);
    }

    private static final TaintValue fromCall$lambda$2$lambda$1(TaintAnalyzer this$0, UExpression $it, Ref.ObjectRef $analyzeContext) {
        return this$0.fromExpressionWithoutCollection($it, (AnalyzeContext)$analyzeContext.element);
    }

    private static final TaintValue fromCall$lambda$3(TaintAnalyzer this$0, Ref.ObjectRef $expression, Ref.ObjectRef $analyzeContext) {
        return this$0.fromExpressionWithoutCollection(((UCallExpression)$expression.element).getReceiver(), (AnalyzeContext)$analyzeContext.element);
    }

    private static final TaintValue fromCall$lambda$5$lambda$4(TaintAnalyzer this$0, UExpression $argument, Ref.ObjectRef $analyzeContext) {
        return this$0.fromExpressionWithoutCollection($argument, (AnalyzeContext)$analyzeContext.element);
    }

    private static final CachedValueProvider.Result getVariableFlow$lambda$7(PsiElement $sourcePsi) {
        UElement uElement = UastContextKt.toUElement((PsiElement)$sourcePsi);
        UMethod method = uElement instanceof UMethod ? (UMethod)uElement : null;
        Companion.FlowVisitor visitor2 = new Companion.FlowVisitor();
        UMethod uMethod = method;
        if (uMethod != null && (uMethod = uMethod.getUastBody()) != null) {
            uMethod.accept((UastVisitor)visitor2);
        }
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)visitor2.getFlow(), (Object[])objectArray);
    }

    private static final TaintValue fromParam$lambda$8(TaintAnalyzer this$0, UForEachExpression $forEach, AnalyzeContext $analyzeContext) {
        return this$0.fromExpressionWithoutCollection($forEach.getIteratedValue(), $analyzeContext);
    }

    private static final TaintValue fromParam$lambda$10(TaintAnalyzer this$0, UCallExpression $callExpression, AnalyzeContext $analyzeContext) {
        return this$0.fromExpressionWithoutCollection($callExpression.getReceiver(), $analyzeContext);
    }

    private static final TaintValue fromParam$lambda$11(TaintAnalyzer this$0, UExpression $valueArgument, AnalyzeContext $analyzeContext) {
        return this$0.fromExpressionWithoutCollection($valueArgument, $analyzeContext);
    }

    private static final TaintValue fromParam$lambda$12(TaintAnalyzer this$0, UExpression $uInitializer, AnalyzeContext $analyzeContext) {
        return this$0.fromExpressionWithoutCollection($uInitializer, $analyzeContext);
    }

    private static final TaintValue fromExpressionInner$lambda$14(TaintAnalyzer this$0, List $operands, AnalyzeContext $analyzeContext, int $size) {
        return this$0.join($operands, $analyzeContext.withDecrementedParts($size));
    }

    private static final TaintValue fromExpressionInner$lambda$15(TaintAnalyzer this$0, Ref.ObjectRef $uExpression, AnalyzeContext $analyzeContext) {
        return this$0.fromExpressionWithoutCollection(((UBinaryExpressionWithType)$uExpression.element).getOperand(), $analyzeContext.withDecrementedParts());
    }

    private static final TaintValue fromExpressionInner$lambda$16(TaintAnalyzer this$0, Ref.ObjectRef $uExpression, AnalyzeContext $analyzeContext) {
        return this$0.fromExpressionWithoutCollection(((UUnaryExpression)$uExpression.element).getOperand(), $analyzeContext.withDecrementedParts());
    }

    private static final TaintValue fromExpressionInner$lambda$17(TaintAnalyzer this$0, Ref.ObjectRef $uExpression, AnalyzeContext $analyzeContext) {
        return this$0.analyzeInner((UExpression)$uExpression.element, $analyzeContext.withDecrementedSteps());
    }

    private static final TaintValue fromExpressionInner$lambda$18(TaintAnalyzer this$0, Ref.ObjectRef $uExpression, AnalyzeContext $analyzeContext) {
        return this$0.fromExpressionWithoutCollection(((UUnaryExpression)$uExpression.element).getOperand(), $analyzeContext.withDecrementedParts());
    }

    private static final TaintValue fromExpressionInner$lambda$19(TaintAnalyzer this$0, Ref.ObjectRef $uExpression, AnalyzeContext $analyzeContext) {
        Object[] objectArray = new UExpression[]{((UBinaryExpression)$uExpression.element).getLeftOperand(), ((UBinaryExpression)$uExpression.element).getRightOperand()};
        return this$0.join(SetsKt.setOf((Object[])objectArray), $analyzeContext.withDecrementedParts(2));
    }

    private static final TaintValue fromExpressionInner$lambda$20(TaintAnalyzer this$0, Ref.ObjectRef $uExpression, AnalyzeContext $analyzeContext) {
        return this$0.fromExpressionWithoutCollection(((ULabeledExpression)$uExpression.element).getExpression(), $analyzeContext.withDecrementedParts());
    }

    private static final TaintValue fromExpressionInner$lambda$21(TaintAnalyzer this$0, UExpression $thenExpression, AnalyzeContext $analyzeContext) {
        return this$0.fromExpressionWithoutCollection($thenExpression, $analyzeContext.withDecrementedParts());
    }

    private static final TaintValue fromExpressionInner$lambda$22(TaintAnalyzer this$0, UExpression $elseExpression, AnalyzeContext $analyzeContext) {
        return this$0.fromExpressionWithoutCollection($elseExpression, $analyzeContext.withDecrementedParts());
    }

    private static final TaintValue fromExpressionInner$lambda$23(Ref.ObjectRef $uExpression, TaintAnalyzer this$0, AnalyzeContext $analyzeContext) {
        List nonStructuralChildren = UastUtils.nonStructuralChildren((UExpression)((UExpression)$uExpression.element)).toList();
        Intrinsics.checkNotNull(nonStructuralChildren);
        return this$0.join(CollectionsKt.filterNotNull((Iterable)nonStructuralChildren), $analyzeContext.withDecrementedParts(nonStructuralChildren.size()));
    }

    private static final TaintValue join$lambda$26$lambda$25(TaintAnalyzer this$0, UExpression $it, AnalyzeContext $analyzeContext) {
        return this$0.fromExpressionWithoutCollection($it, $analyzeContext);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 H2\u00020\u0001:\u0001HB\u007f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0003\u0012\u0006\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0006\u0010(\u001a\u00020\u0000J\u0006\u0010)\u001a\u00020\u0000J\u0006\u0010*\u001a\u00020\u0000J\u0006\u0010+\u001a\u00020\u0000J\u0006\u0010,\u001a\u00020\u0000J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u000bJ\u0006\u0010.\u001a\u00020\u0000J\u0006\u0010/\u001a\u00020\u0000J\u0006\u00100\u001a\u00020\u0000J\u000e\u00101\u001a\u0002022\u0006\u0010-\u001a\u00020\u000bJ\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0006H\u00c6\u0003J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0003H\u00c6\u0003J\t\u00109\u001a\u00020\u000bH\u00c6\u0003J\t\u0010:\u001a\u00020\u000bH\u00c6\u0003J\t\u0010;\u001a\u00020\u000eH\u00c2\u0003J\t\u0010<\u001a\u00020\u000bH\u00c2\u0003J\t\u0010=\u001a\u00020\u000bH\u00c2\u0003J\t\u0010>\u001a\u00020\u0003H\u00c6\u0003J\t\u0010?\u001a\u00020\u0013H\u00c6\u0003J\t\u0010@\u001a\u00020\u0003H\u00c6\u0003J\t\u0010A\u001a\u00020\u0003H\u00c6\u0003J\u009f\u0001\u0010B\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00032\b\b\u0002\u0010\u0015\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010C\u001a\u00020\u00032\b\u0010D\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010E\u001a\u00020\u000bH\u00d6\u0001J\t\u0010F\u001a\u00020GH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0019R\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0019\u00a8\u0006I"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$AnalyzeContext;", "", "processOuterMethodAsQualifierAndArguments", "", "processInnerMethodAsQualifierAndArguments", "file", "Lorg/jetbrains/uast/UFile;", "collectReferences", "collectMarkedByDefault", "processOnlyConstant", "depthOutsideFields", "", "depthOutsideMethods", "parts", "Ljava/util/concurrent/atomic/AtomicInteger;", "inside", "depthNestedMethods", "checkPropagationNext", "untilTaintValue", "Lcom/intellij/codeInspection/sourceToSink/TaintValue;", "parameterOfPrivateMethodIsUntainted", "privateOrFinalFieldSafe", "<init>", "(ZZLorg/jetbrains/uast/UFile;ZZZIILjava/util/concurrent/atomic/AtomicInteger;IIZLcom/intellij/codeInspection/sourceToSink/TaintValue;ZZ)V", "getProcessOuterMethodAsQualifierAndArguments", "()Z", "getProcessInnerMethodAsQualifierAndArguments", "getFile", "()Lorg/jetbrains/uast/UFile;", "getCollectReferences", "getCollectMarkedByDefault", "getProcessOnlyConstant", "getDepthOutsideFields", "()I", "getDepthOutsideMethods", "getCheckPropagationNext", "getUntilTaintValue", "()Lcom/intellij/codeInspection/sourceToSink/TaintValue;", "getParameterOfPrivateMethodIsUntainted", "getPrivateOrFinalFieldSafe", "withDecrementedMethods", "withDecrementedParts", "withDecrementedSteps", "withDecrementedExternalFields", "withDecrementedExternalMethods", "size", "notCollectReferences", "notCollectMarkedByDefault", "notCheckPropagationNext", "checkInside", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "intellij.jvm.analysis.impl"})
    private static final class AnalyzeContext {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean processOuterMethodAsQualifierAndArguments;
        private final boolean processInnerMethodAsQualifierAndArguments;
        @NotNull
        private final UFile file;
        private final boolean collectReferences;
        private final boolean collectMarkedByDefault;
        private final boolean processOnlyConstant;
        private final int depthOutsideFields;
        private final int depthOutsideMethods;
        @NotNull
        private final AtomicInteger parts;
        private final int inside;
        private final int depthNestedMethods;
        private final boolean checkPropagationNext;
        @NotNull
        private final TaintValue untilTaintValue;
        private final boolean parameterOfPrivateMethodIsUntainted;
        private final boolean privateOrFinalFieldSafe;

        public AnalyzeContext(boolean processOuterMethodAsQualifierAndArguments, boolean processInnerMethodAsQualifierAndArguments, @NotNull UFile file, boolean collectReferences, boolean collectMarkedByDefault, boolean processOnlyConstant, int depthOutsideFields, int depthOutsideMethods, @NotNull AtomicInteger parts, int inside, int depthNestedMethods, boolean checkPropagationNext, @NotNull TaintValue untilTaintValue, boolean parameterOfPrivateMethodIsUntainted, boolean privateOrFinalFieldSafe) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
            Intrinsics.checkNotNullParameter((Object)((Object)untilTaintValue), (String)"untilTaintValue");
            this.processOuterMethodAsQualifierAndArguments = processOuterMethodAsQualifierAndArguments;
            this.processInnerMethodAsQualifierAndArguments = processInnerMethodAsQualifierAndArguments;
            this.file = file;
            this.collectReferences = collectReferences;
            this.collectMarkedByDefault = collectMarkedByDefault;
            this.processOnlyConstant = processOnlyConstant;
            this.depthOutsideFields = depthOutsideFields;
            this.depthOutsideMethods = depthOutsideMethods;
            this.parts = parts;
            this.inside = inside;
            this.depthNestedMethods = depthNestedMethods;
            this.checkPropagationNext = checkPropagationNext;
            this.untilTaintValue = untilTaintValue;
            this.parameterOfPrivateMethodIsUntainted = parameterOfPrivateMethodIsUntainted;
            this.privateOrFinalFieldSafe = privateOrFinalFieldSafe;
        }

        public final boolean getProcessOuterMethodAsQualifierAndArguments() {
            return this.processOuterMethodAsQualifierAndArguments;
        }

        public final boolean getProcessInnerMethodAsQualifierAndArguments() {
            return this.processInnerMethodAsQualifierAndArguments;
        }

        @NotNull
        public final UFile getFile() {
            return this.file;
        }

        public final boolean getCollectReferences() {
            return this.collectReferences;
        }

        public final boolean getCollectMarkedByDefault() {
            return this.collectMarkedByDefault;
        }

        public final boolean getProcessOnlyConstant() {
            return this.processOnlyConstant;
        }

        public final int getDepthOutsideFields() {
            return this.depthOutsideFields;
        }

        public final int getDepthOutsideMethods() {
            return this.depthOutsideMethods;
        }

        public final boolean getCheckPropagationNext() {
            return this.checkPropagationNext;
        }

        @NotNull
        public final TaintValue getUntilTaintValue() {
            return this.untilTaintValue;
        }

        public final boolean getParameterOfPrivateMethodIsUntainted() {
            return this.parameterOfPrivateMethodIsUntainted;
        }

        public final boolean getPrivateOrFinalFieldSafe() {
            return this.privateOrFinalFieldSafe;
        }

        @NotNull
        public final AnalyzeContext withDecrementedMethods() {
            int depth = this.depthNestedMethods - 1;
            if (depth < 0) {
                throw new DeepTaintAnalyzerException();
            }
            return AnalyzeContext.copy$default(this, false, false, null, false, false, false, 0, 0, null, 0, depth, false, null, false, false, 31743, null);
        }

        @NotNull
        public final AnalyzeContext withDecrementedParts() {
            int depth = this.parts.decrementAndGet();
            if (depth < 0) {
                throw new DeepTaintAnalyzerException();
            }
            return this;
        }

        @NotNull
        public final AnalyzeContext withDecrementedSteps() {
            if (this.inside < 0) {
                throw new DeepTaintAnalyzerException();
            }
            return AnalyzeContext.copy$default(this, false, false, null, false, false, false, 0, 0, null, this.inside - 1, 0, false, null, false, false, 32255, null);
        }

        @NotNull
        public final AnalyzeContext withDecrementedExternalFields() {
            return AnalyzeContext.copy$default(this, false, false, null, false, false, false, this.depthOutsideFields - 1, 0, null, 0, 0, false, null, false, false, 32703, null);
        }

        @NotNull
        public final AnalyzeContext withDecrementedExternalMethods() {
            return AnalyzeContext.copy$default(this, false, false, null, false, false, false, 0, this.depthOutsideMethods - 1, null, 0, 0, false, null, false, false, 32639, null);
        }

        @NotNull
        public final AnalyzeContext withDecrementedParts(int size) {
            int previous = this.parts.get();
            int next = previous - size;
            this.parts.set(next);
            if (next < 0) {
                throw new DeepTaintAnalyzerException();
            }
            return this;
        }

        @NotNull
        public final AnalyzeContext notCollectReferences() {
            if (this.collectReferences) {
                return AnalyzeContext.copy$default(this, false, false, null, false, false, false, 0, 0, null, 0, 0, false, null, false, false, 32759, null);
            }
            return this;
        }

        @NotNull
        public final AnalyzeContext notCollectMarkedByDefault() {
            if (this.collectMarkedByDefault) {
                return AnalyzeContext.copy$default(this, false, false, null, false, false, false, 0, 0, null, 0, 0, false, null, false, false, 32751, null);
            }
            return this;
        }

        @NotNull
        public final AnalyzeContext notCheckPropagationNext() {
            if (this.checkPropagationNext) {
                return AnalyzeContext.copy$default(this, false, false, null, false, false, false, 0, 0, null, 0, 0, false, null, false, false, 30719, null);
            }
            return this;
        }

        public final void checkInside(int size) {
            if (this.parts.get() - size < 0) {
                throw new DeepTaintAnalyzerException();
            }
        }

        public final boolean component1() {
            return this.processOuterMethodAsQualifierAndArguments;
        }

        public final boolean component2() {
            return this.processInnerMethodAsQualifierAndArguments;
        }

        @NotNull
        public final UFile component3() {
            return this.file;
        }

        public final boolean component4() {
            return this.collectReferences;
        }

        public final boolean component5() {
            return this.collectMarkedByDefault;
        }

        public final boolean component6() {
            return this.processOnlyConstant;
        }

        public final int component7() {
            return this.depthOutsideFields;
        }

        public final int component8() {
            return this.depthOutsideMethods;
        }

        private final AtomicInteger component9() {
            return this.parts;
        }

        private final int component10() {
            return this.inside;
        }

        private final int component11() {
            return this.depthNestedMethods;
        }

        public final boolean component12() {
            return this.checkPropagationNext;
        }

        @NotNull
        public final TaintValue component13() {
            return this.untilTaintValue;
        }

        public final boolean component14() {
            return this.parameterOfPrivateMethodIsUntainted;
        }

        public final boolean component15() {
            return this.privateOrFinalFieldSafe;
        }

        @NotNull
        public final AnalyzeContext copy(boolean processOuterMethodAsQualifierAndArguments, boolean processInnerMethodAsQualifierAndArguments, @NotNull UFile file, boolean collectReferences, boolean collectMarkedByDefault, boolean processOnlyConstant, int depthOutsideFields, int depthOutsideMethods, @NotNull AtomicInteger parts, int inside, int depthNestedMethods, boolean checkPropagationNext, @NotNull TaintValue untilTaintValue, boolean parameterOfPrivateMethodIsUntainted, boolean privateOrFinalFieldSafe) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
            Intrinsics.checkNotNullParameter((Object)((Object)untilTaintValue), (String)"untilTaintValue");
            return new AnalyzeContext(processOuterMethodAsQualifierAndArguments, processInnerMethodAsQualifierAndArguments, file, collectReferences, collectMarkedByDefault, processOnlyConstant, depthOutsideFields, depthOutsideMethods, parts, inside, depthNestedMethods, checkPropagationNext, untilTaintValue, parameterOfPrivateMethodIsUntainted, privateOrFinalFieldSafe);
        }

        public static /* synthetic */ AnalyzeContext copy$default(AnalyzeContext analyzeContext, boolean bl, boolean bl2, UFile uFile, boolean bl3, boolean bl4, boolean bl5, int n, int n2, AtomicInteger atomicInteger, int n3, int n4, boolean bl6, TaintValue taintValue, boolean bl7, boolean bl8, int n5, Object object) {
            if ((n5 & 1) != 0) {
                bl = analyzeContext.processOuterMethodAsQualifierAndArguments;
            }
            if ((n5 & 2) != 0) {
                bl2 = analyzeContext.processInnerMethodAsQualifierAndArguments;
            }
            if ((n5 & 4) != 0) {
                uFile = analyzeContext.file;
            }
            if ((n5 & 8) != 0) {
                bl3 = analyzeContext.collectReferences;
            }
            if ((n5 & 0x10) != 0) {
                bl4 = analyzeContext.collectMarkedByDefault;
            }
            if ((n5 & 0x20) != 0) {
                bl5 = analyzeContext.processOnlyConstant;
            }
            if ((n5 & 0x40) != 0) {
                n = analyzeContext.depthOutsideFields;
            }
            if ((n5 & 0x80) != 0) {
                n2 = analyzeContext.depthOutsideMethods;
            }
            if ((n5 & 0x100) != 0) {
                atomicInteger = analyzeContext.parts;
            }
            if ((n5 & 0x200) != 0) {
                n3 = analyzeContext.inside;
            }
            if ((n5 & 0x400) != 0) {
                n4 = analyzeContext.depthNestedMethods;
            }
            if ((n5 & 0x800) != 0) {
                bl6 = analyzeContext.checkPropagationNext;
            }
            if ((n5 & 0x1000) != 0) {
                taintValue = analyzeContext.untilTaintValue;
            }
            if ((n5 & 0x2000) != 0) {
                bl7 = analyzeContext.parameterOfPrivateMethodIsUntainted;
            }
            if ((n5 & 0x4000) != 0) {
                bl8 = analyzeContext.privateOrFinalFieldSafe;
            }
            return analyzeContext.copy(bl, bl2, uFile, bl3, bl4, bl5, n, n2, atomicInteger, n3, n4, bl6, taintValue, bl7, bl8);
        }

        @NotNull
        public String toString() {
            return "AnalyzeContext(processOuterMethodAsQualifierAndArguments=" + this.processOuterMethodAsQualifierAndArguments + ", processInnerMethodAsQualifierAndArguments=" + this.processInnerMethodAsQualifierAndArguments + ", file=" + this.file + ", collectReferences=" + this.collectReferences + ", collectMarkedByDefault=" + this.collectMarkedByDefault + ", processOnlyConstant=" + this.processOnlyConstant + ", depthOutsideFields=" + this.depthOutsideFields + ", depthOutsideMethods=" + this.depthOutsideMethods + ", parts=" + this.parts + ", inside=" + this.inside + ", depthNestedMethods=" + this.depthNestedMethods + ", checkPropagationNext=" + this.checkPropagationNext + ", untilTaintValue=" + this.untilTaintValue + ", parameterOfPrivateMethodIsUntainted=" + this.parameterOfPrivateMethodIsUntainted + ", privateOrFinalFieldSafe=" + this.privateOrFinalFieldSafe + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.processOuterMethodAsQualifierAndArguments);
            result = result * 31 + Boolean.hashCode(this.processInnerMethodAsQualifierAndArguments);
            result = result * 31 + this.file.hashCode();
            result = result * 31 + Boolean.hashCode(this.collectReferences);
            result = result * 31 + Boolean.hashCode(this.collectMarkedByDefault);
            result = result * 31 + Boolean.hashCode(this.processOnlyConstant);
            result = result * 31 + Integer.hashCode(this.depthOutsideFields);
            result = result * 31 + Integer.hashCode(this.depthOutsideMethods);
            result = result * 31 + this.parts.hashCode();
            result = result * 31 + Integer.hashCode(this.inside);
            result = result * 31 + Integer.hashCode(this.depthNestedMethods);
            result = result * 31 + Boolean.hashCode(this.checkPropagationNext);
            result = result * 31 + this.untilTaintValue.hashCode();
            result = result * 31 + Boolean.hashCode(this.parameterOfPrivateMethodIsUntainted);
            result = result * 31 + Boolean.hashCode(this.privateOrFinalFieldSafe);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnalyzeContext)) {
                return false;
            }
            AnalyzeContext analyzeContext = (AnalyzeContext)other;
            if (this.processOuterMethodAsQualifierAndArguments != analyzeContext.processOuterMethodAsQualifierAndArguments) {
                return false;
            }
            if (this.processInnerMethodAsQualifierAndArguments != analyzeContext.processInnerMethodAsQualifierAndArguments) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)analyzeContext.file)) {
                return false;
            }
            if (this.collectReferences != analyzeContext.collectReferences) {
                return false;
            }
            if (this.collectMarkedByDefault != analyzeContext.collectMarkedByDefault) {
                return false;
            }
            if (this.processOnlyConstant != analyzeContext.processOnlyConstant) {
                return false;
            }
            if (this.depthOutsideFields != analyzeContext.depthOutsideFields) {
                return false;
            }
            if (this.depthOutsideMethods != analyzeContext.depthOutsideMethods) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parts, (Object)analyzeContext.parts)) {
                return false;
            }
            if (this.inside != analyzeContext.inside) {
                return false;
            }
            if (this.depthNestedMethods != analyzeContext.depthNestedMethods) {
                return false;
            }
            if (this.checkPropagationNext != analyzeContext.checkPropagationNext) {
                return false;
            }
            if (this.untilTaintValue != analyzeContext.untilTaintValue) {
                return false;
            }
            if (this.parameterOfPrivateMethodIsUntainted != analyzeContext.parameterOfPrivateMethodIsUntainted) {
                return false;
            }
            return this.privateOrFinalFieldSafe == analyzeContext.privateOrFinalFieldSafe;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jx\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$AnalyzeContext$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$AnalyzeContext;", "processOuterMethodAsQualifierAndArguments", "", "processInnerMethodAsQualifierAndArguments", "file", "Lorg/jetbrains/uast/UFile;", "collectReferences", "processOnlyConstant", "depthOutsideFields", "", "depthOutsideMethods", "parts", "depthInside", "depthNestedMethods", "next", "untilTaintValue", "Lcom/intellij/codeInspection/sourceToSink/TaintValue;", "parameterOfPrivateMethodIsUntainted", "privateOrFinalFieldSafe", "intellij.jvm.analysis.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final AnalyzeContext create(boolean processOuterMethodAsQualifierAndArguments, boolean processInnerMethodAsQualifierAndArguments, @NotNull UFile file, boolean collectReferences, boolean processOnlyConstant, int depthOutsideFields, int depthOutsideMethods, int parts, int depthInside, int depthNestedMethods, boolean next, @NotNull TaintValue untilTaintValue, boolean parameterOfPrivateMethodIsUntainted, boolean privateOrFinalFieldSafe) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)((Object)untilTaintValue), (String)"untilTaintValue");
                AtomicInteger atomicInteger = new AtomicInteger(parts);
                return new AnalyzeContext(processOuterMethodAsQualifierAndArguments, processInnerMethodAsQualifierAndArguments, file, collectReferences, true, processOnlyConstant, depthOutsideFields, depthOutsideMethods, atomicInteger, depthInside, depthNestedMethods, next, untilTaintValue, parameterOfPrivateMethodIsUntainted, privateOrFinalFieldSafe);
            }

            public static /* synthetic */ AnalyzeContext create$default(Companion companion, boolean bl, boolean bl2, UFile uFile, boolean bl3, boolean bl4, int n, int n2, int n3, int n4, int n5, boolean bl5, TaintValue taintValue, boolean bl6, boolean bl7, int n6, Object object) {
                if ((n6 & 0x40) != 0) {
                    n2 = 0;
                }
                return companion.create(bl, bl2, uFile, bl3, bl4, n, n2, n3, n4, n5, bl5, taintValue, bl6, bl7);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u001a\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0006H\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$Companion;", "", "<init>", "()V", "getAllReturns", "", "Lorg/jetbrains/uast/UExpression;", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "equalFiles", "", "analyzeContext", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$AnalyzeContext;", "element", "Lorg/jetbrains/uast/UElement;", "isLibraryCode", "fieldAssignedOnlyWithLiterals", "field", "Lorg/jetbrains/uast/UField;", "findNonMarkedArgs", "", "Lcom/intellij/codeInspection/sourceToSink/NonMarkedElement;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "paramIdx", "", "findArgs", "findAssignments", "target", "isLhs", "uBinary", "Lorg/jetbrains/uast/UBinaryExpression;", "getConcatenation", "Lorg/jetbrains/uast/UPolyadicExpression;", "uExpression", "FlowVisitor", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nTaintAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaintAnalyzer.kt\ncom/intellij/codeInspection/sourceToSink/TaintAnalyzer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1218:1\n2746#2,3:1219\n1617#2,9:1222\n1869#2:1231\n1870#2:1233\n1626#2:1234\n1563#2:1235\n1634#2,3:1236\n1#3:1232\n*S KotlinDebug\n*F\n+ 1 TaintAnalyzer.kt\ncom/intellij/codeInspection/sourceToSink/TaintAnalyzer$Companion\n*L\n1013#1:1219,3\n1020#1:1222,9\n1020#1:1231\n1020#1:1233\n1020#1:1234\n1003#1:1235\n1003#1:1236,3\n1020#1:1232\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<UExpression> getAllReturns(PsiElement sourcePsi) {
            Object object = CachedValuesManager.getManager((Project)sourcePsi.getProject()).getCachedValue((UserDataHolder)sourcePsi, () -> Companion.getAllReturns$lambda$0(sourcePsi));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (Set)object;
        }

        private final boolean equalFiles(AnalyzeContext analyzeContext, UElement element) {
            UFile file = UastUtils.getContainingUFile((UElement)element);
            return file != null && Intrinsics.areEqual((Object)analyzeContext.getFile().getSourcePsi(), (Object)file.getSourcePsi());
        }

        private final boolean isLibraryCode(UElement element) {
            PsiElement psiElement = element.getSourcePsi();
            if (psiElement == null) {
                return true;
            }
            PsiElement sourcePsi = psiElement;
            if (sourcePsi instanceof PsiCompiledElement) {
                return true;
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)sourcePsi);
            return virtualFile != null && FileIndexFacade.getInstance((Project)sourcePsi.getProject()).isInLibrarySource(virtualFile);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean fieldAssignedOnlyWithLiterals(UField field, AnalyzeContext analyzeContext) {
            boolean bl;
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)field));
            if (uClass == null) {
                return false;
            }
            UClass containingUClass = uClass;
            PsiElement psiElement = containingUClass.getSourcePsi();
            if (psiElement == null) {
                return false;
            }
            PsiElement parentSourcePsiForCache = psiElement;
            PsiElement target = field.getSourcePsi();
            Set cachedAssignedFields2 = (Set)CachedValuesManager.getManager((Project)parentSourcePsiForCache.getProject()).getCachedValue((UserDataHolder)parentSourcePsiForCache, () -> Companion.fieldAssignedOnlyWithLiterals$lambda$1(parentSourcePsiForCache));
            if (cachedAssignedFields2.contains(field)) {
                return false;
            }
            List methods = (List)CachedValuesManager.getManager((Project)parentSourcePsiForCache.getProject()).getCachedValue((UserDataHolder)parentSourcePsiForCache, () -> Companion.fieldAssignedOnlyWithLiterals$lambda$3(parentSourcePsiForCache));
            analyzeContext.withDecrementedParts(methods.size());
            Intrinsics.checkNotNull((Object)methods);
            Iterable $this$none$iv = methods;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$none$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                UMethod it = (UMethod)element$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getSourcePsi(), (Object)target)) {
                    JvmParameter[] jvmParameterArray = it.getJavaPsi().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"getParameters(...)");
                    if (((Object[])jvmParameterArray).length != 0) return false;
                    boolean bl3 = true;
                    if (!bl3) {
                        return false;
                    }
                    boolean bl4 = false;
                    if (bl4) {
                        return false;
                    }
                }
                bl = false;
            } while (!bl);
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<NonMarkedElement> findNonMarkedArgs(PsiMethod psiMethod, int paramIdx) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.findArgs(psiMethod, paramIdx);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                NonMarkedElement it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                UExpression arg = (UExpression)element$iv$iv;
                boolean bl2 = false;
                if (NonMarkedElement.create((UElement)arg, false) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final Collection<UExpression> findArgs(PsiMethod psiMethod, int paramIdx) {
            return ((Query)CachedValuesManager.getManager((Project)psiMethod.getProject()).getCachedValue((UserDataHolder)psiMethod, () -> Companion.findArgs$lambda$10(psiMethod))).filtering(arg_0 -> Companion.findArgs$lambda$12(arg_0 -> Companion.findArgs$lambda$11(paramIdx, arg_0), arg_0)).mapping(arg_0 -> Companion.findArgs$lambda$14(arg_0 -> Companion.findArgs$lambda$13(paramIdx, arg_0), arg_0)).findAll();
        }

        private final Collection<NonMarkedElement> findAssignments(PsiElement target) {
            return ReferencesSearch.search((PsiElement)target, (SearchScope)target.getUseScope()).mapping(arg_0 -> Companion.findAssignments$lambda$16(Companion::findAssignments$lambda$15, arg_0)).filtering(arg_0 -> Companion.findAssignments$lambda$18(arg_0 -> Companion.findAssignments$lambda$17(target, arg_0), arg_0)).mapping(arg_0 -> Companion.findAssignments$lambda$20(Companion::findAssignments$lambda$19, arg_0)).filtering(arg_0 -> Companion.findAssignments$lambda$22(Companion::findAssignments$lambda$21, arg_0)).findAll();
        }

        private final boolean isLhs(UBinaryExpression uBinary, PsiElement target) {
            if (uBinary == null) {
                return false;
            }
            UastBinaryOperator operator = uBinary.getOperator();
            if (operator != UastBinaryOperator.ASSIGN && operator != UastBinaryOperator.PLUS_ASSIGN) {
                return false;
            }
            UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uBinary.getLeftOperand());
            UResolvable uResolvable = uExpression instanceof UResolvable ? (UResolvable)uExpression : null;
            if (uResolvable == null) {
                return false;
            }
            UResolvable leftOperand = uResolvable;
            PsiElement lhsTarget = leftOperand.resolve();
            if (Intrinsics.areEqual((Object)lhsTarget, (Object)target)) {
                return true;
            }
            if (!(lhsTarget instanceof PsiMethod) || ((PsiMethod)lhsTarget).getBody() != null) {
                return false;
            }
            UElement uElement = UastContextKt.toUElement((PsiElement)lhsTarget);
            if (uElement == null) {
                return false;
            }
            UElement uElement2 = uElement;
            PsiElement property = uElement2.getSourcePsi();
            return Intrinsics.areEqual((Object)property, (Object)target);
        }

        private final UPolyadicExpression getConcatenation(UExpression uExpression) {
            UPolyadicExpression uPolyadicExpression = uExpression instanceof UPolyadicExpression ? (UPolyadicExpression)uExpression : null;
            if (uPolyadicExpression == null) {
                return null;
            }
            UPolyadicExpression uPolyadic = uPolyadicExpression;
            UastBinaryOperator uOperator = uPolyadic.getOperator();
            return Intrinsics.areEqual((Object)uOperator, (Object)UastBinaryOperator.PLUS) || Intrinsics.areEqual((Object)uOperator, (Object)UastBinaryOperator.PLUS_ASSIGN) ? uPolyadic : null;
        }

        private static final CachedValueProvider.Result getAllReturns$lambda$0(PsiElement $sourcePsi) {
            UElement uElement = UastContextKt.toUElement((PsiElement)$sourcePsi);
            UMethod method = uElement instanceof UMethod ? (UMethod)uElement : null;
            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u001eH\u0016J#\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\"2\u0006\u0010#\u001a\u00020\u0000H\u0002\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020*H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006+"}, d2={"com/intellij/codeInspection/sourceToSink/TaintAnalyzer$Companion$getAllReturns$1$ReturnFinder", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "<init>", "()V", "returns", "", "Lorg/jetbrains/uast/UExpression;", "getReturns", "()Ljava/util/Set;", "stop", "", "getStop", "()Z", "setStop", "(Z)V", "onlyInSameLevel", "getOnlyInSameLevel", "setOnlyInSameLevel", "visitBreakExpression", "node", "Lorg/jetbrains/uast/UBreakExpression;", "visitYieldExpression", "Lorg/jetbrains/uast/UYieldExpression;", "visitContinueExpression", "Lorg/jetbrains/uast/UContinueExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitSwitchExpression", "Lorg/jetbrains/uast/USwitchExpression;", "visitIfExpression", "Lorg/jetbrains/uast/UIfExpression;", "processList", "", "expressions", "", "returnFinder", "(Ljava/util/List;Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$Companion$getAllReturns$1$ReturnFinder;)V", "visitBlockExpression", "Lorg/jetbrains/uast/UBlockExpression;", "visitElement", "Lorg/jetbrains/uast/UElement;", "visitReturnExpression", "Lorg/jetbrains/uast/UReturnExpression;", "intellij.jvm.analysis.impl"})
            public final class ReturnFinder
            extends AbstractUastVisitor {
                private final Set<UExpression> returns;
                private boolean stop;
                private boolean onlyInSameLevel;

                public ReturnFinder() {
                    this.returns = new LinkedHashSet<E>();
                    this.onlyInSameLevel = true;
                }

                public final Set<UExpression> getReturns() {
                    return this.returns;
                }

                public final boolean getStop() {
                    return this.stop;
                }

                public final void setStop(boolean bl) {
                    this.stop = bl;
                }

                public final boolean getOnlyInSameLevel() {
                    return this.onlyInSameLevel;
                }

                public final void setOnlyInSameLevel(boolean bl) {
                    this.onlyInSameLevel = bl;
                }

                public boolean visitBreakExpression(UBreakExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    this.onlyInSameLevel = false;
                    return super.visitBreakExpression(node);
                }

                public boolean visitYieldExpression(UYieldExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    this.onlyInSameLevel = false;
                    return super.visitYieldExpression(node);
                }

                public boolean visitContinueExpression(UContinueExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    this.onlyInSameLevel = false;
                    return super.visitContinueExpression(node);
                }

                public boolean visitClass(UClass node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    return true;
                }

                public boolean visitSwitchExpression(USwitchExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (this.stop) {
                        return true;
                    }
                    this.onlyInSameLevel = false;
                    return super.visitSwitchExpression(node);
                }

                public boolean visitIfExpression(UIfExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Object constant = TaintAnalyzerKt.access$getConstant(node.getCondition());
                    ReturnFinder returnFinder = new ReturnFinder();
                    UExpression nextExpression = null;
                    if (Intrinsics.areEqual((Object)constant, (Object)true)) {
                        nextExpression = node.getThenExpression();
                    } else if (Intrinsics.areEqual((Object)constant, (Object)false)) {
                        nextExpression = node.getElseExpression();
                    }
                    if (nextExpression != null) {
                        if (nextExpression instanceof UBlockExpression) {
                            this.processList(((UBlockExpression)nextExpression).getExpressions(), returnFinder);
                        } else {
                            nextExpression.accept((UastVisitor)returnFinder);
                        }
                    } else {
                        return super.visitIfExpression(node);
                    }
                    this.returns.addAll((Collection<UExpression>)returnFinder.returns);
                    if (returnFinder.onlyInSameLevel && !((Collection)returnFinder.returns).isEmpty()) {
                        this.stop = true;
                    }
                    return true;
                }

                private final void processList(List<? extends UExpression> expressions, ReturnFinder returnFinder) {
                    ImplementationUtilsKt.acceptList(expressions, (UastVisitor)((UastVisitor)returnFinder));
                }

                public boolean visitBlockExpression(UBlockExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (this.stop) {
                        return true;
                    }
                    ReturnFinder returnFinder = new ReturnFinder();
                    this.processList(node.getExpressions(), returnFinder);
                    this.returns.addAll((Collection<UExpression>)returnFinder.returns);
                    this.onlyInSameLevel = false;
                    return true;
                }

                public boolean visitElement(UElement node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    return this.stop;
                }

                public boolean visitReturnExpression(UReturnExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (this.stop) {
                        return true;
                    }
                    UExpression uExpression = node.getReturnExpression();
                    if (uExpression == null) {
                        return super.visitReturnExpression(node);
                    }
                    UExpression returnExpression = uExpression;
                    this.returns.add(returnExpression);
                    return super.visitReturnExpression(node);
                }
            }
            ReturnFinder visitor2 = new ReturnFinder();
            UMethod uMethod = method;
            if (uMethod != null && (uMethod = uMethod.getUastBody()) != null) {
                uMethod.accept((UastVisitor)visitor2);
            }
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create(visitor2.getReturns(), (Object[])objectArray);
        }

        private static final CachedValueProvider.Result fieldAssignedOnlyWithLiterals$lambda$1(PsiElement $parentSourcePsiForCache) {
            UElement uClass;
            var visitor2 = new AbstractUastVisitor(){
                private final Set<UField> assignedFields;
                {
                    this.assignedFields = new HashSet<E>();
                }

                public final Set<UField> getAssignedFields() {
                    return this.assignedFields;
                }

                public boolean visitMethod(UMethod node) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (node.getJavaPsi().isPhysical() || node.getUastBody() != null) break block1;
                        UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)node.getJavaPsi().getBody()));
                        if (uElement != null) {
                            uElement.accept((UastVisitor)this);
                        }
                    }
                    return super.visitMethod(node);
                }

                public boolean visitBinaryExpression(UBinaryExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (!(node.getOperator() instanceof UastBinaryOperator.AssignOperator)) {
                        return super.visitBinaryExpression(node);
                    }
                    PsiElement sourcePsi = node.getSourcePsi();
                    if (sourcePsi == null) {
                        return super.visitBinaryExpression(node);
                    }
                    UExpression uExpression = node.getLeftOperand();
                    UReferenceExpression uReferenceExpression = uExpression instanceof UReferenceExpression ? (UReferenceExpression)uExpression : null;
                    if (uReferenceExpression == null) {
                        return super.visitBinaryExpression(node);
                    }
                    UReferenceExpression lhs = uReferenceExpression;
                    UResolvable $this$resolveToUElementOfType$iv = (UResolvable)lhs;
                    boolean $i$f$resolveToUElementOfType = false;
                    UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                    if (!(uElement instanceof UField)) {
                        uElement = null;
                    }
                    UField uField = (UField)((UElement)((UField)uElement));
                    if (uField == null) {
                        return super.visitBinaryExpression(node);
                    }
                    UField uField2 = uField;
                    if (!(node.getRightOperand() instanceof ULiteralExpression)) {
                        this.assignedFields.add(uField2);
                    }
                    return super.visitBinaryExpression(node);
                }
            };
            UElement uElement = uClass = UastContextKt.toUElement((PsiElement)$parentSourcePsiForCache);
            if (uElement != null) {
                uElement.accept((UastVisitor)visitor2);
            }
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create(visitor2.getAssignedFields(), (Object[])objectArray);
        }

        /*
         * WARNING - void declaration
         */
        private static final CachedValueProvider.Result fieldAssignedOnlyWithLiterals$lambda$3(PsiElement $parentSourcePsiForCache) {
            List list;
            Object[] objectArray;
            UClass uClass;
            UElement uElement = UastContextKt.toUElement((PsiElement)$parentSourcePsiForCache);
            UClass uClass2 = uClass = uElement instanceof UClass ? (UClass)uElement : null;
            if (uClass != null) {
                void $this$mapTo$iv$iv;
                objectArray = new SpreadBuilder(2);
                objectArray.add((Object)uClass);
                objectArray.addSpread((Object)uClass.getInnerClasses());
                Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray.toArray((Object[])new UClass[objectArray.size()]));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    UClass uClass3 = (UClass)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ArraysKt.toList((Object[])it.getMethods()));
                }
                list = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            } else {
                list = CollectionsKt.emptyList();
            }
            List uMethods = list;
            objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)uMethods, (Object[])objectArray);
        }

        private static final PsiMethodCallExpression findArgs$lambda$10$lambda$6(PsiReference it) {
            PsiElement psiElement = it.getElement().getParent();
            return psiElement instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)psiElement : null;
        }

        private static final PsiMethodCallExpression findArgs$lambda$10$lambda$7(Function1 $tmp0, Object p0) {
            return (PsiMethodCallExpression)$tmp0.invoke(p0);
        }

        private static final PsiExpression[] findArgs$lambda$10$lambda$8(PsiMethodCallExpression it) {
            PsiMethodCallExpression psiMethodCallExpression = it;
            return psiMethodCallExpression != null && (psiMethodCallExpression = psiMethodCallExpression.getArgumentList()) != null ? psiMethodCallExpression.getExpressions() : null;
        }

        private static final PsiExpression[] findArgs$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
            return (PsiExpression[])$tmp0.invoke(p0);
        }

        private static final CachedValueProvider.Result findArgs$lambda$10(PsiMethod $psiMethod) {
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)ReferencesSearch.search((PsiElement)((PsiElement)$psiMethod), (SearchScope)$psiMethod.getUseScope()).mapping(arg_0 -> Companion.findArgs$lambda$10$lambda$7(Companion::findArgs$lambda$10$lambda$6, arg_0)).mapping(arg_0 -> Companion.findArgs$lambda$10$lambda$9(Companion::findArgs$lambda$10$lambda$8, arg_0)), (Object[])objectArray);
        }

        private static final boolean findArgs$lambda$11(int $paramIdx, PsiExpression[] args) {
            return args != null && args.length > $paramIdx;
        }

        private static final boolean findArgs$lambda$12(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final UExpression findArgs$lambda$13(int $paramIdx, PsiExpression[] args) {
            Intrinsics.checkNotNull((Object)args);
            UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)args[$paramIdx]));
            return uElement instanceof UExpression ? (UExpression)uElement : null;
        }

        private static final UExpression findArgs$lambda$14(Function1 $tmp0, Object p0) {
            return (UExpression)$tmp0.invoke(p0);
        }

        private static final UBinaryExpression findAssignments$lambda$15(PsiReference u) {
            Intrinsics.checkNotNullParameter((Object)u, (String)"u");
            return (UBinaryExpression)UastContextKt.getUastParentOfType$default((PsiElement)u.getElement(), UBinaryExpression.class, (boolean)false, (int)2, null);
        }

        private static final UBinaryExpression findAssignments$lambda$16(Function1 $tmp0, Object p0) {
            return (UBinaryExpression)$tmp0.invoke(p0);
        }

        private static final boolean findAssignments$lambda$17(PsiElement $target, UBinaryExpression binary) {
            return Companion.isLhs(binary, $target);
        }

        private static final boolean findAssignments$lambda$18(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final NonMarkedElement findAssignments$lambda$19(UBinaryExpression binary) {
            UBinaryExpression uBinaryExpression = binary;
            return NonMarkedElement.create((UElement)(uBinaryExpression != null ? uBinaryExpression.getRightOperand() : null), false);
        }

        private static final NonMarkedElement findAssignments$lambda$20(Function1 $tmp0, Object p0) {
            return (NonMarkedElement)$tmp0.invoke(p0);
        }

        private static final boolean findAssignments$lambda$21(NonMarkedElement e) {
            return e != null;
        }

        private static final boolean findAssignments$lambda$22(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0014H\u0016J*\u0010\u0015\u001a\u00020\u000f2\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00172\u0010\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u0017H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$Companion$FlowVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "<init>", "()V", "flow", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow;", "getFlow", "()Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow;", "visitIfExpression", "", "node", "Lorg/jetbrains/uast/UIfExpression;", "visitSwitchExpression", "Lorg/jetbrains/uast/USwitchExpression;", "afterVisitExpression", "", "Lorg/jetbrains/uast/UExpression;", "afterVisitCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "afterVisitBinaryExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "checkUsages", "expressions", "", "dependsOn", "intellij.jvm.analysis.impl"})
        @SourceDebugExtension(value={"SMAP\nTaintAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaintAnalyzer.kt\ncom/intellij/codeInspection/sourceToSink/TaintAnalyzer$Companion$FlowVisitor\n+ 2 UResolvable.kt\norg/jetbrains/uast/UResolvableKt\n*L\n1#1,1218:1\n43#2:1219\n43#2:1220\n43#2:1221\n43#2:1222\n*S KotlinDebug\n*F\n+ 1 TaintAnalyzer.kt\ncom/intellij/codeInspection/sourceToSink/TaintAnalyzer$Companion$FlowVisitor\n*L\n908#1:1219\n914#1:1220\n934#1:1221\n943#1:1222\n*E\n"})
        private static final class FlowVisitor
        extends AbstractUastVisitor {
            @NotNull
            private final VariableFlow flow = new VariableFlow();

            @NotNull
            public final VariableFlow getFlow() {
                return this.flow;
            }

            public boolean visitIfExpression(@NotNull UIfExpression node) {
                Object value;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UExpression condition = node.getCondition();
                condition.accept((UastVisitor)this);
                Object object = value = TaintAnalyzerKt.access$getConstant(node.getCondition());
                if (Intrinsics.areEqual((Object)object, (Object)true)) {
                    UExpression uExpression = node.getThenExpression();
                    if (uExpression != null) {
                        uExpression.accept((UastVisitor)this);
                    }
                } else if (Intrinsics.areEqual((Object)object, (Object)false)) {
                    UExpression uExpression = node.getElseExpression();
                    if (uExpression != null) {
                        uExpression.accept((UastVisitor)this);
                    }
                } else {
                    FlowVisitor flowIf = new FlowVisitor();
                    FlowVisitor flowElse = new FlowVisitor();
                    UExpression uExpression = node.getThenExpression();
                    if (uExpression != null) {
                        uExpression.accept((UastVisitor)flowIf);
                    }
                    UExpression uExpression2 = node.getElseExpression();
                    if (uExpression2 != null) {
                        uExpression2.accept((UastVisitor)flowElse);
                    }
                    Object[] objectArray = new VariableFlow[]{flowIf.flow, flowElse.flow};
                    this.flow.addSplit(CollectionsKt.listOf((Object[])objectArray), node.getThenExpression() != null && node.getElseExpression() != null);
                }
                return true;
            }

            public boolean visitSwitchExpression(@NotNull USwitchExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                List flows = new ArrayList();
                UExpressionList body = node.getBody();
                for (UExpression expression : body.getExpressions()) {
                    FlowVisitor flowIf = new FlowVisitor();
                    expression.accept((UastVisitor)flowIf);
                    flows.add(flowIf.flow);
                }
                this.flow.addSplit(flows, false);
                return true;
            }

            public void afterVisitExpression(@NotNull UExpression node) {
                UResolvable uResolvable;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        uResolvable = node instanceof UResolvable ? (UResolvable)node : null;
                        if (uResolvable == null) break block5;
                        UResolvable $this$resolveToUElementOfType$iv = uResolvable;
                        boolean $i$f$resolveToUElementOfType = false;
                        UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                        if (!(uElement instanceof UVariable)) {
                            uElement = null;
                        }
                        if ((uResolvable = (UVariable)((UElement)((UVariable)uElement))) != null) break block6;
                    }
                    return;
                }
                UResolvable currentVariable = uResolvable;
                if (!(currentVariable instanceof ULocalVariable) && !(currentVariable instanceof UParameter)) {
                    return;
                }
                this.flow.addUsage((UVariable)currentVariable, node);
            }

            public void afterVisitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UResolvable $this$resolveToUElementOfType$iv = (UResolvable)node;
                boolean $i$f$resolveToUElementOfType = false;
                UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                if (!(uElement instanceof UMethod)) {
                    uElement = null;
                }
                UMethod uMethod = (UMethod)((UElement)((UMethod)uElement));
                PsiMethod javaPsi = uMethod != null ? uMethod.getJavaPsi() : null;
                UExpression receiver = node.getReceiver();
                if (javaPsi != null && JavaMethodContractUtil.isPure((PsiMethod)javaPsi)) {
                    this.flow.addCleaning(receiver, node);
                    return;
                }
                if (receiver != null) {
                    this.checkUsages(CollectionsKt.listOf((Object)receiver), node.getValueArguments());
                    this.flow.addCleaning(receiver, node);
                }
                if (javaPsi != null && HardcodedContracts.isKnownNoParameterLeak((PsiMethod)javaPsi)) {
                    return;
                }
                this.checkUsages(node.getValueArguments(), null);
            }

            public void afterVisitBinaryExpression(@NotNull UBinaryExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!(node.getOperator() instanceof UastBinaryOperator.AssignOperator)) {
                    return;
                }
                UExpression uExpression = node.getLeftOperand();
                UReferenceExpression uReferenceExpression = uExpression instanceof UReferenceExpression ? (UReferenceExpression)uExpression : null;
                if (uReferenceExpression == null) {
                    return;
                }
                UReferenceExpression lhs = uReferenceExpression;
                UResolvable $this$resolveToUElementOfType$iv = (UResolvable)lhs;
                boolean $i$f$resolveToUElementOfType = false;
                UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                if (!(uElement instanceof UVariable)) {
                    uElement = null;
                }
                UVariable uVariable = (UVariable)((UElement)((UVariable)uElement));
                if (uVariable == null) {
                    return;
                }
                UVariable uElement2 = uVariable;
                if (!(uElement2 instanceof ULocalVariable) && !(uElement2 instanceof UParameter)) {
                    return;
                }
                UExpression rhs = node.getRightOperand();
                this.flow.addAssign(uElement2, rhs);
            }

            private final void checkUsages(List<? extends UExpression> expressions, List<? extends UExpression> dependsOn) {
                for (UExpression uExpression : expressions) {
                    UResolvable currentVariable;
                    if (uExpression == null) continue;
                    UResolvable uResolvable = uExpression instanceof UResolvable ? (UResolvable)uExpression : null;
                    if (uResolvable == null) continue;
                    UResolvable $this$resolveToUElementOfType$iv = uResolvable;
                    boolean $i$f$resolveToUElementOfType = false;
                    UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                    if (!(uElement instanceof UVariable)) {
                        uElement = null;
                    }
                    if ((uResolvable = (UVariable)((UElement)((UVariable)uElement))) == null || !((currentVariable = uResolvable) instanceof ULocalVariable) && !(currentVariable instanceof UParameter)) continue;
                    this.flow.addDropLocality((UVariable)currentVariable, dependsOn);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001:\u0007*+,-./0B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u000fJ\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0010J\u0018\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0010J\u001c\u0010\u0019\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00000\u000f2\u0006\u0010\u001b\u001a\u00020\u001cJ@\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00061"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow;", "", "<init>", "()V", "variables", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$VariableStep;", "getVariables", "()Lcom/intellij/util/containers/MultiMap;", "addDropLocality", "", "currentVariable", "Lorg/jetbrains/uast/UVariable;", "dependsOn", "", "Lorg/jetbrains/uast/UExpression;", "addUsage", "usage", "addCleaning", "uExpression", "node", "Lorg/jetbrains/uast/UCallExpression;", "addAssign", "assign", "addSplit", "flows", "full", "", "process", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$FlowResult;", "taintAnalyzer", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer;", "initValue", "Lcom/intellij/codeInspection/sourceToSink/TaintValue;", "uVariable", "analyzeContext", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$AnalyzeContext;", "usedReference", "skipAfterReference", "taintValueFactory", "Lcom/intellij/codeInspection/sourceToSink/TaintValueFactory;", "VariableStep", "CleaningStep", "DropLocalityStep", "UsagesStep", "AssignmentStep", "SplitStep", "FlowResult", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nTaintAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaintAnalyzer.kt\ncom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow\n+ 2 UResolvable.kt\norg/jetbrains/uast/UResolvableKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1218:1\n43#2:1219\n1374#3:1220\n1460#3,5:1221\n1869#3,2:1226\n1563#3:1228\n1634#3,3:1229\n295#3,2:1232\n1869#3,2:1234\n*S KotlinDebug\n*F\n+ 1 TaintAnalyzer.kt\ncom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow\n*L\n1104#1:1219\n1116#1:1220\n1116#1:1221,5\n1118#1:1226,2\n1176#1:1228\n1176#1:1229,3\n1179#1:1232,2\n1184#1:1234,2\n*E\n"})
    private static final class VariableFlow {
        @NotNull
        private final MultiMap<PsiElement, VariableStep> variables = new MultiMap();

        @NotNull
        public final MultiMap<PsiElement, VariableStep> getVariables() {
            return this.variables;
        }

        public final void addDropLocality(@NotNull UVariable currentVariable, @Nullable List<? extends UExpression> dependsOn) {
            Intrinsics.checkNotNullParameter((Object)currentVariable, (String)"currentVariable");
            PsiElement psiElement = currentVariable.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement psiElement2 = psiElement;
            this.variables.putValue((Object)psiElement2, (Object)new DropLocalityStep(dependsOn));
        }

        public final void addUsage(@NotNull UVariable currentVariable, @NotNull UExpression usage) {
            Intrinsics.checkNotNullParameter((Object)currentVariable, (String)"currentVariable");
            Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
            PsiElement psiElement = currentVariable.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement psiElement2 = psiElement;
            PsiElement psiElement3 = usage.getSourcePsi();
            if (psiElement3 == null) {
                return;
            }
            PsiElement psiElementUsage = psiElement3;
            Collection collection = this.variables.get((Object)psiElement2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            Collection variableSteps = collection;
            VariableStep lastStep = (VariableStep)CollectionsKt.lastOrNull((Iterable)variableSteps);
            if (lastStep instanceof UsagesStep) {
                ((UsagesStep)lastStep).getUsages().add(psiElementUsage);
            } else {
                Object[] objectArray = new PsiElement[]{psiElementUsage};
                this.variables.putValue((Object)psiElement2, (Object)new UsagesStep(SetsKt.mutableSetOf((Object[])objectArray)));
            }
        }

        public final void addCleaning(@Nullable UExpression uExpression, @NotNull UCallExpression node) {
            UResolvable uResolvable;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (uExpression == null) {
                        return;
                    }
                    uResolvable = uExpression instanceof UResolvable ? (UResolvable)uExpression : null;
                    if (uResolvable == null) break block6;
                    UResolvable $this$resolveToUElementOfType$iv = uResolvable;
                    boolean $i$f$resolveToUElementOfType = false;
                    UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                    if (!(uElement instanceof UVariable)) {
                        uElement = null;
                    }
                    if ((uResolvable = (UVariable)((UElement)((UVariable)uElement))) != null) break block7;
                }
                return;
            }
            UResolvable currentVariable = uResolvable;
            PsiElement psiElement = currentVariable.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement psiElement2 = psiElement;
            this.variables.putValue((Object)psiElement2, (Object)new CleaningStep(node));
        }

        public final void addAssign(@NotNull UVariable currentVariable, @NotNull UExpression assign) {
            Intrinsics.checkNotNullParameter((Object)currentVariable, (String)"currentVariable");
            Intrinsics.checkNotNullParameter((Object)assign, (String)"assign");
            PsiElement psiElement = currentVariable.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement psiElement2 = psiElement;
            this.variables.putValue((Object)psiElement2, (Object)new AssignmentStep(assign));
        }

        /*
         * WARNING - void declaration
         */
        public final void addSplit(@NotNull List<VariableFlow> flows, boolean full) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(flows, (String)"flows");
            Iterable $this$flatMap$iv = flows;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                VariableFlow it = (VariableFlow)element$iv$iv;
                boolean bl = false;
                Set set = it.variables.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
                Iterable list$iv$iv = set;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                this.variables.putValue((Object)it, (Object)new SplitStep(flows, full));
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FlowResult process(@NotNull TaintAnalyzer taintAnalyzer, @NotNull TaintValue initValue, @NotNull UVariable uVariable, @NotNull AnalyzeContext analyzeContext, @Nullable UExpression usedReference, boolean skipAfterReference, @NotNull TaintValueFactory taintValueFactory) {
            Intrinsics.checkNotNullParameter((Object)taintAnalyzer, (String)"taintAnalyzer");
            Intrinsics.checkNotNullParameter((Object)((Object)initValue), (String)"initValue");
            Intrinsics.checkNotNullParameter((Object)uVariable, (String)"uVariable");
            Intrinsics.checkNotNullParameter((Object)analyzeContext, (String)"analyzeContext");
            Intrinsics.checkNotNullParameter((Object)taintValueFactory, (String)"taintValueFactory");
            PsiElement psiElement = uVariable.getSourcePsi();
            if (psiElement == null) {
                return new FlowResult(TaintValue.UNKNOWN, false);
            }
            PsiElement psiElement2 = psiElement;
            Collection collection = this.variables.get((Object)psiElement2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            Collection variableSteps = collection;
            if (variableSteps.isEmpty()) {
                return new FlowResult(initValue, false);
            }
            TaintValue resultValue = null;
            resultValue = initValue;
            for (VariableStep variableStep : variableSteps) {
                VariableStep variableStep2 = variableStep;
                if (variableStep2 instanceof DropLocalityStep) {
                    TaintValue taintValue = null;
                    if (taintAnalyzer.skipClass(uVariable.getType()) || ClassUtils.isImmutable((PsiType)uVariable.getType())) {
                        taintValue = TaintValue.UNTAINTED;
                    } else if (((DropLocalityStep)variableStep).getDependsOn() != null && analyzeContext.getProcessOuterMethodAsQualifierAndArguments()) {
                        TaintValue processValue = TaintValue.UNTAINTED;
                        analyzeContext.checkInside(((DropLocalityStep)variableStep).getDependsOn().size());
                        for (UExpression relativeExpression : ((DropLocalityStep)variableStep).getDependsOn()) {
                            if (relativeExpression != null) {
                                Intrinsics.checkNotNullExpressionValue((Object)((Object)processValue.joinUntil(analyzeContext.getUntilTaintValue(), () -> VariableFlow.process$lambda$2(taintAnalyzer, relativeExpression, analyzeContext))), (String)"joinUntil(...)");
                            }
                            taintValue = processValue;
                        }
                    } else {
                        taintValue = TaintValue.UNKNOWN;
                    }
                    if (taintValue == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)resultValue.join(taintValue)), (String)"join(...)");
                    continue;
                }
                if (variableStep2 instanceof UsagesStep) {
                    PsiElement sourcePsi;
                    if (!skipAfterReference || usedReference == null || (sourcePsi = usedReference.getSourcePsi()) == null || !((UsagesStep)variableStep).getUsages().contains(sourcePsi)) continue;
                    return new FlowResult(resultValue, true);
                }
                if (variableStep2 instanceof SplitStep) {
                    Object v2;
                    List flowResults;
                    TaintValue processValue;
                    block18: {
                        void $this$mapTo$iv$iv;
                        processValue = null;
                        processValue = TaintValue.UNTAINTED;
                        if (!((SplitStep)variableStep).getFull()) {
                            processValue = resultValue;
                        }
                        Iterable $this$map$iv = ((SplitStep)variableStep).getFlows();
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            VariableFlow variableFlow = (VariableFlow)item$iv$iv;
                            Collection collection2 = destination$iv$iv;
                            boolean bl = false;
                            collection2.add(it.process(taintAnalyzer, resultValue, uVariable, analyzeContext, usedReference, skipAfterReference, taintValueFactory));
                        }
                        flowResults = (List)destination$iv$iv;
                        Iterable $this$firstOrNull$iv = flowResults;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            FlowResult it = (FlowResult)element$iv;
                            boolean bl = false;
                            if (!it.getFast()) continue;
                            v2 = element$iv;
                            break block18;
                        }
                        v2 = null;
                    }
                    FlowResult fastExit = v2;
                    if (fastExit != null) {
                        return new FlowResult(fastExit.getTaintValue(), true);
                    }
                    Iterable $this$forEach$iv = flowResults;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FlowResult flowResult = (FlowResult)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)processValue.joinUntil(analyzeContext.getUntilTaintValue(), () -> VariableFlow.process$lambda$6$lambda$5(flowResult))), (String)"joinUntil(...)");
                    }
                    resultValue = processValue;
                    continue;
                }
                if (variableStep2 instanceof AssignmentStep) {
                    UExpression expression = ((AssignmentStep)variableStep).getExpression();
                    resultValue = taintAnalyzer.fromExpressionWithoutCollection(expression, analyzeContext);
                    continue;
                }
                if (!(variableStep2 instanceof CleaningStep) || !taintValueFactory.needToCleanQualifier(((CleaningStep)variableStep).getNode())) continue;
                resultValue = TaintValue.UNTAINTED;
            }
            return new FlowResult(resultValue, false);
        }

        private static final TaintValue process$lambda$2(TaintAnalyzer $taintAnalyzer, UExpression $relativeExpression, AnalyzeContext $analyzeContext) {
            return $taintAnalyzer.fromExpressionWithoutCollection($relativeExpression, $analyzeContext);
        }

        private static final TaintValue process$lambda$6$lambda$5(FlowResult $flowResult) {
            return $flowResult.getTaintValue();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$AssignmentStep;", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$VariableStep;", "expression", "Lorg/jetbrains/uast/UExpression;", "<init>", "(Lorg/jetbrains/uast/UExpression;)V", "getExpression", "()Lorg/jetbrains/uast/UExpression;", "intellij.jvm.analysis.impl"})
        private static final class AssignmentStep
        implements VariableStep {
            @NotNull
            private final UExpression expression;

            public AssignmentStep(@NotNull UExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                this.expression = expression;
            }

            @NotNull
            public final UExpression getExpression() {
                return this.expression;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$CleaningStep;", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$VariableStep;", "node", "Lorg/jetbrains/uast/UCallExpression;", "<init>", "(Lorg/jetbrains/uast/UCallExpression;)V", "getNode", "()Lorg/jetbrains/uast/UCallExpression;", "intellij.jvm.analysis.impl"})
        private static final class CleaningStep
        implements VariableStep {
            @NotNull
            private final UCallExpression node;

            public CleaningStep(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.node = node;
            }

            @NotNull
            public final UCallExpression getNode() {
                return this.node;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$DropLocalityStep;", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$VariableStep;", "dependsOn", "", "Lorg/jetbrains/uast/UExpression;", "<init>", "(Ljava/util/List;)V", "getDependsOn", "()Ljava/util/List;", "intellij.jvm.analysis.impl"})
        private static final class DropLocalityStep
        implements VariableStep {
            @Nullable
            private final List<UExpression> dependsOn;

            public DropLocalityStep(@Nullable List<? extends UExpression> dependsOn) {
                this.dependsOn = dependsOn;
            }

            @Nullable
            public final List<UExpression> getDependsOn() {
                return this.dependsOn;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$FlowResult;", "", "taintValue", "Lcom/intellij/codeInspection/sourceToSink/TaintValue;", "fast", "", "<init>", "(Lcom/intellij/codeInspection/sourceToSink/TaintValue;Z)V", "getTaintValue", "()Lcom/intellij/codeInspection/sourceToSink/TaintValue;", "getFast", "()Z", "intellij.jvm.analysis.impl"})
        public static final class FlowResult {
            @NotNull
            private final TaintValue taintValue;
            private final boolean fast;

            public FlowResult(@NotNull TaintValue taintValue, boolean fast) {
                Intrinsics.checkNotNullParameter((Object)((Object)taintValue), (String)"taintValue");
                this.taintValue = taintValue;
                this.fast = fast;
            }

            @NotNull
            public final TaintValue getTaintValue() {
                return this.taintValue;
            }

            public final boolean getFast() {
                return this.fast;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$SplitStep;", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$VariableStep;", "flows", "", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow;", "full", "", "<init>", "(Ljava/util/List;Z)V", "getFlows", "()Ljava/util/List;", "getFull", "()Z", "intellij.jvm.analysis.impl"})
        private static final class SplitStep
        implements VariableStep {
            @NotNull
            private final List<VariableFlow> flows;
            private final boolean full;

            public SplitStep(@NotNull List<VariableFlow> flows, boolean full) {
                Intrinsics.checkNotNullParameter(flows, (String)"flows");
                this.flows = flows;
                this.full = full;
            }

            @NotNull
            public final List<VariableFlow> getFlows() {
                return this.flows;
            }

            public final boolean getFull() {
                return this.full;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$UsagesStep;", "Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$VariableStep;", "usages", "", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/util/Set;)V", "getUsages", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.jvm.analysis.impl"})
        private static final class UsagesStep
        implements VariableStep {
            @NotNull
            private final Set<PsiElement> usages;

            public UsagesStep(@NotNull Set<PsiElement> usages) {
                Intrinsics.checkNotNullParameter(usages, (String)"usages");
                this.usages = usages;
            }

            public /* synthetic */ UsagesStep(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    set = new HashSet();
                }
                this(set);
            }

            @NotNull
            public final Set<PsiElement> getUsages() {
                return this.usages;
            }

            @NotNull
            public final Set<PsiElement> component1() {
                return this.usages;
            }

            @NotNull
            public final UsagesStep copy(@NotNull Set<PsiElement> usages) {
                Intrinsics.checkNotNullParameter(usages, (String)"usages");
                return new UsagesStep(usages);
            }

            public static /* synthetic */ UsagesStep copy$default(UsagesStep usagesStep, Set set, int n, Object object) {
                if ((n & 1) != 0) {
                    set = usagesStep.usages;
                }
                return usagesStep.copy(set);
            }

            @NotNull
            public String toString() {
                return "UsagesStep(usages=" + this.usages + ")";
            }

            public int hashCode() {
                return ((Object)this.usages).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UsagesStep)) {
                    return false;
                }
                UsagesStep usagesStep = (UsagesStep)other;
                return Intrinsics.areEqual(this.usages, usagesStep.usages);
            }

            public UsagesStep() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bb\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Lcom/intellij/codeInspection/sourceToSink/TaintAnalyzer$VariableFlow$VariableStep;", "", "intellij.jvm.analysis.impl"})
        private static interface VariableStep {
        }
    }
}

