/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization.internal;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonReaderBuilder;
import com.intellij.openapi.util.Comparing;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.internal.impldep.gnu.trove.TObjectHashingStrategy;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.converters.BackwardsCompatibleIdeaModuleDependency;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.gradle.tooling.model.java.InstalledJdk;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamApiUtils;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalBuildIdentifier;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalGradleModuleVersion;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalGradleProject;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalGradleTask;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaContentRoot;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaDependency;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaDependencyScope;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaJavaLanguageSettings;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaLanguageLevel;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaModule;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaModuleDependency;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaProject;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaSingleEntryLibraryDependency;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaSourceDirectory;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalInstalledJdk;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalProjectIdentifier;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.Supplier;
import org.jetbrains.plugins.gradle.tooling.util.GradleContainerUtil;
import org.jetbrains.plugins.gradle.tooling.util.GradleVersionComparator;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public final class IdeaProjectSerializationService
implements SerializationService<IdeaProject> {
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    public byte[] write(IdeaProject ideaProject, Class<? extends IdeaProject> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (IonWriter writer = ToolingStreamApiUtils.createIonWriter().build((OutputStream)out);){
            GradleVersion gradleVersion = IdeaProjectSerializationService.getBuildGradleVersion(ideaProject);
            this.myWriteContext.setGradleVersion(gradleVersion);
            writer.stepIn(IonType.STRUCT);
            ToolingStreamApiUtils.writeString(writer, "gradleVersion", gradleVersion.getVersion());
            writer.stepOut();
            IdeaProjectSerializationService.writeProject(writer, this.myWriteContext, ideaProject);
        }
        return out.toByteArray();
    }

    public IdeaProject read(byte[] object, Class<? extends IdeaProject> modelClazz) throws IOException {
        try (IonReader reader = IonReaderBuilder.standard().build(object);){
            if (reader.next() == null) {
                IdeaProject ideaProject = null;
                return ideaProject;
            }
            reader.stepIn();
            String gradleVersion = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "gradleVersion"));
            reader.stepOut();
            this.myReadContext.setGradleVersion(GradleVersion.version((String)gradleVersion));
            InternalIdeaProject internalIdeaProject = this.readProject(reader, this.myReadContext);
            return internalIdeaProject;
        }
    }

    public Class<? extends IdeaProject> getModelClass() {
        return IdeaProject.class;
    }

    private static void writeProject(final IonWriter writer, final WriteContext context, final IdeaProject project) throws IOException {
        context.ideaProjectsCollector.add(project, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "name", project.getName());
                    ToolingStreamApiUtils.writeString(writer, "description", project.getDescription());
                    ToolingStreamApiUtils.writeString(writer, "jdkName", project.getJdkName());
                    IdeaProjectSerializationService.writeJavaLanguageSettings(writer, context, project.getJavaLanguageSettings());
                    ToolingStreamApiUtils.writeString(writer, "languageLevel", project.getLanguageLevel().getLevel());
                    IdeaProjectSerializationService.writeModules(writer, context, (DomainObjectSet<? extends IdeaModule>)project.getModules());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeModules(IonWriter writer, WriteContext context, DomainObjectSet<? extends IdeaModule> ideaModules) throws IOException {
        writer.setFieldName("ideaModules");
        writer.stepIn(IonType.LIST);
        for (IdeaModule ideaModule : ideaModules) {
            IdeaProjectSerializationService.writeModule(writer, context, ideaModule);
        }
        writer.stepOut();
    }

    private static void writeModule(IonWriter writer, WriteContext context, final IdeaModule ideaModule) throws IOException {
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeString(writer, "name", ideaModule.getName());
        ToolingStreamApiUtils.writeString(writer, "description", ideaModule.getDescription());
        ToolingStreamApiUtils.writeString(writer, "jdkName", IdeaProjectSerializationService.nullizeUnsupported(new Supplier<String>(){

            public String get() {
                return ideaModule.getJdkName();
            }
        }));
        IdeaProjectSerializationService.writeGradleProject(writer, "gradleProject", context, ideaModule.getGradleProject());
        IdeaProjectSerializationService.writeCompilerOutput(writer, context, ideaModule.getCompilerOutput());
        IdeaProjectSerializationService.writeContentRoots(writer, (DomainObjectSet<? extends IdeaContentRoot>)ideaModule.getContentRoots());
        IdeaProjectSerializationService.writeJavaLanguageSettings(writer, context, IdeaProjectSerializationService.nullizeUnsupported(new Supplier<IdeaJavaLanguageSettings>(){

            public IdeaJavaLanguageSettings get() {
                return ideaModule.getJavaLanguageSettings();
            }
        }));
        IdeaProjectSerializationService.writeDependencies(writer, context, (DomainObjectSet<? extends IdeaDependency>)ideaModule.getDependencies());
        writer.stepOut();
    }

    private static void writeDependencies(IonWriter writer, WriteContext context, DomainObjectSet<? extends IdeaDependency> dependencies) throws IOException {
        writer.setFieldName("dependencies");
        writer.stepIn(IonType.LIST);
        for (IdeaDependency dependency : dependencies) {
            IdeaProjectSerializationService.writeDependency(writer, context, dependency);
        }
        writer.stepOut();
    }

    private static void writeDependency(IonWriter writer, WriteContext context, IdeaDependency dependency) throws IOException {
        if (dependency instanceof IdeaModuleDependency) {
            IdeaProjectSerializationService.writeModuleDependency(writer, context, (IdeaModuleDependency)dependency);
        } else if (dependency instanceof IdeaSingleEntryLibraryDependency) {
            IdeaProjectSerializationService.writeLibraryDependency(writer, context, (IdeaSingleEntryLibraryDependency)dependency);
        } else {
            Object unpack = context.modelAdapter.unpack((Object)dependency);
            if (unpack.getClass().getSimpleName().equals("DefaultIdeaModuleDependency")) {
                BackwardsCompatibleIdeaModuleDependency moduleDependency = (BackwardsCompatibleIdeaModuleDependency)context.modelAdapter.adapt(BackwardsCompatibleIdeaModuleDependency.class, unpack);
                IdeaProjectSerializationService.writeModuleDependency(writer, context, (IdeaModuleDependency)moduleDependency);
            } else if (unpack.getClass().getSimpleName().equals("DefaultIdeaSingleEntryLibraryDependency")) {
                IdeaSingleEntryLibraryDependency libraryDependency = (IdeaSingleEntryLibraryDependency)context.modelAdapter.adapt(IdeaSingleEntryLibraryDependency.class, unpack);
                IdeaProjectSerializationService.writeLibraryDependency(writer, context, libraryDependency);
            }
        }
    }

    private static void writeLibraryDependency(final IonWriter writer, WriteContext context, final IdeaSingleEntryLibraryDependency libraryDependency) throws IOException {
        context.ideaDependenciesCollector.add(libraryDependency, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "_type", IdeaSingleEntryLibraryDependency.class.getSimpleName());
                    ToolingStreamApiUtils.writeFile(writer, "file", libraryDependency.getFile());
                    ToolingStreamApiUtils.writeFile(writer, "javadoc", libraryDependency.getJavadoc());
                    ToolingStreamApiUtils.writeFile(writer, "source", libraryDependency.getSource());
                    ToolingStreamApiUtils.writeString(writer, "scope", libraryDependency.getScope().getScope());
                    ToolingStreamApiUtils.writeBoolean(writer, "exported", libraryDependency.getExported());
                    writer.setFieldName("gradleModuleVersion");
                    GradleModuleVersion version = libraryDependency.getGradleModuleVersion();
                    if (version != null) {
                        writer.stepIn(IonType.STRUCT);
                        ToolingStreamApiUtils.writeString(writer, "group", version.getGroup());
                        ToolingStreamApiUtils.writeString(writer, "name", version.getName());
                        ToolingStreamApiUtils.writeString(writer, "version", version.getVersion());
                        writer.stepOut();
                    } else {
                        writer.writeNull();
                    }
                }
                writer.stepOut();
            }
        });
    }

    private static void writeModuleDependency(final IonWriter writer, final WriteContext context, final IdeaModuleDependency moduleDependency) throws IOException {
        context.ideaDependenciesCollector.add(moduleDependency, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "_type", IdeaModuleDependency.class.getSimpleName());
                    ToolingStreamApiUtils.writeString(writer, "targetModuleName", new TargetModuleNameGetter(moduleDependency, context.myGradleVersionComparator).get());
                    ToolingStreamApiUtils.writeString(writer, "scope", moduleDependency.getScope().getScope());
                    ToolingStreamApiUtils.writeBoolean(writer, "exported", moduleDependency.getExported());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeJavaLanguageSettings(final @NotNull IonWriter writer, @NotNull WriteContext context, final @Nullable IdeaJavaLanguageSettings languageSettings) throws IOException {
        if (writer == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(0);
        }
        if (context == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(1);
        }
        writer.setFieldName("javaLanguageSettings");
        if (languageSettings == null) {
            writer.writeNull();
            return;
        }
        context.ideaJavaLanguageSettingsCollector.add(languageSettings, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "languageLevel", IdeaProjectSerializationService.getJavaVersion(IdeaProjectSerializationService.getLanguageLevel(languageSettings)));
                    ToolingStreamApiUtils.writeString(writer, "targetBytecodeVersion", IdeaProjectSerializationService.getJavaVersion((JavaVersion)IdeaProjectSerializationService.nullizeUnsupported(new TargetBytecodeVersionGetter(languageSettings))));
                    writer.setFieldName("jdk");
                    InstalledJdk jdk = (InstalledJdk)IdeaProjectSerializationService.nullizeUnsupported(new JdkGetter(languageSettings));
                    if (jdk != null) {
                        writer.stepIn(IonType.STRUCT);
                        ToolingStreamApiUtils.writeFile(writer, "javaHome", jdk.getJavaHome());
                        JavaVersion jdkJavaVersion = IdeaProjectSerializationService.getJavaVersion(jdk);
                        ToolingStreamApiUtils.writeString(writer, "javaVersion", jdkJavaVersion == null ? null : jdkJavaVersion.name());
                        writer.stepOut();
                    } else {
                        writer.writeNull();
                    }
                }
                writer.stepOut();
            }
        });
    }

    private static void writeContentRoots(IonWriter writer, DomainObjectSet<? extends IdeaContentRoot> roots) throws IOException {
        writer.setFieldName("contentRoots");
        writer.stepIn(IonType.LIST);
        for (IdeaContentRoot contentRoot : roots) {
            IdeaProjectSerializationService.writeContentRoot(writer, contentRoot);
        }
        writer.stepOut();
    }

    private static void writeContentRoot(IonWriter writer, IdeaContentRoot contentRoot) throws IOException {
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeFile(writer, "rootDirectory", contentRoot.getRootDirectory());
        IdeaProjectSerializationService.writeSourceDirectories(writer, "sourceDirectories", (DomainObjectSet<? extends IdeaSourceDirectory>)contentRoot.getSourceDirectories());
        IdeaProjectSerializationService.writeSourceDirectories(writer, "testDirectories", (DomainObjectSet<? extends IdeaSourceDirectory>)contentRoot.getTestDirectories());
        IdeaProjectSerializationService.writeSourceDirectories(writer, "resourceDirectories", IdeaProjectSerializationService.notNullize(IdeaProjectSerializationService.nullizeUnsupported(new ResourceDirectoriesGetter(contentRoot))));
        IdeaProjectSerializationService.writeSourceDirectories(writer, "testResourceDirectories", IdeaProjectSerializationService.notNullize(IdeaProjectSerializationService.nullizeUnsupported(new TestResourceDirectoriesGetter(contentRoot))));
        ToolingStreamApiUtils.writeFiles(writer, "excludeDirectories", contentRoot.getExcludeDirectories());
        writer.stepOut();
    }

    private static void writeSourceDirectories(IonWriter writer, String fieldName, DomainObjectSet<? extends IdeaSourceDirectory> directories) throws IOException {
        writer.setFieldName(fieldName);
        writer.stepIn(IonType.LIST);
        for (IdeaSourceDirectory sourceDirectory : directories) {
            writer.stepIn(IonType.STRUCT);
            ToolingStreamApiUtils.writeBoolean(writer, "generated", sourceDirectory.isGenerated());
            ToolingStreamApiUtils.writeFile(writer, "directory", sourceDirectory.getDirectory());
            writer.stepOut();
        }
        writer.stepOut();
    }

    private static void writeCompilerOutput(final IonWriter writer, WriteContext context, final IdeaCompilerOutput ideaCompilerOutput) throws IOException {
        writer.setFieldName("compilerOutput");
        if (ideaCompilerOutput == null) {
            writer.writeNull();
            return;
        }
        context.ideaCompilerOutputCollector.add(ideaCompilerOutput, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeBoolean(writer, "inheritOutputDirs", ideaCompilerOutput.getInheritOutputDirs());
                    ToolingStreamApiUtils.writeFile(writer, "outputDir", ideaCompilerOutput.getOutputDir());
                    ToolingStreamApiUtils.writeFile(writer, "testOutputDir", ideaCompilerOutput.getTestOutputDir());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeGradleProject(final @NotNull IonWriter writer, @Nullable String fieldName, final @NotNull WriteContext context, final @Nullable GradleProject gradleProject) throws IOException {
        if (writer == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(2);
        }
        if (context == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(3);
        }
        if (fieldName != null) {
            writer.setFieldName(fieldName);
        }
        if (gradleProject == null) {
            writer.writeNull();
            return;
        }
        context.gradleProjectsCollector.add(gradleProject, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "name", gradleProject.getName());
                    ToolingStreamApiUtils.writeString(writer, "description", gradleProject.getDescription());
                    ToolingStreamApiUtils.writeFile(writer, "projectDirectory", gradleProject.getProjectDirectory());
                    IdeaProjectSerializationService.writeProjectIdentifier(writer, context, gradleProject.getProjectIdentifier());
                    ToolingStreamApiUtils.writeFile(writer, "buildDirectory", gradleProject.getBuildDirectory());
                    IdeaProjectSerializationService.writeGradleProject(writer, "parent", context, gradleProject.getParent());
                    writer.setFieldName("children");
                    writer.stepIn(IonType.LIST);
                    for (GradleProject ideaModule : gradleProject.getChildren()) {
                        IdeaProjectSerializationService.writeGradleProject(writer, null, context, ideaModule);
                    }
                    writer.stepOut();
                    ToolingStreamApiUtils.writeFile(writer, "buildScript", gradleProject.getBuildScript().getSourceFile());
                    writer.setFieldName("tasks");
                    writer.stepIn(IonType.LIST);
                    for (GradleTask task : gradleProject.getTasks()) {
                        IdeaProjectSerializationService.writeGradleTask(writer, context, task);
                    }
                    writer.stepOut();
                }
                writer.stepOut();
            }
        });
    }

    private static void writeGradleTask(final IonWriter writer, final WriteContext context, final @Nullable GradleTask task) throws IOException {
        if (task == null) {
            writer.writeNull();
            return;
        }
        context.gradleTasksCollector.add(task, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "name", task.getName());
                    ToolingStreamApiUtils.writeString(writer, "description", task.getDescription());
                    ToolingStreamApiUtils.writeString(writer, "path", task.getPath());
                    ToolingStreamApiUtils.writeString(writer, "group", task.getGroup());
                    ToolingStreamApiUtils.writeString(writer, "displayName", task.getDisplayName());
                    ToolingStreamApiUtils.writeBoolean(writer, "isPublic", task.isPublic());
                    IdeaProjectSerializationService.writeProjectIdentifier(writer, context, task.getProjectIdentifier());
                    IdeaProjectSerializationService.writeGradleProject(writer, "project", context, task.getProject());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeProjectIdentifier(final IonWriter writer, final WriteContext context, final ProjectIdentifier projectIdentifier) throws IOException {
        writer.setFieldName("projectIdentifier");
        if (projectIdentifier == null) {
            writer.writeNull();
            return;
        }
        context.projectIdentifiersCollector.add(projectIdentifier, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "projectPath", projectIdentifier.getProjectPath());
                    IdeaProjectSerializationService.writeBuildIdentifier(writer, context, projectIdentifier.getBuildIdentifier());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeBuildIdentifier(final IonWriter writer, WriteContext context, final BuildIdentifier buildIdentifier) throws IOException {
        writer.setFieldName("buildIdentifier");
        context.buildIdentifiersCollector.add(buildIdentifier, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeFile(writer, "rootDir", buildIdentifier.getRootDir());
                }
                writer.stepOut();
            }
        });
    }

    @Nullable
    private InternalIdeaProject readProject(final @NotNull IonReader reader, final @NotNull ReadContext context) {
        if (reader == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(4);
        }
        if (context == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(5);
        }
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaProject project = (InternalIdeaProject)context.projectsMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.ObjectFactory<InternalIdeaProject>(){

            public InternalIdeaProject newInstance() {
                return new InternalIdeaProject();
            }

            public void fill(InternalIdeaProject ideaProject) {
                ideaProject.setName(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "name")));
                ideaProject.setDescription(ToolingStreamApiUtils.readString(reader, "description"));
                ideaProject.setJdkName(ToolingStreamApiUtils.readString(reader, "jdkName"));
                ideaProject.setJavaLanguageSettings(IdeaProjectSerializationService.readJavaLanguageSettings(reader, context));
                ideaProject.setLanguageLevel(new InternalIdeaLanguageLevel(ToolingStreamApiUtils.readString(reader, "languageLevel")));
                IdeaProjectSerializationService.this.readModules(reader, context, ideaProject);
            }
        });
        reader.stepOut();
        return project;
    }

    private void readModules(IonReader reader, ReadContext context, InternalIdeaProject project) {
        InternalIdeaModule ideaModule;
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "ideaModules");
        reader.stepIn();
        ArrayList<InternalIdeaModule> ideaModules = new ArrayList<InternalIdeaModule>();
        while ((ideaModule = this.readModule(reader, context)) != null) {
            ideaModule.setParent(project);
            ideaModules.add(ideaModule);
        }
        project.setModules(ideaModules);
        reader.stepOut();
    }

    @Nullable
    private InternalIdeaModule readModule(IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaModule ideaModule = new InternalIdeaModule();
        ideaModule.setName(ToolingStreamApiUtils.readString(reader, "name"));
        ideaModule.setDescription(ToolingStreamApiUtils.readString(reader, "description"));
        ideaModule.setJdkName(ToolingStreamApiUtils.readString(reader, "jdkName"));
        ideaModule.setGradleProject(IdeaProjectSerializationService.readGradleProject(reader, context, "gradleProject"));
        ideaModule.setCompilerOutput(IdeaProjectSerializationService.readCompilerOutput(reader, context));
        ideaModule.setContentRoots(this.readContentRoots(reader));
        ideaModule.setJavaLanguageSettings(IdeaProjectSerializationService.readJavaLanguageSettings(reader, context));
        ideaModule.setDependencies(IdeaProjectSerializationService.readDependencies(reader, context));
        reader.stepOut();
        return ideaModule;
    }

    private static List<InternalIdeaDependency> readDependencies(IonReader reader, ReadContext context) {
        InternalIdeaDependency dependency;
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "dependencies");
        reader.stepIn();
        ArrayList<InternalIdeaDependency> dependencies = new ArrayList<InternalIdeaDependency>();
        while ((dependency = IdeaProjectSerializationService.readDependency(reader, context)) != null) {
            dependencies.add(dependency);
        }
        reader.stepOut();
        return dependencies;
    }

    private static InternalIdeaDependency readDependency(final IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaDependency dependency = (InternalIdeaDependency)context.dependenciesMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<InternalIdeaDependency>(){

            public InternalIdeaDependency create() {
                String type = ToolingStreamApiUtils.readString(reader, "_type");
                if (IdeaModuleDependency.class.getSimpleName().equals(type)) {
                    InternalIdeaModuleDependency moduleDependency = new InternalIdeaModuleDependency();
                    moduleDependency.setTargetModuleName(ToolingStreamApiUtils.readString(reader, "targetModuleName"));
                    moduleDependency.setScope(InternalIdeaDependencyScope.getInstance((String)ToolingStreamApiUtils.readString(reader, "scope")));
                    moduleDependency.setExported(ToolingStreamApiUtils.readBoolean(reader, "exported"));
                    return moduleDependency;
                }
                if (IdeaSingleEntryLibraryDependency.class.getSimpleName().equals(type)) {
                    File file = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readFile(reader, "file"));
                    InternalIdeaSingleEntryLibraryDependency libraryDependency = new InternalIdeaSingleEntryLibraryDependency(file);
                    libraryDependency.setJavadoc(ToolingStreamApiUtils.readFile(reader, "javadoc"));
                    libraryDependency.setSource(ToolingStreamApiUtils.readFile(reader, "source"));
                    libraryDependency.setScope(InternalIdeaDependencyScope.getInstance((String)ToolingStreamApiUtils.readString(reader, "scope")));
                    libraryDependency.setExported(ToolingStreamApiUtils.readBoolean(reader, "exported"));
                    IonType ionType = reader.next();
                    ToolingStreamApiUtils.assertFieldName(reader, "gradleModuleVersion");
                    if (ionType != IonType.NULL) {
                        reader.stepIn();
                        InternalGradleModuleVersion moduleVersion = new InternalGradleModuleVersion();
                        moduleVersion.setGroup(ToolingStreamApiUtils.readString(reader, "group"));
                        moduleVersion.setName(ToolingStreamApiUtils.readString(reader, "name"));
                        moduleVersion.setVersion(ToolingStreamApiUtils.readString(reader, "version"));
                        reader.stepOut();
                        libraryDependency.setModuleVersion(moduleVersion);
                    }
                    return libraryDependency;
                }
                throw new RuntimeException("Unsupported dependency '" + type + "'");
            }
        });
        reader.stepOut();
        return dependency;
    }

    @NotNull
    private List<InternalIdeaContentRoot> readContentRoots(IonReader reader) {
        InternalIdeaContentRoot child;
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "contentRoots");
        reader.stepIn();
        ArrayList<InternalIdeaContentRoot> contentRoots = new ArrayList<InternalIdeaContentRoot>();
        while ((child = this.readContentRoot(reader)) != null) {
            contentRoots.add(child);
        }
        reader.stepOut();
        ArrayList<InternalIdeaContentRoot> arrayList = contentRoots;
        if (arrayList == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private InternalIdeaContentRoot readContentRoot(IonReader reader) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaContentRoot contentRoot = new InternalIdeaContentRoot(this.myReadContext.myGradleVersionComparator);
        contentRoot.setRootDirectory(ToolingStreamApiUtils.readFile(reader, "rootDirectory"));
        contentRoot.setSourceDirectories(IdeaProjectSerializationService.readSourceDirectories(reader, "sourceDirectories"));
        contentRoot.setTestDirectories(IdeaProjectSerializationService.readSourceDirectories(reader, "testDirectories"));
        contentRoot.setResourceDirectories(IdeaProjectSerializationService.readSourceDirectories(reader, "resourceDirectories"));
        contentRoot.setTestResourceDirectories(IdeaProjectSerializationService.readSourceDirectories(reader, "testResourceDirectories"));
        contentRoot.setExcludeDirectories(ToolingStreamApiUtils.readFileSet(reader, "excludeDirectories"));
        reader.stepOut();
        return contentRoot;
    }

    private static Set<InternalIdeaSourceDirectory> readSourceDirectories(IonReader reader, String fieldName) {
        InternalIdeaSourceDirectory sourceDirectory;
        IonType ionType = reader.next();
        if (fieldName != null) {
            ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        }
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        LinkedHashSet<InternalIdeaSourceDirectory> sourceDirectories = new LinkedHashSet<InternalIdeaSourceDirectory>();
        while ((sourceDirectory = IdeaProjectSerializationService.readSourceDirectory(reader)) != null) {
            sourceDirectories.add(sourceDirectory);
        }
        reader.stepOut();
        return sourceDirectories;
    }

    private static InternalIdeaSourceDirectory readSourceDirectory(IonReader reader) {
        IonType ionType = reader.next();
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaSourceDirectory sourceDirectory = new InternalIdeaSourceDirectory();
        sourceDirectory.setGenerated(ToolingStreamApiUtils.readBoolean(reader, "generated"));
        sourceDirectory.setDirectory(ToolingStreamApiUtils.readFile(reader, "directory"));
        reader.stepOut();
        return sourceDirectory;
    }

    private static InternalIdeaCompilerOutput readCompilerOutput(final IonReader reader, ReadContext context) {
        IonType ionType = reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "compilerOutput");
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaCompilerOutput project = (InternalIdeaCompilerOutput)context.compilerOutputsMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<InternalIdeaCompilerOutput>(){

            public InternalIdeaCompilerOutput create() {
                InternalIdeaCompilerOutput compilerOutput = new InternalIdeaCompilerOutput();
                compilerOutput.setInheritOutputDirs(ToolingStreamApiUtils.readBoolean(reader, "inheritOutputDirs"));
                compilerOutput.setOutputDir(ToolingStreamApiUtils.readFile(reader, "outputDir"));
                compilerOutput.setTestOutputDir(ToolingStreamApiUtils.readFile(reader, "testOutputDir"));
                return compilerOutput;
            }
        });
        reader.stepOut();
        return project;
    }

    @Nullable
    private static InternalGradleProject readGradleProject(final IonReader reader, final ReadContext context, String fieldName) {
        IonType ionType = reader.next();
        if (fieldName != null) {
            ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        }
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalGradleProject project = (InternalGradleProject)context.gradleProjectsMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.ObjectFactory<InternalGradleProject>(){

            public InternalGradleProject newInstance() {
                return new InternalGradleProject();
            }

            public void fill(InternalGradleProject gradleProject) {
                InternalGradleTask task;
                InternalGradleProject child;
                gradleProject.setName(ToolingStreamApiUtils.readString(reader, "name"));
                gradleProject.setDescription(ToolingStreamApiUtils.readString(reader, "description"));
                gradleProject.setProjectDirectory(ToolingStreamApiUtils.readFile(reader, "projectDirectory"));
                gradleProject.setProjectIdentifier(IdeaProjectSerializationService.readProjectIdentifier(reader, context));
                gradleProject.setBuildDirectory(ToolingStreamApiUtils.readFile(reader, "buildDirectory"));
                gradleProject.setParent(IdeaProjectSerializationService.readGradleProject(reader, context, "parent"));
                reader.next();
                ToolingStreamApiUtils.assertFieldName(reader, "children");
                reader.stepIn();
                ArrayList<InternalGradleProject> children = new ArrayList<InternalGradleProject>();
                while ((child = IdeaProjectSerializationService.readGradleProject(reader, context, null)) != null) {
                    children.add(child);
                }
                gradleProject.setChildren(children);
                reader.stepOut();
                gradleProject.getBuildScript().setSourceFile(ToolingStreamApiUtils.readFile(reader, "buildScript"));
                reader.next();
                ToolingStreamApiUtils.assertFieldName(reader, "tasks");
                reader.stepIn();
                ArrayList<InternalGradleTask> tasks = new ArrayList<InternalGradleTask>();
                while ((task = IdeaProjectSerializationService.readGradleTask(reader, context)) != null) {
                    tasks.add(task);
                }
                gradleProject.setTasks(tasks);
                reader.stepOut();
            }
        });
        reader.stepOut();
        return project;
    }

    private static InternalGradleTask readGradleTask(final IonReader reader, final ReadContext context) {
        IonType ionType = reader.next();
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalGradleTask project = (InternalGradleTask)context.tasksMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.ObjectFactory<InternalGradleTask>(){

            public InternalGradleTask newInstance() {
                return new InternalGradleTask();
            }

            public void fill(InternalGradleTask gradleTask) {
                gradleTask.setName(ToolingStreamApiUtils.readString(reader, "name"));
                gradleTask.setDescription(ToolingStreamApiUtils.readString(reader, "description"));
                gradleTask.setPath(ToolingStreamApiUtils.readString(reader, "path"));
                gradleTask.setGroup(ToolingStreamApiUtils.readString(reader, "group"));
                gradleTask.setDisplayName(ToolingStreamApiUtils.readString(reader, "displayName"));
                gradleTask.setPublic(ToolingStreamApiUtils.readBoolean(reader, "isPublic"));
                gradleTask.setProjectIdentifier(IdeaProjectSerializationService.readProjectIdentifier(reader, context));
                gradleTask.setGradleProject(IdeaProjectSerializationService.readGradleProject(reader, context, "project"));
            }
        });
        reader.stepOut();
        return project;
    }

    private static InternalProjectIdentifier readProjectIdentifier(final IonReader reader, final ReadContext context) {
        IonType ionType = reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "projectIdentifier");
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalProjectIdentifier dependency = (InternalProjectIdentifier)context.projectsIdentifiersMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<InternalProjectIdentifier>(){

            public InternalProjectIdentifier create() {
                String projectPath = ToolingStreamApiUtils.readString(reader, "projectPath");
                InternalBuildIdentifier buildIdentifier = IdeaProjectSerializationService.readBuildIdentifier(reader, context);
                return new InternalProjectIdentifier(buildIdentifier, projectPath);
            }
        });
        reader.stepOut();
        return dependency;
    }

    private static InternalBuildIdentifier readBuildIdentifier(final IonReader reader, ReadContext context) {
        IonType ionType = reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "buildIdentifier");
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalBuildIdentifier buildIdentifier = (InternalBuildIdentifier)context.buildsIdentifiersMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<InternalBuildIdentifier>(){

            public InternalBuildIdentifier create() {
                return new InternalBuildIdentifier(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readFile(reader, "rootDir")));
            }
        });
        reader.stepOut();
        return buildIdentifier;
    }

    private static InternalIdeaJavaLanguageSettings readJavaLanguageSettings(final IonReader reader, ReadContext context) {
        IonType ionType = reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "javaLanguageSettings");
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaJavaLanguageSettings dependency = (InternalIdeaJavaLanguageSettings)context.languageSettingsMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<InternalIdeaJavaLanguageSettings>(){

            public InternalIdeaJavaLanguageSettings create() {
                String bytecodeVersion;
                InternalIdeaJavaLanguageSettings languageSettings = new InternalIdeaJavaLanguageSettings();
                String languageLevel = ToolingStreamApiUtils.readString(reader, "languageLevel");
                if (languageLevel != null) {
                    languageSettings.setLanguageLevel(JavaVersion.valueOf((String)languageLevel));
                }
                if ((bytecodeVersion = ToolingStreamApiUtils.readString(reader, "targetBytecodeVersion")) != null) {
                    languageSettings.setTargetBytecodeVersion(JavaVersion.valueOf((String)bytecodeVersion));
                }
                languageSettings.setJdk(IdeaProjectSerializationService.readJdk(reader));
                return languageSettings;
            }
        });
        reader.stepOut();
        return dependency;
    }

    @Nullable
    private static InternalInstalledJdk readJdk(IonReader reader) {
        IonType ionType = reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "jdk");
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        File javaHome = ToolingStreamApiUtils.readFile(reader, "javaHome");
        String versionString = ToolingStreamApiUtils.readString(reader, "javaVersion");
        JavaVersion javaVersion = versionString == null ? null : JavaVersion.valueOf((String)versionString);
        InternalInstalledJdk jdk = new InternalInstalledJdk(javaHome, javaVersion);
        reader.stepOut();
        return jdk;
    }

    @Nullable
    private static String getJavaVersion(@Nullable JavaVersion javaVersion) {
        return javaVersion == null ? null : javaVersion.name();
    }

    @Nullable
    private static JavaVersion getLanguageLevel(@NotNull IdeaJavaLanguageSettings languageSettings) {
        if (languageSettings == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(7);
        }
        try {
            return languageSettings.getLanguageLevel();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private static JavaVersion getTargetBytecodeVersion(@NotNull IdeaJavaLanguageSettings languageSettings) {
        if (languageSettings == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(8);
        }
        try {
            return languageSettings.getTargetBytecodeVersion();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private static JavaVersion getJavaVersion(@NotNull InstalledJdk jdk) {
        if (jdk == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(9);
        }
        try {
            return jdk.getJavaVersion();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private static <T> T nullizeUnsupported(@NotNull Supplier<T> getter) {
        if (getter == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(10);
        }
        try {
            return (T)getter.get();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    @NotNull
    public static <T> DomainObjectSet<T> notNullize(@Nullable DomainObjectSet<T> set) {
        DomainObjectSet<T> domainObjectSet = set == null ? GradleContainerUtil.emptyDomainObjectSet() : set;
        if (domainObjectSet == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(11);
        }
        return domainObjectSet;
    }

    @NotNull
    private static GradleVersion getBuildGradleVersion(@Nullable IdeaProject ideaProject) {
        GradleVersion gradleVersion;
        try {
            ClassLoader classLoader = new ProtocolToModelAdapter().unpack((Object)ideaProject).getClass().getClassLoader();
            Class<?> gradleVersionClass = classLoader.loadClass("org.gradle.util.GradleVersion");
            Object buildGradleVersion = gradleVersionClass.getMethod("current", new Class[0]).invoke(gradleVersionClass, new Object[0]);
            gradleVersion = GradleVersion.version((String)gradleVersionClass.getMethod("getVersion", new Class[0]).invoke(buildGradleVersion, new Object[0]).toString());
        }
        catch (Exception exception) {
            GradleVersion gradleVersion2 = GradleVersion.current();
            if (gradleVersion2 == null) {
                IdeaProjectSerializationService.$$$reportNull$$$0(13);
            }
            return gradleVersion2;
        }
        if (gradleVersion == null) {
            IdeaProjectSerializationService.$$$reportNull$$$0(12);
        }
        return gradleVersion;
    }

    private static int argsHashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    private static boolean nullsafeEqual(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/serialization/internal/IdeaProjectSerializationService";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/serialization/internal/IdeaProjectSerializationService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildGradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeJavaLanguageSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeGradleProject";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readProject";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTargetBytecodeVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getJavaVersion";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "nullizeUnsupported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReadContext {
        private final IntObjectMap<InternalIdeaProject> projectsMap = new IntObjectMap();
        private final IntObjectMap<InternalIdeaJavaLanguageSettings> languageSettingsMap = new IntObjectMap();
        private final IntObjectMap<InternalGradleProject> gradleProjectsMap = new IntObjectMap();
        private final IntObjectMap<InternalProjectIdentifier> projectsIdentifiersMap = new IntObjectMap();
        private final IntObjectMap<InternalBuildIdentifier> buildsIdentifiersMap = new IntObjectMap();
        private final IntObjectMap<InternalGradleTask> tasksMap = new IntObjectMap();
        private final IntObjectMap<InternalIdeaCompilerOutput> compilerOutputsMap = new IntObjectMap();
        private final IntObjectMap<InternalIdeaDependency> dependenciesMap = new IntObjectMap();
        private GradleVersionComparator myGradleVersionComparator;

        private ReadContext() {
        }

        private void setGradleVersion(@NotNull GradleVersion gradleVersion) {
            if (gradleVersion == null) {
                ReadContext.$$$reportNull$$$0(0);
            }
            this.myGradleVersionComparator = new GradleVersionComparator(gradleVersion);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "org/jetbrains/plugins/gradle/tooling/serialization/internal/IdeaProjectSerializationService$ReadContext", "setGradleVersion"));
        }
    }

    private static final class WriteContext {
        private final ProtocolToModelAdapter modelAdapter = new ProtocolToModelAdapter();
        private GradleVersionComparator myGradleVersionComparator;
        private final ObjectCollector<IdeaProject, IOException> ideaProjectsCollector = new ObjectCollector(new TObjectHashingStrategy<IdeaProject>(){

            public int computeHashCode(IdeaProject object) {
                return object == null ? 0 : object.getName().hashCode();
            }

            public boolean equals(IdeaProject o1, IdeaProject o2) {
                if (o1 == o2) {
                    return true;
                }
                if (o1 != null && o2 != null) {
                    DomainObjectSet modules1 = o1.getModules();
                    DomainObjectSet modules2 = o2.getModules();
                    if (modules1.size() != modules2.size()) {
                        return false;
                    }
                    BuildIdentifier buildIdentifier1 = ((IdeaModule)modules1.getAt(0)).getGradleProject().getProjectIdentifier().getBuildIdentifier();
                    BuildIdentifier buildIdentifier2 = ((IdeaModule)modules2.getAt(0)).getGradleProject().getProjectIdentifier().getBuildIdentifier();
                    return WriteContext.isSameBuild(buildIdentifier1, buildIdentifier2);
                }
                return false;
            }
        });
        private final ObjectCollector<GradleProject, IOException> gradleProjectsCollector = new ObjectCollector(new TObjectHashingStrategy<GradleProject>(){

            public int computeHashCode(GradleProject object) {
                return object == null ? 0 : object.getPath().hashCode();
            }

            public boolean equals(GradleProject o1, GradleProject o2) {
                return o1 == o2 || o1 != null && o2 != null && WriteContext.isSameProject(o1.getProjectIdentifier(), o2.getProjectIdentifier());
            }
        });
        private final ObjectCollector<IdeaCompilerOutput, IOException> ideaCompilerOutputCollector = new ObjectCollector(new TObjectHashingStrategy<IdeaCompilerOutput>(){

            public int computeHashCode(IdeaCompilerOutput object) {
                return IdeaProjectSerializationService.argsHashCode(new Object[]{object.getInheritOutputDirs(), object.getOutputDir(), object.getTestOutputDir()});
            }

            public boolean equals(IdeaCompilerOutput o1, IdeaCompilerOutput o2) {
                return o1 == o2 || o1 != null && o2 != null && o1.getInheritOutputDirs() == o2.getInheritOutputDirs() && Comparing.compare((Object)o1.getOutputDir(), (Object)o2.getOutputDir(), (Comparator)new FilePathComparator()) == 0 && Comparing.compare((Comparable)o1.getTestOutputDir(), (Comparable)o2.getTestOutputDir()) == 0;
            }
        });
        private final ObjectCollector<GradleTask, IOException> gradleTasksCollector = new ObjectCollector(new TObjectHashingStrategy<GradleTask>(){

            public int computeHashCode(GradleTask object) {
                return object == null ? 0 : object.getPath().hashCode();
            }

            public boolean equals(GradleTask o1, GradleTask o2) {
                return o1 == o2 || o1 != null && o2 != null && o1.getPath().equals(o2.getPath()) && WriteContext.isSameProject(o1.getProjectIdentifier(), o2.getProjectIdentifier());
            }
        });
        private final ObjectCollector<IdeaDependency, IOException> ideaDependenciesCollector = new ObjectCollector(new TObjectHashingStrategy<IdeaDependency>(){

            public int computeHashCode(IdeaDependency object) {
                if (object == null) {
                    return 0;
                }
                if (object instanceof IdeaModuleDependency) {
                    return this.computeHashCode((IdeaModuleDependency)object);
                }
                if (object instanceof IdeaSingleEntryLibraryDependency) {
                    return this.computeHashCode((IdeaSingleEntryLibraryDependency)object);
                }
                return object.hashCode();
            }

            public boolean equals(IdeaDependency o1, IdeaDependency o2) {
                if (o1 == o2) {
                    return true;
                }
                if (o1 != null && o2 != null) {
                    if (o1 instanceof IdeaModuleDependency && o2 instanceof IdeaModuleDependency) {
                        return this.equals((IdeaModuleDependency)o1, (IdeaModuleDependency)o2);
                    }
                    if (o1 instanceof IdeaSingleEntryLibraryDependency && o2 instanceof IdeaSingleEntryLibraryDependency) {
                        return this.equals((IdeaSingleEntryLibraryDependency)o1, (IdeaSingleEntryLibraryDependency)o2);
                    }
                }
                return false;
            }

            private int computeHashCode(@NotNull IdeaModuleDependency object) {
                if (object == null) {
                    5.$$$reportNull$$$0(0);
                }
                return IdeaProjectSerializationService.argsHashCode(new Object[]{new TargetModuleNameGetter(object, myGradleVersionComparator).get(), object.getScope().getScope()});
            }

            private int computeHashCode(@NotNull IdeaSingleEntryLibraryDependency object) {
                if (object == null) {
                    5.$$$reportNull$$$0(1);
                }
                return IdeaProjectSerializationService.argsHashCode(new Object[]{object.getFile(), object.getScope().getScope(), this.hasCode(object.getGradleModuleVersion())});
            }

            private int hasCode(@Nullable GradleModuleVersion version) {
                return version == null ? 0 : IdeaProjectSerializationService.argsHashCode(new Object[]{version.getGroup(), version.getName(), version.getVersion()});
            }

            private boolean equals(@NotNull IdeaModuleDependency o1, @NotNull IdeaModuleDependency o2) {
                if (o1 == null) {
                    5.$$$reportNull$$$0(2);
                }
                if (o2 == null) {
                    5.$$$reportNull$$$0(3);
                }
                return o1.getExported() == o2.getExported() && IdeaProjectSerializationService.nullsafeEqual(new TargetModuleNameGetter(o1, myGradleVersionComparator).get(), new TargetModuleNameGetter(o2, myGradleVersionComparator).get()) && IdeaProjectSerializationService.nullsafeEqual(o1.getScope().getScope(), o2.getScope().getScope());
            }

            private boolean equals(@NotNull IdeaSingleEntryLibraryDependency o1, @NotNull IdeaSingleEntryLibraryDependency o2) {
                if (o1 == null) {
                    5.$$$reportNull$$$0(4);
                }
                if (o2 == null) {
                    5.$$$reportNull$$$0(5);
                }
                return o1.getExported() == o2.getExported() && this.equal(o1.getGradleModuleVersion(), o2.getGradleModuleVersion()) && IdeaProjectSerializationService.nullsafeEqual(o1.getFile().getPath(), o2.getFile().getPath()) && IdeaProjectSerializationService.nullsafeEqual(o1.getScope().getScope(), o2.getScope().getScope());
            }

            private boolean equal(@Nullable GradleModuleVersion version1, @Nullable GradleModuleVersion version2) {
                return version1 == version2 || version1 != null && version2 != null && IdeaProjectSerializationService.nullsafeEqual(version1.getName(), version2.getName()) && IdeaProjectSerializationService.nullsafeEqual(version1.getGroup(), version2.getGroup()) && IdeaProjectSerializationService.nullsafeEqual(version1.getVersion(), version2.getVersion());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o1";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o2";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/serialization/internal/IdeaProjectSerializationService$WriteContext$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computeHashCode";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "equals";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        private final ObjectCollector<IdeaJavaLanguageSettings, IOException> ideaJavaLanguageSettingsCollector = new ObjectCollector(new TObjectHashingStrategy<IdeaJavaLanguageSettings>(){

            public int computeHashCode(IdeaJavaLanguageSettings object) {
                return object == null ? 0 : IdeaProjectSerializationService.argsHashCode(new Object[]{IdeaProjectSerializationService.getLanguageLevel(object), IdeaProjectSerializationService.nullizeUnsupported(new TargetBytecodeVersionGetter(object)), IdeaProjectSerializationService.nullizeUnsupported(new JavaHomePathGetter(object))});
            }

            public boolean equals(IdeaJavaLanguageSettings o1, IdeaJavaLanguageSettings o2) {
                return o1 == o2 || o1 != null && o2 != null && IdeaProjectSerializationService.getLanguageLevel(o1) == IdeaProjectSerializationService.getLanguageLevel(o2) && IdeaProjectSerializationService.nullsafeEqual(IdeaProjectSerializationService.nullizeUnsupported(new TargetBytecodeVersionGetter(o1)), IdeaProjectSerializationService.nullizeUnsupported(new TargetBytecodeVersionGetter(o2))) && IdeaProjectSerializationService.nullsafeEqual(IdeaProjectSerializationService.nullizeUnsupported(new JavaHomePathGetter(o1)), IdeaProjectSerializationService.nullizeUnsupported(new JavaHomePathGetter(o2)));
            }
        });
        private final ObjectCollector<ProjectIdentifier, IOException> projectIdentifiersCollector = new ObjectCollector(new TObjectHashingStrategy<ProjectIdentifier>(){

            public int computeHashCode(ProjectIdentifier object) {
                return object == null ? 0 : object.getProjectPath().hashCode();
            }

            public boolean equals(ProjectIdentifier o1, ProjectIdentifier o2) {
                return o1 == o2 || o1 != null && o2 != null && WriteContext.isSameProject(o1, o2);
            }
        });
        private final ObjectCollector<BuildIdentifier, IOException> buildIdentifiersCollector = new ObjectCollector(new TObjectHashingStrategy<BuildIdentifier>(){

            public int computeHashCode(BuildIdentifier object) {
                return object == null ? 0 : object.getRootDir().getPath().hashCode();
            }

            public boolean equals(BuildIdentifier o1, BuildIdentifier o2) {
                return o1 == o2 || o1 != null && o2 != null && WriteContext.isSameBuild(o1, o2);
            }
        });

        private WriteContext() {
        }

        private void setGradleVersion(@NotNull GradleVersion gradleVersion) {
            if (gradleVersion == null) {
                WriteContext.$$$reportNull$$$0(0);
            }
            this.myGradleVersionComparator = new GradleVersionComparator(gradleVersion);
        }

        private static boolean isSameBuild(BuildIdentifier buildIdentifier1, BuildIdentifier buildIdentifier2) {
            String rootBuildPath1 = buildIdentifier1.getRootDir().getPath();
            String rootBuildPath2 = buildIdentifier2.getRootDir().getPath();
            return rootBuildPath1.equals(rootBuildPath2);
        }

        private static boolean isSameProject(ProjectIdentifier o1, ProjectIdentifier o2) {
            if (o1 == null || o2 == null) {
                return false;
            }
            if (!o1.getProjectPath().equals(o2.getProjectPath())) {
                return false;
            }
            return WriteContext.isSameBuild(o1.getBuildIdentifier(), o2.getBuildIdentifier());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "org/jetbrains/plugins/gradle/tooling/serialization/internal/IdeaProjectSerializationService$WriteContext", "setGradleVersion"));
        }

        private static class FilePathComparator
        implements Comparator<File> {
            private FilePathComparator() {
            }

            @Override
            public int compare(File o1, File o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        }
    }

    private static final class ResourceDirectoriesGetter
    implements Supplier<DomainObjectSet<? extends IdeaSourceDirectory>> {
        private final IdeaContentRoot myContentRoot;

        private ResourceDirectoriesGetter(IdeaContentRoot contentRoot) {
            this.myContentRoot = contentRoot;
        }

        public DomainObjectSet<? extends IdeaSourceDirectory> get() {
            return this.myContentRoot.getResourceDirectories();
        }
    }

    private static final class TestResourceDirectoriesGetter
    implements Supplier<DomainObjectSet<? extends IdeaSourceDirectory>> {
        private final IdeaContentRoot myContentRoot;

        private TestResourceDirectoriesGetter(IdeaContentRoot contentRoot) {
            this.myContentRoot = contentRoot;
        }

        public DomainObjectSet<? extends IdeaSourceDirectory> get() {
            return this.myContentRoot.getTestResourceDirectories();
        }
    }

    private static final class TargetModuleNameGetter
    implements Supplier<String> {
        private final IdeaModuleDependency myModuleDependency;
        private final GradleVersionComparator myGradleVersionComparator;

        private TargetModuleNameGetter(@NotNull IdeaModuleDependency moduleDependency, @NotNull GradleVersionComparator gradleVersionComparator) {
            if (moduleDependency == null) {
                TargetModuleNameGetter.$$$reportNull$$$0(0);
            }
            if (gradleVersionComparator == null) {
                TargetModuleNameGetter.$$$reportNull$$$0(1);
            }
            this.myModuleDependency = moduleDependency;
            this.myGradleVersionComparator = gradleVersionComparator;
        }

        public String get() {
            if (this.myModuleDependency instanceof BackwardsCompatibleIdeaModuleDependency && this.myGradleVersionComparator.lessThan("3.1")) {
                return ((BackwardsCompatibleIdeaModuleDependency)this.myModuleDependency).getDependencyModule().getName();
            }
            return this.myModuleDependency.getTargetModuleName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleDependency";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gradleVersionComparator";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/tooling/serialization/internal/IdeaProjectSerializationService$TargetModuleNameGetter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JavaHomePathGetter
    implements Supplier<String> {
        private final IdeaJavaLanguageSettings myObject;

        private JavaHomePathGetter(IdeaJavaLanguageSettings object) {
            this.myObject = object;
        }

        public String get() {
            InstalledJdk jdk = this.myObject.getJdk();
            if (jdk != null) {
                File home = jdk.getJavaHome();
                return home == null ? null : home.getPath();
            }
            return null;
        }
    }

    private static final class JdkGetter
    implements Supplier<InstalledJdk> {
        private final IdeaJavaLanguageSettings myObject;

        private JdkGetter(IdeaJavaLanguageSettings object) {
            this.myObject = object;
        }

        public InstalledJdk get() {
            return this.myObject.getJdk();
        }
    }

    private static final class TargetBytecodeVersionGetter
    implements Supplier<JavaVersion> {
        private final IdeaJavaLanguageSettings myObject;

        private TargetBytecodeVersionGetter(IdeaJavaLanguageSettings object) {
            this.myObject = object;
        }

        public JavaVersion get() {
            return IdeaProjectSerializationService.getTargetBytecodeVersion(this.myObject);
        }
    }
}

