/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitCheck;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.checkin.GitCheckinHandler;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0003\u0016\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0019"}, d2={"Lgit4idea/checkin/GitFileNameCheckinHandler;", "Lgit4idea/checkin/GitCheckinHandler;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getExecutionOrder", "Lcom/intellij/openapi/vcs/checkin/CommitCheck$ExecutionOrder;", "isEnabled", "", "runGitCheck", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "committedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "(Lcom/intellij/openapi/vcs/checkin/CommitInfo;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkFileName", "Lgit4idea/checkin/GitFileNameCheckinHandler$GitFileNameCommitProblem;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "BadFileNameType", "Companion", "GitFileNameCommitProblem", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCheckinHandlerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCheckinHandlerFactory.kt\ngit4idea/checkin/GitFileNameCheckinHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,538:1\n1761#2,3:539\n1088#3,2:542\n*S KotlinDebug\n*F\n+ 1 GitCheckinHandlerFactory.kt\ngit4idea/checkin/GitFileNameCheckinHandler\n*L\n463#1:539,3\n467#1:542,2\n*E\n"})
final class GitFileNameCheckinHandler
extends GitCheckinHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String WINDOWS_INVALID_CHARS = "<>:\"\\|?*";
    @NotNull
    private static final Set<String> WINDOWS_RESERVED_NAMES;

    public GitFileNameCheckinHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public CommitCheck.ExecutionOrder getExecutionOrder() {
        return CommitCheck.ExecutionOrder.EARLY;
    }

    public boolean isEnabled() {
        return !SystemInfo.isWindows && GitVcsSettings.getInstance(this.getProject()).warnAboutBadFileNames();
    }

    @Override
    @Nullable
    public Object runGitCheck(@NotNull CommitInfo commitInfo, @NotNull List<? extends Change> committedChanges, @NotNull Continuation<? super CommitProblem> $completion) {
        for (Change change : committedChanges) {
            GitFileNameCommitProblem problem;
            ContentRevision contentRevision = change.getBeforeRevision();
            FilePath beforePath = contentRevision != null ? contentRevision.getFile() : null;
            ContentRevision contentRevision2 = change.getAfterRevision();
            Object afterPath = contentRevision2 != null ? contentRevision2.getFile() : null;
            if (afterPath == null || Intrinsics.areEqual((Object)beforePath, (Object)afterPath) || (problem = this.checkFileName((FilePath)afterPath)) == null) continue;
            return problem;
        }
        return null;
    }

    private final GitFileNameCommitProblem checkFileName(FilePath filePath) {
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.getProject()).getRepositoryForFile(filePath);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repo2 = gitRepository;
        FilePath filePath2 = VcsUtil.getFilePath((VirtualFile)repo2.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"getFilePath(...)");
        FilePath rootPath = filePath2;
        for (FilePath parentPath = filePath; parentPath != null && !Intrinsics.areEqual((Object)parentPath, (Object)rootPath); parentPath = parentPath.getParentPath()) {
            boolean bl;
            String fileName;
            block9: {
                boolean $i$f$any;
                String fileNameWithoutExtension;
                Intrinsics.checkNotNullExpressionValue((Object)parentPath.getName(), (String)"getName(...)");
                Intrinsics.checkNotNullExpressionValue((Object)FileUtil.getNameWithoutExtension((String)fileName), (String)"getNameWithoutExtension(...)");
                int n = fileNameWithoutExtension.length();
                boolean bl2 = 3 <= n ? n < 5 : false;
                if (bl2) {
                    boolean bl3;
                    block8: {
                        Iterable $this$any$iv = WINDOWS_RESERVED_NAMES;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl4 = false;
                                if (!StringsKt.equals((String)it, (String)fileNameWithoutExtension, (boolean)true)) continue;
                                bl3 = true;
                                break block8;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        return new GitFileNameCommitProblem(fileName, BadFileNameType.RESERVED);
                    }
                }
                CharSequence $this$any$iv = fileName;
                $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char c = element$iv = $this$any$iv.charAt(i);
                    boolean bl5 = false;
                    if (!(c <= '\u001f' || StringsKt.contains$default((CharSequence)WINDOWS_INVALID_CHARS, (char)c, (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
            if (!bl) continue;
            return new GitFileNameCommitProblem(fileName, BadFileNameType.INVALID_CHAR);
        }
        return null;
    }

    static {
        Object[] objectArray = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
        WINDOWS_RESERVED_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B \b\u0002\u0012\u0015\u0010\u0002\u001a\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR \u0010\u0002\u001a\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lgit4idea/checkin/GitFileNameCheckinHandler$BadFileNameType;", "", "msgKey", "", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.GitBundle", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getMsgKey", "()Ljava/lang/String;", "RESERVED", "INVALID_CHAR", "intellij.vcs.git"})
    public static final class BadFileNameType
    extends Enum<BadFileNameType> {
        @NotNull
        private final String msgKey;
        public static final /* enum */ BadFileNameType RESERVED = new BadFileNameType("warning.message.commit.with.bad.windows.file.name.reserved");
        public static final /* enum */ BadFileNameType INVALID_CHAR = new BadFileNameType("warning.message.commit.with.bad.windows.file.name.bad.character");
        private static final /* synthetic */ BadFileNameType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BadFileNameType(String msgKey) {
            this.msgKey = msgKey;
        }

        @NotNull
        public final String getMsgKey() {
            return this.msgKey;
        }

        public static BadFileNameType[] values() {
            return (BadFileNameType[])$VALUES.clone();
        }

        public static BadFileNameType valueOf(String value) {
            return Enum.valueOf(BadFileNameType.class, value);
        }

        @NotNull
        public static EnumEntries<BadFileNameType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = badFileNameTypeArray = new BadFileNameType[]{BadFileNameType.RESERVED, BadFileNameType.INVALID_CHAR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgit4idea/checkin/GitFileNameCheckinHandler$Companion;", "", "<init>", "()V", "WINDOWS_INVALID_CHARS", "", "WINDOWS_RESERVED_NAMES", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001c\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0015"}, d2={"Lgit4idea/checkin/GitFileNameCheckinHandler$GitFileNameCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "fileName", "", "Lcom/intellij/openapi/util/NlsSafe;", "type", "Lgit4idea/checkin/GitFileNameCheckinHandler$BadFileNameType;", "<init>", "(Ljava/lang/String;Lgit4idea/checkin/GitFileNameCheckinHandler$BadFileNameType;)V", "getFileName", "()Ljava/lang/String;", "getType", "()Lgit4idea/checkin/GitFileNameCheckinHandler$BadFileNameType;", "text", "getText", "showModalSolution", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "project", "Lcom/intellij/openapi/project/Project;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "intellij.vcs.git"})
    private static final class GitFileNameCommitProblem
    implements CommitProblem {
        @NotNull
        private final String fileName;
        @NotNull
        private final BadFileNameType type;

        public GitFileNameCommitProblem(@NotNull String fileName, @NotNull BadFileNameType type) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.fileName = fileName;
            this.type = type;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final BadFileNameType getType() {
            return this.type;
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.fileName};
            String string = GitBundle.message(this.type.getMsgKey(), objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public CheckinHandler.ReturnResult showModalSolution(@NotNull Project project, @NotNull CommitInfo commitInfo) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
            String string = GitBundle.message("warning.title.commit.with.bad.windows.file.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            HtmlBuilder message = new HtmlBuilder().append(this.getText());
            String string2 = message.wrapWithHtmlBody().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            boolean commit = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(title, string2).yesText(commitInfo.getCommitActionText())).icon(Messages.getWarningIcon())).ask(project);
            if (commit) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }
    }
}

