/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.EditSingleFieldCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.Timestamp;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.edit.PointEdit;

public class InterpolateTimestamps
extends GenericFunction {
    private final ArrayList<PointEdit> _edits = new ArrayList();

    public InterpolateTimestamps(App app) {
        super(app);
    }

    @Override
    public void begin() {
        this._edits.clear();
        double d = 0.0;
        ArrayList<IndexAndDistance> arrayList = new ArrayList<IndexAndDistance>();
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        if (n < 0 || n2 <= n) {
            return;
        }
        DataPoint dataPoint = null;
        DataPoint dataPoint2 = null;
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint3 = this._app.getTrackInfo().getTrack().getPoint(n3);
            if (!dataPoint3.isWaypoint()) {
                if (dataPoint3.getSegmentStart()) {
                    arrayList.clear();
                    dataPoint = null;
                }
                if (dataPoint3.hasTimestamp()) {
                    if (dataPoint != null && !arrayList.isEmpty()) {
                        this.processPointList(arrayList, d += InterpolateTimestamps.distanceBetween(dataPoint2, dataPoint3), dataPoint.getTimestamp(), dataPoint3.getTimestamp());
                    }
                    dataPoint = dataPoint3;
                    arrayList.clear();
                    d = 0.0;
                } else if (dataPoint != null) {
                    arrayList.add(new IndexAndDistance(n3, d += InterpolateTimestamps.distanceBetween(dataPoint2, dataPoint3)));
                }
                dataPoint2 = dataPoint3;
            }
            ++n3;
        }
        if (this._edits.isEmpty()) {
            this._app.showErrorMessage(this.getNameKey(), "error.interpolatetimestamps.notpossible");
        } else {
            EditSingleFieldCmd editSingleFieldCmd = new EditSingleFieldCmd(Field.TIMESTAMP, this._edits, null);
            editSingleFieldCmd.setDescription(I18nManager.getText("undo.applytimestamps"));
            editSingleFieldCmd.setConfirmText(I18nManager.getText("confirm.applytimestamps"));
            this._app.execute(editSingleFieldCmd);
        }
    }

    private void processPointList(ArrayList<IndexAndDistance> arrayList, double d, Timestamp timestamp, Timestamp timestamp2) {
        for (IndexAndDistance indexAndDistance : arrayList) {
            double d2 = indexAndDistance._distance / d;
            long l = (long)((double)timestamp2.getMillisecondsSince(timestamp) * d2);
            Timestamp timestamp3 = timestamp.addOffsetMilliseconds(l);
            String string = timestamp3.getText(Timestamp.Format.ISO8601, null);
            this._edits.add(new PointEdit(indexAndDistance._pointIndex, string));
        }
    }

    private static double distanceBetween(DataPoint dataPoint, DataPoint dataPoint2) {
        double d = DataPoint.calculateRadiansBetween(dataPoint, dataPoint2);
        return Distance.convertRadiansToDistance(d, UnitSetLibrary.UNITS_METRES);
    }

    @Override
    public String getNameKey() {
        return "function.interpolatetimestamps";
    }

    private static class IndexAndDistance {
        private final int _pointIndex;
        private final double _distance;

        private IndexAndDistance(int n, double d) {
            this._pointIndex = n;
            this._distance = d;
        }
    }
}

