/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.items;

import ghidra.features.base.quickfix.QuickFix;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.EolCommentFieldLocation;
import ghidra.program.util.PlateFieldLocation;
import ghidra.program.util.PostCommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.RepeatableCommentFieldLocation;
import ghidra.util.exception.AssertException;

public class UpdateCommentQuickFix
extends QuickFix {
    private Address address;
    private CommentType type;

    public UpdateCommentQuickFix(Program program, Address address, CommentType type, String comment, String newComment) {
        super(program, comment, newComment);
        this.address = address;
        this.type = type;
    }

    @Override
    public String getActionName() {
        return "Update";
    }

    @Override
    public String getItemType() {
        return "Code Comment";
    }

    @Override
    public String doGetCurrent() {
        return this.program.getListing().getComment(this.type, this.address);
    }

    @Override
    public void execute() {
        this.program.getListing().setComment(this.address, this.type, this.replacement);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public ProgramLocation getProgramLocation() {
        switch (this.type) {
            case EOL: {
                return new EolCommentFieldLocation(this.program, this.address, null, null, 0, 0, 0);
            }
            case PLATE: {
                return new PlateFieldLocation(this.program, this.address, null, 0, 0, null, 0);
            }
            case POST: {
                return new PostCommentFieldLocation(this.program, this.address, null, null, 0, 0);
            }
            case PRE: {
                return new CommentFieldLocation(this.program, this.address, null, null, this.type, 0, 0);
            }
            case REPEATABLE: {
                return new RepeatableCommentFieldLocation(this.program, this.address, null, null, 0, 0, 0);
            }
        }
        throw new AssertException("Unsupported comment type: " + this.type.name());
    }

    @Override
    public String getPath() {
        return null;
    }
}

