/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.Tool;
import docking.action.builder.ActionBuilder;
import docking.widgets.OkDialog;
import generic.lsh.vector.LSHVectorFactory;
import generic.theme.GIcon;
import ghidra.app.context.ListingActionContext;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.features.bsim.gui.BSimServerManager;
import ghidra.features.bsim.gui.overview.BSimOverviewProvider;
import ghidra.features.bsim.gui.search.dialog.BSimFilterSet;
import ghidra.features.bsim.gui.search.dialog.BSimOverviewDialog;
import ghidra.features.bsim.gui.search.dialog.BSimSearchDialog;
import ghidra.features.bsim.gui.search.dialog.BSimSearchService;
import ghidra.features.bsim.gui.search.dialog.BSimSearchSettings;
import ghidra.features.bsim.gui.search.dialog.BSimServerCache;
import ghidra.features.bsim.gui.search.dialog.BSimServerDialog;
import ghidra.features.bsim.gui.search.results.BSimSearchResultsProvider;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.facade.DefaultSFQueryServiceFactory;
import ghidra.features.bsim.query.facade.QueryDatabaseException;
import ghidra.features.bsim.query.facade.SFOverviewInfo;
import ghidra.features.bsim.query.facade.SFQueryInfo;
import ghidra.features.bsim.query.facade.SFQueryResult;
import ghidra.features.bsim.query.facade.SFQueryServiceFactory;
import ghidra.features.bsim.query.facade.SFResultsUpdateListener;
import ghidra.features.bsim.query.facade.SimilarFunctionQueryService;
import ghidra.features.bsim.query.protocol.BSimFilter;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.features.bsim.query.protocol.ResponseNearestVector;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

@PluginInfo(category="BSim", description="This plugin allows users to search selected functions against a database of previously analyzed functions and returns a table of similar functions", packageName="BSim", shortDescription="Search Bsim database(s) for similar functions", status=PluginStatus.RELEASED)
public class BSimSearchPlugin
extends ProgramPlugin {
    static final Icon ICON = new GIcon("icon.bsim.query.dialog.provider");
    public static final String HELP_TOPIC = "BSimSearchPlugin";
    private SFQueryServiceFactory queryServiceFactory = new DefaultSFQueryServiceFactory();
    private Set<BSimSearchResultsProvider> searchResultsProviders = new HashSet<BSimSearchResultsProvider>();
    private Set<BSimOverviewProvider> overviewProviders = new HashSet<BSimOverviewProvider>();
    private BSimServerManager serverManager = BSimServerManager.getBSimServerManager();
    private BSimSearchService searchService;
    private BSimServerCache lastUsedServerCache = null;
    private BSimSearchSettings lastUsedSettings = new BSimSearchSettings();
    private volatile AbstractProgramTask currentTask;
    private TaskListener taskListener = new TaskListener(){

        public void taskCompleted(Task task) {
            BSimSearchPlugin.this.currentTask = null;
        }

        public void taskCancelled(Task task) {
            BSimSearchPlugin.this.currentTask = null;
        }
    };

    public BSimSearchPlugin(PluginTool plugintool) {
        super(plugintool);
        this.searchService = new MyBSimSearchService();
    }

    protected void init() {
        this.createActions();
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("BSim Overview", this.getName()).menuPath(new String[]{"BSim", "Perform Overview..."})).helpLocation(new HelpLocation(this.getName(), "BSim_Overview_Dialog"))).enabledWhen(c -> this.currentProgram != null)).onAction(c -> this.showOverviewDialog())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("BSim Search Functions", this.getName()).menuPath(new String[]{"BSim", "Search Functions..."})).menuIcon(ICON)).toolBarIcon(ICON)).toolBarGroup("View", "Bsim")).helpLocation(new HelpLocation(this.getName(), "BSim_Search_Dialog"))).enabledWhen(c -> this.currentProgram != null)).onAction(c -> this.showSearchDialog(this.getSelectedFunctions()))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Manage BSim Servers", this.getName()).menuPath(new String[]{"BSim", "Manage Servers"})).helpLocation(new HelpLocation(this.getName(), "BSim_Servers_Dialog"))).onAction(c -> this.manageServers())).buildAndInstall((Tool)this.tool);
        this.tool.setMenuGroup(new String[]{"BSim"}, "ZBSIM");
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("BSim Search From Listing", this.getName()).popupMenuPath(new String[]{"BSim", "Search Function(s)"})).popupMenuGroup("ZZZ")).helpLocation(new HelpLocation(this.getName(), "BSim_Quick_Search"))).withContext(ListingActionContext.class).enabledWhen(c -> this.lastUsedServerCache != null && this.canSearchFunctionsInListing((ListingActionContext)c)).onAction(c -> this.searchService.search(this.lastUsedServerCache, this.lastUsedSettings, this.getSelectedFunctions((ListingActionContext)c))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("BSim Search From Listing With Dialog", this.getName()).popupMenuPath(new String[]{"BSim", "Search Function(s)..."})).popupMenuGroup("ZZZ")).helpLocation(new HelpLocation(this.getName(), "BSim_Quick_Search"))).withContext(ListingActionContext.class).enabledWhen(c -> this.canSearchFunctionsInListing((ListingActionContext)c)).onAction(c -> this.showSearchDialog(this.getSelectedFunctions((ListingActionContext)c))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("BSim Search From Decompiler", this.getName()).popupMenuPath(new String[]{"BSim", "Search Function"})).popupMenuGroup("ZZZ")).helpLocation(new HelpLocation(this.getName(), "BSim_Quick_Search"))).withContext(DecompilerActionContext.class).enabledWhen(c -> this.lastUsedServerCache != null && this.isDecompilerOnFunction((DecompilerActionContext)c)).onAction(c -> this.searchService.search(this.lastUsedServerCache, this.lastUsedSettings, this.getFunctions((DecompilerActionContext)c))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("BSim Search From Decompiler", this.getName()).popupMenuPath(new String[]{"BSim", "Search Function..."})).popupMenuGroup("ZZZ")).helpLocation(new HelpLocation(this.getName(), "BSim_Quick_Search"))).withContext(DecompilerActionContext.class).enabledWhen(c -> this.isDecompilerOnFunction((DecompilerActionContext)c)).onAction(c -> this.showSearchDialog(this.getFunctions((DecompilerActionContext)c))).buildAndInstall((Tool)this.tool);
    }

    public void doBSimSearch(Program program, List<Address> functionAddresses, boolean showDialog) {
        Set<FunctionSymbol> functions = this.getFunctions(program, functionAddresses);
        if (showDialog) {
            this.showSearchDialog(functions);
        } else {
            this.searchService.search(this.lastUsedServerCache, this.lastUsedSettings, functions);
        }
    }

    private Set<FunctionSymbol> getFunctions(Program program, List<Address> functionAddresses) {
        HashSet<FunctionSymbol> functions = new HashSet<FunctionSymbol>();
        FunctionManager functionManager = program.getFunctionManager();
        for (Address address : functionAddresses) {
            Function f = functionManager.getFunctionAt(address);
            if (f == null) continue;
            functions.add((FunctionSymbol)f.getSymbol());
        }
        return functions;
    }

    private boolean isDecompilerOnFunction(DecompilerActionContext c) {
        if (c.isDecompiling()) {
            return false;
        }
        ClangToken token = c.getTokenAtCursor();
        return token instanceof ClangFuncNameToken;
    }

    private boolean canSearchFunctionsInListing(ListingActionContext c) {
        return this.canSearchFunctionsInListing(c.getProgram(), c.getSelection(), c.getLocation());
    }

    private boolean canSearchFunctionsInListing(Program program, ProgramSelection selection, ProgramLocation loc) {
        if (program == null) {
            return false;
        }
        if (selection != null && !selection.isEmpty() && selection.contains(loc.getAddress())) {
            return this.hasAtLeastOneFunctionInSelection(program, selection);
        }
        return program.getFunctionManager().isInFunction(loc.getAddress());
    }

    private boolean hasAtLeastOneFunctionInSelection(Program program, ProgramSelection selection) {
        FunctionManager functionManager = program.getFunctionManager();
        FunctionIterator iterator = functionManager.getFunctionsNoStubs((AddressSetView)selection, true);
        return iterator.hasNext();
    }

    private Set<FunctionSymbol> getFunctions(DecompilerActionContext c) {
        ClangFuncNameToken funcToken = (ClangFuncNameToken)c.getTokenAtCursor();
        PcodeOp op = funcToken.getPcodeOp();
        Address calledAddress = null;
        calledAddress = op == null || op.getOpcode() != 7 ? c.getAddress() : op.getInput(0).getAddress();
        Program p = c.getProgram();
        Function function = p.getFunctionManager().getFunctionContaining(calledAddress);
        return Set.of((FunctionSymbol)function.getSymbol());
    }

    public void dispose() {
        this.closeAllProviders();
    }

    protected boolean canCloseDomainObject(DomainObject dObj) {
        AbstractProgramTask task = this.currentTask;
        return task == null || task.getProgram().equals((Object)dObj);
    }

    protected void programClosed(Program program) {
        ArrayList<BSimSearchResultsProvider> searches = new ArrayList<BSimSearchResultsProvider>(this.searchResultsProviders);
        for (BSimSearchResultsProvider provider : searches) {
            if (provider.getProgram() != program) continue;
            provider.closeComponent();
        }
        ArrayList<BSimOverviewProvider> overviews = new ArrayList<BSimOverviewProvider>(this.overviewProviders);
        for (BSimOverviewProvider provider : overviews) {
            if (provider.getProgram() != program) continue;
            provider.closeComponent();
        }
    }

    private void manageServers() {
        BSimServerDialog dialog = new BSimServerDialog(this.getTool(), this.serverManager);
        DockingWindowManager.showDialog((DialogComponentProvider)dialog);
    }

    private void showSearchDialog(Set<FunctionSymbol> functions) {
        if (this.checkBusy()) {
            return;
        }
        if (functions.isEmpty()) {
            OkDialog.showError((String)"No Function(s) Selected", (String)"You must first place your cursor in a function or \ncreate a selection that contains 1 or more functions!");
            return;
        }
        BSimSearchDialog searchDialog = new BSimSearchDialog(this.tool, this.searchService, this.serverManager, functions);
        this.tool.showDialog((DialogComponentProvider)searchDialog);
    }

    private boolean checkBusy() {
        if (this.currentTask != null) {
            OkDialog.showInfo((String)"BSim Database Busy", (String)"Only one BSim query permitted at a time!");
            return true;
        }
        return false;
    }

    private void showOverviewDialog() {
        if (this.checkBusy()) {
            return;
        }
        BSimOverviewDialog overviewDialog = new BSimOverviewDialog(this.tool, this.searchService, this.serverManager);
        this.tool.showDialog((DialogComponentProvider)overviewDialog);
    }

    private Set<FunctionSymbol> getSelectedFunctions() {
        return this.getSelectedFunctions(this.currentProgram, this.currentSelection, this.currentLocation);
    }

    private Set<FunctionSymbol> getSelectedFunctions(ListingActionContext c) {
        return this.getSelectedFunctions(c.getProgram(), c.getSelection(), c.getLocation());
    }

    private Set<FunctionSymbol> getSelectedFunctions(Program program, ProgramSelection selection, ProgramLocation location) {
        FunctionManager functionManager = program.getFunctionManager();
        HashSet<FunctionSymbol> functions = new HashSet<FunctionSymbol>();
        if (selection == null || selection.isEmpty()) {
            if (this.currentLocation == null) {
                return functions;
            }
            Function currentFunction = functionManager.getFunctionContaining(location.getAddress());
            if (currentFunction != null) {
                functions.add((FunctionSymbol)currentFunction.getSymbol());
            }
            return functions;
        }
        FunctionIterator iterator = functionManager.getFunctionsNoStubs((AddressSetView)selection, true);
        for (Function function : iterator) {
            functions.add((FunctionSymbol)function.getSymbol());
        }
        return functions;
    }

    public void closeAllProviders() {
        for (BSimSearchResultsProvider bSimSearchResultsProvider : this.searchResultsProviders) {
            bSimSearchResultsProvider.closeComponent();
        }
        for (BSimOverviewProvider bSimOverviewProvider : this.overviewProviders) {
            bSimOverviewProvider.closeComponent();
        }
    }

    private Set<FunctionSymbol> getOverviewFunctions() {
        Program program = this.getCurrentProgram();
        if (program == null) {
            return Set.of();
        }
        FunctionManager functionManager = program.getFunctionManager();
        TreeSet<FunctionSymbol> functions = new TreeSet<FunctionSymbol>(new Comparator<FunctionSymbol>(this){

            @Override
            public int compare(FunctionSymbol f1, FunctionSymbol f2) {
                return f1.getAddress().compareTo((Object)f2.getAddress());
            }
        });
        FunctionIterator iterator = functionManager.getFunctionsNoStubs(true);
        for (Function function : iterator) {
            functions.add((FunctionSymbol)function.getSymbol());
        }
        return functions;
    }

    private BSimOverviewProvider getOverviewProvider(BSimServerInfo serverInfo, Program program, LSHVectorFactory vectoryFactory, BSimSearchSettings settings) {
        return (BSimOverviewProvider)((Object)Swing.runNow(() -> new BSimOverviewProvider(this, serverInfo, program, vectoryFactory, settings)));
    }

    private BSimSearchResultsProvider getSearchResultsProvider(BSimServerInfo serverInfo, DatabaseInformation dbInfo, LSHVectorFactory vectorFactory, SFQueryInfo queryInfo, BSimSearchSettings settings) {
        return (BSimSearchResultsProvider)((Object)Swing.runNow(() -> new BSimSearchResultsProvider(this, this.tool, serverInfo, dbInfo, vectorFactory, queryInfo, settings)));
    }

    private SimilarFunctionQueryService getQueryService(Program program, BSimServerInfo serverInfo) throws QueryDatabaseException {
        SimilarFunctionQueryService queryService = this.queryServiceFactory.createSFQueryService(program);
        queryService.initializeDatabase(serverInfo.toURLString());
        String errorMessage = queryService.getDatabaseCompatibility();
        if (queryService.getLastError() != null && queryService.getLastError().category == FunctionDatabase.ErrorCategory.Nodatabase) {
            errorMessage = "Database does not exist";
        }
        if (errorMessage != null) {
            throw new QueryDatabaseException(errorMessage);
        }
        return queryService;
    }

    public void providerClosed(BSimSearchResultsProvider provider) {
        this.searchResultsProviders.remove((Object)provider);
    }

    public void providerClosed(BSimOverviewProvider overviewProvider) {
        this.overviewProviders.remove((Object)overviewProvider);
    }

    BSimServerManager getServerManager() {
        return this.serverManager;
    }

    void setQueryServiceFactory(SFQueryServiceFactory factory) {
        this.queryServiceFactory = factory;
    }

    class MyBSimSearchService
    implements BSimSearchService {
        MyBSimSearchService() {
        }

        @Override
        public BSimServerInfo getLastUsedServer() {
            return BSimSearchPlugin.this.lastUsedServerCache == null ? null : BSimSearchPlugin.this.lastUsedServerCache.getServerInfo();
        }

        @Override
        public BSimSearchSettings getLastUsedSearchSettings() {
            return BSimSearchPlugin.this.lastUsedSettings;
        }

        @Override
        public void search(BSimServerCache serverCache, BSimSearchSettings settings, Set<FunctionSymbol> functions) {
            if (BSimSearchPlugin.this.checkBusy()) {
                return;
            }
            BSimSearchPlugin.this.lastUsedServerCache = serverCache;
            BSimSearchPlugin.this.lastUsedSettings = settings;
            SearchTask searchTask = new SearchTask(serverCache, settings, functions);
            BSimSearchPlugin.this.currentTask = searchTask;
            searchTask.addTaskListener(BSimSearchPlugin.this.taskListener);
            TaskLauncher.launch((Task)searchTask);
        }

        @Override
        public void performOverview(BSimServerCache serverCache, BSimSearchSettings settings) {
            if (BSimSearchPlugin.this.checkBusy()) {
                return;
            }
            BSimSearchPlugin.this.lastUsedServerCache = serverCache;
            BSimSearchPlugin.this.lastUsedSettings = settings;
            OverviewTask task = new OverviewTask(serverCache, settings, BSimSearchPlugin.this.getOverviewFunctions());
            BSimSearchPlugin.this.currentTask = task;
            task.addTaskListener(BSimSearchPlugin.this.taskListener);
            TaskLauncher.launch((Task)task);
        }
    }

    abstract class AbstractProgramTask
    extends Task {
        AbstractProgramTask(BSimSearchPlugin this$0, String title) {
            super(title, true, true, false, false);
        }

        abstract Program getProgram();
    }

    class SearchTask
    extends AbstractProgramTask
    implements SFResultsUpdateListener<SFQueryResult> {
        private BSimServerCache serverCache;
        private BSimSearchResultsProvider resultsProvider;
        private SFQueryInfo queryInfo;
        private BSimSearchSettings settings;

        public SearchTask(BSimServerCache serverCache, BSimSearchSettings settings, Set<FunctionSymbol> functions) {
            super(BSimSearchPlugin.this, "BSim Search For Similar Functions");
            this.serverCache = serverCache;
            this.settings = settings;
            this.queryInfo = new SFQueryInfo(functions);
            this.queryInfo.setSimilarityThreshold(settings.getSimilarity());
            this.queryInfo.setSignificanceThreshold(settings.getConfidence());
            this.queryInfo.setMaximumResults(settings.getMaxResults());
            BSimFilter bsimFilter = this.queryInfo.getBsimFilter();
            BSimFilterSet bSimFilterSet = settings.getBSimFilterSet();
            bsimFilter.replaceWith(bSimFilterSet.getBSimFilter());
        }

        @Override
        Program getProgram() {
            return this.queryInfo.getProgram();
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            monitor.setMessage("Connecting to database...");
            try (SimilarFunctionQueryService queryService = BSimSearchPlugin.this.getQueryService(this.queryInfo.getProgram(), this.serverCache.getServerInfo());){
                monitor.setMessage("Querying database...");
                queryService.querySimilarFunctions(this.queryInfo, this, monitor);
            }
            catch (QueryDatabaseException e) {
                Msg.showError((Object)this, null, (String)"Error Performing BSim Search", (Object)e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void resultAdded(QueryResponseRecord partialResponse) {
        }

        @Override
        public void setFinalResult(SFQueryResult result) {
            if (result != null) {
                SwingUtilities.invokeLater(() -> this.getSearchProvider().setFinalQueryResults(result));
            }
        }

        private BSimSearchResultsProvider getSearchProvider() {
            if (this.resultsProvider == null) {
                BSimServerInfo serverInfo = this.serverCache.getServerInfo();
                DatabaseInformation databaseInfo = this.serverCache.getDatabaseInformation();
                LSHVectorFactory lshVectorFactory = this.serverCache.getLSHVectorFactory();
                this.resultsProvider = BSimSearchPlugin.this.getSearchResultsProvider(serverInfo, databaseInfo, lshVectorFactory, this.queryInfo, this.settings);
                BSimSearchPlugin.this.searchResultsProviders.add(this.resultsProvider);
            }
            return this.resultsProvider;
        }
    }

    class OverviewTask
    extends AbstractProgramTask
    implements SFResultsUpdateListener<ResponseNearestVector> {
        private BSimSearchSettings settings;
        private BSimServerCache serverCache;
        private BSimOverviewProvider overviewProvider;
        private SFOverviewInfo overviewInfo;

        public OverviewTask(BSimServerCache serverCache, BSimSearchSettings settings, Set<FunctionSymbol> functions) {
            super(BSimSearchPlugin.this, "Computing BSim Overview");
            this.serverCache = serverCache;
            this.settings = settings;
            this.overviewInfo = new SFOverviewInfo(functions);
            this.overviewInfo.setSimilarityThreshold(settings.getSimilarity());
            this.overviewInfo.setSignificanceThreshold(settings.getConfidence());
        }

        @Override
        Program getProgram() {
            return this.overviewInfo.getProgram();
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            BSimSearchPlugin.this.lastUsedServerCache = this.serverCache;
            BSimSearchPlugin.this.lastUsedSettings = this.settings;
            try (SimilarFunctionQueryService queryService = BSimSearchPlugin.this.getQueryService(this.overviewInfo.getProgram(), this.serverCache.getServerInfo());){
                monitor.setMessage("Calculating overview...");
                queryService.overviewSimilarFunctions(this.overviewInfo, this, monitor);
            }
            catch (QueryDatabaseException e) {
                Msg.showError((Object)this, null, (String)"Error Performing BSim Overview", (Object)e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void resultAdded(QueryResponseRecord partialResponse) {
            SwingUtilities.invokeLater(() -> this.getProvider().overviewResultAdded((ResponseNearestVector)partialResponse));
        }

        @Override
        public void setFinalResult(ResponseNearestVector result) {
            if (result != null) {
                SwingUtilities.invokeLater(() -> this.getProvider().setFinalOverviewResults(result));
            }
        }

        private BSimOverviewProvider getProvider() {
            if (this.overviewProvider == null) {
                BSimServerInfo serverInfo = this.serverCache.getServerInfo();
                LSHVectorFactory lshVectorFactory = this.serverCache.getLSHVectorFactory();
                Program program = this.overviewInfo.getProgram();
                this.overviewProvider = BSimSearchPlugin.this.getOverviewProvider(serverInfo, program, lshVectorFactory, this.settings);
                BSimSearchPlugin.this.overviewProviders.add(this.overviewProvider);
            }
            return this.overviewProvider;
        }
    }
}

