/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.mdmp.ThreadEx;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ThreadExListStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_THREAD_EX_LIST";
    private int numberOfThreads;
    private ThreadEx[] threads;
    private DumpFileReader reader;
    private long index;

    ThreadExListStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setNumberOfThreads(this.reader.readNextInt());
        this.threads = new ThreadEx[this.numberOfThreads];
        for (int i = 0; i < this.numberOfThreads; ++i) {
            this.setThread(new ThreadEx(this.reader, this.reader.getPointerIndex()), i);
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "NumberOfThreads", null);
        DataType t = this.threads[0].toDataType();
        ArrayDataType a = new ArrayDataType(t, this.numberOfThreads, t.getLength());
        struct.add((DataType)a, a.getLength(), "Threads", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public ThreadEx getThread(int idx) {
        return this.threads[idx];
    }

    public void setThread(ThreadEx thread, int index) {
        this.threads[index] = thread;
    }
}

