/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;

public class FunctionParameterCountTableColumn
extends ProgramLocationTableColumnExtensionPoint<Address, Integer> {
    public String getColumnDescription() {
        return "The number of parameters for the function containing the given address";
    }

    public String getColumnName() {
        return "Param Count";
    }

    @Override
    public ProgramLocation getProgramLocation(Address rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        Function function = this.getFunctionContaining(rowObject, program);
        if (function != null) {
            return new FunctionNameFieldLocation(program, function.getEntryPoint(), 0, function.getPrototypeString(false, false), function.getName());
        }
        return null;
    }

    private Function getFunctionContaining(Object rowObject, Program pgm) {
        Address addr = (Address)rowObject;
        return pgm.getFunctionManager().getFunctionContaining(addr);
    }

    public Integer getValue(Address rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        Function function = this.getFunctionContaining(rowObject, program);
        if (function != null) {
            return function.getParameterCount();
        }
        return null;
    }
}

