/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableFieldRVA
extends CliAbstractTable {
    public CliTableFieldRVA(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliFieldRVARow(reader.readNextInt(), this.readTableIndex(reader, CliTypeTable.Field)));
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "FieldRVA Row", 0);
        rowDt.add(DWORD, "RVA", null);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.Field), "Field", "index into Field table");
        return rowDt;
    }

    public class CliFieldRVARow
    extends CliAbstractTableRow {
        public int rva;
        public int fieldIndex;

        public CliFieldRVARow(int rva, int fieldIndex) {
            this.rva = rva;
            this.fieldIndex = fieldIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("Field %s RVA %x", CliTableFieldRVA.this.getRowRepresentationSafe(CliTypeTable.Field, this.fieldIndex), this.rva);
        }
    }
}

