/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.util.datastruct.WeakValueHashMap;
import java.io.IOException;

public class StringTable {
    protected BinaryReader reader;
    protected WeakValueHashMap<Long, String> cache = new WeakValueHashMap();

    public static StringTable of(BinaryReader reader) {
        if (reader == null) {
            return null;
        }
        return new StringTable(reader);
    }

    public StringTable(BinaryReader reader) {
        this.reader = reader;
    }

    public boolean isValid(long offset) {
        return this.reader.isValidIndex(offset);
    }

    public void clear() {
        this.reader = null;
        this.cache.clear();
    }

    public String getStringAtOffset(long offset) throws IOException {
        if (!this.isValid(offset)) {
            throw new IOException("Invalid offset requested " + offset);
        }
        String s = (String)this.cache.get((Object)offset);
        if (s == null) {
            s = this.reader.readUtf8String(offset);
            this.cache.put((Object)offset, (Object)s);
        }
        return s;
    }
}

