/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug.dbtable;

import db.DBRecord;
import docking.widgets.table.AbstractDynamicTableColumnStub;
import ghidra.app.plugin.debug.dbtable.LongRenderer;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;

abstract class AbstractColumnAdapter
extends AbstractDynamicTableColumnStub<DBRecord, Object> {
    protected LongRenderer longRenderer = new LongRenderer();
    protected int column;
    private String columnName;

    AbstractColumnAdapter(String columnName, int column) {
        this.column = column;
        this.columnName = columnName;
    }

    public Object getValue(DBRecord rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
        if (this.column == 0) {
            return this.getKeyValue(rowObject);
        }
        int dbColumn = this.column - 1;
        return this.getValue(rowObject, dbColumn);
    }

    public Class<Object> getColumnClass() {
        return this.getValueClass();
    }

    public String getColumnName() {
        return this.columnName;
    }

    abstract Class<?> getValueClass();

    abstract Object getKeyValue(DBRecord var1);

    abstract Object getValue(DBRecord var1, int var2);

    protected String getByteString(byte b) {
        String str = Integer.toHexString(b);
        if (str.length() > 2) {
            str = str.substring(str.length() - 2);
        }
        return "0x" + str;
    }
}

