/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.EdgeArrowRenderingSupport;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class BasicEdgeArrowRenderingSupport<V, E>
implements EdgeArrowRenderingSupport<V, E> {
    @Override
    public AffineTransform getArrowTransform(RenderContext<V, E> rc, Shape edgeShape, Shape vertexShape) {
        GeneralPath path = new GeneralPath(edgeShape);
        float[] seg = new float[6];
        Point2D.Float p1 = null;
        Point2D.Float p2 = null;
        AffineTransform at = new AffineTransform();
        PathIterator i = path.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            int ret = i.currentSegment(seg);
            if (ret == 0) {
                p2 = new Point2D.Float(seg[0], seg[1]);
            } else if (ret == 1) {
                p1 = p2;
                p2 = new Point2D.Float(seg[0], seg[1]);
                if (vertexShape.contains(p2)) {
                    at = this.getArrowTransform(rc, new Line2D.Float(p1, p2), vertexShape);
                    break;
                }
            }
            i.next();
        }
        return at;
    }

    @Override
    public AffineTransform getReverseArrowTransform(RenderContext<V, E> rc, Shape edgeShape, Shape vertexShape) {
        return this.getReverseArrowTransform(rc, edgeShape, vertexShape, true);
    }

    @Override
    public AffineTransform getReverseArrowTransform(RenderContext<V, E> rc, Shape edgeShape, Shape vertexShape, boolean passedGo) {
        GeneralPath path = new GeneralPath(edgeShape);
        float[] seg = new float[6];
        Point2D.Float p1 = null;
        Point2D.Float p2 = null;
        AffineTransform at = new AffineTransform();
        PathIterator i = path.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            int ret = i.currentSegment(seg);
            if (ret == 0) {
                p2 = new Point2D.Float(seg[0], seg[1]);
            } else if (ret == 1) {
                p1 = p2;
                p2 = new Point2D.Float(seg[0], seg[1]);
                if (!passedGo && vertexShape.contains(p2)) {
                    passedGo = true;
                } else if (passedGo && !vertexShape.contains(p2)) {
                    at = this.getReverseArrowTransform(rc, new Line2D.Float(p1, p2), vertexShape);
                    break;
                }
            }
            i.next();
        }
        return at;
    }

    @Override
    public AffineTransform getArrowTransform(RenderContext<V, E> rc, Line2D edgeShape, Shape vertexShape) {
        float dx = (float)(edgeShape.getX1() - edgeShape.getX2());
        float dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        while (dx * dx + dy * dy > rc.getArrowPlacementTolerance()) {
            try {
                edgeShape = this.getLastOutsideSegment(edgeShape, vertexShape);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.toString());
                return null;
            }
            dx = (float)(edgeShape.getX1() - edgeShape.getX2());
            dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        }
        double atheta = Math.atan2(dx, dy) + 1.5707963267948966;
        AffineTransform at = AffineTransform.getTranslateInstance(edgeShape.getX1(), edgeShape.getY1());
        at.rotate(-atheta);
        return at;
    }

    protected AffineTransform getReverseArrowTransform(RenderContext<V, E> rc, Line2D edgeShape, Shape vertexShape) {
        float dx = (float)(edgeShape.getX1() - edgeShape.getX2());
        float dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        while (dx * dx + dy * dy > rc.getArrowPlacementTolerance()) {
            try {
                edgeShape = this.getFirstOutsideSegment(edgeShape, vertexShape);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.toString());
                return null;
            }
            dx = (float)(edgeShape.getX1() - edgeShape.getX2());
            dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        }
        double atheta = Math.atan2(dx, dy) - 1.5707963267948966;
        AffineTransform at = AffineTransform.getTranslateInstance(edgeShape.getX1(), edgeShape.getY1());
        at.rotate(-atheta);
        return at;
    }

    protected Line2D getLastOutsideSegment(Line2D line, Shape shape) {
        if (!shape.contains(line.getP2())) {
            String errorString = "line end point: " + line.getP2() + " is not contained in shape: " + shape.getBounds2D();
            throw new IllegalArgumentException(errorString);
        }
        Line2D.Double left = new Line2D.Double();
        Line2D.Double right = new Line2D.Double();
        do {
            this.subdivide(line, left, right);
        } while (!shape.contains((line = right).getP1()));
        return left;
    }

    protected Line2D getFirstOutsideSegment(Line2D line, Shape shape) {
        if (!shape.contains(line.getP1())) {
            String errorString = "line start point: " + line.getP1() + " is not contained in shape: " + shape.getBounds2D();
            throw new IllegalArgumentException(errorString);
        }
        Line2D.Float left = new Line2D.Float();
        Line2D.Float right = new Line2D.Float();
        do {
            this.subdivide(line, left, right);
        } while (!shape.contains((line = left).getP2()));
        return right;
    }

    protected void subdivide(Line2D src, Line2D left, Line2D right) {
        double x1 = src.getX1();
        double y1 = src.getY1();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double mx = x1 + (x2 - x1) / 2.0;
        double my = y1 + (y2 - y1) / 2.0;
        if (left != null) {
            left.setLine(x1, y1, mx, my);
        }
        if (right != null) {
            right.setLine(mx, my, x2, y2);
        }
    }
}

