/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.SatelliteVisualizationViewer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.jungrapht.visualization.util.AWT;
import org.jungrapht.visualization.util.VertexLocationAnimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SatelliteTranslatingGraphMousePlugin<V, E>
extends TranslatingGraphMousePlugin<V, E> {
    private static final Logger log = LoggerFactory.getLogger(SatelliteTranslatingGraphMousePlugin.class);

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public SatelliteTranslatingGraphMousePlugin() {
        this(SatelliteTranslatingGraphMousePlugin.builder());
    }

    public SatelliteTranslatingGraphMousePlugin(Builder<V, E, ?, ?> builder) {
        super(builder);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        log.trace("mouseClicked {} in {}", (Object)e.getClickCount(), (Object)this.getClass().getName());
        super.mouseClicked(e);
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
        Point p = e.getPoint();
        Point2D layoutPoint = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(p);
        VertexLocationAnimator.jumpPointToCenter(vvMaster, AWT.convert(layoutPoint));
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean accepted;
        if (this.down == null) {
            return;
        }
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean bl = accepted = e.getModifiersEx() == this.translatingMask;
        if (accepted) {
            if (vv instanceof SatelliteVisualizationViewer) {
                VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
                MutableTransformer modelTransformerMaster = vvMaster.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
                vv.setCursor(Cursor.getPredefinedCursor(13));
                try {
                    Point2D q = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(this.down);
                    Point2D p = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(e.getPoint());
                    double dx = p.getX() - q.getX();
                    double dy = p.getY() - q.getY();
                    modelTransformerMaster.translate(-dx, -dy);
                    this.down.x = e.getX();
                    this.down.y = e.getY();
                }
                catch (RuntimeException ex) {
                    log.error("down = {}, e = {}", (Object)this.down, (Object)e);
                    throw ex;
                }
            }
            e.consume();
        }
    }

    public static class Builder<V, E, T extends SatelliteTranslatingGraphMousePlugin<V, E>, B extends Builder<V, E, T, B>>
    extends TranslatingGraphMousePlugin.Builder<V, E, T, B> {
        protected Builder() {
        }

        @Override
        public T build() {
            return (T)new SatelliteTranslatingGraphMousePlugin(this);
        }
    }
}

