/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.threaded;

import docking.widgets.table.threaded.IncrementalJobListener;
import docking.widgets.table.threaded.ThreadedTableModel;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import docking.widgets.table.threaded.ThreadedTableModelUpdateMgr;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.SynchronizedListAccumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.Job;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class IncrementalLoadJob<ROW_OBJECT>
extends Job
implements ThreadedTableModelListener {
    private final IncrementalJobListener listener;
    private final ThreadedTableModel<ROW_OBJECT, ?> threadedModel;
    private final ThreadedTableModelUpdateMgr<ROW_OBJECT> updateManager;
    private volatile CountDownLatch completedCallbackLatch = new CountDownLatch(0);
    private volatile boolean isCancelled = false;
    private volatile IncrementalUpdatingAccumulator incrementalAccumulator;

    IncrementalLoadJob(ThreadedTableModel<ROW_OBJECT, ?> threadedModel, IncrementalJobListener listener) {
        this.threadedModel = threadedModel;
        this.listener = listener;
        this.updateManager = threadedModel.getUpdateManager();
    }

    public void run(TaskMonitor monitor) {
        boolean error;
        block2: {
            this.incrementalAccumulator = new IncrementalUpdatingAccumulator();
            this.notifyStarted(monitor);
            error = false;
            try {
                this.doExecute(monitor);
            }
            catch (Exception e) {
                if (ExceptionUtils.hasCause((Throwable)e, InterruptedException.class) || monitor.isCancelled()) break block2;
                String name = this.threadedModel.getName();
                error = true;
                Msg.showError((Object)this, null, (String)"Unexpected Exception", (Object)("Unexpected exception loading table model \"" + name + "\""), (Throwable)e);
            }
        }
        boolean interrupted = Thread.currentThread().isInterrupted();
        this.notifyCompleted(this.hasBeenCancelled(monitor) || interrupted || error);
        this.incrementalAccumulator.clear();
    }

    private void doExecute(TaskMonitor monitor) {
        try {
            this.threadedModel.doLoad((Accumulator<ROW_OBJECT>)this.incrementalAccumulator, monitor);
            this.flush(this.incrementalAccumulator, monitor);
        }
        catch (CancelledException e) {
            this.isCancelled = true;
        }
    }

    private boolean hasBeenCancelled(TaskMonitor monitor) {
        return this.isCancelled || monitor.isCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(IncrementalUpdatingAccumulator accumulator, TaskMonitor monitor) {
        Object object = this.updateManager.getSynchronizingLock();
        synchronized (object) {
            if (this.hasBeenCancelled(monitor)) {
                return;
            }
            accumulator.flushData();
            this.completedCallbackLatch = new CountDownLatch(1);
            Swing.runLater(() -> this.updateManager.addThreadedTableListener(this));
        }
        this.waitForThreadedTableUpdateManagerToFinish();
    }

    private void waitForThreadedTableUpdateManagerToFinish() {
        try {
            this.completedCallbackLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void notifyStarted(TaskMonitor monitor) {
        if (this.listener != null) {
            Swing.runIfSwingOrRunLater(() -> this.listener.loadingStarted());
        }
    }

    private void notifyCompleted(boolean wasCancelled) {
        if (this.listener != null) {
            Swing.runIfSwingOrRunLater(() -> this.listener.loadingFinished(wasCancelled));
        }
        this.updateManager.removeThreadedTableListener(this);
    }

    public void cancel() {
        super.cancel();
        this.isCancelled = true;
        this.incrementalAccumulator.cancel();
    }

    @Override
    public void loadPending() {
    }

    @Override
    public void loadingStarted() {
    }

    @Override
    public void loadingFinished(boolean wasCancelled) {
        this.completedCallbackLatch.countDown();
    }

    private class IncrementalUpdatingAccumulator
    extends SynchronizedListAccumulator<ROW_OBJECT> {
        private volatile boolean isDone;
        private Runnable runnable = () -> {
            block3: {
                if (this.isCancelledOrDone()) {
                    return;
                }
                try {
                    IncrementalLoadJob.this.updateManager.reloadSpecificData(this.asList());
                }
                catch (Exception e) {
                    if (this.isCancelledOrDone()) break block3;
                    Msg.error((Object)((Object)this), (Object)"Exception incrementally loading table data", (Throwable)e);
                }
            }
        };
        private SwingUpdateManager swingUpdateManager;

        private IncrementalUpdatingAccumulator() {
            this.swingUpdateManager = new SwingUpdateManager((int)IncrementalLoadJob.this.threadedModel.getMinDelay(), (int)IncrementalLoadJob.this.threadedModel.getMaxDelay(), "Incremental Table Load Update", this.runnable);
        }

        public synchronized void add(ROW_OBJECT t) {
            super.add(t);
            this.swingUpdateManager.update();
        }

        private boolean isCancelledOrDone() {
            return IncrementalLoadJob.this.isCancelled || this.isDone;
        }

        void cancel() {
            this.swingUpdateManager.dispose();
        }

        public synchronized void addAll(Collection<ROW_OBJECT> collection) {
            super.addAll(collection);
            if (collection.size() > 0) {
                this.swingUpdateManager.update();
            }
        }

        void flushData() {
            this.isDone = true;
            this.swingUpdateManager.dispose();
            IncrementalLoadJob.this.updateManager.reloadSpecificData(this.asList());
        }
    }
}

