/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableColumnModel;
import docking.widgets.table.GTableHeader;
import docking.widgets.table.TableUtils;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class GTableMouseListener
extends MouseAdapter {
    private GTable table;
    private boolean isDragged;
    private boolean isPopup;
    private boolean sortingEnabled = true;

    GTableMouseListener(GTable table) {
        this.table = table;
    }

    void setSortingEnabled(boolean enabled) {
        this.sortingEnabled = enabled;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        this.processPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            this.isDragged = false;
            return;
        }
        this.processPopup(e);
    }

    private void processPopup(MouseEvent e) {
        if (!this.isDragged) {
            if (this.shouldIgnoreRightClick()) {
                return;
            }
            int columnIndex = this.table.columnAtPoint(e.getPoint());
            JPopupMenu menu = this.table.getTableColumnPopupMenu(columnIndex);
            if (menu != null) {
                this.isPopup = true;
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
            e.consume();
        } else {
            this.isDragged = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        boolean wasPopup = this.isPopup;
        this.isPopup = false;
        if (e.isConsumed() || wasPopup) {
            return;
        }
        TableColumnModel colModel = this.table.getColumnModel();
        int colIndex = colModel.getColumnIndexAtX(e.getX());
        if (colIndex < 0) {
            return;
        }
        if (this.isHelpClick()) {
            DockingWindowManager.getHelpService().showHelp(this.getClass(), false, (Component)this.table);
            return;
        }
        if (!this.sortingEnabled) {
            return;
        }
        if (DockingUtils.isControlModifier(e)) {
            TableUtils.columnAlternativelySelected(this.table, colIndex);
        } else {
            TableUtils.columnSelected(this.table, colIndex);
        }
        if (colModel instanceof GTableColumnModel) {
            ((GTableColumnModel)colModel).saveState();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.isDragged = true;
    }

    private boolean isHelpClick() {
        JTableHeader tableHeader = this.table.getTableHeader();
        if (!(tableHeader instanceof GTableHeader)) {
            return false;
        }
        GTableHeader tooltipTableHeader = (GTableHeader)tableHeader;
        return tooltipTableHeader.isMouseOverHelpIcon();
    }

    private boolean shouldIgnoreRightClick() {
        return this.isHelpClick();
    }

    static {
        DockingWindowManager.getHelpService().registerHelp(GTableMouseListener.class, new HelpLocation("Tables", "GhidraTableHeaders"));
    }
}

