/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

class JdkLogger2
implements InternalLogger {
    private final Logger logger;

    JdkLogger2(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void debug(String msg) {
        this.logger.log(Level.FINE, msg);
    }

    @Override
    public void debug(String msg, Throwable cause) {
        this.logger.log(Level.FINE, msg, cause);
    }

    @Override
    public void error(String msg) {
        this.logger.log(Level.SEVERE, msg);
    }

    @Override
    public void error(String msg, Throwable cause) {
        this.logger.log(Level.SEVERE, msg, cause);
    }

    @Override
    public void info(String msg) {
        this.logger.log(Level.INFO, msg);
    }

    @Override
    public void info(String msg, Throwable cause) {
        this.logger.log(Level.INFO, msg, cause);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String msg) {
        this.logger.log(Level.WARNING, msg);
    }

    @Override
    public void warn(String msg, Throwable cause) {
        this.logger.log(Level.WARNING, msg, cause);
    }

    public String toString() {
        return this.logger.toString();
    }

    @Override
    public void debug(String msg, Object paramObject) {
        this.logger.log(Level.FINE, msg, paramObject);
    }

    @Override
    public void debug(String msg, Object ... paramArrayOfObject) {
        this.logger.log(Level.FINE, msg, paramArrayOfObject);
    }

    @Override
    public void debug(String msg, Object paramObject1, Object paramObject2) {
        this.logger.log(Level.FINE, msg, new Object[]{paramObject1, paramObject2});
    }

    @Override
    public void error(String msg, Object paramObject) {
        this.logger.log(Level.SEVERE, msg, paramObject);
    }

    @Override
    public void error(String msg, Object ... paramArrayOfObject) {
        this.logger.log(Level.SEVERE, msg, paramArrayOfObject);
    }

    @Override
    public void error(String msg, Object paramObject1, Object paramObject2) {
        this.logger.log(Level.SEVERE, msg, new Object[]{paramObject1, paramObject2});
    }

    @Override
    public void info(String msg, Object paramObject) {
        this.logger.log(Level.INFO, msg, paramObject);
    }

    @Override
    public void info(String msg, Object ... paramArrayOfObject) {
        this.logger.log(Level.INFO, msg, paramArrayOfObject);
    }

    @Override
    public void info(String msg, Object paramObject1, Object paramObject2) {
        this.logger.log(Level.INFO, msg, new Object[]{paramObject1, paramObject2});
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void trace(String msg) {
        this.info(msg);
    }

    @Override
    public void trace(String msg, Object paramObject) {
        this.info(msg, paramObject);
    }

    @Override
    public void trace(String msg, Object ... paramArrayOfObject) {
        this.info(msg, paramArrayOfObject);
    }

    @Override
    public void trace(String msg, Throwable paramThrowable) {
        this.info(msg, paramThrowable);
    }

    @Override
    public void trace(String msg, Object paramObject1, Object paramObject2) {
        this.info(msg, paramObject1, paramObject2);
    }

    @Override
    public void warn(String msg, Object paramObject) {
        this.error(msg, paramObject);
    }

    @Override
    public void warn(String msg, Object ... paramArrayOfObject) {
        this.error(msg, paramArrayOfObject);
    }

    @Override
    public void warn(String msg, Object paramObject1, Object paramObject2) {
        this.error(msg, paramObject1, paramObject2);
    }

    @Override
    public String name() {
        return this.logger.getName();
    }

    @Override
    public boolean isEnabled(InternalLogLevel paramInternalLogLevel) {
        return paramInternalLogLevel.compareTo(InternalLogLevel.ERROR) == 0 && this.isErrorEnabled() || paramInternalLogLevel.compareTo(InternalLogLevel.WARN) >= 0 && this.isWarnEnabled() || paramInternalLogLevel.compareTo(InternalLogLevel.INFO) >= 0 && this.isInfoEnabled() || paramInternalLogLevel.compareTo(InternalLogLevel.DEBUG) >= 0 && this.isDebugEnabled() || paramInternalLogLevel.compareTo(InternalLogLevel.TRACE) >= 0 && this.isTraceEnabled();
    }

    @Override
    public void log(InternalLogLevel paramInternalLogLevel, String paramString) {
        if (paramInternalLogLevel == InternalLogLevel.ERROR) {
            this.error(paramString);
        } else if (paramInternalLogLevel == InternalLogLevel.WARN) {
            this.warn(paramString);
        } else if (paramInternalLogLevel == InternalLogLevel.INFO) {
            this.info(paramString);
        } else if (paramInternalLogLevel == InternalLogLevel.DEBUG) {
            this.debug(paramString);
        } else if (paramInternalLogLevel == InternalLogLevel.TRACE) {
            this.trace(paramString);
        }
    }

    @Override
    public void log(InternalLogLevel paramInternalLogLevel, String paramString, Object paramObject) {
        if (paramInternalLogLevel == InternalLogLevel.ERROR) {
            this.error(paramString, paramObject);
        } else if (paramInternalLogLevel == InternalLogLevel.WARN) {
            this.warn(paramString, paramObject);
        } else if (paramInternalLogLevel == InternalLogLevel.INFO) {
            this.info(paramString, paramObject);
        } else if (paramInternalLogLevel == InternalLogLevel.DEBUG) {
            this.debug(paramString, paramObject);
        } else if (paramInternalLogLevel == InternalLogLevel.TRACE) {
            this.trace(paramString, paramObject);
        }
    }

    @Override
    public void log(InternalLogLevel paramInternalLogLevel, String paramString, Object paramObject1, Object paramObject2) {
        if (paramInternalLogLevel == InternalLogLevel.ERROR) {
            this.error(paramString, paramObject1, paramObject2);
        } else if (paramInternalLogLevel == InternalLogLevel.WARN) {
            this.warn(paramString, paramObject1, paramObject2);
        } else if (paramInternalLogLevel == InternalLogLevel.INFO) {
            this.info(paramString, paramObject1, paramObject2);
        } else if (paramInternalLogLevel == InternalLogLevel.DEBUG) {
            this.debug(paramString, paramObject1, paramObject2);
        } else if (paramInternalLogLevel == InternalLogLevel.TRACE) {
            this.trace(paramString, paramObject1, paramObject2);
        }
    }

    @Override
    public void log(InternalLogLevel paramInternalLogLevel, String paramString, Object ... paramArrayOfObject) {
        if (paramInternalLogLevel == InternalLogLevel.ERROR) {
            this.error(paramString, paramArrayOfObject);
        } else if (paramInternalLogLevel == InternalLogLevel.WARN) {
            this.warn(paramString, paramArrayOfObject);
        } else if (paramInternalLogLevel == InternalLogLevel.INFO) {
            this.info(paramString, paramArrayOfObject);
        } else if (paramInternalLogLevel == InternalLogLevel.DEBUG) {
            this.debug(paramString, paramArrayOfObject);
        } else if (paramInternalLogLevel == InternalLogLevel.TRACE) {
            this.trace(paramString, paramArrayOfObject);
        }
    }

    @Override
    public void log(InternalLogLevel paramInternalLogLevel, String paramString, Throwable paramThrowable) {
        if (paramInternalLogLevel == InternalLogLevel.ERROR) {
            this.error(paramString, paramThrowable);
        } else if (paramInternalLogLevel == InternalLogLevel.WARN) {
            this.warn(paramString, paramThrowable);
        } else if (paramInternalLogLevel == InternalLogLevel.INFO) {
            this.info(paramString, paramThrowable);
        } else if (paramInternalLogLevel == InternalLogLevel.DEBUG) {
            this.debug(paramString, paramThrowable);
        } else if (paramInternalLogLevel == InternalLogLevel.TRACE) {
            this.trace(paramString, paramThrowable);
        }
    }

    @Override
    public void debug(Throwable arg0) {
        this.debug("", arg0);
    }

    @Override
    public void error(Throwable arg0) {
        this.error("", arg0);
    }

    @Override
    public void info(Throwable arg0) {
        this.info("", arg0);
    }

    @Override
    public void log(InternalLogLevel arg0, Throwable arg1) {
        this.log(arg0, "", arg1);
    }

    @Override
    public void trace(Throwable arg0) {
        this.trace("", arg0);
    }

    @Override
    public void warn(Throwable arg0) {
        this.warn("", arg0);
    }
}

