/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class PackedBytes
extends OutputStream {
    private byte[] out;
    private int bytecnt;

    public PackedBytes(int startlen) {
        this.out = new byte[startlen];
        this.bytecnt = 0;
    }

    public int size() {
        return this.bytecnt;
    }

    public int getByte(int streampos) {
        return this.out[streampos];
    }

    public void insertByte(int streampos, int val) {
        this.out[streampos] = (byte)val;
    }

    @Override
    public void write(int val) {
        int newcount = this.bytecnt + 1;
        if (newcount > this.out.length) {
            this.out = Arrays.copyOf(this.out, Math.max(this.out.length << 1, newcount));
        }
        this.out[this.bytecnt] = (byte)val;
        this.bytecnt = newcount;
    }

    @Override
    public void write(byte[] byteArray, int off, int len) {
        int newcount = this.bytecnt + len;
        if (newcount > this.out.length) {
            this.out = Arrays.copyOf(this.out, Math.max(this.out.length << 1, newcount));
        }
        System.arraycopy(byteArray, off, this.out, this.bytecnt, len);
        this.bytecnt = newcount;
    }

    public int find(int start, int val) {
        while (start < this.bytecnt) {
            if (this.out[start] == val) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public void writeTo(OutputStream s) throws IOException {
        s.write(this.out, 0, this.bytecnt);
    }
}

