/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.sourcemap;

import db.DBRecord;
import db.RecordIterator;
import ghidra.program.database.sourcemap.SourceFileManagerDB;
import ghidra.program.model.sourcemap.SourceMapEntry;
import ghidra.program.model.sourcemap.SourceMapEntryIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SourceMapEntryIteratorDB
implements SourceMapEntryIterator {
    private boolean forward;
    private RecordIterator recIter;
    private SourceFileManagerDB sourceManager;
    private SourceMapEntry nextEntry;

    SourceMapEntryIteratorDB(SourceFileManagerDB sourceManager, RecordIterator recIter, boolean forward) {
        this.sourceManager = sourceManager;
        this.recIter = recIter;
        this.forward = forward;
        this.nextEntry = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        if (this.nextEntry != null) {
            return true;
        }
        this.sourceManager.lock.acquire();
        try {
            boolean recIterNext;
            boolean bl = recIterNext = this.forward ? this.recIter.hasNext() : this.recIter.hasPrevious();
            if (!recIterNext) {
                boolean bl2 = false;
                return bl2;
            }
            DBRecord rec = this.forward ? this.recIter.next() : this.recIter.previous();
            this.nextEntry = this.sourceManager.getSourceMapEntry(rec);
            boolean bl3 = true;
            return bl3;
        }
        catch (IOException e) {
            this.sourceManager.dbError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.sourceManager.lock.release();
        }
    }

    @Override
    public SourceMapEntry next() {
        if (this.hasNext()) {
            SourceMapEntry entryToReturn = this.nextEntry;
            this.nextEntry = null;
            return entryToReturn;
        }
        throw new NoSuchElementException();
    }

    @Override
    public Iterator<SourceMapEntry> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

