/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowItem;
import net.infonode.docking.properties.SplitWindowProperties;
import net.infonode.properties.propertymap.PropertyMap;

public class SplitWindowItem
extends WindowItem {
    public static final SplitWindowProperties emptyProperties = new SplitWindowProperties();
    private boolean isHorizontal;
    private float dividerLocation;
    private SplitWindowProperties splitWindowProperties;
    private SplitWindowProperties parentProperties = emptyProperties;

    public SplitWindowItem() {
        this.splitWindowProperties = new SplitWindowProperties(emptyProperties);
    }

    public SplitWindowItem(SplitWindowItem windowItem) {
        super(windowItem);
        this.splitWindowProperties = new SplitWindowProperties(windowItem.getSplitWindowProperties().getMap().copy(true, true));
        this.splitWindowProperties.getMap().replaceSuperMap(windowItem.getParentSplitWindowProperties().getMap(), emptyProperties.getMap());
    }

    public SplitWindowItem(WindowItem leftWindow, WindowItem rightWindow, boolean horizontal, float dividerLocation) {
        this.addWindow(leftWindow);
        this.addWindow(rightWindow);
        this.isHorizontal = horizontal;
        this.dividerLocation = dividerLocation;
    }

    @Override
    protected DockingWindow createWindow(ViewReader viewReader, ArrayList childWindows) {
        return childWindows.size() == 0 ? null : (childWindows.size() == 1 ? (DockingWindow)childWindows.get(0) : viewReader.createSplitWindow((DockingWindow)childWindows.get(0), (DockingWindow)childWindows.get(1), this));
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public float getDividerLocation() {
        return this.dividerLocation;
    }

    public void setHorizontal(boolean horizontal) {
        this.isHorizontal = horizontal;
    }

    public void setDividerLocation(float dividerLocation) {
        this.dividerLocation = dividerLocation;
    }

    public SplitWindowProperties getSplitWindowProperties() {
        return this.splitWindowProperties;
    }

    public SplitWindowProperties getParentSplitWindowProperties() {
        return this.parentProperties;
    }

    public void setParentSplitWindowProperties(SplitWindowProperties parentProperties) {
        this.splitWindowProperties.getMap().replaceSuperMap(this.parentProperties.getMap(), parentProperties.getMap());
        this.parentProperties = parentProperties;
    }

    @Override
    public WindowItem copy() {
        return new SplitWindowItem(this);
    }

    @Override
    public void write(ObjectOutputStream out, WriteContext context, ViewWriter viewWriter) throws IOException {
        out.writeInt(0);
        super.write(out, context, viewWriter);
    }

    @Override
    public void writeSettings(ObjectOutputStream out, WriteContext context) throws IOException {
        out.writeBoolean(this.isHorizontal);
        out.writeFloat(this.dividerLocation);
        super.writeSettings(out, context);
    }

    @Override
    public void readSettings(ObjectInputStream in, ReadContext context) throws IOException {
        if (context.getVersion() >= 3) {
            this.isHorizontal = in.readBoolean();
            this.dividerLocation = in.readFloat();
        }
        super.readSettings(in, context);
    }

    @Override
    protected PropertyMap getPropertyObject() {
        return this.getSplitWindowProperties().getMap();
    }

    @Override
    public String toString() {
        return "SplitWindow: " + super.toString();
    }
}

