/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.ui.actions.ToolBarConfigurationRegistry;
import org.jkiss.utils.CommonUtils;

public class ToolBarConfigurationDescriptor {
    private static final Log log = Log.getLog(ToolBarConfigurationDescriptor.class);
    static final String TOOLBAR_ELEMENT_NAME = "toolBar";
    static final String ITEM_ELEMENT_NAME = "item";
    static final String KEY_ATTR_NAME = "key";
    static final String NAME_ATTR_NAME = "name";
    static final String CMD_ID_ATTR_NAME = "commandId";
    static final String DEFAULT_VISIBILITY_ATTR_NAME = "defaultVisibility";
    private final String key;
    private final String name;
    private final LinkedHashMap<String, Item> itemsByKey;

    public ToolBarConfigurationDescriptor(@NotNull String key, @NotNull List<IConfigurationElement> elements) {
        this.key = key;
        this.name = elements.stream().map(e -> e.getAttribute(NAME_ATTR_NAME)).filter(CommonUtils::isNotEmpty).findFirst().orElse(key);
        this.itemsByKey = elements.stream().flatMap(e -> Stream.of(e.getChildren(ITEM_ELEMENT_NAME))).map(e -> new Item(this, (IConfigurationElement)e)).collect(Collectors.toMap(item -> item.getKey(), item -> item, (a, b) -> {
            String msg = "Duplicate toolbar " + key + " configuration item " + a.key;
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }, LinkedHashMap::new));
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public boolean isItemVisible(@NotNull String itemKey) {
        Item item = this.itemsByKey.get(itemKey);
        if (item != null) {
            return item.isVisible();
        }
        log.error((Object)("Testing unknown item key " + itemKey + " for toolbar configuration " + this.key));
        return false;
    }

    @NotNull
    public Collection<Item> getItems() {
        return this.itemsByKey.values();
    }

    public class Item {
        private final String key;
        private final String name;
        private final String commandId;
        private final boolean defaultVisibility;
        private final String prefKeyVisibility;
        private final String prefKeyIsSet;
        private Boolean isVisible = null;

        public Item(@NotNull ToolBarConfigurationDescriptor this$0, IConfigurationElement e) {
            String key = e.getAttribute(ToolBarConfigurationDescriptor.KEY_ATTR_NAME);
            String name = e.getAttribute(ToolBarConfigurationDescriptor.NAME_ATTR_NAME);
            String commandId = e.getAttribute(ToolBarConfigurationDescriptor.CMD_ID_ATTR_NAME);
            this.key = CommonUtils.isNotEmpty((String)key) ? key : (CommonUtils.isNotEmpty((String)commandId) ? commandId : null);
            this.name = name;
            this.commandId = commandId;
            this.defaultVisibility = CommonUtils.getBoolean((String)e.getAttribute(ToolBarConfigurationDescriptor.DEFAULT_VISIBILITY_ATTR_NAME));
            if (this.key == null) {
                throw new RuntimeException("Failed to resolve toolbar configuration item key");
            }
            this.prefKeyVisibility = ToolBarConfigurationRegistry.makeItemVisibilityPreferenceKeyName(this$0.key, this.key, "visibility");
            this.prefKeyIsSet = ToolBarConfigurationRegistry.makeItemVisibilityPreferenceKeyName(this$0.key, this.key, "isSet");
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getCommandId() {
            return this.commandId;
        }

        public boolean isVisibleByDefault() {
            return this.defaultVisibility;
        }

        public boolean isVisible() {
            if (this.isVisible == null) {
                IPreferenceStore prefs = DBeaverActivator.getInstance().getPreferenceStore();
                this.isVisible = prefs.getBoolean(this.prefKeyIsSet) ? prefs.getBoolean(this.prefKeyVisibility) : this.defaultVisibility;
            }
            return this.isVisible;
        }

        public void setVisible(boolean value) {
            IPreferenceStore prefs = DBeaverActivator.getInstance().getPreferenceStore();
            prefs.setValue(this.prefKeyIsSet, true);
            prefs.setValue(this.prefKeyVisibility, value);
            this.isVisible = value;
        }
    }
}

